﻿using Oxide.Core.Plugins;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Oxide.Plugins
{
    /*
     * This Version Changes:
     * - Initial
     */
    [Info("ADR Arkan", "Pho3niX90", "1.0.1")]
    [Description("Records a demo when players trigger arkan")]
    internal class ADRArkan : RustPlugin
    {
        [PluginReference] Plugin AutoDemoRecord;
        private ADRArkanConfig config;

        #region Oxide Hooks
        void Loaded() {
            LoadConfig();
        }
        #endregion

        #region Arkan Hooks
        private void API_ArkanOnNoRecoilViolation(BasePlayer player, int NRViolationsNum, string jString) {
            if (NRViolationsNum < config.monitorEvent_ArkanOnNoRecoilViolation_Count) return;
            Record(player, string.Format(GetMsg("No Recoil Violation"), NRViolationsNum), config.monitorEvent_ArkanOnNoRecoilViolation_RecordLength);
        }

        private void API_ArkanOnAimbotViolation(BasePlayer player, int AIMViolationsNum, string jString) {
            if (AIMViolationsNum < config.monitorEvent_ArkanOnAimbotViolation_Count) return;
            Record(player, string.Format(GetMsg("Aimbot Violation"), AIMViolationsNum), config.monitorEvent_ArkanOnAimbotViolation_RecordLength);
        }

        private void API_ArkanOnInRockViolation(BasePlayer player, int IRViolationsNum, string json) {
            if (IRViolationsNum < config.monitorEvent_ArkanOnInRockViolation_Count) return;
            Record(player, string.Format(GetMsg("In Rock Violation"), IRViolationsNum), config.monitorEvent_ArkanOnInRockViolation_RecordLength);
        }
        #endregion

        #region Helpers
        void Record(BasePlayer player, string msg, int length) {
            AutoDemoRecord?.Call("API_StartRecording", player, msg, length);
        }
        #endregion


        #region Configuration
        private class ADRArkanConfig
        {
            // Config default vars
            public bool monitorEvent_ArkanOnNoRecoilViolation = true;
            public bool monitorEvent_ArkanOnAimbotViolation = true;
            public bool monitorEvent_ArkanOnInRockViolation = true;
            public int monitorEvent_ArkanOnNoRecoilViolation_Count = 3;
            public int monitorEvent_ArkanOnAimbotViolation_Count = 0;
            public int monitorEvent_ArkanOnInRockViolation_Count = 0;
            public int monitorEvent_ArkanOnNoRecoilViolation_RecordLength = 10;
            public int monitorEvent_ArkanOnAimbotViolation_RecordLength = 10;
            public int monitorEvent_ArkanOnInRockViolation_RecordLength = 10;

            // Plugin reference
            private ADRArkan plugin;
            public ADRArkanConfig(ADRArkan plugin) {
                this.plugin = plugin;
                /**
                 * Load all saved config values
                 * */
                GetConfig(ref monitorEvent_ArkanOnNoRecoilViolation, "Arkan Events", "No Recoil Violation", "Enable");
                GetConfig(ref monitorEvent_ArkanOnNoRecoilViolation_Count, "Arkan Events", "No Recoil Violation", "Record when violations more than");
                GetConfig(ref monitorEvent_ArkanOnNoRecoilViolation_RecordLength, "Arkan Events", "No Recoil Violation", "Record for X minutes");

                GetConfig(ref monitorEvent_ArkanOnAimbotViolation, "Arkan Events", "Aimbot Violation", "Enable");
                GetConfig(ref monitorEvent_ArkanOnAimbotViolation_Count, "Arkan Events", "Aimbot Violation", "Record when violations more than");
                GetConfig(ref monitorEvent_ArkanOnAimbotViolation_RecordLength, "Arkan Events", "Aimbot Violation", "Record for X minutes");

                GetConfig(ref monitorEvent_ArkanOnInRockViolation, "Arkan Events", "In Rock Violation", "Enable");
                GetConfig(ref monitorEvent_ArkanOnInRockViolation_Count, "Arkan Events", "In Rock Violation", "Record when violations more than");
                GetConfig(ref monitorEvent_ArkanOnInRockViolation_RecordLength, "Arkan Events", "In Rock Violation", "Record for X minutes");

                plugin.SaveConfig();
            }

            private void GetConfig<T>(ref T variable, params string[] path) {
                if (path.Length == 0) return;
                if (plugin.Config.Get(path) == null) {
                    SetConfig(ref variable, path);
                    plugin.PrintWarning($"Added new field to config: {string.Join("/", path)}");
                }
                variable = (T)Convert.ChangeType(plugin.Config.Get(path), typeof(T));
            }

            private void SetConfig<T>(ref T variable, params string[] path) => plugin.Config.Set(path.Concat(new object[] { variable }).ToArray());

        }
        string GetMsg(string key) => lang.GetMessage(key, this);
        protected override void LoadConfig() {
            base.LoadConfig();
            config = new ADRArkanConfig(this);
        }
        protected override void LoadDefaultMessages() {
            lang.RegisterMessages(new Dictionary<string, string> {
                ["No Recoil Violation"] = "Received a No Recoil violation. NR {0}",
                ["Aimbot Violation"] = "Received an Aimbot violation. NR {0}",
                ["In Rock Violation"] = "Received an In Rock violation. NR {0}",
            }, this);
        }

        protected override void LoadDefaultConfig() => PrintWarning("Generating new configuration file.");
        #endregion

    }
}
