﻿using Oxide.Core.Plugins;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Oxide.Plugins
{
    /*
     * This Version Changes:
     * - Initial
     */
    [Info("ADR Proximity", "Pho3niX90", "1.0.1")]
    [Description("Records a demo when players are found in bigger groups")]
    internal class ADRProximity : RustPlugin
    {
        [PluginReference] Plugin AutoDemoRecord;
        private ADRProximityConfig config;

        #region Oxide Hooks
        void Loaded()
        {
            LoadConfig();
        }
        #endregion

        #region Plugin Hooks
        private void API_ProximityGroupTrigger(BasePlayer player, ulong[] players)
        {
            Record(player, string.Format(GetMsg("Record Msg"), player.displayName, players.Length), config.recordMinutes);
            if (config.recordAllPlayers)
            {
                foreach (var userId in players)
                {
                    if (player.userID == userId) continue;

                    var tPLayer = BasePlayer.FindByID(userId);
                    if (tPLayer != null && tPLayer.IsConnected)
                        Record(tPLayer, string.Format(GetMsg("Record Msg"), tPLayer.displayName, players.Length), config.recordMinutes);
                }
            }
        }
        #endregion

        #region Helpers
        void Record(BasePlayer player, string msg, int length)
        {
            AutoDemoRecord?.Call("API_StartRecording", player, msg, length);
        }
        #endregion


        #region Configuration
        private class ADRProximityConfig
        {
            // Config default vars
            public int recordMinutes = 10;
            public bool recordAllPlayers = false;

            // Plugin reference
            private ADRProximity plugin;
            public ADRProximityConfig(ADRProximity plugin)
            {
                this.plugin = plugin;
                /**
                 * Load all saved config values
                 * */

                GetConfig(ref recordMinutes, "General", "Record for X minutes");
                GetConfig(ref recordAllPlayers, "General", "Record all players? False will only record one player");

                plugin.SaveConfig();
            }

            private void GetConfig<T>(ref T variable, params string[] path)
            {
                if (path.Length == 0) return;
                if (plugin.Config.Get(path) == null)
                {
                    SetConfig(ref variable, path);
                    plugin.PrintWarning($"Added new field to config: {string.Join("/", path)}");
                }
                variable = (T)Convert.ChangeType(plugin.Config.Get(path), typeof(T));
            }

            private void SetConfig<T>(ref T variable, params string[] path) => plugin.Config.Set(path.Concat(new object[] { variable }).ToArray());

        }
        string GetMsg(string key) => lang.GetMessage(key, this);
        protected override void LoadConfig()
        {
            base.LoadConfig();
            config = new ADRProximityConfig(this);
        }
        protected override void LoadDefaultMessages()
        {
            lang.RegisterMessages(new Dictionary<string, string>
            {
                ["Record Msg"] = "Player {0} found in a group of {1}",
            }, this);
        }

        protected override void LoadDefaultConfig() => PrintWarning("Generating new configuration file.");
        #endregion

    }
}
