﻿using System.Linq;
using System.Collections.Generic;
using Oxide.Core.Plugins;
using Newtonsoft.Json.Linq;
using Oxide.Core;

namespace Oxide.Plugins
{
    [Info("Clans Rcon", "Wxll", "1.0.1")]
    [Description("Simple plugin for retrieving clan data from Clans REBORN via Rcon.")]
    class ClansRcon : RustPlugin
    {
        [PluginReference] private Plugin Clans;

        Dictionary<string, object> PharseClanData(object cland)
        {
            var data = ((JObject)cland).ToObject<Dictionary<string, object>>();
            var a = 0;
            foreach (var obj in data.ToList())
            {
                JArray ja = obj.Value as JArray;
                if (ja != null) data[obj.Key] = ja.ToObject<List<object>>();
                a++;
            }
            return data;
        }

        bool CheckCmd(ConsoleSystem.Arg args, string syntax)
        {
            if (!args.IsRcon) return false;
            if (args.Args == null || args.Args.Length < 1)
            {
                args.ReplyWith(syntax);
                return false;
            }
            return true;
        }

        private void OnServerInitialized()
        {
            if (Clans == null)
            {
                Puts("Clans REBORN not found, unloading plugin. Install https://www.chaoscode.io/resources/clans-reborn.14/");
                Interface.Oxide.UnloadPlugin(nameof(ClansRcon));
            }
        }

        [ConsoleCommand("clans.gettag")]
        private void GetClan(ConsoleSystem.Arg args)
        {
            if (!CheckCmd(args, "clans.gettag {tag}")) return;
            var data = new Dictionary<string, object>();
            var cdata = Clans.Call("GetClan", args.Args[0]);
            if (cdata != null) data = PharseClanData(cdata);
            else data.Add("NoResults", true);
            data.Add("ClansRconTag", args.Args[0]);
            args.ReplyWithObject(data);
        }

        [ConsoleCommand("clans.getuser")]
        private void GetClanByUser(ConsoleSystem.Arg args)
        {
            if (!CheckCmd(args, "clans.getuser {id or name}")) return;
            var data = new Dictionary<string, object>();
            var cdata = Clans.Call("GetClanOf", args.Args[0]) as string;
            if (!string.IsNullOrWhiteSpace(cdata)) data = PharseClanData(Clans.Call("GetClan", cdata));
            else data.Add("NoResults", true);
            data.Add("ClansRconUser", args.Args[0]);
            args.ReplyWithObject(data);
        }
    }
}
