/*▄▄▄    ███▄ ▄███▓  ▄████  ▄▄▄██▀▀▀▓█████▄▄▄█████▓
▓█████▄ ▓██▒▀█▀ ██▒ ██▒ ▀█▒   ▒██   ▓█   ▀▓  ██▒ ▓▒
▒██▒ ▄██▓██    ▓██░▒██░▄▄▄░   ░██   ▒███  ▒ ▓██░ ▒░
▒██░█▀  ▒██    ▒██ ░▓█  ██▓▓██▄██▓  ▒▓█  ▄░ ▓██▓ ░ 
░▓█  ▀█▓▒██▒   ░██▒░▒▓███▀▒ ▓███▒   ░▒████▒ ▒██▒ ░ 
░▒▓███▀▒░ ▒░   ░  ░ ░▒   ▒  ▒▓▒▒░   ░░ ▒░ ░ ▒ ░░*/
using HarmonyLib;
using Newtonsoft.Json;
using Oxide.Core.Plugins;
using System;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
namespace Oxide.Plugins
{
    [Info("EasyBarrels", "bmgjet", "1.0.0")]
    class EasyBarrels : RustPlugin
    {
        public static EasyBarrels plugin;
        private Configuration config;
        private class Configuration
        {
            [JsonProperty("Auto Collect On Break")]
            public bool AutoCollect = true;

            [JsonProperty("Max Distance For Auto Collect")]
            public float MaxDistance = 25;

            [JsonProperty("Short Name Of Supported Entities")]
            public string[] ShortNames = new string[] { "barrel", "roadsign" };

            public string ToJson() => JsonConvert.SerializeObject(this);

            public Dictionary<string, object> ToDictionary() => JsonConvert.DeserializeObject<Dictionary<string, object>>(ToJson());

        }
        protected override void LoadDefaultConfig() { config = new Configuration(); }

        protected override void LoadConfig()
        {
            base.LoadConfig();
            try
            {
                config = Config.ReadObject<Configuration>();
                if (config == null) { throw new JsonException(); }
                if (!config.ToDictionary().Keys.SequenceEqual(Config.ToDictionary(x => x.Key, x => x.Value).Keys))
                {
                    PrintWarning("Configuration appears to be outdated; updating and saving");
                    SaveConfig();
                }
            }
            catch
            {
                PrintWarning($"Configuration file {Name}.json is invalid; using defaults");
                LoadDefaultConfig();
            }
        }

        protected override void SaveConfig()
        {
            PrintWarning($"Configuration changes saved to {Name}.json");
            Config.WriteObject(config, true);
        }

        private void Init() { plugin = this; }

        private void Unload() { plugin = null; }

        [AutoPatch]
        [HarmonyPatch(typeof(LootContainer), "OnAttacked", new Type[] { typeof(HitInfo) })]
        internal class ResourceEntity_OnAttacked
        {
            [HarmonyPrefix]
            private static bool Prefix(HitInfo info, LootContainer __instance)
            {
                try
                {
                    if (info != null && __instance != null)
                    {
                        BasePlayer initiatorPlayer = info.InitiatorPlayer;
                        if (initiatorPlayer != null)
                        {
                            foreach (string text in plugin.config.ShortNames)
                            {
                                if (__instance.ShortPrefabName.Contains(text))
                                {
                                    if (plugin.config.AutoCollect && __instance != null && Vector3.Distance(initiatorPlayer.transform.position, __instance.transform.position) < plugin.config.MaxDistance)
                                    {
                                        for (int j = __instance.inventory.itemList.Count; j > 0; j--)
                                        {
                                            initiatorPlayer.GiveItem(__instance.inventory.itemList[j - 1], BaseEntity.GiveItemReason.PickedUp);
                                        }
                                    }
                                    info.damageTypes.ScaleAll(999f);
                                    break;
                                }
                            }
                        }
                    }
                }
                catch
                {
                }
                return true;
            }
        }
    }
}