﻿using System;
using System.Collections.Generic;
using System.Net;
using Newtonsoft.Json;
using UnityEngine;

/*v.0.0.1 - Prints random facts to chat, //https://api.api-ninjas.com/v1/facts - for the API
 * v.0.0.2 - Added Chat Icon Customization.
 *v.0.0.3 - Fixed API WebRequest URL due to limiting being changed to premium users only resulting in error.
 */

namespace Oxide.Plugins
{
    [Info("Factoid", "Wrecks", "0.0.3")]
    [Description("Prints random facts to chat.")]
    internal class Factoid : RustPlugin
    {
        private Timer factTimer;
        private WebClient webClient;

        #region methods

        private void PrintRandomFact()
        {
            try
            {
                if (webClient == null)
                {
                    webClient = new WebClient();
                    webClient.Headers.Add("X-Api-Key", config.ApiKey);
                }

                var factJson = webClient.DownloadString("https://api.api-ninjas.com/v1/facts");
                var factData = JsonConvert.DeserializeObject<List<Fact>>(factJson);

                if (factData.Count > 0)
                    Server.Broadcast($"[<color=#a590a2>FACTOID</color>]\n<color=#20f0a0>{factData[0].fact}</color>",
                        null, config.ChatIcon);
            }
            catch (Exception ex)
            {
                Puts($"Failed to fetch a random fact: {ex.Message}");
            }
        }

        #endregion

        private class Fact
        {
            public string fact { get; set; }
        }


        #region Config

        private static Configuration config;

        public class Configuration
        {
            [JsonProperty("API KEY")] public string ApiKey { get; set; }

            [JsonProperty("Announcement Interval")]

            public int AnnouncementInterval { get; set; }

            [JsonProperty("Chat Icon")] public ulong ChatIcon { get; set; }

            public static Configuration DefaultConfig()
            {
                return new Configuration
                {
                    ApiKey = "YOUR_API_KEY_HERE", //https://api.api-ninjas.com/v1/facts
                    AnnouncementInterval = 631,
                    ChatIcon = 0
                };
            }
        }

        protected override void LoadConfig()
        {
            base.LoadConfig();
            try
            {
                config = Config.ReadObject<Configuration>();
                if (config == null) LoadDefaultConfig();
                SaveConfig();
            }
            catch (Exception e)
            {
                Debug.LogException(e);
                PrintWarning("Creating new config file.");
                LoadDefaultConfig();
            }
        }

        protected override void LoadDefaultConfig()
        {
            config = Configuration.DefaultConfig();
        }

        protected override void SaveConfig()
        {
            Config.WriteObject(config);
        }

        #endregion

        #region oxidehooks

        private void Init()
        {
            factTimer = timer.Every(config.AnnouncementInterval, PrintRandomFact);
        }


        private void Unload()
        {
            factTimer?.Destroy();
            webClient?.Dispose();
        }

        #endregion
    }
}