/*▄▄▄    ███▄ ▄███▓  ▄████  ▄▄▄██▀▀▀▓█████▄▄▄█████▓
▓█████▄ ▓██▒▀█▀ ██▒ ██▒ ▀█▒   ▒██   ▓█   ▀▓  ██▒ ▓▒
▒██▒ ▄██▓██    ▓██░▒██░▄▄▄░   ░██   ▒███  ▒ ▓██░ ▒░
▒██░█▀  ▒██    ▒██ ░▓█  ██▓▓██▄██▓  ▒▓█  ▄░ ▓██▓ ░ 
░▓█  ▀█▓▒██▒   ░██▒░▒▓███▀▒ ▓███▒   ░▒████▒ ▒██▒ ░ 
░▒▓███▀▒░ ▒░   ░  ░ ░▒   ▒  ▒▓▒▒░   ░░ ▒░ ░ ▒ ░░*/
using HarmonyLib;
using Newtonsoft.Json;
using Oxide.Core.Plugins;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using UnityEngine;
namespace Oxide.Plugins
{
    [Info("GambleAnything", "bmgjet", "1.0.1")]
    class GambleAnything : RustPlugin
    {
        public static GambleAnything _instance;
        private Dictionary<SlotMachine, ItemDefinition> SlotBets = new Dictionary<SlotMachine, ItemDefinition>();

        #region Reflection
        private FieldInfo _CurrentMultiplier = typeof(SlotMachine).GetField("<CurrentMultiplier>k__BackingField", BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic);
        private FieldInfo _CurrentSpinPlayer = typeof(SlotMachine).GetField("CurrentSpinPlayer", BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic);
        private FieldInfo _SpinResult1 = typeof(SlotMachine).GetField("SpinResult1", BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic);
        private FieldInfo _SpinResult2 = typeof(SlotMachine).GetField("SpinResult2", BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic);
        private FieldInfo _SpinResult3 = typeof(SlotMachine).GetField("SpinResult3", BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic);
        #endregion

        #region Confg
        private Configuration config;

        private class Configuration
        {
            [JsonProperty("Enable On SlotMachine")]
            public bool Slots = true;

            [JsonProperty("Slot Machine Max Multiplier")]
            public int MaxMulti = 5;

            [JsonProperty("Enable On BigWheel Game")]
            public bool BigWheel = true;

            [JsonProperty("Blacklist These Items")]
            public string[] BlackListItems;

            public string ToJson() => JsonConvert.SerializeObject(this);

            public Dictionary<string, object> ToDictionary() => JsonConvert.DeserializeObject<Dictionary<string, object>>(ToJson());

        }
        protected override void LoadDefaultConfig()
        {
            config = new Configuration(); config.BlackListItems = new string[] { "supply.signal", "grenade.beancan", "ammo.rifle.explosive", "explosives", "grenade.f1", "explosive.satchel", "explosive.timed", "ammo.rocket.hv", "ammo.rocket.fire", "ammo.rocket.mlrs", "ammo.rocket.basic", "ammo.rocket.sam", "ammo.grenadelauncher.he" };
        }

        protected override void LoadConfig()
        {
            base.LoadConfig();
            try
            {
                config = Config.ReadObject<Configuration>();
                if (config == null) { throw new JsonException(); }
                if (!config.ToDictionary().Keys.SequenceEqual(Config.ToDictionary(x => x.Key, x => x.Value).Keys))
                {
                    PrintWarning("Configuration appears to be outdated; updating and saving");
                    SaveConfig();
                }
            }
            catch
            {
                PrintWarning($"Configuration file {Name}.json is invalid; using defaults");
                LoadDefaultConfig();
            }
        }

        protected override void SaveConfig()
        {
            PrintWarning($"Configuration changes saved to {Name}.json");
            Config.WriteObject(config, true);
        }
        #endregion

        #region OxideHooks
        private void Init() { _instance = this; }

        private void Unload() { _instance = null; }

        #endregion

        #region Methods
        public ItemDefinition ScrapReplacement(SlotMachine slotmachine)
        {
            if (SlotBets.ContainsKey(slotmachine)) { return SlotBets[slotmachine]; }
            return ItemManager.FindItemDefinition("scrap");
        }

        private int GetBettingAmount(SlotMachine slotmachine)
        {
            SlotMachineStorage slotMachineStorage = slotmachine.StorageInstance.Get(slotmachine.isServer) as SlotMachineStorage;
            if (slotMachineStorage == null) { return 0; }
            Item slot = slotMachineStorage.inventory.GetSlot(0);
            if (slot != null) { return slot.amount; }
            return 0;
        }

        public void RequestMultiplierChange(BaseEntity.RPCMessage msg, SlotMachine slotmachine)
        {
            if (msg.player != slotmachine.GetMounted()) { return; }
            int num = msg.read.Int32();
            if (num < 1) { num = config.MaxMulti; }
            if (num > config.MaxMulti) { num = 1; }
            _CurrentMultiplier.SetValue(slotmachine, Mathf.Clamp(num, 1, config.MaxMulti));
            slotmachine.OnBettingScrapUpdated(GetBettingAmount(slotmachine));
            slotmachine.SendNetworkUpdate(0);
        }

        public void Spin(SlotMachine slotmachine)
        {
            SlotMachineStorage slotMachineStorage = slotmachine.StorageInstance.Get(true) as SlotMachineStorage;
            if (SlotBets.ContainsKey(slotmachine))
            {
                SlotBets[slotmachine] = ItemManager.FindItemDefinition(slotMachineStorage.inventory.GetSlot(0).info.itemid);
                return;
            }
            SlotBets.Add(slotmachine, ItemManager.FindItemDefinition(slotMachineStorage.inventory.GetSlot(0).info.itemid));
        }

        public void PayOutSlots(SlotMachine __instance)
        {
            bool flag = false;
            SlotMachinePayoutSettings.PayoutInfo payoutInfo;
            int num;
            if (__instance.PayoutSettings != null && BaseNetworkableEx.IsValid(_CurrentSpinPlayer.GetValue(__instance) as BaseNetworkable) && _CurrentSpinPlayer.GetValue(__instance) as BasePlayer == __instance.GetMounted() && CalculateBonus(out payoutInfo, out num, __instance))
            {
                payoutInfo.Item.itemDef = ScrapReplacement(__instance);
                int num2 = ((int)payoutInfo.Item.amount + num) * __instance.CurrentMultiplier;
                BaseEntity baseEntity = __instance.StorageInstance.Get(true);
                SlotMachineStorage slotMachineStorage = baseEntity as SlotMachineStorage;
                if (baseEntity != null && slotMachineStorage != null)
                {
                    Item slot = slotMachineStorage.inventory.GetSlot(1);
                    if (slot != null && slot.info.itemid == payoutInfo.Item.itemDef.itemid)
                    {
                        slot.amount += num2;
                        slot.MarkDirty();
                    }
                    else
                    {
                        if (slot != null) { slot.DropAndTossUpwards(__instance.transform.position, 2f); }
                        ItemManager.Create(payoutInfo.Item.itemDef, num2, 0UL).MoveToContainer(slotMachineStorage.inventory, 1, true, false, null, true);
                    }
                }
                (_CurrentSpinPlayer.GetValue(__instance) as BasePlayer).ChatMessage(string.Format("You received {0}x {1} for slots payout!", num2, payoutInfo.Item.itemDef.displayName.english));
                if (payoutInfo.OverrideWinEffect != null && payoutInfo.OverrideWinEffect.isValid) { Effect.server.Run(payoutInfo.OverrideWinEffect.resourcePath, __instance, 0U, Vector3.zero, Vector3.zero, null, false); }
                else if (__instance.PayoutSettings.DefaultWinEffect != null && __instance.PayoutSettings.DefaultWinEffect.isValid) { Effect.server.Run(__instance.PayoutSettings.DefaultWinEffect.resourcePath, __instance, 0U, Vector3.zero, Vector3.zero, null, false); }
                if (payoutInfo.OverrideWinEffect == null || !payoutInfo.OverrideWinEffect.isValid) { flag = true; }
            }
            if (!flag) { __instance.SetFlag((BaseEntity.Flags)256, false, false, true); }
            else { __instance.Invoke(delegate { __instance.SetFlag((BaseEntity.Flags)256, false, false, true); }, 4f); }
            _CurrentSpinPlayer.SetValue(__instance, null);
        }

        private bool CalculateBonus(out SlotMachinePayoutSettings.PayoutInfo info, out int bonus, SlotMachine __instance)
        {
            info = default(SlotMachinePayoutSettings.PayoutInfo);
            bonus = 0;
            foreach (SlotMachinePayoutSettings.IndividualPayouts individualPayouts in __instance.PayoutSettings.FacePayouts)
            {
                if (individualPayouts.Result == (int)_SpinResult1.GetValue(__instance))
                {
                    bonus += (int)individualPayouts.Item.amount;
                }
                if (individualPayouts.Result == (int)_SpinResult2.GetValue(__instance))
                {
                    bonus += (int)individualPayouts.Item.amount;
                }
                if (individualPayouts.Result == (int)_SpinResult3.GetValue(__instance))
                {
                    bonus += (int)individualPayouts.Item.amount;
                }
                if (bonus > 0)
                {
                    info.Item = new ItemAmount(individualPayouts.Item.itemDef, 0f);
                }
            }
            foreach (SlotMachinePayoutSettings.PayoutInfo payoutInfo in __instance.PayoutSettings.Payouts)
            {
                if (payoutInfo.Result1 == (int)_SpinResult1.GetValue(__instance) && payoutInfo.Result2 == (int)_SpinResult2.GetValue(__instance) && payoutInfo.Result3 == (int)_SpinResult3.GetValue(__instance))
                {
                    info = payoutInfo;
                    return true;
                }
            }
            return bonus > 0;
        }

        public void ModStorage(StorageContainer container, bool Allow)
        {
            if (Allow)
            {
                container.inventory.onlyAllowedItems = null;
                return;
            }
            if (container.inventory.onlyAllowedItems == null)
            {
                container.inventory.SetOnlyAllowedItem(ItemManager.FindItemDefinition("scrap"));
            }
        }
        #endregion

        #region Harmony
        [AutoPatch]
        [HarmonyPatch(typeof(SlotMachine), "Server_RequestMultiplierChange", new Type[] { typeof(BaseEntity.RPCMessage) })]
        internal class SlotMachine_Server_RequestMultiplierChange
        {
            [HarmonyPrefix]
            private static bool Prefix(BaseEntity.RPCMessage msg, SlotMachine __instance)
            {
                try
                {
                    _instance.RequestMultiplierChange(msg, __instance);
                    return false;
                }
                catch { }
                return true;
            }
        }
        [AutoPatch]
        [HarmonyPatch(typeof(SlotMachine), "RPC_Spin", new Type[] { typeof(BaseEntity.RPCMessage) })]
        internal class SlotMachine_RPC_Spin
        {
            [HarmonyPrefix]
            private static bool Prefix(SlotMachine __instance)
            {
                try
                {
                    if (_instance.config.Slots) { _instance.Spin(__instance); }
                }
                catch { }
                return true;
            }
        }
        [AutoPatch]
        [HarmonyPatch(typeof(SlotMachine), "CheckPayout")]
        internal class SlotMachine_CheckPayout
        {
            [HarmonyPrefix]
            private static bool Prefix(SlotMachine __instance)
            {
                try
                {
                    if (_instance.config.Slots)
                    {
                        _instance.PayOutSlots(__instance);
                        return false;
                    }
                }
                catch { }
                return true;
            }
        }
        [AutoPatch]
        [HarmonyPatch(typeof(SlotMachineStorage), "PlayerOpenLoot", new Type[]
    {
        typeof(BasePlayer),
        typeof(string),
        typeof(bool)
    })]
        internal class SlotMachineStorage_PlayerOpenLoot
        {
            [HarmonyPrefix]
            private static bool Prefix(BasePlayer player, SlotMachineStorage __instance)
            {
                try
                {
                    if (_instance.config.Slots)
                    {
                        _instance.ModStorage(__instance, true);
                    }
                    else
                    {
                        _instance.ModStorage(__instance, false);
                    }
                }
                catch { }
                return true;
            }
        }
        [AutoPatch]
        [HarmonyPatch(typeof(ItemContainer), "CanAcceptItem", new Type[]
    {
        typeof(Item),
        typeof(int)
    })]
        internal class ItemContainer_CanAcceptItem
        {
            [HarmonyPrefix]
            private static bool Prefix(Item item, int targetPos, ItemContainer __instance, ref ItemContainer.CanAcceptResult __result)
            {
                try
                {
                    if (__instance.entityOwner != null && !__instance.HasFlag((ItemContainer.Flag)16) && ((__instance.entityOwner is SlotMachineStorage && _instance.config.Slots) || (__instance.entityOwner is BigWheelBettingTerminal && _instance.config.BigWheel)))
                    {
                        string[] blackListItems = _instance.config.BlackListItems;
                        for (int i = 0; i < blackListItems.Length; i++)
                        {
                            if (blackListItems[i] == item.info.shortname)
                            {
                                __result = (ItemContainer.CanAcceptResult)1;
                                return false;
                            }
                        }
                    }
                }
                catch { }
                return true;
            }
        }
        [AutoPatch]
        [HarmonyPatch(typeof(BigWheelBettingTerminal), "PlayerOpenLoot", new Type[]
    {
        typeof(BasePlayer),
        typeof(string),
        typeof(bool)
    })]
        internal class BigWheelBettingTerminal_PlayerOpenLoot
        {
            [HarmonyPrefix]
            private static bool Prefix(BasePlayer player, BigWheelBettingTerminal __instance)
            {
                try
                {
                    if (_instance.config.BigWheel) { _instance.ModStorage(__instance, true); }
                    else { _instance.ModStorage(__instance, false); }
                }
                catch { }
                return true;
            }
        }
        #endregion
    }
}