﻿namespace Oxide.Plugins
{
    [Info("Instant Startup", "Kaysharp", "1.0.2")]
    [Description("Instant engine Startup for Minicopter and Scrap Transport Helicopter")]
    public class InstantStartup : RustPlugin
    {
        private string permissionuse = "Instantstartup.use";
        private void Init()
        {
            permission.RegisterPermission(permissionuse, this);
        }
        private void OnEngineStarted(BaseMountable entity, BasePlayer player)
        {
            if (!permission.UserHasPermission(player.UserIDString, permissionuse)) return;
            var vehicle = player.GetMountedVehicle();
            if (vehicle == null) return;
            if (vehicle is MiniCopter)
            {
                var Heli = vehicle as MiniCopter;
                if (Heli == null) return;
                Heli.engineController.FinishStartingEngine();
            }
        }
    }
}
