using System;
using Newtonsoft.Json;
using Oxide.Core;
using Oxide.Core.Plugins;
using Oxide.Game.Rust.Cui;
using UnityEngine;

/*
 * Changelog:
 *
 *  Version - 1.0.5
 *  - Added Support For Mevents ServerPanel.
 * - Hook Call is , "OpenWallet"
 *
 */

namespace Oxide.Plugins
{
    [Info("License Wallet", "Wrecks", "1.0.5")]
    [Description("Easy License Handling of Various Wrecks Plugins")]
    public class LicenseWallet : RustPlugin
    {
        [PluginReference] private Plugin BountyHunter, TheFlorist, ZombieHunter, TheAngler, TheTrapper, BeastMaster, ImageLibrary;

        #region Declarations

        private const string Permission = "licensewallet.use";
        private const string OpenEffect = "assets/prefabs/deployable/research table/effects/research-success.prefab";
        private const string DeniedFx = "assets/prefabs/locks/keypad/effects/lock.code.denied.prefab";
        private const string CloseFx = "assets/bundled/prefabs/fx/notice/stack.world.fx.prefab";

        #endregion

        #region Config

        static Configuration config;

        public class Configuration
        {
            [JsonProperty("Wallet Skin ID")] public ulong WalletSkin = 3321288892;
            [JsonProperty("Show Not Installed Buttons When Missing A Dependency?")] public bool ShowNotInstalled;
            [JsonProperty("Add Buy Button Where Available?")] public bool AddBuyButton;
            [JsonProperty("Console Command In Bounty Hunter Plugin? (BE SURE TO LEAVE A SPACE AFTER THE COMMAND FOR PLAYER ID TO PARSE) Ex: buybl ")] public string BountyCommand;
            [JsonProperty("Bounty License Price From Your Bounty Hunter Config")] public string BountyPrice = "<color=green>Price: $10,000</color>";
            [JsonProperty("Console Command In The Florist Plugin? (BE SURE TO LEAVE A SPACE AFTER THE COMMAND FOR PLAYER ID TO PARSE) Ex: buyfg ")] public string FloristCommand;
            [JsonProperty("Florist Guide Price From Your Florist Config")] public string FloristPrice = "<color=green>Price: $10,000</color>";
            [JsonProperty("Console Command In Zombie Hunter Plugin? (BE SURE TO LEAVE A SPACE AFTER THE COMMAND FOR PLAYER ID TO PARSE) Ex: buyzl ")] public string ZombieCommand;
            [JsonProperty("Zombie License Price From Your Zombie Hunter Config")] public string ZombiePrice = "<color=green>Price: $10,000</color>";
            [JsonProperty("Console Command In The Angler Plugin? (BE SURE TO LEAVE A SPACE AFTER THE COMMAND FOR PLAYER ID TO PARSE) Ex: buyal ")] public string AnglerCommand;
            [JsonProperty("Angler License Price From Your Angler Config")] public string AnglerPrice = "<color=green>Price: $10,000</color>";
            [JsonProperty("Console Command In The Trapper Plugin? (BE SURE TO LEAVE A SPACE AFTER THE COMMAND FOR PLAYER ID TO PARSE) Ex: buytl ")] public string TrapperCommand;
            [JsonProperty("Trapper License Price From Your Trapper Config")] public string TrapperPrice = "<color=green>Price: $10,000</color>";
            [JsonProperty("Console Command In Beast Master Plugin? (BE SURE TO LEAVE A SPACE AFTER THE COMMAND FOR PLAYER ID TO PARSE) Ex: buybml ")] public string BeastCommand = "buybml ";
            [JsonProperty("Beast Master License Price From Your Beast Master Config")] public string BeastPrice = "<color=green>Price: $10,000</color>";

            public static Configuration DefaultConfig()
            {
                return new Configuration
                {
                    WalletSkin = 3321288892,
                    ShowNotInstalled = true,
                    AddBuyButton = true,
                    BountyCommand = "buybl ",
                    BountyPrice = "<color=green>Price: $10,000</color>",
                    FloristCommand = "buyfg ",
                    FloristPrice = "<color=green>Price: $10,000</color>",
                    ZombieCommand = "buyzl ",
                    ZombiePrice = "<color=green>Price: $10,000</color>",
                    AnglerCommand = "buyal ",
                    AnglerPrice = "<color=green>Price: $10,000</color>",
                    TrapperCommand = "buytl ",
                    TrapperPrice = "<color=green>Price: $10,000</color>",
                    BeastCommand = "buybml ",
                    BeastPrice = "<color=green>Price: $10,000</color>"
                };
            }
        }

        protected override void LoadConfig()
        {
            base.LoadConfig();
            try
            {
                config = Config.ReadObject<Configuration>();
                if (config == null) LoadDefaultConfig();
                SaveConfig();
            }
            catch (Exception ex)
            {
                Debug.LogException(ex);
                PrintWarning("Creating new configuration file.");
                LoadDefaultConfig();
            }
        }

        protected override void LoadDefaultConfig() => config = Configuration.DefaultConfig();
        protected override void SaveConfig() => Config.WriteObject(config);

        #endregion

        #region Hooks

        private void OnServerInitialized()
        {
            permission.RegisterPermission(Permission, this);
            LoadImages();
        }

        private object OnItemAction(Item item, string action, BasePlayer player)
        {
            if (player == null)
                return null;
            switch (action)
            {
                case "upgrade_item" when item.skin == config.WalletSkin:
                    SendDeniedEffect(player);
                    return true;
                case "unwrap" when item.skin == config.WalletSkin:
                    OpenWallet(player);
                    SendOpenEffect(player);
                    return true;
                default:
                    return null;
            }
        }

        private void Unload()
        {
            foreach (var p in BasePlayer.activePlayerList)
            {
                DestroyPanel(p);
            }
        }

        #endregion

        #region UI

        private const float WalletImageVertAdjuster = 15f;
        private const float WalletImageHorizAdjuster = 20f;
        private const float ImageWidth = 1200f;
        private const float ImageHeight = 567f;
        private const float ImageAspectRatio = ImageWidth / ImageHeight;
        private const float ScaleFactor = 0.7f;
        private const float ScaledWidth = ImageWidth * ScaleFactor / 2f;
        private const float ScaledHeight = ScaledWidth / ImageAspectRatio;
        private const float ButtonWidth = 20f;
        private const float ButtonHeight = 20f;

        [ChatCommand("lw")]
        private void cmdLW(BasePlayer player)
        {
            if (!permission.UserHasPermission(player.UserIDString, Permission)) return;
            CuiHelper.DestroyUi(player, "WalletPanel");
            var container = new CuiElementContainer();
            container.Add
            (new CuiElement
            {
                Name = "WalletPanel",
                Parent = "Overlay",
                DestroyUi = "WalletPanel",
                FadeOut = 1,
                Components =
                {
                    new CuiNeedsCursorComponent(),
                    new CuiImageComponent { Color = "0 0 0 0.995", FadeIn = 1, Material = "assets/content/ui/uibackgroundblur.mat" },
                    new CuiRectTransformComponent { AnchorMin = "0 0", AnchorMax = "1 1", OffsetMin = "-0.009 0.017", OffsetMax = "-0.009 0.017" }
                }
            });
            container.Add
            (new CuiElement
            {
                Name = "WalletImage",
                Parent = "WalletPanel",
                FadeOut = 1,
                Components =
                {
                    new CuiRawImageComponent { Color = "1 1 1 1", FadeIn = 1, Png = ImageLibrary?.Call<string>("GetImage", "LWBACKGROUND") },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = "0.5 0.5",
                        AnchorMax = "0.5 0.5",
                        OffsetMin = $"{-ScaledWidth + WalletImageHorizAdjuster} {-ScaledHeight - WalletImageVertAdjuster}",
                        OffsetMax = $"{ScaledWidth + WalletImageHorizAdjuster} {ScaledHeight - WalletImageVertAdjuster}"
                    }
                }
            });
            SetupBounty(player, container);
            SetupFlorist(player, container);
            SetupBeastMaster(player, container);
            SetupZombie(player, container);
            SetupAngler(player, container);
            SetupTrapper(player, container);
            container.Add
            (new CuiButton
            {
                FadeOut = 1,
                Button =
                {
                    Color = "1 0 0 1",
                    FadeIn = 1,
                    Sprite = "assets/icons/close.png",
                    Command = "closewallet"
                },
                RectTransform =
                {
                    AnchorMin = "0.98 0.96",
                    AnchorMax = "0.98 0.96",
                    OffsetMin = $"-{ButtonWidth / 2} -{ButtonHeight / 2}",
                    OffsetMax = $"{ButtonWidth / 2} {ButtonHeight / 2}"
                }
            }, "WalletImage", "CloseButton");
            CuiHelper.AddUi(player, container);
        }

        private void SetupBounty(BasePlayer player, CuiElementContainer container)
        {
            if (BountyHunter && BountyHunter.Call<bool>("HasBountyLicense", player.userID.Get()))
                container.Add
                (new CuiElement
                {
                    Name = "ActiveLicenseImage1",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWACTIVE") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-322.3 -3.9", OffsetMax = "-287.3 6.1" }
                    }
                });
            else if (!BountyHunter && config.ShowNotInstalled)
            {
                container.Add
                (new CuiElement
                {
                    Name = "NotInstalledImage1",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWNOTINSTALLED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-300 -18.46", OffsetMax = "-208.427 -6.94" }
                    }
                });
            }
            else if (BountyHunter && !BountyHunter.Call<bool>("HasBountyLicense", player.userID.Get()))
            {
                container.Add
                (new CuiElement
                {
                    Name = "InActiveLicenseImage1",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWEXPIRED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-322.3 -3.9", OffsetMax = "-287.3 6.1" }
                    }
                });
                if (!config.AddBuyButton) return;
                container.Add
                (new CuiElement
                {
                    Name = "Price1",
                    Parent = "WalletImage",
                    FadeOut = 0.5f,
                    Components =
                    {
                        new CuiTextComponent()
                        {
                            FadeIn = 1,
                            VerticalOverflow = VerticalWrapMode.Truncate,
                            Text = config.BountyPrice,
                            FontSize = 14,
                        },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.535 0.65",
                            AnchorMax = "0.535 0.75",
                            OffsetMin = "-300.3 -66.0",
                            OffsetMax = "-210.3 -56.0"
                        }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "BuyLicenseButton1",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWBUY") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-272.3 -3.9", OffsetMax = "-237.3 6.1" }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "InvisibleBuyButton",
                    Parent = "WalletImage",
                    Components =
                    {
                        new CuiButtonComponent
                        {
                            Command = "runbountycommand",
                            Color = "0 0 0 0"
                        },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-272.3 -3.9", OffsetMax = "-237.3 6.1" }
                    }
                });
            }
        }

        private void SetupFlorist(BasePlayer player, CuiElementContainer container)
        {
            if (TheFlorist && TheFlorist.Call<bool>("HasFloristLicense", player.userID.Get()))
                container.Add
                (new CuiElement
                {
                    Name = "ActiveLicenseImage2",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWACTIVE") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-60.1 -3.9", OffsetMax = "-25.1 6.1" }
                    }
                });
            else if (!TheFlorist && config.ShowNotInstalled)
            {
                container.Add
                (new CuiElement
                {
                    Name = "NotInstalledImage2",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWNOTINSTALLED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-40.073 -18.46", OffsetMax = "52.073 -6.94" }
                    }
                });
            }
            else if (TheFlorist && !TheFlorist.Call<bool>("HasFloristLicense", player.userID.Get()))
            {
                container.Add
                (new CuiElement
                {
                    Name = "InActiveLicenseImage2",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWEXPIRED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-60.1 -3.9", OffsetMax = "-25.1 6.1" }
                    }
                });
                if (!config.AddBuyButton) return;
                container.Add
                (new CuiElement
                {
                    Name = "Price2",
                    Parent = "WalletImage",
                    FadeOut = 0.5f,
                    Components =
                    {
                        new CuiTextComponent()
                        {
                            FadeIn = 1,
                            VerticalOverflow = VerticalWrapMode.Truncate,
                            Text = config.FloristPrice,
                            FontSize = 14,
                        },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.845 0.65",
                            AnchorMax = "0.845 0.75",
                            OffsetMin = "-300.3 -66.0",
                            OffsetMax = "-210.3 -56.0"
                        }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "BuyLicenseButton2",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWBUY") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-10.1 -3.9", OffsetMax = "25.1 6.1" }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "InvisibleBuyButton",
                    Parent = "WalletImage",
                    Components =
                    {
                        new CuiButtonComponent
                        {
                            Command = "runfloristcommand",
                            Color = "0 0 0 0"
                        },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-10.1 -3.9", OffsetMax = "25.1 6.1" }
                    }
                });
            }
        }

        private void SetupBeastMaster(BasePlayer player, CuiElementContainer container)
        {
            if (BeastMaster && BeastMaster.Call<bool>("HasBeastLicense", player.userID.Get()))
                container.Add
                (new CuiElement
                {
                    Name = "ActiveLicenseImage6",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWACTIVE") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-60.1 -137.3", OffsetMax = "-25.1 -127.3" }
                    }
                });
            else if (!BeastMaster && config.ShowNotInstalled)
            {
                container.Add
                (new CuiElement
                {
                    Name = "NotInstalledImage6",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWNOTINSTALLED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-40.073 -151.46", OffsetMax = "52.073 -139.94" }
                    }
                });
            }
            else if (BeastMaster && !BeastMaster.Call<bool>("HasBeastLicense", player.userID.Get()))
            {
                container.Add
                (new CuiElement
                {
                    Name = "InActiveLicenseImage6",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWEXPIRED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-60.1 -137.3", OffsetMax = "-25.1 -127.3" }
                    }
                });
                if (!config.AddBuyButton) return;
                container.Add
                (new CuiElement
                {
                    Name = "Price5",
                    Parent = "WalletImage",
                    FadeOut = 0.5f,
                    Components =
                    {
                        new CuiTextComponent()
                        {
                            FadeIn = 1,
                            VerticalOverflow = VerticalWrapMode.Truncate,
                            Text = config.BeastPrice,
                            FontSize = 14,
                        },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.845 0.32",
                            AnchorMax = "0.845 0.42",
                            OffsetMin = "-300.3 -66.0",
                            OffsetMax = "-210.3 -56.0"
                        }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "BuyLicenseButton6",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWBUY") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-10.1 -137.3", OffsetMax = "25.1 -127.3" }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "InvisibleBuyButton",
                    Parent = "WalletImage",
                    Components =
                    {
                        new CuiButtonComponent
                        {
                            Command = "runbeastcommand",
                            Color = "0 0 0 0"
                        },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-10.1 -137.3", OffsetMax = "25.1 -127.3" }
                    }
                });
            }
        }

        private void SetupZombie(BasePlayer player, CuiElementContainer container)
        {
            if (ZombieHunter && ZombieHunter.Call<bool>("HasZombieLicense", player.userID.Get()))
                container.Add
                (new CuiElement
                {
                    Name = "ActiveLicenseImage3",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWACTIVE") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "200.74 -3.9", OffsetMax = "235.74 6.1" }
                    }
                });
            else if (!ZombieHunter && config.ShowNotInstalled)
            {
                container.Add
                (new CuiElement
                {
                    Name = "NotInstalledImage3",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWNOTINSTALLED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "222.073 -18.46", OffsetMax = "314.073 -6.94" }
                    }
                });
            }
            else if (ZombieHunter && !ZombieHunter.Call<bool>("HasZombieLicense", player.userID.Get()))
            {
                container.Add
                (new CuiElement
                {
                    Name = "InActiveLicenseImage3",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWEXPIRED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "200.74 -3.9", OffsetMax = "235.74 6.1" }
                    }
                });
                if (!config.AddBuyButton) return;
                container.Add
                (new CuiElement
                {
                    Name = "Price3",
                    Parent = "WalletImage",
                    FadeOut = 0.5f,
                    Components =
                    {
                        new CuiTextComponent()
                        {
                            FadeIn = 1,
                            VerticalOverflow = VerticalWrapMode.Truncate,
                            Text = config.ZombiePrice,
                            FontSize = 14,
                        },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "1.157 0.65",
                            AnchorMax = "1.157 0.75",
                            OffsetMin = "-300.3 -66.0",
                            OffsetMax = "-210.3 -56.0"
                        }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "BuyLicenseButton3",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWBUY") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "250.74 -3.9", OffsetMax = "285.74 6.1" }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "InvisibleBuyButton",
                    Parent = "WalletImage",
                    Components =
                    {
                        new CuiButtonComponent
                        {
                            Command = "runzombiecommand",
                            Color = "0 0 0 0"
                        },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "250.74 -3.9", OffsetMax = "285.74 6.1" }
                    }
                });
            }
        }

        private void SetupAngler(BasePlayer player, CuiElementContainer container)
        {
            if (TheAngler && TheAngler.Call<bool>("HasAnglerLicense", player.userID.Get()))
                container.Add
                (new CuiElement
                {
                    Name = "ActiveLicenseImage4",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWACTIVE") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-321.4 -137.3", OffsetMax = "-286.4 -127.3" }
                    }
                });
            else if (!TheAngler && config.ShowNotInstalled)
            {
                container.Add
                (new CuiElement
                {
                    Name = "NotInstalledImage4",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWNOTINSTALLED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-300 -151.46", OffsetMax = "-208.427 -139.94" }
                    }
                });
            }
            else if (TheAngler && !TheAngler.Call<bool>("HasAnglerLicense", player.userID.Get()))
            {
                container.Add
                (new CuiElement
                {
                    Name = "InActiveLicenseImage4",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWEXPIRED") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-321.4 -137.3", OffsetMax = "-286.4 -127.3" }
                    }
                });
                if (!config.AddBuyButton) return;
                container.Add
                (new CuiElement
                {
                    Name = "Price5",
                    Parent = "WalletImage",
                    FadeOut = 0.5f,
                    Components =
                    {
                        new CuiTextComponent()
                        {
                            FadeIn = 1,
                            VerticalOverflow = VerticalWrapMode.Truncate,
                            Text = config.AnglerPrice,
                            FontSize = 14,
                        },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.535 0.32",
                            AnchorMax = "0.535 0.42",
                            OffsetMin = "-300.3 -66.0",
                            OffsetMax = "-210.3 -56.0"
                        }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "BuyLicenseButton4",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWBUY") },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-271.4 -137.3", OffsetMax = "-236.4 -127.3" }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "InvisibleBuyButton",
                    Parent = "WalletImage",
                    Components =
                    {
                        new CuiButtonComponent
                        {
                            Command = "runanglercommand",
                            Color = "0 0 0 0"
                        },
                        new CuiRectTransformComponent { AnchorMin = "0.5 0.5", AnchorMax = "0.5 0.5", OffsetMin = "-271.4 -137.3", OffsetMax = "-236.4 -127.3" }
                    }
                });
            }
        }

        private void SetupTrapper(BasePlayer player, CuiElementContainer container)
        {
            if (TheTrapper && TheTrapper.Call<bool>("HasTrapperLicense", player.userID.Get()))
                container.Add
                (new CuiElement
                {
                    Name = "ActiveLicenseImage5",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWACTIVE") },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.5 0.5",
                            AnchorMax = "0.5 0.5",
                            OffsetMin = "200.74 -136.93",
                            OffsetMax = "235.74 -126.93"
                        }
                    }
                });
            else if (!TheTrapper && config.ShowNotInstalled)
            {
                container.Add
                (new CuiElement
                {
                    Name = "NotInstalledImage5",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWNOTINSTALLED") },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.5 0.5",
                            AnchorMax = "0.5 0.5",
                            OffsetMin = "222.073 -151.46",
                            OffsetMax = "314.073 -139.94"
                        }
                    }
                });
            }
            else if (TheTrapper && !TheTrapper.Call<bool>("HasTrapperLicense", player.userID.Get()))
            {
                container.Add
                (new CuiElement
                {
                    Name = "InActiveLicenseImage5",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWEXPIRED") },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.5 0.5",
                            AnchorMax = "0.5 0.5",
                            OffsetMin = "200.74 -136.93", OffsetMax = "235.74 -126.93"
                        }
                    }
                });
                if (!config.AddBuyButton) return;
                container.Add
                (new CuiElement
                {
                    Name = "Price6",
                    Parent = "WalletImage",
                    FadeOut = 0.5f,
                    Components =
                    {
                        new CuiTextComponent()
                        {
                            FadeIn = 1,
                            VerticalOverflow = VerticalWrapMode.Truncate,
                            Text = config.TrapperPrice,
                            FontSize = 14,
                        },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "1.157 0.32",
                            AnchorMax = "1.157 0.42",
                            OffsetMin = "-300.3 -66.0",
                            OffsetMax = "-210.3 -56.0"
                        }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "BuyLicenseButton5",
                    Parent = "WalletImage",
                    FadeOut = 1,
                    Components =
                    {
                        new CuiRawImageComponent { FadeIn = 1, Color = "1 1 1 1", Png = ImageLibrary?.Call<string>("GetImage", "LWBUY") },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.5 0.5",
                            AnchorMax = "0.5 0.5",
                            OffsetMin = "250.74 -136.93",
                            OffsetMax = "285.74 -126.93"
                        }
                    }
                });
                container.Add
                (new CuiElement
                {
                    Name = "InvisibleBuyButton",
                    Parent = "WalletImage",
                    Components =
                    {
                        new CuiButtonComponent
                        {
                            Command = "runtrappercommand",
                            Color = "0 0 0 0"
                        },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.5 0.5",
                            AnchorMax = "0.5 0.5",
                            OffsetMin = "250.74 -136.93",
                            OffsetMax = "285.74 -126.93"
                        }
                    }
                });
            }
        }

        #endregion

        #region ServerPanel

        [HookMethod("OpenWallet")]
        private CuiElementContainer OpenWallet(BasePlayer player)
        {
            var container = new CuiElementContainer();

            #region Background

            container.Add
            (new CuiPanel()
            {
                RectTransform = { AnchorMin = "0 0", AnchorMax = "1 1" },
                Image = { Color = "0 0 0 0" }
            }, "UI.Server.Panel.Content", "UI.Server.Panel.Content.Plugin", "UI.Server.Panel.Content.Plugin");
            container.Add
            (new CuiPanel()
            {
                RectTransform = { AnchorMin = "0 0", AnchorMax = "1 1" },
                Image = { Color = "0 0 0 0" }
            }, "UI.Server.Panel.Content.Plugin", "LW" + ".Background", "LW" + ".Background");

            #endregion

            #region Content

            container.Add
            (new CuiElement
            {
                Name = "WalletPanel",
                Parent = "LW.Background",
                FadeOut = 1,
                Components =
                {
                    new CuiNeedsCursorComponent(),
                    new CuiImageComponent { Color = "0 0 0 0.995", FadeIn = 1, Material = "assets/content/ui/uibackgroundblur.mat" },
                    new CuiRectTransformComponent { AnchorMin = "0 0", AnchorMax = "1 1", OffsetMin = "-0.009 0.017", OffsetMax = "-0.009 0.017" }
                }
            });
            container.Add
            (new CuiElement
            {
                Name = "WalletImage",
                Parent = "WalletPanel",
                FadeOut = 1,
                Components =
                {
                    new CuiRawImageComponent { Color = "1 1 1 1", FadeIn = 1, Png = ImageLibrary?.Call<string>("GetImage", "LWBACKGROUND") },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = "0.5 0.5",
                        AnchorMax = "0.5 0.5",
                        OffsetMin = $"{-ScaledWidth + WalletImageHorizAdjuster} {-ScaledHeight - WalletImageVertAdjuster}",
                        OffsetMax = $"{ScaledWidth + WalletImageHorizAdjuster} {ScaledHeight - WalletImageVertAdjuster}"
                    }
                }
            });
            SetupBounty(player, container);
            SetupFlorist(player, container);
            SetupBeastMaster(player, container);
            SetupZombie(player, container);
            SetupAngler(player, container);
            SetupTrapper(player, container);
            /*container.Add
            (new CuiButton
            {
                FadeOut = 1,
                Button =
                {
                    Color = "1 0 0 1",
                    FadeIn = 1,
                    Sprite = "assets/icons/close.png",
                    Command = "closewallet"
                },
                RectTransform =
                {
                    AnchorMin = "0.98 0.96",
                    AnchorMax = "0.98 0.96",
                    OffsetMin = $"-{ButtonWidth / 2} -{ButtonHeight / 2}",
                    OffsetMax = $"{ButtonWidth / 2} {ButtonHeight / 2}"
                }
            }, "WalletImage", "CloseButton");*/

            #endregion Content

            return container;
        }

        #endregion

        #region Commands

        [ConsoleCommand("runtrappercommand")]
        private void RunTrapperCommand(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            var id = player.userID.Get();
            DestroyPanel(player);
            ConsoleSystem.Run(ConsoleSystem.Option.Server.Quiet(), config.TrapperCommand + id);
        }

        [ConsoleCommand("runanglercommand")]
        private void RunAnglerCommand(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            var id = player.userID.Get();
            DestroyPanel(player);
            ConsoleSystem.Run(ConsoleSystem.Option.Server.Quiet(), config.AnglerCommand + id);
        }

        [ConsoleCommand("runzombiecommand")]
        private void RunZombieCommand(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            var id = player.userID.Get();
            DestroyPanel(player);
            ConsoleSystem.Run(ConsoleSystem.Option.Server.Quiet(), config.ZombieCommand + id);
        }

        [ConsoleCommand("runfloristcommand")]
        private void RunFloristCommand(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            var id = player.userID.Get();
            DestroyPanel(player);
            ConsoleSystem.Run(ConsoleSystem.Option.Server.Quiet(), config.FloristCommand + id);
        }

        [ConsoleCommand("runbeastcommand")]
        private void RunBeastCommand(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            var id = player.userID.Get();
            DestroyPanel(player);
            ConsoleSystem.Run(ConsoleSystem.Option.Server.Quiet(), config.BeastCommand + id);
        }

        [ConsoleCommand("runbountycommand")]
        private void RunbountyCommand(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            var id = player.userID.Get();
            DestroyPanel(player);
            ConsoleSystem.Run(ConsoleSystem.Option.Server.Quiet(), config.BountyCommand + id);
        }

        [ConsoleCommand("CloseWallet")]
        private void CloseWallet(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            SendCloseEffect(player);
            DestroyPanel(player);
        }

        #endregion

        #region Helpers

        private static void DestroyPanel(BasePlayer player)
        {
            CuiHelper.DestroyUi(player, "CloseButton");
            CuiHelper.DestroyUi(player, "WalletImage");
            for (int i = 1; i <= 6; i++)
            {
                CuiHelper.DestroyUi(player, $"InActiveLicenseImage{i}");
                CuiHelper.DestroyUi(player, $"NotInstalledImage{i}");
                CuiHelper.DestroyUi(player, $"ActiveLicenseImage{i}");
                CuiHelper.DestroyUi(player, $"BuyLicenseButton{i}");
                CuiHelper.DestroyUi(player, $"Price{i}");
            }
            CuiHelper.DestroyUi(player, "WalletPanel");
            Interface.CallHook("API_OnServerPanelCallClose", player);
        }

        private void LoadImages()
        {
            ImageLibrary?.Call("AddImage", "https://www.dropbox.com/scl/fi/no3dgwl22wy75fqrqr95b/LWUpdate.png?rlkey=qol9rj4ev80nm8ffy61gvagp7&st=qt6vz8aj&dl=1", "LWBACKGROUND");
            ImageLibrary?.Call("AddImage", "https://www.dropbox.com/scl/fi/kzzky2ernoo8073ak1qvx/ButtonNOTINSTALLED.png?rlkey=fd5qslejpc14uanxiibchtb7r&st=alq2iwu4&dl=1", "LWNOTINSTALLED");
            ImageLibrary?.Call("AddImage", "https://www.dropbox.com/scl/fi/4t3g5i1a48tkgkvfv157b/ButtonACTIVE.png?rlkey=6i3xtf7d52d2n44qmw5iualdr&st=o4eosbok&dl=1", "LWACTIVE");
            ImageLibrary?.Call("AddImage", "https://www.dropbox.com/scl/fi/mxfrkuthpt3uzgc1pl2zo/ButtonEXPIRED-3.png?rlkey=4x0qp2clbfb5pl06wmvxe2qgf&st=yuo3t0i3&dl=1", "LWEXPIRED");
            ImageLibrary?.Call("AddImage", "https://www.dropbox.com/scl/fi/wr8lye67cgdot8yp8zecz/BUY.png?rlkey=55xk0z5mv9twiu7k0yrnshytc&st=adv0z23s&dl=1", "LWBUY");
        }

        #endregion

        #region Fx

        private void SendOpenEffect(BasePlayer player)
        {
            EffectNetwork.Send(new Effect(OpenEffect, player.transform.position, player.transform.position), player.net.connection);
        }

        private void SendDeniedEffect(BasePlayer player)
        {
            EffectNetwork.Send(new Effect(DeniedFx, player.transform.position, player.transform.position), player.net.connection);
        }

        private void SendCloseEffect(BasePlayer player)
        {
            EffectNetwork.Send(new Effect(CloseFx, player.transform.position, player.transform.position), player.net.connection);
        }

        #endregion
    }
}