﻿using Newtonsoft.Json;
using Oxide.Core;
using Oxide.Core.Libraries.Covalence;
using Oxide.Core.Plugins;
using Oxide.Game.Rust.Cui;
using System.Globalization;
using UnityEngine;
using Newtonsoft.Json.Linq;
using Oxide.Core.Configuration;
using Oxide.Core.Libraries;
using Oxide.Plugins;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Oxide.Plugins
{
    [Info("PlaytimeCommands", "Ifte", "1.0.0")]
    [Description("Execute commands when completing hour goals.")]
    public class PlaytimeCommands : RustPlugin
    {
        [PluginReference]
        Plugin PlaytimeTracker;

        private Configuration config;
        private Timer RepeatTimer;
        private Dictionary<string, List<int>> playerRewards = new Dictionary<string, List<int>>();
        private const string AdminPerm = "PlaytimeCommands.admin";

        protected override void LoadConfig()
        {
            base.LoadConfig();
            config = Config.ReadObject<Configuration>();
        }

        protected override void LoadDefaultConfig()
        {
            config = new Configuration();
        }

        protected override void SaveConfig()
        {
            Config.WriteObject(config, true);
        }
        private List<string> Cmds = new List<string>();
        private class Configuration
        {
            [JsonProperty("Check how often it checks for playtime and execute commands?(In Seconds)")]
            public int interval = 1800;

            [JsonProperty("Execute command upon playtime hour completation", ObjectCreationHandling = ObjectCreationHandling.Replace)]
            public Dictionary<int, List<string>> Rewards { get; set; } = new Dictionary<int, List<string>>
            {
                { 20, new List<string> { "oxide.usergroup add {UserID} chads", "chat user add {UserID} chads" } },
                { 30, new List<string> { "sr add {Name} 1000", "sr take {UserID} 100", "oxide.usergroup add {UserID} veteran" } }
            };

        }


        private void OnServerInitialized()
        {
            permission.RegisterPermission(AdminPerm, this);       

            if (PlaytimeTracker == null)
            {
                Puts($"This requires PlaytimeTracker plugin to work.(Link: https://umod.org/plugins/playtime-tracker)");
                return;
            }

            LoadData();

            if (config.interval > 0)
            {
                RepeatTimer = timer.Every(config.interval, () =>
                {
                    StartTimer();
                });
            }
        }

        private void Unload()
        {
            RepeatTimer.Destroy();
        }

        private void StartTimer()
        {
            if (PlaytimeTracker == null || config == null || config.Rewards == null)
                return;

            foreach (var player in BasePlayer.activePlayerList)
            {
                double playtimeHours = GetPlayTime(player); // Get playtime in hours

                foreach (var reward in config.Rewards)
                {
                    int thresholdHours = reward.Key; // Threshold in hours
                    List<string> commands = reward.Value; // Commands for this threshold

                    // Check if player's playtime meets or exceeds the threshold
                    if (playtimeHours >= thresholdHours && !HasReceivedReward(player.UserIDString, thresholdHours))
                    {
                        // Execute commands for this reward
                        foreach (var command in commands)
                        {
                            // Execute command here
                            ExecuteCommand(command, player);
                        }

                        AddRewardRecord(player.UserIDString, thresholdHours);
                    }
                }
            }
        }

        private void ExecuteCommand(string command, BasePlayer player)
        {
            IPlayer p = player.IPlayer;
            // Execute the command here
            // Check for {UserID}, {Name}
            Server.Command(command.Replace("{UserID}", player.UserIDString).Replace("{Name}", p.Name));
        }

        private double GetPlayTime(BasePlayer player)
        {
            double playTime = 0;

            if (PlaytimeTracker != null)
            {
                //PlaytimeTracker.Call method returns playtime in seconds
                playTime = Convert.ToDouble(PlaytimeTracker.Call("GetPlayTime", player.UserIDString)) / 3600; // Convert seconds to hours
            }
            else
            {
                Puts("There is no PlaytimeTracker tracking the playtime for players.");
            }

            return playTime;
        }

        private void LoadData()
        {
            playerRewards = Interface.Oxide.DataFileSystem.ReadObject<Dictionary<string, List<int>>>($"{Name}/PlayerRewards");
        }

        private void SaveData()
        {
            Interface.Oxide.DataFileSystem.WriteObject($"{Name}/PlayerRewards", playerRewards);
        }

        private bool HasReceivedReward(string userId, int hour)
        {
            if (!playerRewards.ContainsKey(userId))
                return false;

            return playerRewards[userId].Contains(hour);
        }

        private void AddRewardRecord(string userId, int hour)
        {
            if (!playerRewards.ContainsKey(userId))
                playerRewards[userId] = new List<int>();

            playerRewards[userId].Add(hour);
            SaveData();
        }

        [ChatCommand("prc")]
        private void CMDAdmin(BasePlayer player, string cmd, string[] args)
        {
            if (player == null || !permission.UserHasPermission(player.UserIDString, AdminPerm) || !player.IsAdmin)
            {
                player?.ChatMessage("No Permission or invalid player.");
                return;
            }

            string command = args[0];

            switch (command)
            {
                case "reset":
                    playerRewards.Clear();
                    SaveData();
                    Puts("You have cleared all PlayerRewards data.");
                    player.ChatMessage("You have cleared all PlayerRewards data.");
                    return;
            }
            
        }

        [ConsoleCommand("prc")]
        private void CMDAdminConsole(ConsoleSystem.Arg args)
        {
            BasePlayer player = args.Player();

            string command = args.Args[0];

            switch (command)
            {
                case "reset":
                    playerRewards.Clear();
                    SaveData();
                    Puts("You have cleared all PlayerRewards data.");                 
                    return;

            }

        }

    }
}
