﻿using Oxide.Game.Rust.Cui;
using UnityEngine;

namespace Oxide.Plugins
{
    [Info("Rust UI Helper", "Billy Joe", "1.0.0")]
    public class RustUIHelper : CovalencePlugin
    {
        public static RustUIHelper Instance;
        void Loaded()
        {
            Instance = this;
        }

        #region Functions
        public void AddPanel(CuiElementContainer container, string name = "", string parent = "Overlay", string color = "1 1 1 1", string anchor = "0 0|0 0", string offset = "0 0|0 0", bool cursor = false, int fadeOut = 0, int fadeIn = 0, string sprite = "", string material = "")
        {
            string anchormin = anchor.Split('|')[0]; string anchormax = anchor.Split('|')[1]; string offsetmin = offset.Split('|')[0]; string offsetmax = offset.Split('|')[1];

            container.Add(new CuiPanel
            {
                FadeOut = fadeOut,
                Image =
                {
                    Color = color,
                    FadeIn = fadeIn,
                    Sprite = sprite,
                    Material = material,

                },

                RectTransform =
                {
                    AnchorMin = anchormin,
                    AnchorMax = anchormax,
                    OffsetMin = offsetmin,
                    OffsetMax = offsetmax
                },

                CursorEnabled = cursor
            }, parent, name);
        }

        public void AddLabel(CuiElementContainer container, string name = "", string parent = "Overlay", string text = "", int fontSize = 20, string color = "1 1 1 1", string anchor = "0 0|0 0", string offset = "0 0|0 0", int fadeOut = 0, int fadeIn = 0, int alignment = 0, string font = "robotocondensed-bold.ttf", string outlineColor = "0 0 0 0", string outlineDistance = "0 0")
        {
            string anchormin = anchor.Split('|')[0]; string anchormax = anchor.Split('|')[1]; string offsetmin = offset.Split('|')[0]; string offsetmax = offset.Split('|')[1];

            container.Add(new CuiElement
            {
                Name = name,
                Parent = parent,
                FadeOut = fadeOut,
                Components =
                {
                    new CuiTextComponent
                    {
                        Text = text,
                        Font = font,
                        FontSize = fontSize,
                        Align = (TextAnchor)alignment,
                        Color = color,
                        FadeIn = fadeIn
                    },

                    new CuiRectTransformComponent
                    {
                        AnchorMin = anchormin,
                        AnchorMax = anchormax,
                        OffsetMin = offsetmin,
                        OffsetMax = offsetmax
                    },

                    new CuiOutlineComponent
                    {
                        Color = outlineColor,
                        Distance = outlineDistance
                    }
                }
            });
        }

        public void AddImage(CuiElementContainer container, string name = "", string parent = "Overlay", string color = "1 1 1 1", string anchor = "0 0|0 0", string offset = "0 0|0 0", int fadeOut = 0, int fadeIn = 0, string sprite = "assets/content/textures/generic/fulltransparent.tga", string material = "", string url = "")
        {
            string anchormin = anchor.Split('|')[0]; string anchormax = anchor.Split('|')[1]; string offsetmin = offset.Split('|')[0]; string offsetmax = offset.Split('|')[1];

            container.Add(new CuiElement
            {
                Name = name,
                Parent = parent,
                FadeOut = fadeOut,
                Components =
                {
                    new CuiRawImageComponent
                    {
                        Color = color,
                        Sprite = sprite,
                        Material = material,
                        Url = url,
                        FadeIn = fadeIn
                    },

                    new CuiRectTransformComponent
                    {
                        AnchorMin = anchormin,
                        AnchorMax = anchormax,
                        OffsetMin = offsetmin,
                        OffsetMax = offsetmax
                    }
                }
            });
        }

        public void AddButton(CuiElementContainer container, string name = "", string parent = "Overlay", string buttonColor = "1 1 1 1", string textColor = "1 1 1 1", string anchor = "0 0|0 0", string offset = "0 0|0 0", int fadeOut = 0, int fadeIn = 0, string buttonText = "", int fontSize = 20, int alignment = 0, string font = "robotocondensed-bold.ttf", string sprite = "assets/content/textures/generic/fulltransparent.tga", string material = "", string buttonCommand = "")
        {
            string anchormin = anchor.Split('|')[0]; string anchormax = anchor.Split('|')[1]; string offsetmin = offset.Split('|')[0]; string offsetmax = offset.Split('|')[1];

            container.Add(new CuiButton
            {
                FadeOut = fadeOut,
                Button =
                {
                    Command = buttonCommand,
                    Color = buttonColor,
                    Sprite = sprite,
                    Material = material,
                    FadeIn = fadeIn
                },

                Text =
                {
                    Text = buttonText,
                    Font = font,
                    FontSize = fontSize,
                    Align = (TextAnchor)alignment,
                    Color = textColor,
                    FadeIn = fadeIn
                },

                RectTransform =
                {
                    AnchorMin = anchormin,
                    AnchorMax = anchormax,
                    OffsetMin = offsetmin,
                    OffsetMax = offsetmax
                }
            }, parent, name);
        }

        public void AddInputField(CuiElementContainer container, string name = "", string parent = "Overlay", string anchor = "0 0|0 0", string offset = "0 0|0 0", int fadeOut = 0, int fadeIn = 0, int fontSize = 20, string color = "1 1 1 1", bool isPassword = false, int charLimit = 30, int alignment = 0, string font = "robotocondensed-bold.ttf", string command = "")
        {
            string anchormin = anchor.Split('|')[0]; string anchormax = anchor.Split('|')[1]; string offsetmin = offset.Split('|')[0]; string offsetmax = offset.Split('|')[1];

            container.Add(new CuiElement
            {
                Name = name,
                Parent = parent,
                FadeOut = fadeOut,
                Components =
                {
                    new CuiInputFieldComponent
                    {
                        Text = string.Empty,
                        CharsLimit = charLimit,
                        Color = color,
                        IsPassword = isPassword,
                        Command = command,
                        Font = font,
                        FontSize = fontSize,
                        Align = (TextAnchor)alignment
                    },

                    new CuiRectTransformComponent
                    {
                        AnchorMin = anchormin,
                        AnchorMax = anchormax,
                        OffsetMin = offsetmin,
                        OffsetMax = offsetmax
                    }
                }
            });
        }
        #endregion
    }
}
