/*▄▄▄    ███▄ ▄███▓  ▄████  ▄▄▄██▀▀▀▓█████▄▄▄█████▓
▓█████▄ ▓██▒▀█▀ ██▒ ██▒ ▀█▒   ▒██   ▓█   ▀▓  ██▒ ▓▒
▒██▒ ▄██▓██    ▓██░▒██░▄▄▄░   ░██   ▒███  ▒ ▓██░ ▒░
▒██░█▀  ▒██    ▒██ ░▓█  ██▓▓██▄██▓  ▒▓█  ▄░ ▓██▓ ░ 
░▓█  ▀█▓▒██▒   ░██▒░▒▓███▀▒ ▓███▒   ░▒████▒ ▒██▒ ░ 
░▒▓███▀▒░ ▒░   ░  ░ ░▒   ▒  ▒▓▒▒░   ░░ ▒░ ░ ▒ ░░   
▒░▒   ░ ░  ░      ░  ░   ░  ▒ ░▒░    ░ ░  ░   ░    
 ░    ░ ░      ░   ░ ░   ░  ░ ░ ░      ░    ░      
 ░             ░         ░  ░   ░      ░  ░*/
using System;
using System.Collections.Generic;
using System.Linq;
using HarmonyLib;
using Newtonsoft.Json;
using Oxide.Core.Plugins;

namespace Oxide.Plugins
{
    [Info("TCStoreAnything", "bmgjet", "1.2.1")]
    class TCStoreAnything : RustPlugin
    {
        public static TCStoreAnything plugin;
        private readonly string PermUse = "TCStoreAnything.Use";

        #region Configuration
        private Configuration config;

        private class Configuration
        {
            [JsonProperty("Limit To TCs That The Owner Has The 'TCStoreAnything.Use' Perm")]
            public bool PermLimit = true;

            [JsonProperty("Limit To Tool Slots Only")]
            public bool SlotsOnly = true;

            [JsonProperty("Limit To Whitelist")]
            public bool UseWhiteList = true;

            [JsonProperty("Whitelist Shortnames")]
            public string[] LimitItems = new string[]
            {
            "hammer",
            "toolgun",
            "building.planner",
            "hosetool",
            "wiretool",
            "jackhammer",
            "chainsaw",
            "ammo.rifle.explosive",
            "explosives",
            "explosive.satchel",
            "explosive.timed",
            "grenade.beancan",
            "ammo.rocket"
            };

            public string ToJson() => JsonConvert.SerializeObject(this);

            public Dictionary<string, object> ToDictionary() => JsonConvert.DeserializeObject<Dictionary<string, object>>(ToJson());
        }

        protected override void LoadDefaultConfig() { config = new Configuration(); }

        protected override void LoadConfig()
        {
            base.LoadConfig();
            try
            {
                config = Config.ReadObject<Configuration>();
                if (config == null) { throw new JsonException(); }

                if (!config.ToDictionary().Keys.SequenceEqual(Config.ToDictionary(x => x.Key, x => x.Value).Keys))
                {
                    PrintWarning("Configuration appears to be outdated; updating and saving");
                    SaveConfig();
                }
            }
            catch
            {
                PrintWarning($"Configuration file {Name}.json is invalid; using defaults");
                LoadDefaultConfig();
            }
        }

        protected override void SaveConfig()
        {
            PrintWarning($"Configuration changes saved to {Name}.json");
            Config.WriteObject(config, true);
        }
        #endregion Configuration

        #region OxideHooks
        private void Init()
        {
            plugin = this;
            permission.RegisterPermission(PermUse, this);
        }
        private void Unload() { plugin = null; }

        private object ItemFilter(Item item, int targetSlot, BuildingPrivlidge tc)
        {
            if (config.PermLimit && !permission.UserHasPermission(tc.OwnerID.ToString(), PermUse)) { return null; }
            if (config.UseWhiteList && !config.LimitItems.Contains(item.info.shortname)) { return null; }
            if (!config.SlotsOnly) { return true; }
            if (targetSlot >= 24 && targetSlot <= 29) { return true; }
            return null;
        }
        #endregion

        #region Harmony
        [AutoPatch]
        [HarmonyPatch(typeof(BuildingPrivlidge), "ItemFilter", new Type[] { typeof(Item), typeof(int) })]
        internal class BuildingPrivlidge_ItemFilter
        {
            [HarmonyPrefix]
            private static bool Prefix(Item item, int targetSlot, BuildingPrivlidge __instance, ref bool __result)
            {
                try
                {
                    object obj = plugin.ItemFilter(item, targetSlot, __instance);
                    if (obj != null)
                    {
                        __result = (bool)obj;
                        return false;
                    }
                }
                catch { }
                return true;
            }
        }
        #endregion
    }
}