/*▄▄▄    ███▄ ▄███▓  ▄████  ▄▄▄██▀▀▀▓█████▄▄▄█████▓
▓█████▄ ▓██▒▀█▀ ██▒ ██▒ ▀█▒   ▒██   ▓█   ▀▓  ██▒ ▓▒
▒██▒ ▄██▓██    ▓██░▒██░▄▄▄░   ░██   ▒███  ▒ ▓██░ ▒░
▒██░█▀  ▒██    ▒██ ░▓█  ██▓▓██▄██▓  ▒▓█  ▄░ ▓██▓ ░ 
░▓█  ▀█▓▒██▒   ░██▒░▒▓███▀▒ ▓███▒   ░▒████▒ ▒██▒ ░ 
░▒▓███▀▒░ ▒░   ░  ░ ░▒   ▒  ▒▓▒▒░   ░░ ▒░ ░ ▒ ░░   
▒░▒   ░ ░  ░      ░  ░   ░  ▒ ░▒░    ░ ░  ░   ░    
 ░    ░ ░      ░   ░ ░   ░  ░ ░ ░      ░    ░      
 ░             ░         ░  ░   ░      ░  ░*/
using Newtonsoft.Json;
using Oxide.Game.Rust.Cui;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
namespace Oxide.Plugins
{
    [Info("unlimitedhookup", "bmgjet", "1.1.2")]
    [Description("Admin Tool To Connect Wires, Pipes and hoses")]
    class unlimitedhookup : RustPlugin
    {
        public static unlimitedhookup _plugin; //Self Reference for componant
        Dictionary<BasePlayer, UnlimitedPipe> UnlimitedPipeComponant = new Dictionary<BasePlayer, UnlimitedPipe>(); //List of loaded Componants
        private string permUnlimitedPipe = "unlimitedhookup.unlimited";//Grants unlimited pipe length

        #region Configuration
        private Configuration config;

        private class Configuration
        {
            [JsonProperty("Icon CUI")]
            public string CUIData = "H4sIAAAAAAAEAO1YbY+aQBD+K4Tcx4OwvAl+u0PSkqo0Kk2Ty32gslpS2DWwNmcv9987gCeI5IKixjQNMa7jzC7zzDPzoE+vPPFjzPd5j0RhHDIcOC5/z6/8BBMGZvc3TiJ/A6YApyyhGy88cJ7TeEUJ+Kd8/+mVZ5tVsWHINjZZhgSLniM6sb/EuXNEE/haEjWufJn82/0ucoLnbJb4JF3QJIYQn8x/wiokWRgnlRb/BSwIwg2w0cUixazwQpIucaoqlebcVdBFzeAETRORwb89Z0dus5/SdTLHzuhTNfczZIm4/AIL7BOHAd9HsqJqes8wKwnXNnHXLIJlFSwuv0Qtq0OYMsgf57sLqDVwBdY18EprFT7BVESFU+roaUZmbURu+DisIleFsxVuM/zCwJdlb33+Ls3jWWFcUMKm4R+IMooP4JHQH5TROSUBJikOhAQv15GfiIwtsgyjcJnlMQqDIMIWnI2ThqLccAVkGTbuVc0F1xWJy80NJXC9WacSPK4Zo6Twjn0SZB7joTNyZvbgs+t+8b5yU9ebWHZx0AdgngsEpEmAgl7HwACrvkWglu77rR3NOCj4ar1Ptt55yFYQ5wN8mkv57WHo2edsqWlK57/wfopIulKO3ThQH+MZA1BjD1hD+2FynS54P+oafYAUzjicBTIcp+9mQS3l8vaOpsrLHke0c81cSZQktYd005T31m1bYwDPH9cQaNPo6ZqqyOiG5aEQaEEx+CaJFpRD5GoCXYJ5yizJHgX/i3M7cc6RHnfAvsVEGtjTWX7GjYnyLvcTSOaQmxDkIoUDNe7WP4N/W4szcA6U+DKsv1kVrmJwAkW+X0iDj2D+ZE0sSgg4hHkhuqhui2pa7nhsW9VfFneWO4RHrS7/DKBaDWFIyXUGg82Q6uWrJ39CCbfx+02uXkwkDyr5/BcVq7Oz3BEAAA==";

            [JsonProperty("Use Reload Key Instead Of Middle Mouse")]
            public bool ReloadKey = false;

            [JsonProperty("Draw Crosshair In Center Screen")]
            public bool Crosshair = true;

            public string ToJson() => JsonConvert.SerializeObject(this);

            public Dictionary<string, object> ToDictionary() => JsonConvert.DeserializeObject<Dictionary<string, object>>(ToJson());
        }

        protected override void LoadDefaultConfig() { config = new Configuration(); }

        protected override void LoadConfig()
        {
            base.LoadConfig();
            try
            {
                config = Config.ReadObject<Configuration>();
                if (config == null) { throw new JsonException(); }

                if (!config.ToDictionary().Keys.SequenceEqual(Config.ToDictionary(x => x.Key, x => x.Value).Keys))
                {
                    PrintWarning("Configuration appears to be outdated; updating and saving");
                    SaveConfig();
                }
            }
            catch
            {
                PrintWarning($"Configuration file {Name}.json is invalid; using defaults");
                LoadDefaultConfig();
            }
        }

        protected override void SaveConfig()
        {
            PrintWarning($"Configuration changes saved to {Name}.json");
            Config.WriteObject(config, true);
        }
        #endregion Configuration

        private void Init()
        {
            _plugin = this;
            permission.RegisterPermission(permUnlimitedPipe, this); //Register permission
            config.CUIData = Encoding.ASCII.GetString(Facepunch.Utility.Compression.Uncompress(Convert.FromBase64String(config.CUIData)));// Unpack CUI
        }
        void Unload()
        {
            foreach (BasePlayer player in BasePlayer.activePlayerList) { CuiHelper.DestroyUi(player, "UnlimitedIO"); } //Remove any CUI
            for (int i = UnlimitedPipeComponant.Count - 1; i >= 0; i--) { UnlimitedPipeComponant.ElementAt(i).Value.RemoveMe(); }  //Remove componants
            _plugin = null; //Remove referece
        }     

        //Handle CUI Buttons
        [ConsoleCommand("UNLIMITEDHOOKUP")] private void StoreCMD(ConsoleSystem.Arg arg) { if (arg.Player() == null || !HasPermission(arg.Player(), permUnlimitedPipe)) { return; } CUIMananger(arg); } //Processes CUI Button Presses

        [ChatCommand("hookup")] //Chat Command toggle mode
        private void CommandRunUnlimited(BasePlayer player, string command, string[] args)
        {
            if (HasPermission(player, permUnlimitedPipe))
            {
                if (player?.GetHeldEntity()?.ShortPrefabName == "toolgun.entity") //Check player has a tool gun
                {
                    if (UnlimitedPipeComponant.ContainsKey(player)) //Remove player from mode if already has it
                    {
                        GameObject.Destroy(UnlimitedPipeComponant[player]);
                        UnlimitedPipeComponant.Remove(player);
                        return;
                    }
                    //Give player mode if doesnt have it.
                    UnlimitedPipe UP = player.gameObject.AddComponent<UnlimitedPipe>();
                    UnlimitedPipeComponant.Add(player, UP);
                    UP.player = player;
                    _plugin.CreateTip("Look at an entity and press middle mouse button to select.", player);
                    UP.UnlimitedHookupCUI();
                    return;
                }
                CreateTip("You must be holding a tool gun!", player);
                return;
            }
            player.ChatMessage("Dont Have Permission To Use This Command!");
        }

        private IOEntity FindIO(Ray ray)
        {
            //Ray cast to find IOEntity
            RaycastHit hit;
            var raycast = Physics.Raycast(ray, out hit, 5, -1);
            BaseEntity entity = raycast ? hit.GetEntity() : null;
            if (entity != null && entity is IOEntity) { return entity as IOEntity; }
            return null;
        }

        private bool HasPermission(BasePlayer player, string perm) { return player.IsAdmin || permission.UserHasPermission(player.UserIDString, perm); } //Check permission or admin

        private void DrawSpot(List<Vector3> to, BasePlayer player, Vector3 source, Vector3 dest)
        {
            //Check for admin toggle plugins
            if (!player.IsAdmin && !player.IsDeveloper && player.IsFlying) { return; }// BasePlayer => FinalizeTick => NoteAdminHack => Ban => Cheat Detected!
            bool _isadmin = player.IsAdmin; //Check if is admin
            //Toggle admin so dont get anti-cheat kicked for drawing on screen.
            if (!_isadmin)
            {
                player.SetPlayerFlag(BasePlayer.PlayerFlags.IsAdmin, true);
                player.SendNetworkUpdateImmediate();
            }
            Vector3 start = source; //Hold start position
            foreach (Vector3 pos in to)
            {
                player.SendConsoleCommand("ddraw.sphere", 5, Color.blue, pos, 0.1); //Draw on screen
                DrawLine(player, start, pos);
                start = pos; //Update last position
            }
            if (dest != Vector3.zero) { DrawLine(player, start, dest); }
            //Remove admin toggle
            if (!_isadmin && player.HasPlayerFlag(BasePlayer.PlayerFlags.IsAdmin))
            {
                player.SetPlayerFlag(BasePlayer.PlayerFlags.IsAdmin, false);
                player.SendNetworkUpdateImmediate();
            }
        }

        private void DrawLine(BasePlayer player, Vector3 start, Vector3 end)
        {
            player.SendConsoleCommand("ddraw.line", 5, Color.white, start + new Vector3(0, 0.01f, 0), end + new Vector3(0, 0.01f, 0)); //Draw line between this and last position if its not the start
            player.SendConsoleCommand("ddraw.line", 5, Color.white, start + new Vector3(0, 0.02f, 0), end + new Vector3(0, 0.02f, 0)); //Make Line a bit thicker
        }

        private void RUNIO(IOEntity source, IOEntity dest, Vector3[] pipes, int dsocket = 0, int ssocket = 0)
        {
            //Try Clear Any Already Used Slots
            try { if (source.outputs[ssocket].connectedTo.Get() != null) { WireTool.AttemptClearSlot(source.outputs[ssocket].connectedTo.Get(), null, ssocket, true); } } catch { }
            try{if (dest.inputs[dsocket].connectedTo.Get() != null) { WireTool.AttemptClearSlot(dest.inputs[dsocket].connectedTo.Get().outputs[dsocket].connectedTo.Get(), null, dsocket, true); }}catch { }
            //Connect
            var slack = new List<float>();
            foreach(var p in pipes){slack.Add(0);}
            source.ConnectTo(dest, ssocket, dsocket, pipes.ToList(), slack, new IOEntity.LineAnchor[0], 0);
            source.NotifyIndustrialNetworkChanged();
            source.NotifyIndustrialNetworkChanged();
        }

        public void CreateTip(string msg, BasePlayer player, int time = 5) //Creates game tip message
        {
            if (player == null) { return; }
            player.SendConsoleCommand("gametip.hidegametip");
            player.SendConsoleCommand("gametip.showgametip", msg);
            timer.Once(time, () => player?.SendConsoleCommand("gametip.hidegametip"));
        }

        private void CUIMananger(ConsoleSystem.Arg arg)
        {
            if (arg == null || arg.Args.Length == 0 || arg.Player() == null || !UnlimitedPipeComponant.ContainsKey(arg.Player())) { return; }
            UnlimitedPipe UP = UnlimitedPipeComponant[arg.Player()];
            switch (arg.Args[0])
            {
                case "CONNECT": //Connect Wires/Pipes
                    if (UP.source != null && UP.dest != null) { UP.HookUp(); }
                    return;
                case "SOURCECLEAR": //Clear Source Item
                    UP.source = null;
                    UP.Ssocket = 0;
                    UP.PipePath.Clear();
                    UP.UnlimitedHookupCUI();
                    return;
                case "DESTCLEAR": //Clear Dest Item
                    UP.dest = null;
                    UP.Dsocket = 0;
                    UP.UnlimitedHookupCUI();
                    return;
                case "SOURCEOUT": //Change Souce Output Socket
                    if (UP.source == null) { return; }
                    if (UP.Ssocket < UP.source.outputs.Length - 1) { UP.Ssocket++; }
                    else { UP.Ssocket = 0; }
                    UP.UnlimitedHookupCUI();
                    return;
                case "DESTIN": //Change Dest Input Socket
                    if (UP.dest == null) { return; }
                    if (UP.Dsocket < UP.dest.inputs.Length - 1) { UP.Dsocket++; }
                    else { UP.Dsocket = 0; }
                    UP.UnlimitedHookupCUI();
                    return;
            }
        }

        public class UnlimitedPipe : MonoBehaviour
        {
            //Variables
            public BasePlayer player;
            public IOEntity source;
            public int Ssocket = 0;
            public IOEntity dest;
            public int Dsocket = 0;
            public List<Vector3> PipePath = new List<Vector3>();
            //Remove CUI, Remove player from list
            void OnDestroy() { if (player != null && _plugin != null) { CuiHelper.DestroyUi(player, "UnlimitedIO"); CuiHelper.DestroyUi(player, "CUICrosshair"); _plugin.UnlimitedPipeComponant.Remove(player); } }

            public void RemoveMe(){Destroy(this);}

            public void DrawCrosshair(BasePlayer player)
            {
                CuiHelper.DestroyUi(player, "CUICrosshair");
                var container = new CuiElementContainer();

                // Root (transparent) to group children for easy destroy
                container.Add(new CuiElement
                {
                    Name = "CUICrosshair",
                    Parent = "Overlay",
                    Components =
                {
                    new CuiImageComponent { Color = "0 0 0 0" },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = "0 0",
                        AnchorMax = "1 1",
                        OffsetMin = "0 0",
                        OffsetMax = "0 0"
                    }
                }
                });

                // Vertical bar
                {
                    float halfThickness = 1f;
                    float halfLen = 12f;

                    // Centered at (0.5, 0.5); vertical offsets produce vertical bar
                    var vert = new CuiElement
                    {
                        Name = "CUICrosshair.V",
                        Parent = "CUICrosshair",
                        Components =
                    {
                        new CuiImageComponent { Color = "1 1 1 0.9" },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.5 0.5",
                            AnchorMax = "0.5 0.5",
                            OffsetMin = $"{-halfThickness} {-halfLen}",
                            OffsetMax = $"{halfThickness} {halfLen}"
                        }
                    }
                    };
                    container.Add(vert);
                }

                // Horizontal bar
                {
                    float halfThickness = 1f;
                    float halfLen = 12f;

                    var horiz = new CuiElement
                    {
                        Name = "CUICrosshair.H",
                        Parent = "CUICrosshair",
                        Components =
                    {
                        new CuiImageComponent { Color = "1 1 1 0.9" },
                        new CuiRectTransformComponent
                        {
                            AnchorMin = "0.5 0.5",
                            AnchorMax = "0.5 0.5",
                            OffsetMin = $"{-halfLen} {-halfThickness}",
                            OffsetMax = $"{halfLen} {halfThickness}"
                        }
                    }
                    };
                    container.Add(horiz);
                }

                CuiHelper.AddUi(player, container);
            }

            private void ClearData() { source = null; Ssocket = 0; dest = null; Dsocket = 0; PipePath.Clear(); } //Reset the data

            public void HookUp()
            {
                try
                {
                    List<Vector3> FullPath = new List<Vector3>() { source.outputs[Ssocket].handlePosition }; //Create the start point position
                    foreach (Vector3 p in PipePath) { FullPath.Add(source.transform.InverseTransformPoint(p)); } //Convert world positions to local positions
                    FullPath.Add(source.transform.InverseTransformPoint(dest.transform.TransformPoint(dest.inputs[Dsocket].handlePosition))); //Add the end position
                    _plugin.RUNIO(source, dest, FullPath.ToArray(), Dsocket, Ssocket); //Run wires/pipes
                }
                catch { _plugin.CreateTip("Failed to make connection, bad setting?", player); }
                ClearData(); //Remove old data
                UnlimitedHookupCUI();
            }

            void FixedUpdate()
            {
                if (player == null || _plugin == null || (player?.GetHeldEntity()?.ShortPrefabName != "toolgun.entity")) { Destroy(this); } //Destroy componant if plugin unloads, player is destroyed or toolgun put away
                else if ((_plugin.config.ReloadKey && player.serverInput.WasJustPressed(BUTTON.RELOAD)) || (!_plugin.config.ReloadKey) && player.serverInput.WasJustPressed(BUTTON.FIRE_THIRD)) //Catch button input
                {
                    if (player.IsBuildingBlocked() && !player.IsAdmin) { _plugin.CreateTip("Building Blocked!", player); return; }
                    IOEntity IO = _plugin.FindIO(player.eyes.HeadRay()); //Find IOEnt player is looking at
                    if (IO != null && source == null && Vector3.Distance(player.transform.position, IO.transform.position) < 5) { source = IO; UnlimitedHookupCUI(); return; } //Set source
                    if (IO != null && dest == null && Vector3.Distance(player.transform.position, IO.transform.position) < 5)
                    {
                        if (Vector3.Distance(source.transform.position, IO.transform.position) > 250) { _plugin.CreateTip("Connections won't transfere past 250 distance!", player); return; }
                        dest = IO; UnlimitedHookupCUI();
                        return;
                    } //Set Dest
                    if (source == null) { _plugin.CreateTip("Select your source entity first", player); return; } //Warning they need a source first
                    //Add path points
                    RaycastHit hit;
                    if (Physics.Raycast(player.eyes.HeadRay(), out hit, 10, 1236478737))
                    {
                        if (PipePath.Count >= 50) { _plugin.CreateTip("Max connections reached!", player); return; } //Limit connections so dont get packet flood for too many links in wire/pipe/hose
                        PipePath.Add(hit.point); //Add a joint
                        Vector3 vector3 = Vector3.zero;
                        if (dest) { vector3 = dest.transform.position; }
                        _plugin.DrawSpot(PipePath, player, source.transform.position, vector3); //Draw on screen
                    }
                }
            }

            public void UnlimitedHookupCUI()
            {
                //Process CUI Data
                string sourcetext = "No Source";
                string desttext = "No Dest";
                int sourceid = 1803831286; //Using toolgun icon as default
                int destid = 1803831286;
                string colour = "0.5 0.5 0.5 0.9"; //Grey connect button
                if (source != null && dest != null) { colour = "0 1 0 1"; } //green connection button
                if (source != null) { sourcetext = source.ShortPrefabName.ToString(); sourceid = source.sourceItem.itemid; }
                if (dest != null) { desttext = dest.ShortPrefabName.ToString(); destid = dest.sourceItem.itemid; }
                if (_plugin.config.Crosshair) { DrawCrosshair(player); }
                CuiHelper.AddUi(player, CuiHelper.FromJson(_plugin.config.CUIData.Replace("$COLOUR", colour).Replace("123456789", sourceid.ToString()).Replace("987654321", destid.ToString()).Replace("$sourcetext", sourcetext).Replace("$Ssocket", Ssocket.ToString()).Replace("$desttext", desttext).Replace("$Dsocket", Dsocket.ToString()))); //mod cui
            }
        }
    }
}