using UnityEngine;

namespace Oxide.Plugins
{
    [Info("Workcart Spawner Vanilla", "SPooCK", "1.0.0")]
    [Description("Only applies anti-collision collider for Work Carts.")]
    class WorkcartSpawnerVa : RustPlugin
    {
        static int passLayer = ToLayer(LayerMask.GetMask("Trigger")); // 18

        void OnEntitySpawned(TrainCar entity) {
            if (entity == null) return;
            NextTick(() => SetupCart(entity));
        }

        private void SetupCart(TrainCar train) {
            if (train == null) return;

            foreach (TriggerTrainCollisions Trigger in train.GetComponentsInChildren<TriggerTrainCollisions>()) {
                Trigger.triggerCollider.gameObject.layer = passLayer;
            }
        }

        public static int ToLayer(int bitmask) {
            int result = bitmask > 0 ? 0 : 31;
            while (bitmask > 1) {
                bitmask >>= 1;
                result++;
            }
            return result;
        }
    }
}
