using Oxide.Core.Plugins;
using Oxide.Core;
using System.Collections.Generic;
using UnityEngine;

namespace Oxide.Plugins
{
    [Info("WorkbenchTaxChanger", "Frosted Gaming", "0.1.0")]
    public class WorkbenchTaxChanger : RustPlugin
    {
        private Dictionary<string, float> TaxRates = new Dictionary<string, float>
        {
            // Initializing with default values directly in the dictionary
            ["server.workbench1taxrate"] = 0.0f,
            ["server.workbench2taxrate"] = 10.0f,
            ["server.workbench3taxrate"] = 20.0f
        };

        protected override void LoadDefaultConfig() {
            Puts("Creating a new configuration file with default values.");
            SaveConfig();
        }

        private void Init()
        {
            LoadConfig();
        }

        private void LoadConfig()
        {
            foreach (var rate in TaxRates)
            {
                var convar = ConsoleSystem.Index.Server.Find(rate.Key);
                if (convar != null)
                {
                    convar.Set(rate.Value);
                    Puts($"{rate.Key} set to {rate.Value}%.");
                }
            }
        }

        private void SaveConfig()
        {
            foreach (var rate in TaxRates)
            {
                var convar = ConsoleSystem.Index.Server.Find(rate.Key);
                if (convar != null)
                {
                    convar.Set(rate.Value);
                }
            }
            Puts("Tax rates saved to server configuration.");
        }

        [ChatCommand("settax")]
        private void SetTaxRateCommand(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin)
            {
                player.ChatMessage("You need to be an admin to use this command.");
                return;
            }

            if (args.Length != 2)
            {
                player.ChatMessage("Incorrect usage. Format: /settax <workbench1|workbench2|workbench3> <rate>");
                return;
            }

            string convarName = $"server.{args[0]}taxrate";
            if (!TaxRates.ContainsKey(convarName))
            {
                player.ChatMessage("Invalid workbench level specified. Use: workbench1, workbench2, or workbench3.");
                return;
            }

            if (float.TryParse(args[1], out float newRate))
            {
                TaxRates[convarName] = newRate;
                var convar = ConsoleSystem.Index.Server.Find(convarName);
                if (convar != null)
                {
                    convar.Set(newRate);
                    SaveConfig();
                    player.ChatMessage($"Tax rate for {args[0]} set to {newRate}%.");
                }
                else
                {
                    player.ChatMessage($"Failed to find the server variable {convarName}.");
                }
            }
            else
            {
                player.ChatMessage("Invalid rate. Please enter a valid number.");
            }
        }
    }
}
