﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text.RegularExpressions;
using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Oxide.Core;
using Oxide.Core.Configuration;
using Oxide.Core.Plugins;
using Oxide.Core.Database;
using Oxide.Core.Libraries.Covalence;
using Oxide.Plugins.XPerienceEx;
using Oxide.Game.Rust.Cui;
using Rust;
using UnityEngine;
using Random = UnityEngine.Random;
using WebSocketSharp;
using ConVar;
using Facepunch;
using Facepunch.Math;

namespace Oxide.Plugins
{
    [Info("XPerience", "MACHIN3", "1.5.1")]
    [Description("Player level system with xp, stats, and skills")]
    public class XPerience : RustPlugin
    {
        #region Update Log
        /*****************************************************
		【 𝓜𝓐𝓒𝓗𝓘𝓝𝓔 】
        Website: https://www.rustlevels.com/
        Discord: http://discord.rustlevels.com/
        *****************************************************/
        #region version 1.5.1
        /*****************************************************
        ----------------------
        ✯ version 1.5.1
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Added checks for XPerience Addon UIs
        ✯ Added support for new Miner abilities from XPerience Addon

        New Miner Ability: Quarry Production (XPerience Addon Required!)
        ✯ Option to increase quarry production by % per Miner level
        ✯ Option to set production duration
        ✯ Option to set cooldown duration

        The new Minor ability requires the XPerience Addon and is NOT included in XPerience!

        *****************************************************/
        #endregion
        #region version 1.5.0
        /*****************************************************
        ----------------------
        ✯ version 1.5.0
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ fixed dash/speedometer default type being set to 0 instead of 1 when players first join
        ✯ fixed API errors when returned data is null
        ✯ Added support for the new Addon Notify UI features

        *****************************************************/
        #endregion
        #region version 1.4.9
        /*****************************************************
        ----------------------
        ✯ version 1.4.9
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Updated profile UI to include DeathRecords button if XPerienceAddon installed
        ✯ Fixed LiveUI location options showing when diabled
        ✯ LiveUI location auto updates to default when player joins if allowed to move is disabled

        *****************************************************/
        #endregion
        #region version 1.4.8
        /*****************************************************
        ----------------------
        ✯ version 1.4.8
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Updated Help page for showing Weaponry Stat and other abilties added
        ✯ Fixed speedometer showing -999 instead of N/A when speed not detected
        ✯ Fixed Dash Panel UI showing gap when option to show rank in LiveUI is disabled
        ✯ Fixed OnEntityDismounted error
        ✯ Fixed Dash Panel UI not disappearing when vehicle, mini, or boat destroyed with player inside
        ✯ Dash Panel speedometer now shows engine thrust for boats, and max rotor speed for minicopters
        ✯ Added MiniCopter maxrotor speed boost to dexterity stats ability (RELOAD button activates boost)

        *****************************************************/
        #endregion
        #region version 1.4.7
        /*****************************************************
        ----------------------
        ✯ version 1.4.7
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Changed admin commands to include type (name or id) for xpgive, xptake, and xpresetplayer commands
        ✯ More adjustments to UIs
        ✯ Added more API for new Weaponry stat ability and Pets plugin
        ✯ Removed unused coding
        ✯ Moved taming effects to skill list where they should be in player profile UIs
        ✯ Rewrote admin setting values to show % instead of decimals for easier understanding
        ✯ Fixed other mod icons showing next to stats/skills when disabled
        ✯ Added a check to make sure player names are updated when joining in case they changed their name.
        ✯ Fixed stats/skills reset buttons showing timer when restrictions disabled
        ✯ Added xp option for Zombie Horde NPCs if plugin is installed
        ✯ Added option to show new Fuel Gauge UI with LiveStatsUI (boats, cars, minis)
        ✯ Added option to show new Speedometer UI with LiveStatsUI
        ✯ Added option to swich between MPH and KMH for players speedometer UI

        Pets Support:
        ✯ Added support for PolarBear pet update (must have Pets v0.6.5 or higher)
        ✯ Increased default max level for Tamer from 5 to 6 for Polar Bear taming

        NOTE: Must adjust Taming skill in admin panel for polar bear taming 

        New Mentality Ability Added:
        ✯ Increased damage to NPCs (dwellers, scientists scarecrows, customnpcs, zombies)
        ✯ Option to adjust damage percentage increase to NPCs

        New Dexterity Ability Added:
        ✯ Increased horse speed (walking, trotting, running and max speed)
        ✯ Increased Boat speed
        ✯ Increase vehicle speed
        ✯ Reduced vehicle fuel consumption
        ✯ Option to adjust horse, boat and vehicle speed percentage per level
        ✯ Option to adjust vehicle reduced fuel consumption percentage per level
        ✯ Pressing the USE key while on a horse activates/deactivates speed boost
        ✯ Pressing the RELOAD key while on a boat or in a vehicle activates/deactivates speed boost

        New Stat: Weaponry
        ✯ Percentage Chance to reduce condition damage to tools, power tools, and weapons by percentage
        ✯ Percentage Increase to max ammo weapons can hold
        ✯ Option to adjust reduced condition percentage chance
        ✯ Option to adjust reduced percentage for tools
        ✯ Option to adjust reduced percentage for power tools
        ✯ Option to adjust reduced percentage for melee weapons
        ✯ Option to adjust reduced percentage for projectile weapons
        ✯ Option to set minimum damage taken
        ✯ Option to set max ammo percentage

        OTHER NOTES: Some of these new features are still experimental such as the Fuel gauge and Speedometer. If you have any issues please post in the RustLevels discord bug report channel so that it can be addresses asap!
        *****************************************************/
        #endregion
        #region version 1.4.6
        /*****************************************************
        ----------------------
        ✯ version 1.4.6
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Changes to admin pages - Other mods now have their own settings page for easier adjustment and to make room for more mod support
        ✯ Fixed issues with manually setting hex color in config
        ✯ Added separate XP setting amount for twig building
        ✯ Added more API data for future Addon features
        ✯ Adjusted player profile UIs to better fit extra abilities from other mods
        ✯ Added option to allow XP gains after reaching max level/rank (no level up)
        ✯ Added option to set chance for xp when using power tools (chainsaw/jackhammer)
        ✯ Added option to give xp percentage when using power tools (chainsaw/jackhammer)
        ✯ Other mod icons now show next to stat/skill that controls them

        Live Stats UI Rewrite:
        ✯ Includes customizable icons in config
        ✯ LiveUI now scales with user scale settings
        ✯ New LiveUI progressive level icon option that changes the closer a player reaches next level
        ✯ Adjusted location 1 so that it no longer overlaps Backpack icon if Backpack plugin installed

        New Feature: Backpacks now can be assigned to stat or skill
        ✯ Option to set which stat or skill enables backpack usage
        ✯ Option to set number of backpack rows per stat/skill level

        NOTES:
        ✯ If ranks are enabled and a player opts out of them if allowed they will not earn xp once they reach max level even if allowed xp after max level is set to true. This prevents players from gaining xp then opting back in ranks to skip many levels.
        ✯ For new power tool xp options to work (chance/percentage), both the power tool xp disable option and one time xp option must be set to false.
        ✯ Backpack plugin must still be configured before XPerience can control it if enabled however, permissions to use and rows allowed will be fully controlled by XPerience settings. (conflicts may occur if using any other backpack control plugins)
        ✯ If Backpacks is already set to group usage such as default or any other group you must remove that usage permission within the Backpacks plugin so that XPerience can control permissions

        *****************************************************/
        #endregion
        #region version 1.4.5
        /*****************************************************
        ----------------------
        ✯ version 1.4.5
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Minor change to admin addon details page
        ✯ Adjusted Other Mod Settings page to fit new support options

        More Economics Support:
        ✯ Option to set costs to level stats/skills
        ✯ Option to set multiplier cost per level

        More Server Rewards Support
        ✯ Option to set costs to level stats/skills
        ✯ Option to set multiplier cost per level

        *****************************************************/
        #endregion
        #region version 1.4.4
        /*****************************************************
        ----------------------
        ✯ version 1.4.4
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Possible fix for OnEntityDeath error from turret kills
        ✯ Added new admin page for XPerienceAddon options and details
        ✯ New API for developers to return player info

        *****************************************************/
        #endregion
        #region version 1.4.3
        /*****************************************************
        ----------------------
        ✯ version 1.4.3
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Added option to allow players to level Captaincy without being in a team
        ✯ Added support for other tech tree mods when OnTechTreeNodeUnlock hook is called
        ✯ XPerience now auto reloads Addon if detected when XPerience reloads
        ✯ Updated admin reset panel with new commands
        ✯ Admin reset panel now has KillRecords reset option
        ✯ Fixed SQL issues not creating Rank tables on first install
        ✯ Possible fix for OnPlayerHealthChange error
        ✯ Possible fix for OnLoseCondition error

        *****************************************************/
        #endregion
        #region version 1.4.2
        /*****************************************************
        ----------------------
        ✯ version 1.4.2
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Quick update for missing Addon Features
        ✯ Added new chat command for admins to give xp to all players

        *****************************************************/
        #endregion
        #region version 1.4.1
        /*****************************************************
        ----------------------
        ✯ version 1.4.1
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Added ScareCrow to xp gain list with option to set xp amount
        ✯ Fixed player chat not working and Ranks will not show in chat if ColouredChat plugin installed
        ✯ Fixed player status not being set on first join
        ✯ Added option to allow players to opt out of prestige ranks
        ✯ Added option to allow autoturrets to give owners xp and set amount given
        ✯ Added cooldown timer for crafting XP to prevent crafting XP spamming
        ✯ Added support for latest KillRecords tracking of scarecrows and turrets
        ✯ Code cleanup - removed unused coding and better handlers

        NOTE: If player opts out of prestige ranks they will not benefit from any rank boosts even if they currently have a rank.
        All rank benefits will be disabled for that player until they opt back in. 
        No previous progress will be lost and no further progress will be granted after reaching max level.

        New Medic Ability:
        ✯ Healing teas now give % bonus health per Medic level
        ✯ Option to set bonus amount

        New Plugin Support:
          Archery Plugin:
            ✯ Enable - allows XPerience to grant/revoke permissions
            ✯ Option to require specific rank level to unlock
            ✯ Option to set the Stat or Skill Archery is assigned to
            ✯ Option to set required Stat/Skill level for Novice, Adept, and Master abilities
            ✯ Option to auto remove permissions on plugin unload
          Wizardry Plugin:
            ✯ Enable - allows XPerience to grant/revoke permissions
            ✯ Option to require specific rank level to unlock
            ✯ Option to set the Stat or Skill Wizardry is assigned to
            ✯ Option to set required Stat/Skill level for Novice, Adept, and Master abilities
            ✯ Option to auto remove permissions on plugin unload

        *****************************************************/
        #endregion
        #region version 1.4.0
        /*****************************************************
        ----------------------
        ✯ version 1.4.0
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Added support for XPerienceAddon Discord Features
        ✯ Fixed permission issues for xperience.admin

        *****************************************************/
        #endregion
        #region version 1.3.9
        /*****************************************************
        ----------------------
        ✯ version 1.3.9
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Fixed issues with group permissions
        ✯ Added field to ranks in config for custom group name
        ✯ Added option for players to keep previous rank groups
        ✯ Fixed armor reduction in Dexterity preventing damage to players
        ✯ Added additional page to Help UI for steam privacy agreement section 5.5
        ✯ Fixed new players not being assign group when joining

        *****************************************************/
        #endregion
        #region version 1.3.8
        /*****************************************************
         ----------------------
         ✯ version 1.3.8
         ----------------------
        ** MAJOR UPDATE **
         DELETE LANG FILE BEFORE UPLOADING UPDATE!

        Bug Fixes / Changes:
        ✯ Another Fix for not changing online status if player was kicked or disconnected randomly
        ✯ Added support for the latest KillRecords harvest tracking to KillRecords page
        ✯ Added new harvest API for XPerienceAddon
        ✯ New SQL update method for creating new columns in existing SQL database
        ✯ Fixed player profile reset when admin uses /xpgive command to player
        ✯ Adjusted Top UI pages to fit new Ranks feature
        ✯ Changed main icon for profiles to show rank image if ranks enabled
        ✯ New API for Addon to include Ranks feature
        ✯ Admin givexp command now carries over remaining XP if enabled
        ✯ Expanded Captaincy Skill to effect more skills
        ✯ Admin can now give xp to any player in the records 
        ✯ Admin/Player fixdata issues resolved and compensates for rank feature if enabled
        ✯ Fixed Apple chance and Metal chance when using power tools (disable power tool option must be true)
        ✯ Added support for BetterChat plugin when using Ranks and chat tags
        ✯ Added option to only give xp at the end of cutting trees or mining ore
        ✯ Fixed issues with smithy skill not giving higher production rates when max level or fuel reduction activates
        ✯ Armor asorbtion now rounded up to whole number

        New Ranks Feature: (custom ranks after reaching max level)
        ✯ Enable max level ranks reset feature
        ✯ Option to set max rank
        ✯ Option to allow remaining XP to carry over
        ✯ Set XP boost per rank
        ✯ Set Stats/Skills boost per rank
        ✯ Set Start Stat/Skill points per rank
        ✯ Set Additional Stat/Skill points per level per rank
        ✯ Option to show rank level
        ✯ Option to show rank xp
        ✯ Option to set rank name, level, xp colors
        ✯ Top ranked players page in Top UI
        ✯ Sends Rank, Name, Sig, ImageURL, Level, and XP to SQL if used
        ✯ Option to show Rank Tag(sig) in chat name
        ✯ Option to show Rank Name and Image in LiveUI
        ✯ Admin chat commands to reset level only and rank only for players or all records
        ✯ Stats/Skills effected by ranks show same color as rank level in player profile UIs
        ✯ Groups feature to use for other mods to grant/restrict features based on player rank
        ✯ Creates groups for each rank listed in the config and automatically assigns/revokes player group based on rank

        NOTE: Rank Boosts adds additional % per rank level to all stat/skill effects if rank boosts enabled!
        If Rank Stat/Skill boosts enabled you may need to adjust base stat/skill values to compensate for extra boosts to all effects!

        New Harvest Amount Tracking:
        ✯ Wood
        ✯ Stone
        ✯ Metal
        ✯ Sulfur
        ✯ Cactus
        ✯ Berries
        ✯ Potatos
        ✯ Pumpkins
        ✯ Mushrooms
        ✯ Corn
        ✯ Hemp
        ✯ Seeds
        ✯ Admin reset harvest command
        ✯ Harvest count resets on player reset
        ✯ Sends all harvest data to SQL if used

        Don't forget to check out the New XPerienceAddon mod! Check our discord for details on how and where to get it.
        Discord: discord.skilledsoldiers.net
        *****************************************************/
        #endregion
        #region version 1.3.7
        /*****************************************************
         ----------------------
         ✯ version 1.3.7
         ----------------------
         DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Added PolarBear to KillRecords page if plugin is installed
        ✯ Added building upgrade xp cooldown to building start
        ✯ Possible fix for rare OnResearchCostDetermine error
        ✯ Fix for ImageLibrary URLs

        Don't forget to check out the New XPerienceAddon mod! Check our discord for details on how and where to get it.
        Discord: discord.skilledsoldiers.net
        *****************************************************/
        #endregion
        #region version 1.3.6
        /*****************************************************
         ----------------------
         ✯ version 1.3.6
         ----------------------
         DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Fixed not changing online status if player was kicked or disconnected randomly
        ✯ Added support for new polar bear (xp amount, hunter skills, etc..)

        Don't forget to check out the New XPerienceAddon mod! Check our discord for details on how and where to get it.
        Discord: discord.skilledsoldiers.net
        *****************************************************/
        #endregion
        #region version 1.3.5
        /*****************************************************
         ----------------------
         ✯ version 1.3.5
         ----------------------
         DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Fixed Tamer link not working in Top Players UI
        ✯ Fixed online indicator not showing correctly for second column in top player UIs
		✯ Added API needed for XPerienceAddon

        New Player Info Box:
        ✯ Can disable entire feature or each display option

        Player Data Shown: (since last spawn)
        ✯ Time Alive
        ✯ Time Sleeping
        ✯ Time Driving
        ✯ Time Boating
        ✯ Time Flying
        ✯ Time in Base
        ✯ Time in Monuments
        ✯ Time Swimming
        ✯ Meters Ran
        ✯ Meters Walked
        ✯ Last Damage Time
        ✯ Last Damage Source
        ✯ Last Attack Time
        ✯ Last Attack Source

        Don't forget to check out the New XPerienceAddon mod! Check our discord for details on how and where to get it.
        Discord: discord.skilledsoldiers.net
        *****************************************************/
        #endregion
        #region version 1.3.4
        /*****************************************************
         ----------------------
         ✯ version 1.3.4
         ----------------------
         DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Organized code cache for XPerienceAddon mod

        New Fisher Abilities
        ✯ Reduced oxygen tank usage
        ✯ Reduced oxygen usage without tanks before damage recieved

        New XPerienceAddon mod available! Check our discord for details on how and where to get it.
        Discord: discord.skilledsoldiers.net

        *****************************************************/
        #endregion
        #region version 1.3.3
        /*****************************************************
         ----------------------
         ✯ version 1.3.3
         ----------------------
         DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Additional TeaModifiers support implemented
        ✯ Fixed issues with drop in player health when resetting stats
        ✯ Fixed issues with wrong health values when player resets progress
        ✯ Fixed issues with wrong health values when Admin resets player progress
        ✯ Fixed issues with wrong health values when using FixData commands

        *****************************************************/
        #endregion
        #region version 1.3.2
        /*****************************************************
         ----------------------
         ✯ version 1.3.2
         ----------------------
         DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Adjusted extra armor calculations when using TeaModifiers plugin
        ✯ Fixed armor bar not showing properly when adjusting tea modifiers
        ✯ Fixed issues with using full reset commands
        ✯ Added API for retriving cache of XPerience (used for future addon)

        *****************************************************/
        #endregion
        #region version 1.3.1
        /*****************************************************
         ----------------------
         ✯ version 1.3.1
         ----------------------
         DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Fixed spent points total not showing correctly for Stats/Skills on profiles
        ✯ Fixed exploiting levels higher than max level set in Stats/Skills
        ✯ Fixed issues where LiveStatsUI would stack or replicate
        ✯ Fixed SQL errors due to player names

        *****************************************************/
        #endregion
        #region version 1.3.0
        /*****************************************************
         ----------------------
         ✯ version 1.3.0
         ----------------------
         DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Adjusted math calculations to prevent decimals in XP gains
        ✯ Fixed skill effects list not showing full values
        ✯ Crafter reduced repair cost ability now only works when condition chance activates
        ✯ Fixed XP exploit for opening containers for players without scavenger levels
        ✯ Fixed armor bar calculations with tea usage
        ✯ Teas now grant an extra armor boost based on tea type
        ✯ Added Tea boost, type, and time remaining to player profiles
        ✯ Notifacation cooldown setting now in seconds and effects more messages
        ✯ Added option to increase scientists loot in scavenger skill
        ✯ Fixed issue with armor and health reseting to default when plugins are reloaded

        New: Online Status Feature
        ✯ Shows online status if enabled on profile UIs and Top UIs
        ✯ Sends online status with SQL data for external use

        New: Permission Options
        ✯ Option to use permissions (disabled by default)
        ✯ Each Stat and Skill has it's own permission requirement
        ✯ Only Stats/Skills with permissions will be seen on profiles
        NOTE: If players already have stats/skills you must use Fix Player Data after setting permissions

        New: TeaModifiers Support
        ✯ Now supports TeaModifiers plugin to properly show armor stats

        *****************************************************/
        #endregion
        #region version 1.2.9
        /*****************************************************
        ----------------------
        ✯ version 1.2.9
        ----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Set max players per page in Top UI to 40 players
        ✯ Added second column for up to 40 players per page in top UI
        ✯ Fixed Economics issues when ressetting stats/skills
        ✯ Added ServerRewards cost options for resseting stats/skills
        ✯ Help chat commands now opens UI help page
        ✯ Code overhaul and rewrite for better performance
        ✯ Changed Medic mixing table speed setting from 0.1 to 0.01
        ✯ Added option to allow  players to reset their character back to 0
        ✯ Added second column to skill effects list when effects reach more than 30

        New Ability in Smithy Skill:
        ✯ Chance for high quality metal from mining ore
        ✯ Increased high quality metal amount per level

        New Ability in Miner Skill:
        ✯ Chance for metal fragments from mining ore
        ✯ Increased metal fragment amount per level

        New Custom Chat Commands Player/Admins: can set custom commands for:
        Players:
        ✯ Player stats UI
        ✯ Player stats chat display
        ✯ Top players UI
        ✯ Help page UI
        ✯ Player reset stats
        ✯ Player reset skills
        ✯ Player LiveStats Selection
        Admins:
        ✯ Admin Help commands
        ✯ Admin Panel UI
        ✯ Admin Give XP
        ✯ Admin Take XP
        ✯ Admin Player Reset
        ✯ Admin Full Reset
        ✯ Admin Fix All Data
        ✯ Admin Item condition and max condition change command

         *****************************************************/
        #endregion
        #region version 1.2.8
        /*****************************************************
		----------------------
		✯ version 1.2.8
		----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Armor bar no longer shows if armor config set to 0
        ✯ If Scavenger loot multiplier set to 0 it will not longer run extra loot hook
        ✯ Moved reset buttons for stats/skills next to labels on My Stats page
        ✯ Admin: stat settings now count by 0.01 instead of 0.1 (stats only)
        ✯ Admin: skills for fuel consumption settings now count by 0.01 instead of 0.1
        ✯ Code cleanup and rewrite for performance

        New Fullscreen UI: Top Players
        ✯ Show top player for Levels, Stats, and Skills
        ✯ Option to set how many players per page

         *****************************************************/
        #endregion
        #region version 1.2.7
        /*****************************************************
		----------------------
		✯ version 1.2.7
		----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ New Live Stats UI layouts
        ✯ Now anytime a config value for stats/skills is negative the perk values will turn red for players
        ✯ Fixed player profiles being seen from Online Players when player searching disabled

         *****************************************************/
        #endregion
        #region version 1.2.6
        /*****************************************************
		----------------------
		✯ version 1.2.6
		----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ Added color option for stat/skill/effect labels in UI
        ✯ Fixed OnResearchCostDetermine errors
        ✯ Removed all old UI coding for cleanup
        ✯ Implemented required level option for custom item drops in Scavenger
        ✯ Added Option to randomize custom item drop amount
        ✯ Added option to set Chat/UI notify timers to prevent spamming
        ✯ Combined Save/Reload buttons in admin UI
        ✯ Fixed admins not being able to use playerfixdata on profile when admin bypass enabled
        ✯ Added option to show unused stats/skills
        ✯ Fixed exploit with container loot multiplier
        ✯ Fixed chance of more durability when crafting if option is disabled
        ✯ New fullscreen UI now used for showing other player stats
        ✯ UI will not show any stat/skill effects that are set to 0
        ✯ Cleaned up UI for admin area and stats page
        ✯ Reset buttons no longer show if Hardcore mode enabled
        ✯ Reset buttons and fixdata button now show for admins if admin bypass enabled
        ✯ Cleaned code of any remaining Chemist stats 
        ✯ Added option to delay in seconds giving XP on building to prevent exploits with other mods

        Added ImageLibrary Support: (requires ImageLibrary plugin)
        ✯ Default icon URLs included
        ✯ Can set custom icon URLs

         *****************************************************/
        #endregion
        #region version 1.2.5
        /*****************************************************
		----------------------
		✯ version 1.2.5
		----------------------
        DELETE LANG FILE BEFORE UPLOADING UPDATE!

        ✯ New Fullscreen UI for players (old UI will be removed in the future)
        ✯ Fixed issues with Medic points and Calculations
        ✯ Rewrote hooks to work with new scavenger skill
        ✯ Fixed player chat profile on connect not showing properly
        ✯ Removed unused code (more to come when old UI removed)
        ✯ Changed critical hit amount to round up to prevent 0 crital damage
        ✯ Fixed loot container IDs not saving causing exploits
        ✯ Fixed new players LiveStatsUI not being set to config default location
        ✯ Moved Tamer skill settings in admin panel to Other Mod settings page

        NEW SKILL: Scavenger
        ✯ Chance for more loot in Drops/Crates  
        ✯ Loot Multiplier per level
        ✯ Option to set Extra loot to components only
        ✯ Custom item list in config to drop what items you want
        ✯ Custom item Multiplier per level x base item amount
        ✯ Option to set base amount per custom item
        ✯ Option to set max amount per custom item
        ✯ Option to enable/disable Drops & Different Crates 
        NOTE: (required level in custom item list not implemented yet)

        New Fullscreen UI For Players:
        ✯ Smarter UI where users can edit everything in one page
        ✯ Displays points needed for next level for stats/skills
        ✯ Only shows active Stat/Skill abilities in a cleaner list
        ✯ Kill Records page so players can view their records inside XPerience (Kill Records plugin required)
        ✯ Auto close feature closes UI when player takes damage
        ✯ Quick link button for admins to go to admin panel and vise versa

        *****************************************************/
        #endregion
        #region version 1.2.4
        /*****************************************************
		----------------------
		✯ version 1.2.4
		----------------------
        ✯ Fixed repair skill in crafter
        ✯ Fixed Admin panel FixPlayerData button issues

        *****************************************************/
        #endregion
        #region version 1.2.3
        /*****************************************************
		----------------------
		✯ version 1.2.3
		----------------------
        ✯ Added individual player reset command for admins
        ✯ Fixed fixplayerdata not resetting all players
        ✯ Fixed Admin Give/Take XP command not working on sleepers/offline players
        ✯ Fixed Admin Give/Take XP not properly setting players levels
        ✯ Adjusted Captaincy Stat and XP gain now stacks on other gains (if enabled)

        *****************************************************/
        #endregion
        #region version 1.2.2
        /*****************************************************
		----------------------
		✯ version 1.2.2
		----------------------
        ✯ Added Teams support
        ✯ Added option to share XP gain and loss
        ✯ Added option to set team distance for gains/loss

        ✯ ADDED NEW STAT = Captaincy
        ✯ Requires Team of 2 or more players
        ✯ Give boosts to all other team member skills
        ✯ Optional boost to all other team member XP gains
        ✯ Increase effective distance of Captaincy per level
        ✯ Stacks with other members with Captancy stat

        *****************************************************/
        #endregion
        #region version 1.2.1
        /*****************************************************
		----------------------
		✯ version 1.2.1
		----------------------
        ✯ More fixes repair item issues in Crafting skill
        ✯ Added option to disabled players fix data option
        ✯ Added Hardcore No Reset Option - players cannot reset stats/skills
        ✯ Changed XP loss to % of current level XP instead of total XP

        *****************************************************/
        #endregion
        #region version 1.2.0
        /*****************************************************
		----------------------
		✯ version 1.2.0
		----------------------
        ✯ Added reset page to admin panel for resetting config and all players
        ✯ Fixed crafting and repair issue in Crafting skill
        ✯ Changed all crafting adjustments from 0.1 to 0.01  in Crafting skill
        ✯ Added repair cost decrease to Crafter skill
        ✯ Fixed XP from going negative
        ✯ Fixed LiveUI not updating when FixPlayerData used
        ✯ Fixed SQL error on server save
        ✯ Resetting XPerience now deletes all SQL data as well
        ✯ Moved all other mod support to a seperate admin page "Other Mod Settings"
        ✯ Added API (Hooks) for developers to add/take xp 

        ✯ Added Server Rewards support: (requires Server Rewards plugin)
        ✯ Option to enable level up reward and amount
        ✯ Option to enable level down reduction and amount
        
        ✯ Added Clans support: (requires Clans plugin)
        ✯ Option to enable shared xp gain and amount
        ✯ Option to enable shared xp reduction and amount

        *****************************************************/
        #endregion
        #region version 1.1.9
        /*****************************************************
		----------------------
		✯ version 1.1.9
		----------------------
        ✯ Fixed power tool detection not working to disable xp
        ✯ Changed apple chance adjustment from 0.1 to 0.01
        ✯ Fixed xp gain issue when upgrading buildings with Building Grades plugin

        ✯ Added Economics support: (requires Economics plugin)
        ✯ Option to enable level up reward and amount
        ✯ Option to enable level down reduction and amount
        ✯ Option to enable cost to reset stats and amount
        ✯ Option to enable cost to reset skills and amount
        *****************************************************/
        #endregion
        #region version 1.1.8
        /*****************************************************
		----------------------
		✯ version 1.1.8
		----------------------
        ✯ Added xp for reviving players
        ✯ Replaced Chemist Stat with Medic Skill
        ✯ Expanded UIs to fit new skill
        ✯ Changed LiveStats location label
        ✯ Added Fix My Data button to help page for players to fix their own data after server settings change
        ✯ Added timer on admin timer page for player fix data option
        ✯ Fixed level boost setting adjustment from 0.1 to 0.01
        ✯ Fixed Armor bar display issues not showing correct values
        ✯ Changed OnFishCaught to OnFishCatch so fishing skill works again
        ✯ Changed Critical and Block display to round to whole numbers
        ✯ Added option to show KillRecords button on Player Control Panel
        ✯ Adjusted cold/heat tolerance detection - more work needed
        ✯ Added option to disable XP when using chainsaw or jackhammer

        ✯ Added New Skill (Medic):
        ✯ Reduced crafting time (mixing table)
        ✯ Revive players with more health
        ✯ Recover from wounded with higher health
        ✯ Get more health from some medical tools

        ✯ Added UINotify support: (requires UINotify plugin and user permissions)
        ✯ Option to disable default chat messages
        ✯ Show XP gain/loss in UINotify
        ✯ Show Level up/down in UInotify
        ✯ Show Dodge/Block notification in UINotify
        ✯ Show Critical Hit in UINotify

        ATTENTION - IF YOU HAVEN'T ALREADY DONE SO WITH PREVIOUS UPDATES YOU MUST RUN CHAT COMMAND /xpupdate THEN USE REPAIR ALL PLAYER DATA IN ADMIN PANEL!
        *****************************************************/
        #endregion
        #region version 1.1.7
        /*****************************************************
		----------------------
		✯ version 1.1.7
		----------------------
        ✯ Fixed gunpowder multiply issue when above level 5 crafter

        ATTENTION - IF YOU HAVEN'T ALREADY DONE SO WITH PREVIOUS UPDATES YOU MUST RUN CHAT COMMAND /xpupdate THEN USE REPAIR ALL PLAYER DATA IN ADMIN PANEL!
          *****************************************************/
        #endregion
        #region version 1.1.6
        /*****************************************************      
        ----------------------
		✯ version 1.1.6
		----------------------
        ✯ Fixed building repair issues
		✯ Rewrote building repair to properly reduce costs and time
        ✯ Fixed item repair issues

        ATTENTION - IF YOU HAVEN'T ALREADY DONE SO WITH PREVIOUS UPDATES YOU MUST RUN CHAT COMMAND /xpupdate THEN USE REPAIR ALL PLAYER DATA IN ADMIN PANEL!
        *****************************************************/
        #endregion
        #region version 1.1.5
        /*****************************************************    
        ----------------------
		✯ version 1.1.5
		----------------------
		✯ Changed some lang text
        ✯ Reordered admin panel menu
        ✯ Setting Stats/Skills to max level 0 will now disable them
        ✯ Fixed level percentage not showing correct value
        ✯ Fixed admin FixPlayerData button not working for server admins

        ✯ Added Missions Support:
        ✯ Option to set eperience reward amount
        ✯ Option to enable failed xp reduction
        ✯ Option to set failed xp reduction amount

        ATTENTION - IF YOU HAVEN'T ALREADY DONE SO WITH LAST UPDATE YOU MUST RUN CHAT COMMAND /xpupdate THEN USE REPAIR ALL PLAYER DATA IN ADMIN PANEL!
        *****************************************************/
        #endregion
        #region version 1.1.4
        /*****************************************************        
        ----------------------
		✯ version 1.1.4
		----------------------
		✯ Added 5th location option for LiveUI stats
        ✯ Added Admin Control Panel for config changes in game
        ✯ Added Option to prevent players from changing LiveUI Location
        ✯ Added option to disable armor absorb chat messages
        ✯ Fixed tamer skill not giving permissions to use Pets mod
        ✯ Rewrote xp and level progression
        ✯ Added max level limit option (default 500)
        ✯ Added admin command to reset all player stats except experience
        ✯ Fixed OnPlayerHealthChange error

        ATTENTION - MUST RUN CHAT COMMAND /xpupdate THEN USE REPAIR ALL PLAYER DATA IN ADMIN PANEL!
        *****************************************************/
        #endregion
        #region version 1.1.3
        /*****************************************************
        ----------------------
		✯ version 1.1.3
		----------------------
		✯ Fixed level loss issue when admin removes more than 1 level of xp from a player
        *****************************************************/
        #endregion
        #region version 1.1.2
        /*****************************************************        
        ----------------------
		✯ version 1.1.2
		----------------------
		✯ Fixed error from c4 on bradley
        ✯ Fixed point cost multipler to go off next level instead of current
        ✯ Added new pages to help UI that shows server settings
        ✯ Added new pages to help UI that explains all stats and skills
        ✯ Added Admin command for giving expience to players
        ✯ Added Admin command for taking expience from players

        ✯ Ingame Admin Panel Coming Soon
        *****************************************************/
        #endregion
        #region version 1.1.1
        /*****************************************************	
		----------------------
		✯ version 1.1.1
		----------------------
		✯ Fixed OnEntityTake Damage Error
        *****************************************************/
        #endregion
        #region version 1.1.0
        /*****************************************************	
		----------------------
		✯ version 1.1.0
		----------------------
		✯ Fixed building errors
		✯ Fixed TC auth issues
		✯ Fixed crafting cost issues
		✯ Changed API hook - expects rarity cost as double
		✯ Fixed OnEntityDeath errors
		✯ Added VIP class for seperate reset timers
        *****************************************************/
        #endregion
        #region version 1.0.9
        /*****************************************************
		----------------------
		✯ version 1.0.9
		----------------------
		✯ LiveUI selection within player control panel
		✯ Added HELP button to control panel
		✯ created HELP UI that will explain XPerience in more detail to players
		✯ fixed OnPlayerDeath error
		✯ fixed OnEntityTakeDamage error
		✯ Fixed ResearchCostDetermain error
		✯ Added API support for other Research mods
		✯ Changed gather rate from multiple to addition
		✯ Added option to use vanilla gather rates
		✯ Fixed armor bar display when using tea
		✯ Added Bradley / Helicopter XP gain options
		✯ Added config list for randomchance items in forager
        *****************************************************/
        #endregion
        #region version 1.0.8
        /*****************************************************
		----------------------
		✯ version 1.0.8
		----------------------
		✯ Added armor damage reduction - dexterity
		✯ Changed Smithy skill to include % chance production increase
		✯ Added option to allow admin class to bypass reset timers
		✯ Added more items to random find in Forager
		✯ Ability to search other player stats
		✯ Top list names now link to player stats
        *****************************************************/
        #endregion
        #region version 1.0.7
        /*****************************************************
		----------------------
		✯ version 1.0.7
		----------------------
		✯ Fixed research cost issues
		✯ Added apple as random item on forager
        *****************************************************/
        #endregion
        #region version 1.0.6
        /*****************************************************
		----------------------
		✯ version 1.0.6
		----------------------
		✯ Added reset restriction and timer option
        *****************************************************/
        #endregion
        #region version 1.0.5
        /*****************************************************
		----------------------
		✯ version 1.0.5
		----------------------
		✯ fixed lang API spelling
		✯ Added admin reset command
		✯ fixed metabolism issues
        *****************************************************/
        #endregion
        #region version prereleases
        /*****************************************************
		----------------------
		✯ version 1.0.4
		----------------------
		✯ more lang API fixes

		----------------------
		✯ version 1.0.3
		----------------------
		✯ full lang api addition

		----------------------
		✯ version 1.0.2
		----------------------
		✯ fixed hooks and loading issues

		----------------------
		✯ version 1.0.1
		----------------------
		✯ more language definitions
		✯ fixed OnEntityTakeDamage error

        *****************************************************/
        #endregion
        /*****************************************************
		----------------------
		To-Do:
		✯ More pet abilities for tamer
		✯ Fix horse taming
		✯ Add chance for more grubs/worms
		*****************************************************/
        #endregion

        #region Refrences
        [PluginReference]
        private readonly Plugin XPerienceAddon, KillRecords, Pets, UINotify, Economics, ServerRewards, Clans, ImageLibrary, TeaModifiers, BetterChat, ColouredChat, Archery, Wizardry, Backpacks;
        #endregion

        #region Fields
        public const string version = "1.5.1";
        private XPData _xpData;
        private LootData _lootData;
        private CorpseData _corpseData;
        private HorseData _horseData;
        private WeaponData _weaponData;
        private BoatData _boatData;
        private VehicleData _vehicleData;
        private MinicopterData _minicopterData;
        private DynamicConfigFile _XPerienceData;
        private DynamicConfigFile _LootContainData;
        private DynamicConfigFile _CorpseContainData;
        private DynamicConfigFile _HorseData;
        private DynamicConfigFile _WeaponData;
        private DynamicConfigFile _BoatData;
        private DynamicConfigFile _VehicleData;
        private DynamicConfigFile _MinicopterData;
        private Dictionary<string, XPRecord> _xperienceCache;
        private Dictionary<uint, Loot> _lootCache;
        private Dictionary<uint, Corpse> _corpseCache;
        private Dictionary<uint, Horse> _horseCache;
        private Dictionary<uint, Weapon> _weaponCache;
        private Dictionary<uint, Boat> _boatCache;
        private Dictionary<uint, Vehicle> _vehicleCache;
        private Dictionary<uint, Minicopter> _minicopterCache;
        private Configuration config;
        private static readonly RNGCryptoServiceProvider _generator = new RNGCryptoServiceProvider();
        private const string Admin = "xperience.admin";
        private const string VIP = "xperience.vip";
        private const string PermMentality = "xperience.mentality";
        private const string PermDexterity = "xperience.dexterity";
        private const string PermMight = "xperience.might";
        private const string PermCaptaincy = "xperience.captaincy";
        private const string PermWeaponry = "xperience.weaponry";
        private const string PermWoodCutter = "xperience.woodcutter";
        private const string PermSmithy = "xperience.smithy";
        private const string PermMiner = "xperience.miner";
        private const string PermForager = "xperience.forager";
        private const string PermHunter = "xperience.hunter";
        private const string PermFisher = "xperience.fisher";
        private const string PermCrafter = "xperience.crafter";
        private const string PermFramer = "xperience.framer";
        private const string PermMedic = "xperience.medic";
        private const string PermScavenger = "xperience.scavenger";
        private const string PermTamer = "xperience.tamer";
        private readonly Hash<ulong, double> _notifyCooldowns = new Hash<ulong, double>();
        private readonly Hash<ulong, double> _buildCooldowns = new Hash<ulong, double>();
        private readonly Hash<ulong, double> _craftCooldowns = new Hash<ulong, double>();
        private readonly Hash<ulong, int> _TopUIPage = new Hash<ulong, int>();
        private double CurrentTime => DateTime.UtcNow.Subtract(new DateTime(1970, 1, 1, 0, 0, 0)).TotalSeconds;
        private bool _isXPReady;
        private bool _isRestart = true;
        private int _imageLibraryCheck = 0;
        private Dictionary<string, string> _xperienceImageList;
        #endregion

        #region Config
        private class Configuration : SerializableConfiguration
        {
            [JsonProperty("Player Chat Commands")]
            public PlayerChatCommands playerchatCommands = new PlayerChatCommands();
            [JsonProperty("Admin Chat Commands")]
            public AdminChatCommands adminchatCommands = new AdminChatCommands();
            [JsonProperty("Player Info Box")]
            public PlayerInfoBoxSettings playerinfoBoxsettings = new PlayerInfoBoxSettings();
            [JsonProperty("Default Options")]
            public DefaultOptions defaultOptions = new DefaultOptions();
            [JsonProperty("UI Text Colors")]
            public UITextColor uitextColor = new UITextColor();
            [JsonProperty("Image Icons")]
            public ImageIcons imageicons = new ImageIcons();
            [JsonProperty("UI Notify (requires UINotify plugin)")]
            public UINotifier UiNotifier = new UINotifier();
            [JsonProperty("XP - Level Config")]
            public XpLevel xpLevel = new XpLevel();
            [JsonProperty("XP - Level Ranks")]
            public XpLevelRanks xpLevelRanks = new XpLevelRanks();
            [JsonProperty("XP - Night Bonus")]
            public NightBonus nightBonus = new NightBonus();
            [JsonProperty("XP - Gain Amounts")]
            public XpGain xpGain = new XpGain();
            [JsonProperty("XP - Gather Amounts")]
            public XpGather xpGather = new XpGather();
            [JsonProperty("XP - Building Amounts")]
            public XpBuilding xpBuilding = new XpBuilding();
            [JsonProperty("XP - Teams")]
            public XpTeams xpTeams = new XpTeams();
            [JsonProperty("XP - Mission Amounts")]
            public XpMissions xpMissions = new XpMissions();
            [JsonProperty("XP - Reducer Amounts")]
            public XpReducer xpReducer = new XpReducer();
            [JsonProperty("BonusXP - Bonus Amounts (requires KillRecords plugin)")]
            public XpBonus xpBonus = new XpBonus();
            [JsonProperty("Economics Rewards (requires Economics plugin)")]
            public XpEcon xpEcon = new XpEcon();
            [JsonProperty("Server Rewards (requires ServerRewards plugin)")]
            public SRewards sRewards = new SRewards();
            [JsonProperty("Mentality Stat")]
            public Mentality mentality = new Mentality();
            [JsonProperty("Dexterity Stat")]
            public Dexterity dexterity = new Dexterity();
            [JsonProperty("Might Stat")]
            public Might might = new Might();
            [JsonProperty("Captaincy Stat")]
            public Captaincy captaincy = new Captaincy();
            [JsonProperty("Weaponry Stat")]
            public Weaponry weaponry = new Weaponry();
            [JsonProperty("WoodCutter Skill")]
            public Woodcutter woodcutter = new Woodcutter();
            [JsonProperty("Smithy Skill")]
            public Smithy smithy = new Smithy();
            [JsonProperty("Miner Skill")]
            public Miner miner = new Miner();
            [JsonProperty("Forager Skill")]
            public Forager forager = new Forager();
            [JsonProperty("Hunter Skill")]
            public Hunter hunter = new Hunter();
            [JsonProperty("Fisher Skill")]
            public Fisher fisher = new Fisher();
            [JsonProperty("Crafter Skill")]
            public Crafter crafter = new Crafter();
            [JsonProperty("Framer Skill")]
            public Framer framer = new Framer();
            [JsonProperty("Medic Skill")]
            public Medic medic = new Medic();
            [JsonProperty("Scavenger Skill")]
            public Scavenger scavenger = new Scavenger();
            [JsonProperty("Tamer Skill")]
            public Tamer tamer = new Tamer();
            [JsonProperty("Clans (requires Clans plugin)")]
            public XpClans xpclans = new XpClans();
            [JsonProperty("SQL Info")]
            public SQL sql = new SQL();
            [JsonProperty("Archery Mod")]
            public ArcheryMod archerymod = new ArcheryMod();
            [JsonProperty("Wizardry Mod")]
            public WizardryMod wizardrymod = new WizardryMod();
            [JsonProperty("Backpacks Mod")]
            public BackpacksMod backpacksmod = new BackpacksMod();
        }
        public class PlayerChatCommands
        {
            public string openplayerstats = "xpstats";
            public string showplayerstatschat = "xpstatschat";
            public string opentopplayers = "xptop";
            public string playeraddstat = "xpaddstat";
            public string playeraddskill = "xpaddskill";
            public string playerresetstats = "xpresetstats";
            public string playerresetskills = "xpresetskills";
            public string playerresetall = "xprestart";
            public string playerliveuichange = "xpliveui";
            public string openhelp = "xphelp";
        }
        public class AdminChatCommands
        {
            public string showadminhelp = "xpadminhelp";
            public string openadminpanel = "xpconfig";
            public string adminresetxperience = "xpresetall";
            public string adminxpgive = "xpgive";
            public string adminxpgiveall = "xpgiveall";
            public string adminxptake = "xptake";
            public string adminresetplayer = "xpresetplayer";
            public string adminfixdata = "xpfix";
            public string adminitemchange = "itemchange";
            public string adminresetharvest = "resetharvest";
            public string adminresetlevelonly = "resetlevel";
            public string adminresetrankonly = "resetrank";
            public string adminresetlevelonlyall = "resetalllevels";
            public string adminresetrankonlyall = "resetallranks";
        }
        public class PlayerInfoBoxSettings
        {
            public bool showinfobox = true;
            public bool alivetime = true;
            public bool sleepingtime = true;
            public bool swimingtime = true;
            public bool drivingtime = true;
            public bool flyingtime = true;
            public bool boatingtime = true;
            public bool basetime = true;
            public bool monumenttime = true;
            public bool wildernesstime = true;
            public bool metersran = true;
            public bool meterswalked = true;
            public bool lastdmgrec = true;
            public bool lastdmgrecby = true;
            public bool lastdmgdelt = true;
            public bool lastdmgdeltto = true;
        }
        public class DefaultOptions
        {
            public bool userpermissions = false;
            public int liveuistatslocation = 1;
            public bool liveuistatslocationmoveable = true;
            public bool showchatprofileonconnect = true;
            public bool showunusedeffects = false;
            public int NotifcationCooldown = 2;
            public bool restristresets = true;
            public int resetminsstats = 60;
            public int resetminsskills = 60;
            public bool bypassadminreset = true;
            public int vipresetminstats = 30;
            public int vipresetminsskills = 30;
            public int playerfixdatatimer = 60;
            public bool disableplayerfixdata = false;
            public bool disablearmorchat = false;
            public bool hardcorenoreset = false;
            public bool allowplayersearch = true;
            public bool allowplayerreset = false;
            public int topplayersperpage = 20;
            public bool showonlinestatus = true;
            public bool useprogressivelevelicons = true;
            public bool showfuelguage = true;
            public bool showspeedometer = true;
            public int speedometertype = 1;
        }
        public class UITextColor
        {
            public string defaultcolor = "white";
            public string level = "green";
            public string ranklevel = "blue";
            public string rankxp = "blue";
            public string rankname = "magenta";
            public string experience = "green";
            public string nextlevel = "yellow";
            public string remainingxp = "cyan";
            public string statskilllevels = "yellow";
            public string perks = "green";
            public string unspentpoints = "green";
            public string spentpoints = "red";
            public string pets = "cyan";
            public string mentality = "white";
            public string dexterity = "white";
            public string might = "white";
            public string captaincy = "white";
            public string weaponry = "white";
            public string woodcutter = "white";
            public string smithy = "white";
            public string miner = "white";
            public string forager = "white";
            public string hunter = "white";
            public string fisher = "white";
            public string crafter = "white";
            public string framer = "white";
            public string medic = "white";
            public string scavenger = "white";
            public string tamer = "white";
        }
        public class ImageIcons
        {
            public string mainicon = "https://i.imgur.com/JUwd2a8.png";
            public string mentality = "https://i.imgur.com/dR7Hcif.png";
            public string dexterity = "https://i.imgur.com/u9BSoMI.png";
            public string might = "https://i.imgur.com/BXCVcKb.png";
            public string captaincy = "https://i.imgur.com/6y5Yha1.png";
            public string weaponry = "https://i.imgur.com/k6jGA6F.png";
            public string woodcutter = "https://i.imgur.com/3teb5s2.png";
            public string smithy = "https://i.imgur.com/uz8szzL.png";
            public string miner = "https://i.imgur.com/lFkLUv0.png";
            public string forager = "https://i.imgur.com/SSdZZ8O.png";
            public string hunter = "https://i.imgur.com/UwASeQs.png";
            public string fisher = "https://i.imgur.com/QU76hi1.png";
            public string crafter = "https://i.imgur.com/IiywcbI.png";
            public string framer = "https://i.imgur.com/M3VgQic.png";
            public string medic = "https://i.imgur.com/mXp3Mrh.png";
            public string scavenger = "https://i.imgur.com/g3S4XKW.png";
            public string tamer = "https://i.imgur.com/DatpWzL.png";
            public string chicken = "https://i.imgur.com/qJYzAZ6.png";
            public string boar = "https://i.imgur.com/ou1DgxE.png";
            public string stag = "https://i.imgur.com/CwACyuG.png";
            public string wolf = "https://i.imgur.com/J18C2Je.png";
            public string bear = "https://i.imgur.com/kTbD3B1.png";
            public string polarbear = "https://i.imgur.com/Shk1sza.png";
            public string archery = "https://i.imgur.com/qdm8AWg.png";
            public string wizardry = "https://i.imgur.com/aNuEdni.png";
            public string online = "https://i.imgur.com/WafMLkk.png";
            public string offline = "https://i.imgur.com/QtbFqQz.png";
            public string backpack = "https://i.imgur.com/zJbJpwx.png";
            public string xp = "https://i.imgur.com/u46vNfo.png";
            public string level = "https://i.imgur.com/2ouaBoh.png";
            public string armor = "https://i.imgur.com/mEr59mA.png";
            public string level0 = "https://i.imgur.com/7KTHgTa.png";
            public string level2 = "https://i.imgur.com/GocRCM1.png";
            public string level4 = "https://i.imgur.com/KxxRouB.png";
            public string level6 = "https://i.imgur.com/Dgy9X9P.png";
            public string level8 = "https://i.imgur.com/IYloCuJ.png";
            public string level10 = "https://i.imgur.com/Xz9ZgZ4.png";
            public string fuelguage = "https://i.imgur.com/NhhE3qm.png";
            public string speedometer = "https://i.imgur.com/Q1Kqsfz.png";
            public string dash = "https://i.imgur.com/LLKCN1n.png";
            public string dmgindicator = "https://i.imgur.com/XzoMdbI.png";
        }
        public class UINotifier
        {
            public bool useuinotify = false;
            public bool disablechats = false;
            public bool xpgainloss = true;
            public int xpgainlosstype = 0;
            public bool levelupdown = true;
            public int levelupdowntype = 0;
            public bool dodgeblock = true;
            public int dodgeblocktype = 0;
            public bool criticalhit = true;
            public int criticalhittype = 0;
        }
        public class XpLevel
        {
            public double levelstart = 25;
            public double levelmultiplier = 50;
            public int maxlevel = 500;
            public double levelxpboost = 0.05;
            public int statpointsperlvl = 1;
            public int skillpointsperlvl = 2;
            public bool alwaysearnxp = false;
        }
        public class XpLevelRanks
        {
            public bool enableresetranks = false;
            public bool allowplayerdisable = false;
            public int maxresetrank = 13;
            public bool enablerankxpboost = false;
            public double rankxpboost = 0.01;
            public bool rankstatboost = false;
            public double rankstatboostamount = 0.01;
            public int rankstatpointstart = 1;
            public int rankstatpointincrease = 1;
            public bool rankskillboost = false;
            public double rankskillboostamount = 0.01;
            public int rankskillpointstart = 2;
            public int rankskillpointincrease = 1;
            public bool keepremainingxp = true;
            public bool showtruelevelprofile = true;
            public bool showrankinchat = true;
            public bool showtruexpprofile = true;
            public bool showrankinliveui = true;
            public bool keepgrouponrank = true;
            public Dictionary<int, Ranks> ranks = new Dictionary<int, Ranks>
            {
                [0] = new Ranks
                {
                    name = "Newbie",
                    sig = "",
                    image = "https://i.imgur.com/i6M4ZmV.png",
                    group = "Newbie",
                },
                [1] = new Ranks
                {
                    name = "Airman",
                    sig = "〘AMN〙",
                    image = "https://i.imgur.com/E0NeO2R.png",
                    group = "Airman",
                },
                [2] = new Ranks
                {
                    name = "Airman First Class",
                    sig = "〘A1C〙",
                    image = "https://i.imgur.com/wYL15FW.png",
                    group = "Airman First Class",
                },
                [3] = new Ranks
                {
                    name = "Senior Airman",
                    sig = "〘SRA〙",
                    image = "https://i.imgur.com/egqFVW5.png",
                    group = "Senior Airman",
                },
                [4] = new Ranks
                {
                    name = "Staff Sergeant",
                    sig = "〘SSGT〙",
                    image = "https://i.imgur.com/pL6jbXM.png",
                    group = "Staff Sergeant",
                },
                [5] = new Ranks
                {
                    name = "Technical Sergeant",
                    sig = "〘TSGT〙",
                    image = "https://i.imgur.com/XrtmWAn.png",
                    group = "Technical Sergeant",
                },
                [6] = new Ranks
                {
                    name = "Master Sergeant",
                    sig = "〘MSGT〙",
                    image = "https://i.imgur.com/muYU6lf.png",
                    group = "Master Sergeant",
                },
                [7] = new Ranks
                {
                    name = "First Sergeant",
                    sig = "〘1stSGT〙",
                    image = "https://i.imgur.com/1OJ2zso.png",
                    group = "First Sergeant",
                },
                [8] = new Ranks
                {
                    name = "Senior Master Sergeant",
                    sig = "〘SMSGT〙",
                    image = "https://i.imgur.com/zmNiE20.png",
                    group = "Senior Master Sergeant",
                },
                [9] = new Ranks
                {
                    name = "Senior First Sergeant",
                    sig = "〘S1stSGT〙",
                    image = "https://i.imgur.com/1S7Z0cO.png",
                    group = "Senior First Sergeant",
                },
                [10] = new Ranks
                {
                    name = "Chief Master Sergeant",
                    sig = "〘CMSGT〙",
                    image = "https://i.imgur.com/V6dQMJL.png",
                    group = "Chief Master Sergeant",
                },
                [11] = new Ranks
                {
                    name = "Chief First Sergeant",
                    sig = "〘C1stSGT〙",
                    image = "https://i.imgur.com/Dm6B08J.png",
                    group = "Chief First Sergeant",
                },
                [12] = new Ranks
                {
                    name = "Command Chief Master Sergeant",
                    sig = "〘CCMSGT〙",
                    image = "https://i.imgur.com/wE5C1w8.png",
                    group = "Command Chief Master Sergeant",
                },
                [13] = new Ranks
                {
                    name = "Chief Master Sergeant of the Server",
                    sig = "〘CMSGTS〙",
                    image = "https://i.imgur.com/UdqLO7a.png",
                    group = "Chief Master Sergeant of the Server",
                }
            };
        }
        public class Ranks
        {
            public string name;
            public string sig;
            public string image;
            public string group;
        }
        public class NightBonus
        {
            public bool Enable = true;
            public int StartTime = 19;
            public int EndTime = 5;
            public double Bonus = 0.10;
            public bool enableskillboosts = true;
        }
        public class XpGain
        {
            public double chickenxp = 5;
            public double fishxp = 5;
            public double boarxp = 10;
            public double stagxp = 15;
            public double wolfxp = 20;
            public double bearxp = 25;
            public double polarbearxp = 25;
            public double sharkxp = 30;
            public double horsexp = 20;
            public double scientistxp = 25;
            public double dwellerxp = 25;
            public double scarecrownpc = 25;
            public double customnpc = 25;
            public double zombienpc = 25;
            public double playerxp = 25;
            public double lootcontainerxp = 5;
            public double animalharvestxp = 5;
            public double corpseharvestxp = 5;
            public double underwaterlootcontainerxp = 10;
            public double lockedcratexp = 25;
            public double hackablecratexp = 50;
            public double craftingxp = 5;
            public bool craftingxpdelay = true;
            public double craftingxpdelayseconds = 10;
            public double bradley = 25;
            public double patrolhelicopter = 30;
            public double turretxp = 5;
            public bool allowturretxp = false;
            public double playerrevive = 5;
        }
        public class XpGather
        {
            public double treexp = 5;
            public double orexp = 5;
            public double harvestxp = 5;
            public double plantxp = 5;
            public bool noxptools = true;
            public bool onetimexp = false;
            public double toolxpchance = 0.20;
            public double toolxppercent = 0.10;
        }
        public class XpBuilding
        {
            public double twigstructure = 2;
            public double woodstructure = 5;
            public double stonestructure = 10;
            public double metalstructure = 15;
            public double armoredstructure = 20;
            public bool buildxpdelay = false;
            public int buildxpdelayseconds = 2;
        }
        public class XpTeams
        {
            public bool enableteamxpgain = true;
            public bool enableteamxploss = true;
            public double teamxpgainamount = 0.10;
            public double teamxplossamount = 0.05;
            public float teamdistance = 50f;
        }
        public class XpMissions
        {
            public double missionsucceededxp = 50;
            public bool missionfailed = false;
            public double missionfailedxp = 10;
        }
        public class XpReducer
        {
            public bool suicidereduce = true;
            public double suicidereduceamount = 0.05;
            public bool deathreduce = true;
            public double deathreduceamount = 0.05;
        }
        public class XpBonus
        {
            public bool showkrbutton = false;
            public bool enablebonus = false;
            public int requiredkills = 10;
            public double bonusxp = 5;
            public int endbonus = 500;
            public bool multibonus = true;
            public string multibonustype = "fixed";
        }
        public class XpEcon
        {
            public bool econlevelup = false;
            public bool econleveldown = false;
            public bool econresetstats = false;
            public bool econresetskills = false;
            public double econlevelreward = 50;
            public double econlevelreduction = 25;
            public double econresetstatscost = 100;
            public double econresetskillscost = 100;
            public bool econstatlevelcost = false;
            public bool econskilllevelcost = false;
            public double econstatlevelcostmultiplier = 0;
            public double econskilllevelcostmultiplier = 0;
            public double econmentality = 100;
            public double econdexterity = 100;
            public double econmight = 100;
            public double econcaptaincy = 100;
            public double econweaponry = 100;
            public double econwoodcutter = 100;
            public double econsmithy = 100;
            public double econminer = 100;
            public double econforager = 100;
            public double econhunter = 100;
            public double econfisher = 100;
            public double econcrafter = 100;
            public double econframer = 100;
            public double econmedic = 100;
            public double econscavenger = 100;
            public double econtamer = 100;
        }
        public class SRewards
        {
            public bool srewardlevelup = false;
            public bool srewardleveldown = false;
            public bool srewardresetstats = false;
            public bool srewardresetskills = false;
            public int srewardlevelupamt = 5;
            public int srewardleveldownamt = 5;
            public int srewardresetstatscost = 50;
            public int srewardresetskillscost = 50;
            public bool srewardstatlevelcost = false;
            public bool srewardskilllevelcost = false;
            public int srewardstatlevelcostmultiplier = 0;
            public int srewardskilllevelcostmultiplier = 0;
            public int srewardmentality = 50;
            public int srewarddexterity = 50;
            public int srewardmight = 50;
            public int srewardcaptaincy = 50;
            public int srewardweaponry = 50;
            public int srewardwoodcutter = 50;
            public int srewardsmithy = 50;
            public int srewardminer = 50;
            public int srewardforager = 50;
            public int srewardhunter = 50;
            public int srewardfisher = 50;
            public int srewardcrafter = 50;
            public int srewardframer = 50;
            public int srewardmedic = 50;
            public int srewardscavenger = 50;
            public int srewardtamer = 50;

        }
        public class Mentality
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double researchcost = 0.10;
            public double researchspeed = 0.10;
            public double criticalchance = 0.05;
            public double damageincrease = 0.01;
            public bool useotherresearchmod = false;
        }
        public class Dexterity
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double blockchance = 0.05;
            public double blockamount = 0.10;
            public double dodgechance = 0.05;
            public double reducearmordmg = 0.05;
            public double horsespeed = 0.05;
            public double boatspeed = 0.05;
            public double vehiclespeed = 0.05;
            public double fuelreduce = 0.05;
        }
        public class Might
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double armor = 0.10;
            public double meleedmg = 0.05;
            public double metabolism = 0.02;
            public double bleedreduction = 0.05;
            public double radreduction = 0.05;
            public double heattolerance = 0.05;
            public double coldtolerance = 0.05;
            //public bool enablestacking = false;
            //public int stackmultiplier = 2;
        }
        public class Captaincy
        {
            public int maxlvl = 0;
            public int pointcoststart = 4;
            public int costmultiplier = 4;
            public bool allownoteam = false;
            public double skillboost = 0.05;
            public bool enablexpboost = false;
            public double xpboost = 0.05;
            public float captaincydistance = 10f;
        }
        public class Weaponry
        {
            public int maxlvl = 10;
            public int pointcoststart = 4;
            public int costmultiplier = 4;
            public double reductionchance = 0.10;
            public double tool = 0.05;
            public double powertools = 0.03;
            public double meleeweapons = 0.05;
            public double projectileweapons = 0.02;
            public double mindamage = 0.10;
            public double maxammo = 0.10;
        }
        public class Woodcutter
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double gatherrate = 0.5;
            public double bonusincrease = 0.10;
            public double applechance = 0.10;
        }
        public class Smithy
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double productionrate = 0.10;
            public double fuelconsumption = 0.10;
            public double metalchance = 0.05;
            public int metalamount = 1;
        }
        public class Miner
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double gatherrate = 0.5;
            public double bonusincrease = 0.10;
            public double fuelconsumption = 0.10;
            public double metalchance = 0.10;
            public int metalamount = 1;
        }
        public class Forager
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double gatherrate = 0.3;
            public double chanceincrease = 0.10;
            //public double grubwormincrease = 0.10;
            public double randomchance = 0.05;
            public Dictionary<int, RandomChanceList> randomChanceList = new Dictionary<int, RandomChanceList>
            {
                [0] = new RandomChanceList
                {
                    shortname = "apple",
                    amount = 1
                },
                [1] = new RandomChanceList
                {
                    shortname = "bandage",
                    amount = 1
                },
                [2] = new RandomChanceList
                {
                    shortname = "scrap",
                    amount = 1
                },
                [3] = new RandomChanceList
                {
                    shortname = "bucket.water",
                    amount = 1
                },
                [4] = new RandomChanceList
                {
                    shortname = "metal.fragments",
                    amount = 1
                }
            };
        }
        public class RandomChanceList
        {
            public string shortname = "";
            public int amount = 1;
        }
        public class Hunter
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double gatherrate = 0.3;
            public double bonusincrease = 0.10;
            public double damageincrease = 0.05;
            public double nightdmgincrease = 0.01;
        }
        public class Fisher
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double fishamountincrease = 0.75;
            public double itemamountincrease = 0.25;
            public double oxygenreduction = 0.04;
            public double oxygentankreduction = 0.05;
        }
        public class Crafter
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double craftspeed = 0.10;
            public double craftcost = 0.05;
            public double repairincrease = 0.07;
            public double repaircost = 0.05;
            public double conditionchance = 0.07;
            public double conditionamount = 0.10;
        }
        public class Framer
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double upgradecost = 0.05;
            public double repaircost = 0.05;
            public double repairtime = 0.10;
        }
        public class Medic
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double revivehp = 5;
            public double recoverhp = 5;
            public double crafttime = 0.10;
            public double tools = 2;
            public double teas = 0.02;
        }
        public class Scavenger
        {
            public int maxlvl = 10;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public double scavlootchance = 0.10;
            public double scavchance = 0.05;
            public double scavmultiplier = 1.0;
            public double customscavmultiplier = 0.5;
            public bool customscavrandom = true;
            public bool usecustomscavlist = false;
            public bool drops = true;
            public bool crates = true;
            public bool uncrates = true;
            public bool lockedcrates = true;
            public bool hackcrates = true;
            public bool scientists = true;
            public bool componentsonly = true;
            public Dictionary<int, ScavChanceList> scavChanceList = new Dictionary<int, ScavChanceList>
            {
                [0] = new ScavChanceList
                {
                    shortname = "scrap",
                    amount = 1,
                    maxamount = 10,
                    requiredlevel = 1
                },
                [1] = new ScavChanceList
                {
                    shortname = "metal.fragments",
                    amount = 1,
                    maxamount = 10,
                    requiredlevel = 5
                }
            };
        }
        public class ScavChanceList
        {
            public string shortname = "";
            public int amount = 1;
            public int maxamount = 10;
            public int requiredlevel = 1;
        }
        public class Tamer
        {
            public bool enabletame = false;
            public int maxlvl = 6;
            public int pointcoststart = 2;
            public int costmultiplier = 2;
            public bool tamechicken = true;
            public bool tameboar = true;
            public bool tamestag = true;
            public bool tamewolf = true;
            public bool tamebear = true;
            public bool tamepolarbear = true;
            //public bool rideablepets = false;
            //public double petdamage = 0.05;
            public int chickenlevel = 1;
            public int boarlevel = 2;
            public int staglevel = 3;
            public int wolflevel = 4;
            public int bearlevel = 5;
            public int polarbearlevel = 6;
        }
        public class XpClans
        {
            public bool enableclanbonus = false;
            public bool enableclanreduction = false;
            public double clanbonusamount = 0.10;
            public double clanreductionamount = 0.02;
        }
        public class SQL
        {
            public bool enablesql = false;
            public string SQLhost = "localhost";
            public int SQLport = 3306;
            public string SQLdatabase = "databasename";
            public string SQLusername = "username";
            public string SQLpassword = "password";
        }
        public class ArcheryMod
        {
            public bool enablearchery = false;
            public bool rankrequired = false;
            public int ranklevel = 0;
            public string statorskill = "Hunter";
            public int novicelevel = 1;
            public int adeptlevel = 5;
            public int masterlevel = 10;
            public bool removeonunload = true;
        }
        public class WizardryMod
        {
            public bool enablewizardry = false;
            public bool rankrequired = false;
            public int ranklevel = 0;
            public string statorskill = "Mentality";
            public int novicelevel = 1;
            public int adeptlevel = 5;
            public int masterlevel = 10;
            public bool removeonunload = true;
        }
        public class BackpacksMod
        {
            public bool enablebackpacks = false;
            public string statorskill = "Might";
            public int backpackrow1 = 1;
            public int backpackrow2 = 2;
            public int backpackrow3 = 3;
            public int backpackrow4 = 4;
            public int backpackrow5 = 5;
            public int backpackrow6 = 6;
            public int backpackrow7 = 7;
            public bool removeonunload = true;
        }
        protected override void LoadDefaultConfig() => config = new Configuration();
        protected override void LoadConfig()
        {
            base.LoadConfig();
            try
            {
                config = Config.ReadObject<Configuration>();
                if (config == null)
                {
                    throw new JsonException();
                }
                if (MaybeUpdateConfig(config))
                {
                    PrintWarning("Configuration appears to be outdated; updating and saving");
                    SaveConfig();
                }
            }
            catch
            {
                PrintWarning($"Configuration file {Name}.json is invalid; using defaults");
                LoadDefaultConfig();
            }
        }
        protected override void SaveConfig()
        {
            PrintWarning($"Configuration changes saved to {Name}.json");
            Config.WriteObject(config, true);
        }
        #region UpdateChecker
        internal class SerializableConfiguration
        {
            public string ToJson() => JsonConvert.SerializeObject(this);

            public Dictionary<string, object> ToDictionary() => JsonHelper.Deserialize(ToJson()) as Dictionary<string, object>;
        }
        private static class JsonHelper
        {
            public static object Deserialize(string json) => ToObject(JToken.Parse(json));

            private static object ToObject(JToken token)
            {
                switch (token.Type)
                {
                    case JTokenType.Object:
                        return token.Children<JProperty>().ToDictionary(prop => prop.Name, prop => ToObject(prop.Value));
                    case JTokenType.Array:
                        return token.Select(ToObject).ToList();

                    default:
                        return ((JValue)token).Value;
                }
            }
        }
        private bool MaybeUpdateConfig(SerializableConfiguration config)
        {
            var currentWithDefaults = config.ToDictionary();
            var currentRaw = Config.ToDictionary(x => x.Key, x => x.Value);
            return MaybeUpdateConfigDict(currentWithDefaults, currentRaw);
        }
        private bool MaybeUpdateConfigDict(Dictionary<string, object> currentWithDefaults, Dictionary<string, object> currentRaw)
        {
            bool changed = false;

            foreach (var key in currentWithDefaults.Keys)
            {
                object currentRawValue;
                if (currentRaw.TryGetValue(key, out currentRawValue))
                {
                    var defaultDictValue = currentWithDefaults[key] as Dictionary<string, object>;
                    var currentDictValue = currentRawValue as Dictionary<string, object>;

                    if (defaultDictValue != null)
                    {
                        if (currentDictValue == null)
                        {
                            currentRaw[key] = currentWithDefaults[key];
                            changed = true;
                        }
                        else if (MaybeUpdateConfigDict(defaultDictValue, currentDictValue))
                            changed = true;
                    }
                }
                else
                {
                    currentRaw[key] = currentWithDefaults[key];
                    changed = true;
                }
            }

            return changed;
        }
        #endregion
        public static class RandomNumber
        {
            private static readonly RNGCryptoServiceProvider _generator = new RNGCryptoServiceProvider();
            public static int Between(int minimumValue, int maximumValue)
            {
                byte[] randomNumber = new byte[1];
                _generator.GetBytes(randomNumber);
                double asciiValueOfRandomCharacter = Convert.ToDouble(randomNumber[0]);
                double multiplier = Math.Max(0, (asciiValueOfRandomCharacter / 255d) - 0.00000000001d);
                int range = maximumValue - minimumValue + 1;
                double randomValueInRange = Math.Floor(multiplier * range);
                return (int)(minimumValue + randomValueInRange);
            }
        }
        #endregion

        #region Storage
        private void SaveData()
        {
            if (_xpData != null)
            {
                _xpData.XPerience = _xperienceCache;
                _XPerienceData.WriteObject(_xpData);
            }
        }
        private void SaveLoot()
        {
            if (_lootData != null)
            {
                _lootData.LootRecords = _lootCache;
                _LootContainData.WriteObject(_lootData);
            }
        }
        private void SaveCorpse()
        {
            if (_corpseData != null)
            {
                _corpseData.CorpseRecords = _corpseCache;
                _CorpseContainData.WriteObject(_corpseData);
            }
        }
        private void SaveHorse()
        {
            if (_horseData != null)
            {
                _horseData.HorseRecords = _horseCache;
                _HorseData.WriteObject(_horseData);
            }
        }
        private void SaveWeapon()
        {
            if (_weaponData != null)
            {
                _weaponData.WeaponRecords = _weaponCache;
                _WeaponData.WriteObject(_weaponData);
            }
        }
        private void SaveBoat()
        {
            if (_boatData != null)
            {
                _boatData.BoatRecords = _boatCache;
                _BoatData.WriteObject(_boatData);
            }
        }
        private void SaveVehicle()
        {
            if (_vehicleData != null)
            {
                _vehicleData.VehicleRecords = _vehicleCache;
                _VehicleData.WriteObject(_vehicleData);
            }
        }
        private void SaveMinicopter()
        {
            if (_minicopterData != null)
            {
                _minicopterData.MinicopterRecords = _minicopterCache;
                _MinicopterData.WriteObject(_minicopterData);
            }
        }
        private void LoadData()
        {
            try
            {
                _xpData = _XPerienceData.ReadObject<XPData>();
                _xperienceCache = _xpData.XPerience;
            }
            catch
            {
                _xpData = new XPData();
            }
            try
            {
                _lootData = _LootContainData.ReadObject<LootData>();
                _lootCache = _lootData.LootRecords;
            }
            catch
            {
                _lootData = new LootData();
            }
            try
            {
                _corpseData = _CorpseContainData.ReadObject<CorpseData>();
                _corpseCache = _corpseData.CorpseRecords;
            }
            catch
            {
                _corpseData = new CorpseData();
            }
            try
            {
                _horseData = _HorseData.ReadObject<HorseData>();
                _horseCache = _horseData.HorseRecords;
            }
            catch
            {
                _horseData = new HorseData();
            }
            try
            {
                _weaponData = _WeaponData.ReadObject<WeaponData>();
                _weaponCache = _weaponData.WeaponRecords;
            }
            catch
            {
                _weaponData = new WeaponData();
            }
            try
            {
                _boatData = _BoatData.ReadObject<BoatData>();
                _boatCache = _boatData.BoatRecords;
            }
            catch
            {
                _boatData = new BoatData();
            }
            try
            {
                _vehicleData = _VehicleData.ReadObject<VehicleData>();
                _vehicleCache = _vehicleData.VehicleRecords;
            }
            catch
            {
                _vehicleData = new VehicleData();
            }
            try
            {
                _minicopterData = _MinicopterData.ReadObject<MinicopterData>();
                _minicopterCache = _minicopterData.MinicopterRecords;
            }
            catch
            {
                _minicopterData = new MinicopterData();
            }
        }
        private class XPData
        {
            public Dictionary<string, XPRecord> XPerience = new Dictionary<string, XPRecord>();
        }
        private class XPRecord
        {
            public int rank;
            public int truelevel;
            public int trueexperience;
            public double level;
            public double experience;
            public double requiredxp;
            public int statpoint;
            public int skillpoint;
            public int Mentality;
            public int MentalityP;
            public int Dexterity;
            public int DexterityP;
            public int Might;
            public int MightP;
            public int Captaincy;
            public int CaptaincyP;
            public int Weaponry;
            public int WeaponryP;
            public int WoodCutter;
            public int WoodCutterP;
            public int Smithy;
            public int SmithyP;
            public int Miner;
            public int MinerP;
            public int Forager;
            public int ForagerP;
            public int Hunter;
            public int HunterP;
            public int Fisher;
            public int FisherP;
            public int Crafter;
            public int CrafterP;
            public int Framer;
            public int FramerP;
            public int Medic;
            public int MedicP;
            public int Scavenger;
            public int ScavengerP;
            public int Tamer;
            public int TamerP;
            public int Wood;
            public int Stone;
            public int Metal;
            public int Sulfur;
            public int Cactus;
            public int Berries;
            public int Pumpkin;
            public int Potato;
            public int Corn;
            public int Mushroom;
            public int Hemp;
            public int Seed;
            public bool Status;
            public bool DisableRank;
            public int UILocation;
            public string teatype;
            public double teacooldown;
            public DateTime resettimerstats;
            public DateTime resettimerskills;
            public DateTime playerfixdata;
            public int dash;
            public bool fuelgauge;
            public bool speedometer;
            public int speedometertype;
            public string displayname;
            public string id;
        }
        private class LootData
        {
            public Dictionary<uint, Loot> LootRecords = new Dictionary<uint, Loot>();
        }
        private class Loot
        {
            public uint lootcontainer;
            public List<string> id;
        }
        private class CorpseData
        {
            public Dictionary<uint, Corpse> CorpseRecords = new Dictionary<uint, Corpse>();
        }
        private class Corpse
        {
            public uint corpsecontainer;
            public List<string> id;
        }
        private class HorseData
        {
            public Dictionary<uint, Horse> HorseRecords = new Dictionary<uint, Horse>();
        }
        private class Horse
        {
            public uint horse;
            public float maxSpeed;
            public float runSpeed;
            public float walkSpeed;
            public float trotSpeed;
        }
        private class WeaponData
        {
            public Dictionary<uint, Weapon> WeaponRecords = new Dictionary<uint, Weapon>();
        }
        private class Weapon
        {
            public uint weapon;
            public int defaultammo;
            public int maxammo;
            public ulong player;
        }
        private class BoatData
        {
            public Dictionary<uint, Boat> BoatRecords = new Dictionary<uint, Boat>();
        }
        private class Boat
        {
            public uint boat;
            public float defaultSpeed;
            public ulong player;
        }
        private class VehicleData
        {
            public Dictionary<uint, Vehicle> VehicleRecords = new Dictionary<uint, Vehicle>();
        }
        private class Vehicle
        {
            public uint vehicle;
            public float maxDriveSlip;
            public float reversePercentSpeed;
            public float driveForceToMaxSlip;
            public ulong player;
        }
        private class MinicopterData
        {
            public Dictionary<uint, Minicopter> MinicopterRecords = new Dictionary<uint, Minicopter>();
        }
        private class Minicopter
        {
            public uint minicopter;
            public float maxRotorSpeed;
            public ulong player;
        }
        #endregion

        #region SQL
        private readonly Core.MySql.Libraries.MySql sqlLibrary = Interface.Oxide.GetLibrary<Core.MySql.Libraries.MySql>();
        Connection sqlConnection;
        private void CreatSQLTable()
        {
            sqlLibrary.Insert(Sql.Builder.Append($"CREATE TABLE IF NOT EXISTS XPerience (" +
                $" `id` BIGINT(255) NOT NULL AUTO_INCREMENT," +
                $" `steamid` BIGINT(255) NOT NULL," +
                $" `displayname` VARCHAR(255) NOT NULL," +
                $" `Rank` BIGINT(255) NOT NULL," +
                $" `RankName` VARCHAR(255) NOT NULL," +
                $" `RankSig` VARCHAR(255) NOT NULL," +
                $" `RankImg` VARCHAR(255) NOT NULL," +
                $" `RankLevel` BIGINT(255) NOT NULL," +
                $" `RankXP` BIGINT(255) NOT NULL," +
                $" `level` BIGINT(255) NOT NULL," +
                $" `experience` BIGINT(255) NOT NULL," +
                $" `requiredxp` BIGINT(255) NOT NULL," +
                $" `statpoint` BIGINT(255) NOT NULL," +
                $" `skillpoint` BIGINT(255) NOT NULL," +
                $" `Mentality` BIGINT(255) NOT NULL," +
                $" `MentalityP` BIGINT(255) NOT NULL," +
                $" `Dexterity` BIGINT(255) NOT NULL," +
                $" `DexterityP` BIGINT(255) NOT NULL," +
                $" `Might` BIGINT(255) NOT NULL," +
                $" `MightP` BIGINT(255) NOT NULL," +
                $" `Captaincy` BIGINT(255) NOT NULL," +
                $" `CaptaincyP` BIGINT(255) NOT NULL," +
                $" `Weaponry` BIGINT(255) NOT NULL," +
                $" `WeaponryP` BIGINT(255) NOT NULL," +
                $" `WoodCutter` BIGINT(255) NOT NULL," +
                $" `WoodCutterP` BIGINT(255) NOT NULL," +
                $" `Smithy` BIGINT(255) NOT NULL," +
                $" `SmithyP` BIGINT(255) NOT NULL," +
                $" `Miner` BIGINT(255) NOT NULL," +
                $" `MinerP` BIGINT(255) NOT NULL," +
                $" `Forager` BIGINT(255) NOT NULL," +
                $" `ForagerP` BIGINT(255) NOT NULL," +
                $" `Hunter` BIGINT(255) NOT NULL," +
                $" `HunterP` BIGINT(255) NOT NULL," +
                $" `Fisher` BIGINT(255) NOT NULL," +
                $" `FisherP` BIGINT(255) NOT NULL," +
                $" `Crafter` BIGINT(255) NOT NULL," +
                $" `CrafterP` BIGINT(255) NOT NULL," +
                $" `Framer` BIGINT(255) NOT NULL," +
                $" `FramerP` BIGINT(255) NOT NULL," +
                $" `Medic` BIGINT(255) NOT NULL," +
                $" `MedicP` BIGINT(255) NOT NULL," +
                $" `Scavenger` BIGINT(255) NOT NULL," +
                $" `ScavengerP` BIGINT(255) NOT NULL," +
                $" `Tamer` BIGINT(255) NOT NULL," +
                $" `TamerP` BIGINT(255) NOT NULL," +
                $" `Wood` BIGINT(255) NOT NULL," +
                $" `Stone` BIGINT(255) NOT NULL," +
                $" `Metal` BIGINT(255) NOT NULL," +
                $" `Sulfur` BIGINT(255) NOT NULL," +
                $" `Cactus` BIGINT(255) NOT NULL," +
                $" `Berries` BIGINT(255) NOT NULL," +
                $" `Pumpkin` BIGINT(255) NOT NULL," +
                $" `Potato` BIGINT(255) NOT NULL," +
                $" `Corn` BIGINT(255) NOT NULL," +
                $" `Mushroom` BIGINT(255) NOT NULL," +
                $" `Hemp` BIGINT(255) NOT NULL," +
                $" `Seed` BIGINT(255) NOT NULL," +
                $" `Status` VARCHAR(255) NOT NULL," +
                $"PRIMARY KEY (id)" +
                $" )ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;"), sqlConnection);
        }
        private void UpdateSQLTable()
        {
            try
            {
                bool rank = false;
                bool rankname = false;
                bool ranksig = false;
                bool rankimg = false;
                bool ranklevel = false;
                bool rankxp = false;
                bool wood = false;
                bool stone = false;
                bool metal = false;
                bool sulfur = false;
                bool cactus = false;
                bool berries = false;
                bool pumpkin = false;
                bool potato = false;
                bool corn = false;
                bool mushroom = false;
                bool hemp = false;
                bool seed = false;
                bool status = false;
                bool chemist = false;
                bool chemistp = false;
                bool scavenger = false;
                bool scavengerp = false;
                bool captaincy = false;
                bool captaincyp = false;
                bool weaponry = false;
                bool weaponryp = false;
                bool medic = false;
                bool medicp = false;
                sqlLibrary.Query(Sql.Builder.Append($"SELECT * FROM XPerience"), sqlConnection, list =>
                {
                    foreach (var entry in list)
                    {
                        if (!entry.ContainsKey("Rank")) { rank = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Rank` BIGINT(255) NOT NULL AFTER displayname"), sqlConnection);
                        if (!entry.ContainsKey("RankName")) { rankname = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankName` BIGINT(255) NOT NULL AFTER TamerP"), sqlConnection);
                        if (!entry.ContainsKey("RankSig")) { ranksig = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankSig` BIGINT(255) NOT NULL AFTER TamerP"), sqlConnection);
                        if (!entry.ContainsKey("RankImg")) { rankimg = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankImg` BIGINT(255) NOT NULL AFTER TamerP"), sqlConnection);
                        if (!entry.ContainsKey("RankLevel")) { ranklevel = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankLevel` BIGINT(255) NOT NULL AFTER TamerP"), sqlConnection);
                        if (!entry.ContainsKey("RankXP")) { rankxp = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankXP` BIGINT(255) NOT NULL AFTER TamerP"), sqlConnection);
                        if (!entry.ContainsKey("Wood")) { wood = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Wood` BIGINT(255) NOT NULL AFTER TamerP"), sqlConnection);
                        if (!entry.ContainsKey("Stone")) { stone = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Stone` BIGINT(255) NOT NULL AFTER Wood"), sqlConnection);
                        if (!entry.ContainsKey("Metal")) { metal = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Metal` BIGINT(255) NOT NULL AFTER Stone"), sqlConnection);
                        if (!entry.ContainsKey("Sulfur")) { sulfur = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Sulfur` BIGINT(255) NOT NULL AFTER Metal"), sqlConnection);
                        if (!entry.ContainsKey("Cactus")) { cactus = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Cactus` BIGINT(255) NOT NULL AFTER Sulfur"), sqlConnection);
                        if (!entry.ContainsKey("Berries")) { berries = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Berries` BIGINT(255) NOT NULL AFTER Cactus"), sqlConnection);
                        if (!entry.ContainsKey("Pumpkin")) { pumpkin = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Pumpkin` BIGINT(255) NOT NULL AFTER Berries"), sqlConnection);
                        if (!entry.ContainsKey("Potato")) { potato = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Potato` BIGINT(255) NOT NULL AFTER Pumpkin"), sqlConnection);
                        if (!entry.ContainsKey("Corn")) { corn = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Corn` BIGINT(255) NOT NULL AFTER Potato"), sqlConnection);
                        if (!entry.ContainsKey("Mushroom")) { mushroom = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Mushroom` BIGINT(255) NOT NULL AFTER Corn"), sqlConnection);
                        if (!entry.ContainsKey("Hemp")) { hemp = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Hemp` BIGINT(255) NOT NULL AFTER Mushroom"), sqlConnection);
                        if (!entry.ContainsKey("Seed")) { seed = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Seed` BIGINT(255) NOT NULL AFTER Hemp"), sqlConnection);
                        if (!entry.ContainsKey("Status")) { status = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Status` VARCHAR(255) NOT NULL AFTER Seed"), sqlConnection); }
                        if (entry.ContainsKey("Chemist")) { chemist = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience DROP COLUMN `Chemist`"), sqlConnection); }
                        if (entry.ContainsKey("ChemistP")) { chemistp = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience DROP COLUMN `ChemistP`"), sqlConnection); }
                        if (!entry.ContainsKey("Scavenger")) { scavenger = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Scavenger` BIGINT(255) NOT NULL DEFAULT '0' AFTER MedicP"), sqlConnection); }
                        if (!entry.ContainsKey("ScavengerP")) { scavenger = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `ScavengerP` BIGINT(255) NOT NULL DEFAULT '0' AFTER Scavenger"), sqlConnection); }
                        if (!entry.ContainsKey("Captaincy")) { captaincy = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Captaincy` BIGINT(255) NOT NULL DEFAULT '0' AFTER MightP"), sqlConnection); }
                        if (!entry.ContainsKey("CaptaincyP")) { captaincyp = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `CaptaincyP` BIGINT(255) NOT NULL DEFAULT '0' AFTER Captaincy"), sqlConnection); }
                        if (!entry.ContainsKey("Weaponry")) { weaponry = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Captaincy` BIGINT(255) NOT NULL DEFAULT '0' AFTER MightP"), sqlConnection); }
                        if (!entry.ContainsKey("WeaponryP")) { weaponryp = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `CaptaincyP` BIGINT(255) NOT NULL DEFAULT '0' AFTER Captaincy"), sqlConnection); }
                        if (!entry.ContainsKey("Medic")) { medic = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Medic` BIGINT(255) NOT NULL DEFAULT '0' AFTER FramerP"), sqlConnection); }
                        if (!entry.ContainsKey("MedicP")) { medicp = true; } // sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `MedicP` BIGINT(255) NOT NULL DEFAULT '0' AFTER Medic"), sqlConnection); }
                    }
                    if (rank) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Rank` BIGINT(255) NOT NULL AFTER displayname"), sqlConnection); }
                    if (rankname) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankName` VARCHAR(255) NOT NULL AFTER Rank"), sqlConnection); }
                    if (ranksig) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankSig` VARCHAR(255) NOT NULL AFTER RankName"), sqlConnection); }
                    if (rankimg) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankImg` VARCHAR(255) NOT NULL AFTER RankSig"), sqlConnection); }
                    if (ranklevel) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankLevel` BIGINT(255) NOT NULL AFTER RankImg"), sqlConnection); }
                    if (rankxp) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `RankXP` BIGINT(255) NOT NULL AFTER RankLevel"), sqlConnection); }
                    if (wood) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Wood` BIGINT(255) NOT NULL AFTER TamerP"), sqlConnection); }
                    if (stone) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Stone` BIGINT(255) NOT NULL AFTER Wood"), sqlConnection); }
                    if (metal) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Metal` BIGINT(255) NOT NULL AFTER Stone"), sqlConnection); }
                    if (sulfur) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Sulfur` BIGINT(255) NOT NULL AFTER Metal"), sqlConnection); }
                    if (cactus) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Cactus` BIGINT(255) NOT NULL AFTER Sulfur"), sqlConnection); }
                    if (berries) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Berries` BIGINT(255) NOT NULL AFTER Cactus"), sqlConnection); }
                    if (pumpkin) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Pumpkin` BIGINT(255) NOT NULL AFTER Berries"), sqlConnection); }
                    if (potato) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Potato` BIGINT(255) NOT NULL AFTER Pumpkin"), sqlConnection); }
                    if (corn) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Corn` BIGINT(255) NOT NULL AFTER Potato"), sqlConnection); }
                    if (mushroom) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Mushroom` BIGINT(255) NOT NULL AFTER Corn"), sqlConnection); }
                    if (hemp) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Hemp` BIGINT(255) NOT NULL AFTER Mushroom"), sqlConnection); }
                    if (seed) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Seed` BIGINT(255) NOT NULL AFTER Hemp"), sqlConnection); }
                    if (status) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Status` VARCHAR(255) NOT NULL AFTER Seed"), sqlConnection); }
                    if (chemist) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience DROP COLUMN `Chemist`"), sqlConnection); }
                    if (chemistp) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience DROP COLUMN `ChemistP`"), sqlConnection); }
                    if (scavenger) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Scavenger` BIGINT(255) NOT NULL DEFAULT '0' AFTER MedicP"), sqlConnection); }
                    if (scavengerp) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `ScavengerP` BIGINT(255) NOT NULL DEFAULT '0' AFTER Scavenger"), sqlConnection); }
                    if (captaincy) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Captaincy` BIGINT(255) NOT NULL DEFAULT '0' AFTER MightP"), sqlConnection); }
                    if (captaincyp) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `CaptaincyP` BIGINT(255) NOT NULL DEFAULT '0' AFTER Captaincy"), sqlConnection); }
                    if (weaponry) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Weaponry` BIGINT(255) NOT NULL DEFAULT '0' AFTER CaptaincyP"), sqlConnection); }
                    if (weaponryp) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `WeaponryP` BIGINT(255) NOT NULL DEFAULT '0' AFTER Weaponry"), sqlConnection); }
                    if (medic) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `Medic` BIGINT(255) NOT NULL DEFAULT '0' AFTER FramerP"), sqlConnection); }
                    if (medicp) { sqlLibrary.Insert(Sql.Builder.Append($"ALTER TABLE XPerience ADD COLUMN `MedicP` BIGINT(255) NOT NULL DEFAULT '0' AFTER Medic"), sqlConnection); }
                });
            }
            catch (MySqlException e)
            {
                PrintError("Failed to Update Table (" + e.Message + ")");
            }
        }
        private void CreatePlayerDataSQL(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            Ranks rank = GetXPRank(xprecord.rank);
            // Remove special characters in names to prevent injection
            string removespecials = "(['^$.|?*+%;@()&{}\\\\])";
            string replacename = "\\$1";
            Regex rgx = new Regex(removespecials);
            var playername = rgx.Replace(xprecord.displayname, replacename);

            sqlLibrary.Insert(Sql.Builder.Append("INSERT XPerience (steamid, displayname, Rank, RankName, RankSig, RankImg, RankLevel, RankXP, level, experience, requiredxp, statpoint, skillpoint, Mentality, MentalityP, Dexterity, DexterityP, Might, MightP, Captaincy, CaptaincyP, Weaponry, WeaponryP, WoodCutter, WoodCutterP, Smithy, SmithyP, Miner, MinerP, Forager, ForagerP, Hunter, HunterP, Fisher, FisherP, Crafter, CrafterP, Framer, FramerP, Medic, MedicP, Scavenger, ScavengerP, Tamer, TamerP, Wood, Stone, Metal, Sulfur, Cactus, Berries, Pumpkin, Potato, Corn, Mushroom, Hemp, Seed, Status) " +
            "VALUES (" +
            $"'{xprecord.id}', " +
            $"'{playername}', " +
            $"'{xprecord.rank}', " +
            $"'{rank.name}', " +
            $"'{rank.sig}', " +
            $"'{rank.image}', " +
            $"'{xprecord.truelevel}', " +
            $"'{xprecord.trueexperience}', " +
            $"'{xprecord.level}', " +
            $"'{xprecord.experience}', " +
            $"'{xprecord.requiredxp}', " +
            $"'{xprecord.statpoint}', " +
            $"'{xprecord.skillpoint}', " +
            $"'{xprecord.Mentality}', " +
            $"'{xprecord.MentalityP}', " +
            $"'{xprecord.Dexterity}', " +
            $"'{xprecord.DexterityP}', " +
            $"'{xprecord.Might}', " +
            $"'{xprecord.MightP}', " +
            $"'{xprecord.Captaincy}', " +
            $"'{xprecord.CaptaincyP}', " +
            $"'{xprecord.Weaponry}', " +
            $"'{xprecord.WeaponryP}', " +
            $"'{xprecord.WoodCutter}', " +
            $"'{xprecord.WoodCutterP}', " +
            $"'{xprecord.Smithy}', " +
            $"'{xprecord.SmithyP}', " +
            $"'{xprecord.Miner}', " +
            $"'{xprecord.MinerP}', " +
            $"'{xprecord.Forager}', " +
            $"'{xprecord.ForagerP}', " +
            $"'{xprecord.Hunter}', " +
            $"'{xprecord.HunterP}', " +
            $"'{xprecord.Fisher}', " +
            $"'{xprecord.FisherP}', " +
            $"'{xprecord.Crafter}', " +
            $"'{xprecord.CrafterP}', " +
            $"'{xprecord.Framer}', " +
            $"'{xprecord.FramerP}', " +
            $"'{xprecord.Medic}', " +
            $"'{xprecord.MedicP}', " +
            $"'{xprecord.Scavenger}', " +
            $"'{xprecord.ScavengerP}', " +
            $"'{xprecord.Tamer}', " +
            $"'{xprecord.TamerP}', " +
            $"'{xprecord.Wood}', " +
            $"'{xprecord.Stone}', " +
            $"'{xprecord.Metal}', " +
            $"'{xprecord.Sulfur}', " +
            $"'{xprecord.Cactus}', " +
            $"'{xprecord.Berries}', " +
            $"'{xprecord.Pumpkin}', " +
            $"'{xprecord.Potato}', " +
            $"'{xprecord.Corn}', " +
            $"'{xprecord.Mushroom}', " +
            $"'{xprecord.Hemp}', " +
            $"'{xprecord.Seed}', " +
            $"'{xprecord.Status}');"), sqlConnection);
        }
        private void UpdatePlayersDataSQL()
        {
            foreach (var r in _xperienceCache)
            {
                // Remove special characters in names to prevent injection
                string removespecials = "(['^$.|?*+%@;()&{}\\\\])";
                string replacename = "\\$1";
                Regex rgx = new Regex(removespecials);
                var playername = rgx.Replace(r.Value.displayname, replacename);
                Ranks rank = GetXPRank(r.Value.rank);
                sqlLibrary.Update(Sql.Builder.Append($"UPDATE XPerience SET " +
                $"steamid='{r.Value.id}', " +
                $"displayname='{playername}', " +
                $"Rank='{r.Value.rank}', " +
                $"RankName='{rank.name}', " +
                $"RankSig='{rank.sig}', " +
                $"RankImg='{rank.image}', " +
                $"RankLevel='{r.Value.truelevel}', " +
                $"RankXP='{r.Value.trueexperience}', " +
                $"level='{r.Value.level}', " +
                $"experience='{r.Value.experience}', " +
                $"requiredxp='{r.Value.requiredxp}', " +
                $"statpoint='{r.Value.statpoint}', " +
                $"skillpoint='{r.Value.skillpoint}', " +
                $"Mentality='{r.Value.Mentality}', " +
                $"MentalityP='{r.Value.MentalityP}', " +
                $"Dexterity='{r.Value.Dexterity}', " +
                $"DexterityP='{r.Value.DexterityP}', " +
                $"Might='{r.Value.Might}', " +
                $"MightP='{r.Value.MightP}', " +
                $"Captaincy='{r.Value.Captaincy}', " +
                $"CaptaincyP='{r.Value.CaptaincyP}', " +
                $"Weaponry='{r.Value.Weaponry}', " +
                $"WeaponryP='{r.Value.WeaponryP}', " +
                $"WoodCutter='{r.Value.WoodCutter}', " +
                $"WoodCutterP='{r.Value.WoodCutterP}', " +
                $"Smithy='{r.Value.Smithy}', " +
                $"SmithyP='{r.Value.SmithyP}', " +
                $"Miner='{r.Value.Miner}', " +
                $"MinerP='{r.Value.MinerP}', " +
                $"Forager='{r.Value.Forager}', " +
                $"ForagerP='{r.Value.ForagerP}', " +
                $"Hunter='{r.Value.Hunter}', " +
                $"HunterP='{r.Value.HunterP}', " +
                $"Fisher='{r.Value.Fisher}', " +
                $"FisherP='{r.Value.FisherP}', " +
                $"Crafter='{r.Value.Crafter}', " +
                $"CrafterP='{r.Value.CrafterP}', " +
                $"Framer='{r.Value.Framer}', " +
                $"FramerP='{r.Value.FramerP}', " +
                $"Medic='{r.Value.Medic}', " +
                $"MedicP='{r.Value.MedicP}', " +
                $"Scavenger='{r.Value.Scavenger}', " +
                $"ScavengerP='{r.Value.ScavengerP}', " +
                $"Tamer='{r.Value.Tamer}', " +
                $"TamerP='{r.Value.TamerP}', " +
                $"Wood='{r.Value.Wood}', " +
                $"Stone='{r.Value.Stone}', " +
                $"Metal='{r.Value.Metal}', " +
                $"Sulfur='{r.Value.Sulfur}', " +
                $"Cactus='{r.Value.Cactus}', " +
                $"Berries='{r.Value.Berries}', " +
                $"Pumpkin='{r.Value.Pumpkin}', " +
                $"Potato='{r.Value.Potato}', " +
                $"Corn='{r.Value.Corn}', " +
                $"Mushroom='{r.Value.Mushroom}', " +
                $"Hemp='{r.Value.Hemp}', " +
                $"Seed='{r.Value.Seed}', " +
                $"Status='{r.Value.Status}' " +
                $"WHERE steamid = '{r.Key}';"), sqlConnection);

            }
        }
        private void UpdatePlayerDataSQL(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            // Remove special characters in names to prevent injection
            string removespecials = "(['^$.|?*+%@;()&{}\\\\])";
            string replacename = "\\$1";
            Regex rgx = new Regex(removespecials);
            var playername = rgx.Replace(xprecord.displayname, replacename);
            Ranks rank = GetXPRank(xprecord.rank);
            sqlLibrary.Update(Sql.Builder.Append($"UPDATE XPerience SET " +
            $"steamid='{xprecord.id}', " +
            $"displayname='{playername}', " +
            $"Rank='{xprecord.rank}', " +
            $"RankName='{rank.name}', " +
            $"RankSig='{rank.sig}', " +
            $"RankImg='{rank.image}', " +
            $"RankLevel='{xprecord.truelevel}', " +
            $"RankXP='{xprecord.trueexperience}', " +
            $"level='{xprecord.level}', " +
            $"experience='{xprecord.experience}', " +
            $"requiredxp='{xprecord.requiredxp}', " +
            $"statpoint='{xprecord.statpoint}', " +
            $"skillpoint='{xprecord.skillpoint}', " +
            $"Mentality='{xprecord.Mentality}', " +
            $"MentalityP='{xprecord.MentalityP}', " +
            $"Dexterity='{xprecord.Dexterity}', " +
            $"DexterityP='{xprecord.DexterityP}', " +
            $"Might='{xprecord.Might}', " +
            $"MightP='{xprecord.MightP}', " +
            $"Captaincy='{xprecord.Captaincy}', " +
            $"CaptaincyP='{xprecord.CaptaincyP}', " +
            $"Weaponry='{xprecord.Weaponry}', " +
            $"WeaponryP='{xprecord.WeaponryP}', " +
            $"WoodCutter='{xprecord.WoodCutter}', " +
            $"WoodCutterP='{xprecord.WoodCutterP}', " +
            $"Smithy='{xprecord.Smithy}', " +
            $"SmithyP='{xprecord.SmithyP}', " +
            $"Miner='{xprecord.Miner}', " +
            $"MinerP='{xprecord.MinerP}', " +
            $"Forager='{xprecord.Forager}', " +
            $"ForagerP='{xprecord.ForagerP}', " +
            $"Hunter='{xprecord.Hunter}', " +
            $"HunterP='{xprecord.HunterP}', " +
            $"Fisher='{xprecord.Fisher}', " +
            $"FisherP='{xprecord.FisherP}', " +
            $"Crafter='{xprecord.Crafter}', " +
            $"CrafterP='{xprecord.CrafterP}', " +
            $"Framer='{xprecord.Framer}', " +
            $"FramerP='{xprecord.FramerP}', " +
            $"Medic='{xprecord.Medic}', " +
            $"MedicP='{xprecord.MedicP}', " +
            $"Scavenger='{xprecord.Scavenger}', " +
            $"ScavengerP='{xprecord.ScavengerP}', " +
            $"Tamer='{xprecord.Tamer}', " +
            $"TamerP='{xprecord.TamerP}', " +
            $"Wood='{xprecord.Wood}', " +
            $"Stone='{xprecord.Stone}', " +
            $"Metal='{xprecord.Metal}', " +
            $"Sulfur='{xprecord.Sulfur}', " +
            $"Cactus='{xprecord.Cactus}', " +
            $"Berries='{xprecord.Berries}', " +
            $"Pumpkin='{xprecord.Pumpkin}', " +
            $"Potato='{xprecord.Potato}', " +
            $"Corn='{xprecord.Corn}', " +
            $"Mushroom='{xprecord.Mushroom}', " +
            $"Hemp='{xprecord.Hemp}', " +
            $"Seed='{xprecord.Seed}', " +
            $"Status='{xprecord.Status}' " +
            $"WHERE steamid = '{player.UserIDString}';"), sqlConnection);
        }
        private void CheckPlayerDataSQL(BasePlayer player)
        {
            bool newplayer = true;
            sqlLibrary.Query(Sql.Builder.Append($"SELECT steamid FROM XPerience"), sqlConnection, list =>
            {
                foreach (var entry in list)
                {
                    if (entry["steamid"].ToString() == player.UserIDString)
                    {
                        UpdatePlayerDataSQL(player);
                        newplayer = false;
                    }
                }
                if (newplayer)
                {
                    CreatePlayerDataSQL(player);
                }
            });

        }
        private void DeleteSQL()
        {
            sqlLibrary.Delete(Sql.Builder.Append($"DELETE FROM XPerience;"), sqlConnection);
        }
        #endregion

        #region Load/Save
        private void Init()
        {
            Unsubscribe(nameof(OnRunPlayerMetabolism));
            Unsubscribe(nameof(OnPlayerDeath));
            Unsubscribe(nameof(OnResearchCostDetermine));
            Unsubscribe(nameof(CanUnlockTechTreeNode));
            Unsubscribe(nameof(OnTechTreeNodeUnlock));
            Unsubscribe(nameof(OnItemResearch));
            _xperienceCache = new Dictionary<string, XPRecord>();
            _lootCache = new Dictionary<uint, Loot>();
            _corpseCache = new Dictionary<uint, Corpse>();
            _horseCache = new Dictionary<uint, Horse>();
            _weaponCache = new Dictionary<uint, Weapon>();
            _boatCache = new Dictionary<uint, Boat>();
            _vehicleCache = new Dictionary<uint, Vehicle>();
            _minicopterCache = new Dictionary<uint, Minicopter>();
            ChangeImageURLs();
        }
        private void OnServerInitialized()
        {
            cmd.AddChatCommand(config.playerchatCommands.openplayerstats, this, Openplayerstats);
            cmd.AddChatCommand(config.playerchatCommands.opentopplayers, this, Opentopplayers);
            cmd.AddChatCommand(config.playerchatCommands.openhelp, this, Openhelp);
            cmd.AddChatCommand(config.playerchatCommands.showplayerstatschat, this, Showplayerstatschat);
            cmd.AddChatCommand(config.playerchatCommands.playeraddstat, this, Playeraddstat);
            cmd.AddChatCommand(config.playerchatCommands.playeraddskill, this, Playeraddskill);
            cmd.AddChatCommand(config.playerchatCommands.playerresetstats, this, Playerresetstats);
            cmd.AddChatCommand(config.playerchatCommands.playerresetskills, this, Playerresetskills);
            cmd.AddChatCommand(config.playerchatCommands.playerresetall, this, Playerresetall);
            cmd.AddChatCommand(config.playerchatCommands.playerliveuichange, this, Playerliveuichange);
            cmd.AddChatCommand(config.adminchatCommands.showadminhelp, this, Showadminhelp);
            cmd.AddChatCommand(config.adminchatCommands.openadminpanel, this, Openadminpanel);
            cmd.AddChatCommand(config.adminchatCommands.adminresetxperience, this, Adminresetxperience);
            cmd.AddChatCommand(config.adminchatCommands.adminxpgive, this, Adminxpgive);
            cmd.AddChatCommand(config.adminchatCommands.adminxpgiveall, this, Adminxpgiveall);
            cmd.AddChatCommand(config.adminchatCommands.adminxptake, this, Adminxptake);
            cmd.AddChatCommand(config.adminchatCommands.adminresetplayer, this, Adminxpresetplayer);
            cmd.AddChatCommand(config.adminchatCommands.adminfixdata, this, Adminfixdata);
            cmd.AddChatCommand(config.adminchatCommands.adminitemchange, this, Adminitemchange);
            cmd.AddChatCommand(config.adminchatCommands.adminresetharvest, this, AdminHarvestReset);
            cmd.AddChatCommand(config.adminchatCommands.adminresetlevelonly, this, AdminLevelReset);
            cmd.AddChatCommand(config.adminchatCommands.adminresetrankonly, this, AdminRankReset);
            cmd.AddChatCommand(config.adminchatCommands.adminresetlevelonlyall, this, AdminLevelResetAll);
            cmd.AddChatCommand(config.adminchatCommands.adminresetrankonlyall, this, AdminRankResetAll);
            _XPerienceData = Interface.Oxide.DataFileSystem.GetFile(nameof(XPerience) + "/XPerience");
            _LootContainData = Interface.Oxide.DataFileSystem.GetFile(nameof(XPerience) + "/XPLootData");
            _CorpseContainData = Interface.Oxide.DataFileSystem.GetFile(nameof(XPerience) + "/XPCorpseData");
            _HorseData = Interface.Oxide.DataFileSystem.GetFile(nameof(XPerience) + "/XPHorseData");
            _WeaponData = Interface.Oxide.DataFileSystem.GetFile(nameof(XPerience) + "/XPWeaponData");
            _BoatData = Interface.Oxide.DataFileSystem.GetFile(nameof(XPerience) + "/XPBoatData");
            _VehicleData = Interface.Oxide.DataFileSystem.GetFile(nameof(XPerience) + "/XPVehicleData");
            _MinicopterData = Interface.Oxide.DataFileSystem.GetFile(nameof(XPerience) + "/XPMinicopterData");
            LoadData();
            SaveData();
            SaveLoot();
            SaveCorpse();
            SaveHorse();
            SaveWeapon();
            SaveBoat();
            SaveVehicle();
            SaveMinicopter();
            if (config.xpReducer.deathreduce)
            {
                Subscribe(nameof(OnPlayerDeath));
            }
            permission.RegisterPermission(Admin, this);
            permission.RegisterPermission(VIP, this);
            permission.RegisterPermission(PermMentality, this);
            permission.RegisterPermission(PermDexterity, this);
            permission.RegisterPermission(PermMight, this);
            permission.RegisterPermission(PermCaptaincy, this);
            permission.RegisterPermission(PermWeaponry, this);
            permission.RegisterPermission(PermWoodCutter, this);
            permission.RegisterPermission(PermSmithy, this);
            permission.RegisterPermission(PermMiner, this);
            permission.RegisterPermission(PermForager, this);
            permission.RegisterPermission(PermHunter, this);
            permission.RegisterPermission(PermFisher, this);
            permission.RegisterPermission(PermCrafter, this);
            permission.RegisterPermission(PermFramer, this);
            permission.RegisterPermission(PermMedic, this);
            permission.RegisterPermission(PermScavenger, this);
            permission.RegisterPermission(PermTamer, this);
            if (config.xpLevelRanks.enableresetranks)
            {
                foreach (var rank in config.xpLevelRanks.ranks)
                {
                    permission.CreateGroup(rank.Value.group, rank.Value.sig, rank.Key);
                }
            }
            Subscribe(nameof(OnRunPlayerMetabolism));
            foreach (var player in BasePlayer.activePlayerList)
            {
                GetXPRecord(player);
                PlayerArmor(player);
                MightAttributes(player);
                LiveStats(player, true);
                _xperienceCache[player.UserIDString].Status = true;
                // Backpack Check
                if (Backpacks != null && config.backpacksmod.enablebackpacks)
                {
                    BackPackChecks(player, config.backpacksmod.statorskill, false);
                }
                // Archery Check
                if (Archery != null && config.archerymod.enablearchery)
                {
                    ArcheryChecks(player, config.archerymod.statorskill, false);
                }
                // Wizardry Check
                if (Wizardry != null && config.wizardrymod.enablewizardry)
                {
                    WizardryChecks(player, config.wizardrymod.statorskill, false);
                }
            }
            if (config.sql.enablesql)
            {
                sqlConnection = sqlLibrary.OpenDb(config.sql.SQLhost, config.sql.SQLport, config.sql.SQLdatabase, config.sql.SQLusername, config.sql.SQLpassword, this);
                CreatSQLTable();
                UpdateSQLTable();
            }
            if (!config.mentality.useotherresearchmod)
            {
                Subscribe(nameof(OnResearchCostDetermine));
                Subscribe(nameof(CanUnlockTechTreeNode));
                Subscribe(nameof(OnTechTreeNodeUnlock));
                Subscribe(nameof(OnItemResearch));
            }
            LibraryCheck();
            config.xpLevelRanks.keepremainingxp = true;
        }
        private void OnPluginLoaded(Plugin name)
        {
            if (ImageLibrary != null && name.Name == ImageLibrary.Name && !_isRestart)
            {
                _imageLibraryCheck = 0;
                LibraryCheck();
            }
            foreach (var player in BasePlayer.activePlayerList)
            {
                DestroyUi(player, XPerienceLivePrimary);
                PlayerArmor(player);
                MightAttributes(player);
                LiveStats(player, true);
                // Archery Check
                if (Archery != null && config.archerymod.enablearchery)
                {
                    ArcheryChecks(player, config.archerymod.statorskill, false);
                }
                // Wizardry Check
                if (Wizardry != null && config.wizardrymod.enablewizardry)
                {
                    WizardryChecks(player, config.wizardrymod.statorskill, false);
                }
            }
        }
        private void Unload()
        {
            foreach (var player in BasePlayer.activePlayerList)
            {
                DestroyUi(player, XPerienceLivePrimary);
                DestroyUi(player, XPerienceLiveFuel);
                DestroyUi(player, XPerienceLiveSpeed);
                DestroyUi(player, XPeriencePlayerControlPrimary);
                DestroyUi(player, XPerienceTopMain);
                DestroyUi(player, XPerienceAdminPanelMain);
                DestroyUi(player, XPeriencePlayerControlFullMain);
                DestroyUi(player, XPeriencePlayerInfoBox);
                DestroyUi(player, XPerienceLiveDashPanel);
                if (config.backpacksmod.removeonunload)
                {
                    if (permission.UserHasPermission(player.UserIDString, Backpack1))
                    {
                        permission.RevokeUserPermission(player.UserIDString, Backpack1);
                    }
                    if (permission.UserHasPermission(player.UserIDString, Backpack2))
                    {
                        permission.RevokeUserPermission(player.UserIDString, Backpack2);
                    }
                    if (permission.UserHasPermission(player.UserIDString, Backpack3))
                    {
                        permission.RevokeUserPermission(player.UserIDString, Backpack3);
                    }
                    if (permission.UserHasPermission(player.UserIDString, Backpack4))
                    {
                        permission.RevokeUserPermission(player.UserIDString, Backpack4);
                    }
                    if (permission.UserHasPermission(player.UserIDString, Backpack5))
                    {
                        permission.RevokeUserPermission(player.UserIDString, Backpack5);
                    }
                    if (permission.UserHasPermission(player.UserIDString, Backpack6))
                    {
                        permission.RevokeUserPermission(player.UserIDString, Backpack6);
                    }
                    if (permission.UserHasPermission(player.UserIDString, Backpack7))
                    {
                        permission.RevokeUserPermission(player.UserIDString, Backpack7);
                    }
                }
                if (config.archerymod.removeonunload)
                {
                    if (permission.UserHasPermission(player.UserIDString, ArcheryNovice))
                    {
                        permission.RevokeUserPermission(player.UserIDString, ArcheryNovice);
                    }
                    if (permission.UserHasPermission(player.UserIDString, ArcheryAdept))
                    {
                        permission.RevokeUserPermission(player.UserIDString, ArcheryAdept);
                    }
                    if (permission.UserHasPermission(player.UserIDString, ArcheryMaster))
                    {
                        permission.RevokeUserPermission(player.UserIDString, ArcheryMaster);
                    }
                }
                if (config.wizardrymod.removeonunload)
                {
                    if (permission.UserHasPermission(player.UserIDString, WizardryNovice))
                    {
                        permission.RevokeUserPermission(player.UserIDString, WizardryNovice);
                    }
                    if (permission.UserHasPermission(player.UserIDString, WizardryAdept))
                    {
                        permission.RevokeUserPermission(player.UserIDString, WizardryAdept);
                    }
                    if (permission.UserHasPermission(player.UserIDString, WizardryMaster))
                    {
                        permission.RevokeUserPermission(player.UserIDString, WizardryMaster);
                    }
                }
            }
            SaveData();
            SaveLoot();
            SaveCorpse();
            SaveHorse();
            SaveWeapon();
            SaveBoat();
            SaveVehicle();
            SaveMinicopter();
            if (config.sql.enablesql)
            {
                UpdatePlayersDataSQL();
                sqlLibrary.CloseDb(sqlConnection);
            }
            _xperienceImageList.Clear();
        }
        private void OnServerShutdown()
        {
            SaveData();
            if (config.sql.enablesql)
            {
                UpdatePlayersDataSQL();
                sqlLibrary.CloseDb(sqlConnection);
            }
            _lootCache.Clear();
            _LootContainData.Clear();
            SaveLoot();
            _corpseCache.Clear();
            _CorpseContainData.Clear();
            SaveCorpse();
            _horseCache.Clear();
            _HorseData.Clear();
            SaveHorse();
            _weaponCache.Clear();
            _WeaponData.Clear();
            SaveWeapon();
            _boatCache.Clear();
            _BoatData.Clear();
            SaveBoat();
            _vehicleCache.Clear();
            _VehicleData.Clear();
            SaveVehicle();
            _minicopterCache.Clear();
            _MinicopterData.Clear();
            SaveMinicopter();
        }
        private void OnServerSave()
        {
            CheckOnlineStatus();
            SaveData();
            SaveLoot();
            SaveCorpse();
            SaveHorse();
            SaveWeapon();
            SaveBoat();
            SaveVehicle();
            SaveMinicopter();
            if (config.sql.enablesql)
            {
                foreach (var player in BasePlayer.allPlayerList)
                {
                    CheckPlayerDataSQL(player);
                }
                UpdatePlayersDataSQL();
            }
        }
        private void OnPlayerConnected(BasePlayer player)
        {
            UpdateDisplayName(player);
            GetXPRecord(player);
            PlayerArmor(player);
            MightAttributes(player);
            if (!config.defaultOptions.liveuistatslocationmoveable)
            {
                _xperienceCache[player.UserIDString].UILocation = config.defaultOptions.liveuistatslocation;
            }
            LiveStats(player, true);
            if (config.defaultOptions.showchatprofileonconnect)
            {
                PlayerStatsChat(player);
            }
            _xperienceCache[player.UserIDString].Status = true;
            if(_xperienceCache[player.UserIDString].dash == 0)
            {
                _xperienceCache[player.UserIDString].dash = 1;
            }
            if(_xperienceCache[player.UserIDString].speedometertype == 0)
            {
                _xperienceCache[player.UserIDString].speedometertype = 1;
            }
            if (config.xpLevelRanks.enableresetranks)
            {
                RankCheck(player);
            }
            // Backpack Check
            if (Backpacks != null && config.backpacksmod.enablebackpacks)
            {
                BackPackChecks(player, config.backpacksmod.statorskill, false);
            }
            // Archery Check
            if (Archery != null && config.archerymod.enablearchery)
            {
                ArcheryChecks(player, config.archerymod.statorskill, false);
            }
            // Wizardry Check
            if (Wizardry != null && config.wizardrymod.enablewizardry)
            {
                WizardryChecks(player, config.wizardrymod.statorskill, false);
            }
        }
        private void OnPlayerDisconnected(BasePlayer player)
        {
            DestroyUi(player, XPerienceLivePrimary);
            DestroyUi(player, XPerienceLiveFuel);
            DestroyUi(player, XPeriencePlayerControlPrimary);
            DestroyUi(player, XPerienceTopMain);
            DestroyUi(player, XPerienceAdminPanelMain);
            DestroyUi(player, XPeriencePlayerControlFullMain);
            DestroyUi(player, XPeriencePlayerInfoBox);
            DestroyUi(player, XPerienceLiveSpeed);
            DestroyUi(player, XPerienceLiveDashPanel);
            if (config.sql.enablesql)
            {
                CheckPlayerDataSQL(player);
            }
            _xperienceCache[player.UserIDString].Status = false;
        }
        private void OnPlayerRespawn(BasePlayer player)
        {
            if (player == null) return;
            LiveStats(player, true);
        }
        private void OnPlayerRespawned(BasePlayer player)
        {
            PlayerArmor(player);
            MightAttributes(player);
            LiveStats(player, true);
        }
        private void OnPlayerKicked(BasePlayer player)
        {
            _xperienceCache[player.UserIDString].Status = false;
        }
        #endregion

        #region ImageLibrary
        private void LibraryCheck()
        {
            if (ImageLibrary == null || !ImageLibrary.IsLoaded || !ImageLibrary.Call<bool>("IsReady"))
            {
                _imageLibraryCheck++;

                if (_imageLibraryCheck >= 20)
                {
                    _isRestart = false;
                    PrintWarning($"ImageLibrary appears to be missing. XPerience is unusable.");
                    return;
                }

                timer.In(60, LibraryCheck);
                PrintWarning("if ImageLibrary is installed, then it appears to be occupied will check again in 1 minute");
                return;
            }

            LoadImages();
        }
        private void LoadImages()
        {
            _isRestart = false;
            _xperienceImageList = new Dictionary<string, string>();
            _xperienceImageList.Add(XPerienceicon, config.imageicons.mainicon);
            _xperienceImageList.Add(XPeriencementality, config.imageicons.mentality);
            _xperienceImageList.Add(XPeriencedexterity, config.imageicons.dexterity);
            _xperienceImageList.Add(XPeriencemight, config.imageicons.might);
            _xperienceImageList.Add(XPeriencecaptaincy, config.imageicons.captaincy);
            _xperienceImageList.Add(XPerienceweaponry, config.imageicons.weaponry);
            _xperienceImageList.Add(XPeriencewoodcutter, config.imageicons.woodcutter);
            _xperienceImageList.Add(XPeriencesmithy, config.imageicons.smithy);
            _xperienceImageList.Add(XPerienceminer, config.imageicons.miner);
            _xperienceImageList.Add(XPerienceforager, config.imageicons.forager);
            _xperienceImageList.Add(XPeriencehunter, config.imageicons.hunter);
            _xperienceImageList.Add(XPeriencefisher, config.imageicons.fisher);
            _xperienceImageList.Add(XPeriencecrafter, config.imageicons.crafter);
            _xperienceImageList.Add(XPerienceframer, config.imageicons.framer);
            _xperienceImageList.Add(XPeriencemedic, config.imageicons.medic);
            _xperienceImageList.Add(XPeriencescavenger, config.imageicons.scavenger);
            _xperienceImageList.Add(XPeriencetamer, config.imageicons.tamer);
            _xperienceImageList.Add(XPeriencechicken, config.imageicons.chicken);
            _xperienceImageList.Add(XPerienceboar, config.imageicons.boar);
            _xperienceImageList.Add(XPeriencestag, config.imageicons.stag);
            _xperienceImageList.Add(XPeriencewolf, config.imageicons.wolf);
            _xperienceImageList.Add(XPeriencebear, config.imageicons.bear);
            _xperienceImageList.Add(XPeriencepolarbear, config.imageicons.polarbear);
            _xperienceImageList.Add(XPeriencearchery, config.imageicons.archery);
            _xperienceImageList.Add(XPeriencewizardry, config.imageicons.wizardry);
            _xperienceImageList.Add(XPerienceonline, config.imageicons.online);
            _xperienceImageList.Add(XPerienceoffline, config.imageicons.offline);
            _xperienceImageList.Add(XPeriencebackpack, config.imageicons.backpack);
            _xperienceImageList.Add(XPeriencelevel, config.imageicons.level);
            _xperienceImageList.Add(XPeriencelevel0, config.imageicons.level0);
            _xperienceImageList.Add(XPeriencelevel2, config.imageicons.level2);
            _xperienceImageList.Add(XPeriencelevel4, config.imageicons.level4);
            _xperienceImageList.Add(XPeriencelevel6, config.imageicons.level6);
            _xperienceImageList.Add(XPeriencelevel8, config.imageicons.level8);
            _xperienceImageList.Add(XPeriencelevel10, config.imageicons.level10);
            _xperienceImageList.Add(XPeriencefuelguage, config.imageicons.fuelguage);
            _xperienceImageList.Add(XPeriencespeedometer, config.imageicons.speedometer);
            _xperienceImageList.Add(XPeriencedash, config.imageicons.dash);
            _xperienceImageList.Add(XPeriencexp, config.imageicons.xp);
            _xperienceImageList.Add(XPeriencearmor, config.imageicons.armor);
            _xperienceImageList.Add(XPeriencelogo, "https://i.imgur.com/d16zkJk.png");
            foreach (var rank in config.xpLevelRanks.ranks)
            {
                if (!rank.Value.image.IsNullOrEmpty() && !_xperienceImageList.ContainsKey(rank.Value.image))
                {
                    _xperienceImageList.Add(rank.Value.name, rank.Value.image);
                }
            }
            ImageLibrary?.Call("ImportImageList", Name, _xperienceImageList, 0UL, true, new Action(Ready));
        }
        private void Ready()
        {
            _isXPReady = true;
            _xperienceImageList.Clear();
        }
        private void ChangeImageURLs()
        {
            bool changesmade = false;
            if (config.imageicons.speedometer == "https://i.imgur.com/fO1YfUz.png") { config.imageicons.speedometer = "https://i.imgur.com/Q1Kqsfz.png"; changesmade = true; }
            if (changesmade)
            {
                SaveConfig();
            }
        }
        #endregion

        #region PlayerData
        private void CheckOnlineStatus()
        {
            foreach (var player in _xperienceCache)
            {
                player.Value.Status = false;
                foreach (var online in BasePlayer.activePlayerList)
                {
                    if (player.Key == online.UserIDString)
                    {
                        player.Value.Status = true;
                    }
                }
            }
        }
        private void UpdateDisplayName(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.displayname != player.displayName)
                xprecord.displayname = player.displayName;
        }
        private XPRecord GetXPRecord(BasePlayer player)
        {
            if (player == null || !player.userID.IsSteamId()) return null;
            XPRecord xprecord;
            if (_xperienceCache.TryGetValue(player.UserIDString, out xprecord))
            {
                return xprecord;
            }
            if (!_xperienceCache.TryGetValue(player.UserIDString, out xprecord))
            {
                _xperienceCache[player.UserIDString] = xprecord = new XPRecord
                {
                    rank = 0,
                    truelevel = 0,
                    trueexperience = 0,
                    level = 0,
                    experience = 0,
                    requiredxp = config.xpLevel.levelstart,
                    statpoint = 0,
                    skillpoint = 0,
                    Mentality = 0,
                    MentalityP = 0,
                    Dexterity = 0,
                    DexterityP = 0,
                    Might = 0,
                    MightP = 0,
                    Captaincy = 0,
                    CaptaincyP = 0,
                    Weaponry = 0,
                    WeaponryP = 0,
                    WoodCutter = 0,
                    WoodCutterP = 0,
                    Smithy = 0,
                    SmithyP = 0,
                    Miner = 0,
                    MinerP = 0,
                    Forager = 0,
                    ForagerP = 0,
                    Hunter = 0,
                    HunterP = 0,
                    Fisher = 0,
                    FisherP = 0,
                    Crafter = 0,
                    CrafterP = 0,
                    Framer = 0,
                    FramerP = 0,
                    Medic = 0,
                    MedicP = 0,
                    Tamer = 0,
                    TamerP = 0,
                    Wood = 0,
                    Stone = 0,
                    Metal = 0,
                    Sulfur = 0,
                    Cactus = 0,
                    Berries = 0,
                    Pumpkin = 0,
                    Potato = 0,
                    Corn = 0,
                    Mushroom = 0,
                    Hemp = 0,
                    Seed = 0,
                    Status = true,
                    DisableRank = false,
                    UILocation = config.defaultOptions.liveuistatslocation,
                    teatype = "none",
                    teacooldown = 0,
                    resettimerstats = DateTime.Now,
                    resettimerskills = DateTime.Now,
                    playerfixdata = DateTime.Now,
                    dash = 1,
                    fuelgauge = true,
                    speedometer = true,
                    speedometertype = config.defaultOptions.speedometertype,
    };
                xprecord.id = player.UserIDString;
                xprecord.displayname = player.displayName;
            }
            return xprecord;
        }
        private Ranks GetXPRank(int rank)
        {
            Ranks ranks;
            if (config.xpLevelRanks.ranks.TryGetValue(rank, out ranks))
            {
                return ranks;
            }
            return ranks;
        }
        private XPRecord GetPlayerRecord(string player)
        {
            if (player == null) return null;
            XPRecord xprecord;
            if (_xperienceCache.TryGetValue(player, out xprecord))
            {
                return xprecord;
            }
            return xprecord;
        }
        private void AddLootData(BasePlayer player, LootContainer lootcontainer)
        {
            Loot loot;
            if (!_lootCache.TryGetValue(lootcontainer.net.ID, out loot))
            {
                _lootCache.Add(lootcontainer.net.ID, loot = new Loot
                {
                    lootcontainer = lootcontainer.net.ID,
                    id = new List<string>(),
                });
            }

            if (!loot.id.Contains(player.UserIDString))
            {
                loot.id.Add(player.UserIDString);
            }
        }
        private void AddHorseData(BasePlayer player, RidableHorse horse)
        {
            Horse defaulthorse;
            if (!_horseCache.TryGetValue(horse.net.ID, out defaulthorse))
            {
                _horseCache.Add(horse.net.ID, new Horse
                {
                    horse = horse.net.ID,
                    maxSpeed = horse.maxSpeed,
                    runSpeed = horse.runSpeed,
                    trotSpeed = horse.trotSpeed,
                    walkSpeed = horse.walkSpeed
                });
            }
        }
        private void AddBoatData(BasePlayer player, BaseBoat boat)
        {
            Boat defaultboat;
            if (!_boatCache.TryGetValue(boat.net.ID, out defaultboat))
            {
                _boatCache.Add(boat.net.ID, new Boat
                {
                    boat = boat.net.ID,
                    defaultSpeed = boat.engineThrust,
                    player = player.userID
                });
            }
        }
        private void AddVehicleData(BasePlayer player, ModularCar car)
        {
            Vehicle vehicle;
            if (!_vehicleCache.TryGetValue(car.net.ID, out vehicle))
            {
                _vehicleCache.Add(car.net.ID, new Vehicle
                {
                    vehicle = car.net.ID,
                    maxDriveSlip = car.carSettings.maxDriveSlip,
                    reversePercentSpeed = car.carSettings.reversePercentSpeed,
                    driveForceToMaxSlip = car.carSettings.driveForceToMaxSlip,
                    player = player.userID
                });
            }
        }
        private void AddMiniCopterData(BasePlayer player, MiniCopter mini)
        {
            Minicopter minicopter;
            if (!_minicopterCache.TryGetValue(mini.net.ID, out minicopter))
            {
                _minicopterCache.Add(mini.net.ID, new Minicopter
                {
                    minicopter = mini.net.ID,
                    maxRotorSpeed = mini.maxRotorSpeed,
                    player = player.userID
                });
            }
        }
        private void AddWeaponData(BasePlayer player, BaseProjectile projectile, int defaultammo, int maxammo)
        {
            Weapon weapon;
            if (!_weaponCache.TryGetValue(projectile.net.ID, out weapon))
            {
                _weaponCache.Add(projectile.net.ID, new Weapon
                {
                    weapon = projectile.net.ID,
                    defaultammo = defaultammo,
                    maxammo = maxammo,
                    player = player.userID
                });
            }
        }
        private void AddCorpseData(BasePlayer player, LootableCorpse corpse)
        {
            Corpse corpseid;
            if (!_corpseCache.TryGetValue(corpse.net.ID, out corpseid))
            {
                _corpseCache.Add(corpse.net.ID, corpseid = new Corpse
                {
                    corpsecontainer = corpse.net.ID,
                    id = new List<string>(),
                });
            }

            if (!corpseid.id.Contains(player.UserIDString))
            {
                corpseid.id.Add(player.UserIDString);
            }
        }
        private static BasePlayer FindPlayer(string playerid)
        {
            foreach (var activePlayer in BasePlayer.activePlayerList)
            {
                if (activePlayer.UserIDString == playerid)
                    return activePlayer;
            }
            foreach (var sleepingPlayer in BasePlayer.sleepingPlayerList)
            {
                if (sleepingPlayer.UserIDString == playerid)
                    return sleepingPlayer;
            }
            return null;
        }
        private double GetPlayerCooldown(ulong userID, string type)
        {
            double playerCooldown;
            double currentTime = CurrentTime;
            double gettime = 0;
            switch (type)
            {
                case "build":
                    if (_buildCooldowns.TryGetValue(userID, out playerCooldown))
                        gettime = currentTime > playerCooldown ? 0 : playerCooldown - CurrentTime;
                    break;
                case "craft":
                    if (_craftCooldowns.TryGetValue(userID, out playerCooldown))
                        gettime = currentTime > playerCooldown ? 0 : playerCooldown - CurrentTime;
                    break;
                case "notify":
                    if (_notifyCooldowns.TryGetValue(userID, out playerCooldown))
                        gettime = currentTime > playerCooldown ? 0 : playerCooldown - CurrentTime;
                    break;
            }
            return gettime;

        }
        private double GetTeaCooldown(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.teacooldown == 0) return 0;
            double currentTime = CurrentTime;
            return currentTime > xprecord.teacooldown ? 0 : xprecord.teacooldown - CurrentTime;
        }
        private string GetTeaTypes(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.teatype == "none") return "none";
            return xprecord.teatype;
        }
        private object OnPlayerChat(BasePlayer player, string message, Chat.ChatChannel channel)
        {
            if (!config.xpLevelRanks.showrankinchat || BetterChatActv() || ColouredChatAct()) return null;
            if (player == null || message == null) return null;
            XPRecord xprecord = GetXPRecord(player);
            Ranks rank = GetXPRank(xprecord.rank);
            string color = ColorConverter(config.uitextColor.rankname).ToString();
            OverrideChatMessage(player, color, rank.sig, player.displayName, message, channel);
            return true;
        }
        private object OverrideChatMessage(BasePlayer player, string color, string ranksig, string displayname, string message, Chat.ChatChannel channel)
        {
            RCon.Broadcast(RCon.LogType.Chat, new Chat.ChatEntry
            {
                Channel = channel,
                Message = new Regex("<[^>]*>").Replace(string.Join(" ", message), ""),
                UserId = player.UserIDString,
                Username = player.displayName,
                Color = color,
                Time = Epoch.Current
            });

            switch ((int)channel)
            {
                // Global
                case 0:
                    var newglobalchat = ArrayPool.Get(3);
                    newglobalchat[0] = (int)channel;
                    newglobalchat[1] = player.UserIDString;
                    foreach (BasePlayer p in BasePlayer.activePlayerList.Where(p => p.IsValid() == true))
                    {
                        newglobalchat[2] = $"<color={color}>{ranksig}</color>{displayname}: {message}";
                        p.SendConsoleCommand("chat.add", newglobalchat);
                    }
                    ArrayPool.Free(newglobalchat);
                    break;

                // Teams
                case 1:
                    var newteamchat = ArrayPool.Get(3);
                    newteamchat[0] = (int)channel;
                    newteamchat[1] = player.UserIDString;
                    foreach (BasePlayer p in BasePlayer.activePlayerList.Where(p => p.Team != null && player.Team != null && p.Team.teamID == player.Team.teamID && p.IsValid() == true))
                    {
                        newteamchat[2] = $"<color={color}>{ranksig}</color>{displayname}: {message}";
                        p.SendConsoleCommand("chat.add", newteamchat);
                    }
                    ArrayPool.Free(newteamchat);
                    break;
                default:
                    break;
            }
            return true;
        }
        // Check for BetterChat/ColouredChat plugins
        private bool BetterChatActv() => (BetterChat != null && BetterChat.IsLoaded);
        private bool ColouredChatAct() => (ColouredChat != null && ColouredChat.IsLoaded);
        private object OnBetterChat(Dictionary<string, object> chat)
        {
            if (config.xpLevelRanks.showrankinchat && BetterChatActv())
            {
                var player = (chat["Player"] as IPlayer).Object as BasePlayer;
                if (player == null) return null;
                XPRecord xprecord = GetXPRecord(player);
                Ranks rank = GetXPRank(xprecord.rank);
                string color = ColorConverter(config.uitextColor.rankname).ToString();
                chat["Username"] = $"<color={color}>{rank.sig}</color>{player.displayName}";
                return chat;
            }
            return null;
        }
        // Prevent ranks in chat if ColouredChat installed
        /*
        private void OnColouredChat()
        {
            if (ColouredChatAct() && config.xpLevelRanks.showrankinchat)
            {
                Puts("ColouredChat plugin detected, Rank titles for XPerience will not show with this pluign installed. Remove ColouredChat or disable Ranks in chat option in XPerience.");
            }
        }
        */
        #endregion

        #region Level/XP/Stat/Skill Control
        private void GainExp(BasePlayer player, double e)
        {
            if (player == null || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(player);
            // Check True Level
            if (xprecord.truelevel <= 0 || xprecord.truelevel < xprecord.level)
            {
                xprecord.truelevel = (int)xprecord.level;
            }
            // Make sure XP and True XP are not 0 and are correct
            if (xprecord.experience <= 0)
            {
                xprecord.experience = 0;
            }
            if (xprecord.trueexperience <= 0 || xprecord.trueexperience < xprecord.experience)
            {
                xprecord.trueexperience = (int)xprecord.experience;
            }
            // Night Bonus
            if (IsNight() && config.nightBonus.Enable)
            {
                double timebonus = e * config.nightBonus.Bonus;
                e += timebonus;
            }
            // Level Bonus
            if (xprecord.level > 0)
            {
                e += (config.xpLevel.levelxpboost * xprecord.level) * e;
            }
            // Teams
            if (config.xpTeams.enableteamxpgain && e != 0)
            {
                XPTeams(player, e, "addxp");
            }
            // Captaincy
            if (config.captaincy.enablexpboost && e != 0)
            {
                double captaincyboost = Math.Ceiling(e * (double)CaptaincyTeamXPBoost(player));
                e += captaincyboost;
            }
            // Clans
            if (Clans != null && config.xpclans.enableclanbonus && e != 0)
            {
                XPClans(player, e, "addxp");
            }
            // Ranks
            if (config.xpLevelRanks.enableresetranks && !xprecord.DisableRank && config.xpLevelRanks.enablerankxpboost && xprecord.rank > 0)
            {
                e += (e * config.xpLevelRanks.rankxpboost) * xprecord.rank;
            }
            // Check for max rank or level and prevent level up but still award XP if allowed
            if ((xprecord.level >= config.xpLevel.maxlevel && !config.xpLevelRanks.enableresetranks) || (xprecord.level >= config.xpLevel.maxlevel && xprecord.rank >= config.xpLevelRanks.maxresetrank) || (xprecord.DisableRank && xprecord.level >= config.xpLevel.maxlevel))
            {
                xprecord.level = config.xpLevel.maxlevel;
                if (xprecord.DisableRank && xprecord.rank < config.xpLevelRanks.maxresetrank)
                {
                    return;
                }
                if (config.xpLevel.alwaysearnxp)
                {
                    xprecord.experience += Math.Ceiling(e);
                    xprecord.trueexperience += (int)Math.Ceiling(e);
                    xprecord.requiredxp = xprecord.experience;
                    LiveStats(player, true);
                    // UINotify
                    if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.xpgainloss && e != 0)
                    {
                        if (GetPlayerCooldown(player.userID, "notify") == 0)
                        {
                            UINotify.Call("SendNotify", player, config.UiNotifier.xpgainlosstype, XPLang("uinotify_xpgain", player.UserIDString, Math.Round(e)));
                            _notifyCooldowns[player.userID] = CurrentTime + config.defaultOptions.NotifcationCooldown;
                        }
                    }
                }
                else
                {
                    xprecord.experience = xprecord.requiredxp;
                }
                return;
            }
            // Give the calculated XP and Update Player
            xprecord.experience += Math.Ceiling(e);
            xprecord.trueexperience += (int)Math.Ceiling(e);
            LiveStats(player, true);
            // UINotify
            if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.xpgainloss && e != 0)
            {
                if (GetPlayerCooldown(player.userID, "notify") == 0)
                {
                    UINotify.Call("SendNotify", player, config.UiNotifier.xpgainlosstype, XPLang("uinotify_xpgain", player.UserIDString, Math.Round(e)));
                    _notifyCooldowns[player.userID] = CurrentTime + config.defaultOptions.NotifcationCooldown;
                }
            }
            if (xprecord.experience >= xprecord.requiredxp)
            {
                LvlUp(player, 0, 0);
            }
        }
        private void GainExpAdmin(BasePlayer player, double e, int truexp = 0, bool reset = false)
        {
            if (player == null || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(player);
            if (reset)
            {
                xprecord.trueexperience = truexp;
            }
            // Check True Level
            if (xprecord.truelevel <= 0 || xprecord.truelevel < xprecord.level)
            {
                xprecord.truelevel = (int)xprecord.level;
            }
            // Check for max rank or level and prevent level up but still award XP if allowed
            if ((xprecord.level >= config.xpLevel.maxlevel && !config.xpLevelRanks.enableresetranks) || (xprecord.level >= config.xpLevel.maxlevel && xprecord.rank >= config.xpLevelRanks.maxresetrank))
            {
                xprecord.level = config.xpLevel.maxlevel;
                if (config.xpLevel.alwaysearnxp)
                {
                    xprecord.experience += Math.Ceiling(e);
                    xprecord.trueexperience += (int)Math.Ceiling(e);
                    xprecord.requiredxp = xprecord.experience;
                    LiveStats(player, true);
                    // UINotify
                    if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.xpgainloss && e != 0)
                    {
                        if (GetPlayerCooldown(player.userID, "notify") == 0)
                        {
                            UINotify.Call("SendNotify", player, config.UiNotifier.xpgainlosstype, XPLang("uinotify_xpgain", player.UserIDString, Math.Round(e)));
                            _notifyCooldowns[player.userID] = CurrentTime + config.defaultOptions.NotifcationCooldown;
                        }
                    }
                }
                else
                {
                    xprecord.experience = xprecord.requiredxp;
                }
                return;
            }
            // Make sure XP and True XP are not 0 and are correct
            if (xprecord.experience <= 0)
            {
                xprecord.experience = 0;
            }
            if (xprecord.trueexperience <= 0 || xprecord.trueexperience < xprecord.experience)
            {
                xprecord.trueexperience = (int)xprecord.experience;
            }
            // Give XP and Update Player
            xprecord.experience += e;
            if (!reset)
            {
                xprecord.trueexperience += (int)e;
            }
            LiveStats(player, true);
            if (xprecord.experience >= xprecord.requiredxp)
            {
                LvlUp(player, 0, 0);
            }
        }
        private void GainExpAdminFix(string player, double e, int truexp = 0, bool reset = false)
        {
            if (player == null) return;
            XPRecord xprecord = GetPlayerRecord(player);
            if (reset)
            {
                xprecord.trueexperience = truexp;
            }
            // Check True Level
            if (xprecord.truelevel <= 0 || xprecord.truelevel < xprecord.level)
            {
                xprecord.truelevel = (int)xprecord.level;
            }
            // If max level and ranks disabled return
            if (xprecord.level >= config.xpLevel.maxlevel && !config.xpLevelRanks.enableresetranks) return;
            // Make sure XP and True XP are not 0 and are correct
            if (xprecord.experience <= 0)
            {
                xprecord.experience = 0;
            }
            if (xprecord.trueexperience <= 0 || xprecord.trueexperience < xprecord.experience)
            {
                xprecord.trueexperience = (int)xprecord.experience;
            }
            // Give XP and Update Player
            xprecord.experience += e;
            if (!reset)
            {
                xprecord.trueexperience += (int)e;
            }
            if (xprecord.experience >= xprecord.requiredxp)
            {
                LvlUpFix(player);
            }
        }
        private void LvlUp(BasePlayer player, int chatstatpoint, int chatskillpoint, bool reset = false)
        {
            XPRecord xprecord = GetXPRecord(player);
            xprecord.level++;
            xprecord.truelevel++;
            if ((xprecord.level >= config.xpLevel.maxlevel && !config.xpLevelRanks.enableresetranks) || (xprecord.level >= config.xpLevel.maxlevel && xprecord.rank >= config.xpLevelRanks.maxresetrank))
            {
                xprecord.level = config.xpLevel.maxlevel;
                xprecord.experience = xprecord.requiredxp;
                LiveStats(player, true);
                return;
            }
            if (config.xpLevelRanks.enableresetranks && !xprecord.DisableRank)
            {
                if (xprecord.rank <= 0)
                {
                    xprecord.statpoint += config.xpLevel.statpointsperlvl;
                    xprecord.skillpoint += config.xpLevel.skillpointsperlvl;
                    chatstatpoint += config.xpLevel.statpointsperlvl;
                    chatskillpoint += config.xpLevel.skillpointsperlvl;
                }
                else
                {
                    xprecord.statpoint += config.xpLevel.statpointsperlvl + (config.xpLevelRanks.rankstatpointincrease * xprecord.rank);
                    xprecord.skillpoint += config.xpLevel.skillpointsperlvl + (config.xpLevelRanks.rankskillpointincrease * xprecord.rank);
                    chatstatpoint += config.xpLevel.statpointsperlvl + (config.xpLevelRanks.rankstatpointincrease * xprecord.rank);
                    chatskillpoint += config.xpLevel.skillpointsperlvl + (config.xpLevelRanks.rankskillpointincrease * xprecord.rank);
                }
                if (xprecord.level >= config.xpLevel.maxlevel && config.xpLevelRanks.enableresetranks)
                {
                    double remainingxp = xprecord.experience - xprecord.requiredxp;
                    RankUp(player, remainingxp);
                    return;
                }
            }
            else
            {
                xprecord.statpoint += config.xpLevel.statpointsperlvl;
                xprecord.skillpoint += config.xpLevel.skillpointsperlvl;
                chatstatpoint += config.xpLevel.statpointsperlvl;
                chatskillpoint += config.xpLevel.skillpointsperlvl;
            }
            if (xprecord.level >= config.xpLevel.maxlevel)
            {
                if (xprecord.level >= config.xpLevel.maxlevel && xprecord.DisableRank)
                {
                    xprecord.requiredxp = xprecord.experience;
                }
                else
                {
                    xprecord.requiredxp = config.xpLevel.levelstart;
                }
            }
            else
            {
                xprecord.requiredxp = Math.Round(xprecord.requiredxp + (xprecord.level * config.xpLevel.levelmultiplier));
            }
            MightAttributes(player);
            if (xprecord.experience > xprecord.requiredxp)
            {
                LvlUp(player, chatstatpoint, chatskillpoint);
                return;
            }
            // UINotify
            if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.levelupdown)
            {
                UINotify.Call("SendNotify", player, config.UiNotifier.levelupdowntype, XPLang("levelup", player.UserIDString, xprecord.level, chatstatpoint, chatskillpoint));
            }
            // Normal Chat Notify
            if (!config.UiNotifier.disablechats)
            {
                player.ChatMessage(XPLang("levelup", player.UserIDString, xprecord.level, chatstatpoint, chatskillpoint));
            }
            // Econ
            if (Economics != null && config.xpEcon.econlevelup && !reset)
            {
                Economics.Call("Deposit", player.UserIDString, config.xpEcon.econlevelreward);
                player.ChatMessage(XPLang("econdeposit", player.UserIDString, config.xpEcon.econlevelreward));
            }
            // Server Rewards
            if (ServerRewards != null && config.sRewards.srewardlevelup && !reset)
            {
                ServerRewards?.Call("AddPoints", player.userID, config.sRewards.srewardlevelupamt);
                player.ChatMessage(XPLang("srewardsup", player.UserIDString, config.sRewards.srewardlevelupamt));
            }
            LiveStats(player, true);
            // AddonDiscord
            if (XPerienceAddon != null)
            {
                XPerienceAddon?.Call("AddonDiscordLevel", player, xprecord.level);
                XPerienceAddon?.Call("NotifyUIBar", player, "level", "level", (int)xprecord.level);
                XPerienceAddon?.Call("NotifyUIBarGlobal", player, "level", "level", (int)xprecord.level);
            }
        }
        private void LvlUpFix(string player)
        {
            XPRecord xprecord = GetPlayerRecord(player);
            xprecord.level++;
            xprecord.truelevel++;
            if (xprecord.level >= config.xpLevel.maxlevel && !config.xpLevelRanks.enableresetranks) return;
            if (config.xpLevelRanks.enableresetranks && !xprecord.DisableRank)
            {
                if (xprecord.rank <= 0)
                {
                    xprecord.statpoint += config.xpLevel.statpointsperlvl;
                    xprecord.skillpoint += config.xpLevel.skillpointsperlvl;
                }
                else
                {
                    xprecord.statpoint += config.xpLevel.statpointsperlvl + (config.xpLevelRanks.rankstatpointincrease * xprecord.rank);
                    xprecord.skillpoint += config.xpLevel.skillpointsperlvl + (config.xpLevelRanks.rankskillpointincrease * xprecord.rank);
                }
                if (xprecord.level >= config.xpLevel.maxlevel && config.xpLevelRanks.enableresetranks)
                {
                    double remainingxp = xprecord.experience - xprecord.requiredxp;
                    RankUpFix(player, remainingxp);
                    return;
                }
            }
            else
            {
                xprecord.statpoint += config.xpLevel.statpointsperlvl;
                xprecord.skillpoint += config.xpLevel.skillpointsperlvl;
            }
            if (xprecord.level >= config.xpLevel.maxlevel)
            {
                xprecord.requiredxp = config.xpLevel.levelstart;
            }
            else
            {
                xprecord.requiredxp = Math.Round(xprecord.requiredxp + (xprecord.level * config.xpLevel.levelmultiplier));
            }
            if (xprecord.experience > xprecord.requiredxp)
            {
                LvlUpFix(player);
                return;
            }
        }
        private void RankUp(BasePlayer player, double remainingxp)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.rank >= config.xpLevelRanks.maxresetrank) return;
            xprecord.rank++;
            Ranks rank = GetXPRank(xprecord.rank);
            // Reset Level, Required XP & Stat/Skill Points
            xprecord.level = 0;
            if (config.xpLevelRanks.keepremainingxp)
            {
                xprecord.experience = remainingxp;
            }
            else
            {
                xprecord.experience = 0;
            }
            xprecord.requiredxp = config.xpLevel.levelstart;
            xprecord.statpoint = config.xpLevelRanks.rankstatpointstart * xprecord.rank;
            xprecord.skillpoint = config.xpLevelRanks.rankskillpointstart * xprecord.rank;
            // Reset health if needed before removing points
            if (xprecord.Might >= 1)
            {
                // Max Health
                double armor = (xprecord.Might * config.might.armor) * 100;
                double newmaxhealth = player._maxHealth - armor;
                // Change Max Health
                if (newmaxhealth < 100)
                {
                    player._maxHealth = 100;
                }
                else
                {
                    player._maxHealth = (float)newmaxhealth;
                }
                // Player Current Health
                double defaulthealth = 100;
                double teahealth = 100;
                bool teamodified = false;
                double healthdifference = 0;
                if (GetTeaCooldown(player) != 0)
                {
                    // Check for Tea Modifier
                    if (TeaModifiers != null && xprecord.teatype != "none")
                    {
                        teahealth = defaulthealth + TeaModifiers.Call<float>("GetTeaValue", player, xprecord.teatype, Modifier.ModifierType.Max_Health) * 100;
                        teamodified = true;
                    }
                    switch (GetTeaTypes(player))
                    {
                        case "maxhealthtea":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 5;
                            }
                            break;
                        case "maxhealthtea.advanced":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 12.5;
                            }
                            break;
                        case "maxhealthtea.pure":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 20;
                            }
                            break;
                    }
                }
                if (player._health > teahealth)
                {
                    healthdifference = player._health - teahealth;
                }
                player._health -= (float)healthdifference;
            }
            // Reset Stat Levels
            xprecord.Mentality = 0;
            xprecord.Dexterity = 0;
            xprecord.Might = 0;
            xprecord.Captaincy = 0;
            xprecord.Weaponry = 0;
            // Reset Stat Spent Points
            xprecord.MentalityP = 0;
            xprecord.DexterityP = 0;
            xprecord.MightP = 0;
            xprecord.CaptaincyP = 0;
            xprecord.WeaponryP = 0;
            // Reset Skill Levels
            xprecord.WoodCutter = 0;
            xprecord.Smithy = 0;
            xprecord.Miner = 0;
            xprecord.Forager = 0;
            xprecord.Hunter = 0;
            xprecord.Fisher = 0;
            xprecord.Crafter = 0;
            xprecord.Framer = 0;
            xprecord.Medic = 0;
            xprecord.Scavenger = 0;
            xprecord.Tamer = 0;
            // Reset Skill Spents Points
            xprecord.WoodCutterP = 0;
            xprecord.SmithyP = 0;
            xprecord.MinerP = 0;
            xprecord.ForagerP = 0;
            xprecord.HunterP = 0;
            xprecord.FisherP = 0;
            xprecord.CrafterP = 0;
            xprecord.FramerP = 0;
            xprecord.MedicP = 0;
            xprecord.ScavengerP = 0;
            xprecord.TamerP = 0;
            // Reset calories/hydration if needed
            if (player.metabolism.calories.max > 500)
            {
                player.metabolism.calories.max = 500;
            }
            if (player.metabolism.hydration.max > 250)
            {
                player.metabolism.hydration.max = 250;
            }
            // Check/Reset RankGroup permission
            RankCheck(player);
            // Backpack Check
            if (Backpacks != null && config.backpacksmod.enablebackpacks)
            {
                BackPackChecks(player, config.backpacksmod.statorskill, true);
            }
            // Archery Check
            if (Archery != null && config.archerymod.enablearchery)
            {
                ArcheryChecks(player, config.archerymod.statorskill, true);
            }
            // Wizardry Check
            if (Wizardry != null && config.wizardrymod.enablewizardry)
            {
                WizardryChecks(player, config.wizardrymod.statorskill, true);
            }
            // Check/Reset Tamer permissions
            PetChecks(player, true);
            // Update Live UI
            LiveStats(player, true);
            // Notify Players
            player.ChatMessage(XPLang("playerrankup", player.UserIDString, rank.name, xprecord.statpoint, xprecord.skillpoint));
            // AddonDiscord
            if (XPerienceAddon != null)
            {
                XPerienceAddon?.Call("AddonDiscordRank", player, rank.name);
                XPerienceAddon?.Call("NotifyUIBar", player, "rank", rank.name, xprecord.rank);
                XPerienceAddon?.Call("NotifyUIBarGlobal", player, "rank", rank.name, xprecord.rank);
            }
            // Check remaining XP for level Up
            if (xprecord.experience > xprecord.requiredxp)
            {
                LvlUp(player, 0, 0);
                return;
            }
        }
        private void RankUpFix(string player, double remainingxp)
        {
            XPRecord xprecord = GetPlayerRecord(player);
            if (xprecord.rank >= config.xpLevelRanks.maxresetrank) return;
            xprecord.rank++;
            // Reset Level, Required XP & Stat/Skill Points
            xprecord.level = 0;
            if (config.xpLevelRanks.keepremainingxp)
            {
                xprecord.experience = remainingxp;
            }
            else
            {
                xprecord.experience = 0;
            }
            xprecord.requiredxp = config.xpLevel.levelstart;
            xprecord.statpoint = config.xpLevelRanks.rankstatpointstart * xprecord.rank;
            xprecord.skillpoint = config.xpLevelRanks.rankskillpointstart * xprecord.rank;
            // Reset Stat Levels
            xprecord.Mentality = 0;
            xprecord.Dexterity = 0;
            xprecord.Might = 0;
            xprecord.Captaincy = 0;
            xprecord.Weaponry = 0;
            // Reset Stat Spent Points
            xprecord.MentalityP = 0;
            xprecord.DexterityP = 0;
            xprecord.MightP = 0;
            xprecord.CaptaincyP = 0;
            xprecord.WeaponryP = 0;
            // Reset Skill Levels
            xprecord.WoodCutter = 0;
            xprecord.Smithy = 0;
            xprecord.Miner = 0;
            xprecord.Forager = 0;
            xprecord.Hunter = 0;
            xprecord.Fisher = 0;
            xprecord.Crafter = 0;
            xprecord.Framer = 0;
            xprecord.Medic = 0;
            xprecord.Scavenger = 0;
            xprecord.Tamer = 0;
            // Reset Skill Spents Points
            xprecord.WoodCutterP = 0;
            xprecord.SmithyP = 0;
            xprecord.MinerP = 0;
            xprecord.ForagerP = 0;
            xprecord.HunterP = 0;
            xprecord.FisherP = 0;
            xprecord.CrafterP = 0;
            xprecord.FramerP = 0;
            xprecord.MedicP = 0;
            xprecord.ScavengerP = 0;
            xprecord.TamerP = 0;
            // Check for Rank Group and Assign or Revoke
            foreach (var rankgroup in config.xpLevelRanks.ranks)
            {
                if (xprecord.rank >= rankgroup.Key && !permission.UserHasGroup(xprecord.id, rankgroup.Value.group))
                {
                    permission.AddUserGroup(xprecord.id, rankgroup.Value.group);
                }
                if (xprecord.rank < rankgroup.Key && !permission.UserHasGroup(xprecord.id, rankgroup.Value.group))
                {
                    permission.RemoveUserGroup(xprecord.id, rankgroup.Value.group);
                }
            }
            // Take Backpack Permissions
            if (permission.UserHasPermission(xprecord.id, Backpack1))
            {
                permission.RevokeUserPermission(xprecord.id, Backpack1);
            }
            if (permission.UserHasPermission(xprecord.id, Backpack2))
            {
                permission.RevokeUserPermission(xprecord.id, Backpack2);
            }
            if (permission.UserHasPermission(xprecord.id, Backpack3))
            {
                permission.RevokeUserPermission(xprecord.id, Backpack3);
            }
            if (permission.UserHasPermission(xprecord.id, Backpack4))
            {
                permission.RevokeUserPermission(xprecord.id, Backpack4);
            }
            if (permission.UserHasPermission(xprecord.id, Backpack5))
            {
                permission.RevokeUserPermission(xprecord.id, Backpack5);
            }
            if (permission.UserHasPermission(xprecord.id, Backpack6))
            {
                permission.RevokeUserPermission(xprecord.id, Backpack6);
            }
            if (permission.UserHasPermission(xprecord.id, Backpack7))
            {
                permission.RevokeUserPermission(xprecord.id, Backpack7);
            }
            // Take Archery Permissions
            if (permission.UserHasPermission(xprecord.id, ArcheryNovice))
            {
                permission.RevokeUserPermission(xprecord.id, ArcheryNovice);
            }
            if (permission.UserHasPermission(xprecord.id, ArcheryAdept))
            {
                permission.RevokeUserPermission(xprecord.id, ArcheryAdept);
            }
            if (permission.UserHasPermission(xprecord.id, ArcheryMaster))
            {
                permission.RevokeUserPermission(xprecord.id, ArcheryMaster);
            }
            //Take Wizardry Permissions
            if (permission.UserHasPermission(xprecord.id, WizardryNovice))
            {
                permission.RevokeUserPermission(xprecord.id, WizardryNovice);
            }
            if (permission.UserHasPermission(xprecord.id, WizardryAdept))
            {
                permission.RevokeUserPermission(xprecord.id, WizardryAdept);
            }
            if (permission.UserHasPermission(xprecord.id, WizardryMaster))
            {
                permission.RevokeUserPermission(xprecord.id, WizardryMaster);
            }
            // Take Pet Permission
            permission.RevokeUserPermission(xprecord.id, TameChicken);
            permission.RevokeUserPermission(xprecord.id, TameBoar);
            permission.RevokeUserPermission(xprecord.id, TameStag);
            permission.RevokeUserPermission(xprecord.id, TameWolf);
            permission.RevokeUserPermission(xprecord.id, TameBear);
            // Check remaining XP for level Up
            if (xprecord.experience > xprecord.requiredxp)
            {
                LvlUpFix(player);
                return;
            }
        }
        private void RankCheck(BasePlayer player, bool reset = false)
        {
            if (player == null || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(player);
            if (!config.xpLevelRanks.enableresetranks || xprecord.DisableRank) return;
            // Reset Rank Permission
            if (reset)
            {
                foreach (var rankgroup in config.xpLevelRanks.ranks)
                {
                    if (permission.UserHasGroup(player.UserIDString, rankgroup.Value.group))
                    {
                        permission.RemoveUserGroup(player.UserIDString, rankgroup.Value.group);
                    }
                }
                return;
            }
            // Check for Rank Group and Assign or Revoke
            foreach (var rankgroup in config.xpLevelRanks.ranks)
            {
                if (config.xpLevelRanks.keepgrouponrank && xprecord.rank > rankgroup.Key && !permission.UserHasGroup(player.UserIDString, rankgroup.Value.group))
                {
                    permission.AddUserGroup(player.UserIDString, rankgroup.Value.group);
                }
                if (xprecord.rank == rankgroup.Key && !permission.UserHasGroup(player.UserIDString, rankgroup.Value.group))
                {
                    permission.AddUserGroup(player.UserIDString, rankgroup.Value.group);
                }
                if (xprecord.rank < rankgroup.Key && permission.UserHasGroup(player.UserIDString, rankgroup.Value.group))
                {
                    permission.RemoveUserGroup(player.UserIDString, rankgroup.Value.group);
                }
                if (!config.xpLevelRanks.keepgrouponrank && xprecord.rank > rankgroup.Key && permission.UserHasGroup(player.UserIDString, rankgroup.Value.group))
                {
                    permission.RemoveUserGroup(player.UserIDString, rankgroup.Value.group);
                }
            }
        }
        private void LoseExp(BasePlayer player, double e)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (e < 1)
            {
                e = 1;
            }
            // Teams
            if (config.xpTeams.enableteamxploss && e != 0)
            {
                XPTeams(player, e, "takexp");
            }
            // Clans
            if (Clans != null && config.xpclans.enableclanreduction && e != 0)
            {
                XPClans(player, e, "takexp");
            }
            double newxp = xprecord.experience - e;
            double nextlevel = xprecord.requiredxp;
            // Make sure XP does not go negative
            if (newxp <= 0)
            {
                newxp = 0;
            }
            xprecord.experience = (int)newxp;
            if (nextlevel == config.xpLevel.levelstart) return;
            double prevlevel = xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier);
            if (xprecord.experience < prevlevel)
            {
                LvlDown(player);
            }
            LiveStats(player, true);
            // UINotify
            if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.xpgainloss)
            {
                UINotify.Call("SendNotify", player, config.UiNotifier.xpgainlosstype, XPLang("uinotify_xploss", player.UserIDString, Math.Round(e)));
            }
        }
        private void LoseExpAdmin(BasePlayer player, double e)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (e < 1)
            {
                e = 1;
            }
            double newxp = xprecord.experience - e;
            double nextlevel = xprecord.requiredxp;
            // Make sure XP does not go negative
            if (newxp <= 0)
            {
                newxp = 0;
            }
            xprecord.experience = (int)newxp;
            if (nextlevel == config.xpLevel.levelstart) return;
            double prevlevel = xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier);
            if (xprecord.experience < prevlevel)
            {
                LvlDown(player);
            }
            LiveStats(player, true);
            //PlayerFixData(player);
        }
        private void LvlDown(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            double newlevel = xprecord.level - 1;
            int newtruelevel = xprecord.truelevel - 1;
            if (newlevel == 0) return;
            xprecord.level = newlevel;
            xprecord.truelevel = newtruelevel;
            xprecord.requiredxp = Math.Round(xprecord.requiredxp - (newlevel * config.xpLevel.levelmultiplier));
            //chatstatpoint -= config.xpLevel.statpointsperlvl;
            //chatskillpoint -= config.xpLevel.skillpointsperlvl;
            bool removestatlvl = false;
            bool removeskilllvl = false;
            // UINotify
            if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.levelupdown)
            {
                UINotify.Call("SendNotify", player, config.UiNotifier.levelupdowntype, XPLang("leveldown", player.UserIDString, xprecord.level));
            }
            // Normal Chat Notify
            if (!config.UiNotifier.disablechats)
            {
                player.ChatMessage(XPLang("leveldown", player.UserIDString, xprecord.level));
            }
            // Check if player has enough unspent stat points to take
            if (xprecord.statpoint >= config.xpLevel.statpointsperlvl)
            {
                xprecord.statpoint -= config.xpLevel.statpointsperlvl;
                player.ChatMessage(XPLang("statdown", player.UserIDString, config.xpLevel.statpointsperlvl));
            }
            else
            {
                removestatlvl = true;
            }
            // Check if player has enough unspent skill points to take
            if (xprecord.skillpoint >= config.xpLevel.skillpointsperlvl)
            {
                xprecord.skillpoint -= config.xpLevel.skillpointsperlvl;
                player.ChatMessage(XPLang("skilldown", player.UserIDString, config.xpLevel.skillpointsperlvl));
            }
            else
            {
                removeskilllvl = true;
            }
            // If player does not have enough unspent stat points then get first available stat to level down and remove points
            if (removestatlvl == true)
            {
                int allstats = xprecord.Mentality + xprecord.Dexterity + xprecord.Might + xprecord.Captaincy + xprecord.Weaponry;
                if (allstats == 0)
                {
                    xprecord.statpoint = 0;
                    player.ChatMessage(XPLang("nostatpoints", player.UserIDString));
                    return;
                }
                var stat = "";
                int statpoints;
                int pointadj = 0;
                bool dropmentality = false;
                bool dropdexterity = false;
                bool dropmight = false;
                bool dropcaptaincy = false;
                bool dropweaponry = false;
                // Check each stat for levels
                if (xprecord.Mentality > 0) { dropmentality = true; }
                else if (xprecord.Dexterity > 0) { dropdexterity = true; }
                else if (xprecord.Might > 0) { dropmight = true; }
                else if (xprecord.Captaincy > 0) { dropcaptaincy = true; }
                else if (xprecord.Weaponry > 0) { dropweaponry = true; }
                // Random stat chosen
                if (dropmentality == true)
                {
                    stat = "Mentality";
                    if (xprecord.Mentality == 1)
                    {
                        statpoints = config.mentality.pointcoststart;
                    }
                    else
                    {
                        statpoints = (xprecord.Mentality - 1) * config.mentality.costmultiplier;
                    }
                    pointadj = statpoints - config.xpLevel.statpointsperlvl;
                    xprecord.Mentality--;
                    xprecord.MentalityP -= statpoints;
                    xprecord.statpoint = pointadj;
                }
                else if (dropdexterity == true)
                {
                    stat = "Dexterity";
                    if (xprecord.Dexterity == 1)
                    {
                        statpoints = config.dexterity.pointcoststart;
                    }
                    else
                    {
                        statpoints = (xprecord.Dexterity - 1) * config.dexterity.costmultiplier;
                    }
                    pointadj = statpoints - config.xpLevel.statpointsperlvl;
                    xprecord.Dexterity--;
                    xprecord.DexterityP -= statpoints;
                    xprecord.statpoint = pointadj;
                }
                else if (dropmight == true)
                {
                    stat = "Might";
                    if (xprecord.Might == 1)
                    {
                        statpoints = config.might.pointcoststart;
                    }
                    else
                    {
                        statpoints = (xprecord.Might - 1) * config.might.costmultiplier;
                    }
                    pointadj = statpoints - config.xpLevel.statpointsperlvl;
                    xprecord.Might--;
                    xprecord.MightP -= statpoints;
                    xprecord.statpoint = pointadj;
                    MightAttributes(player);
                }
                else if (dropcaptaincy == true)
                {
                    stat = "Captaincy";
                    if (xprecord.Captaincy == 1)
                    {
                        statpoints = config.captaincy.pointcoststart;
                    }
                    else
                    {
                        statpoints = (xprecord.Captaincy - 1) * config.captaincy.costmultiplier;
                    }
                    pointadj = statpoints - config.xpLevel.statpointsperlvl;
                    xprecord.Captaincy--;
                    xprecord.CaptaincyP -= statpoints;
                    xprecord.statpoint = pointadj;
                }
                else if (dropweaponry == true)
                {
                    stat = "Weaponry";
                    if (xprecord.Weaponry == 1)
                    {
                        statpoints = config.weaponry.pointcoststart;
                    }
                    else
                    {
                        statpoints = (xprecord.Weaponry - 1) * config.weaponry.costmultiplier;
                    }
                    pointadj = statpoints - config.xpLevel.statpointsperlvl;
                    xprecord.Weaponry--;
                    xprecord.WeaponryP -= statpoints;
                    xprecord.statpoint = pointadj;
                }
                // Make sure points do not go negative
                if (xprecord.statpoint < 0)
                {
                    xprecord.statpoint = 0;
                }
                // Archery Check
                if (Archery != null && config.archerymod.enablearchery)
                {
                    ArcheryChecks(player, stat, true);
                }
                // Wizardry Check
                if (Wizardry != null && config.wizardrymod.enablewizardry)
                {
                    WizardryChecks(player, stat, true);
                }
                player.ChatMessage(XPLang("statdownextra", player.UserIDString, stat, config.xpLevel.statpointsperlvl, pointadj));
            }
            // If player does not have enough unspent skill points then get first available skill to level down and remove points
            if (removeskilllvl == true)
            {
                int allskills = xprecord.WoodCutter + xprecord.Smithy + xprecord.Miner + xprecord.Forager + xprecord.Hunter + xprecord.Fisher + xprecord.Crafter + xprecord.Framer + xprecord.Medic + xprecord.Scavenger + xprecord.Tamer;
                if (allskills == 0)
                {
                    xprecord.skillpoint = 0;
                    player.ChatMessage(XPLang("noskillpoints", player.UserIDString));
                    return;
                }

                var skill = "";
                int skillpoints;
                int pointadj = 0;
                bool dropwoodcutter = false;
                bool dropsmithy = false;
                bool dropminer = false;
                bool dropforager = false;
                bool drophunter = false;
                bool dropfisher = false;
                bool dropcrafter = false;
                bool dropframer = false;
                bool dropmedic = false;
                bool dropscavenger = false;
                bool droptamer = false;

                // Check each skill for levels
                if (xprecord.WoodCutter > 0) { dropwoodcutter = true; }
                else if (xprecord.Smithy > 0) { dropsmithy = true; }
                else if (xprecord.Miner > 0) { dropminer = true; }
                else if (xprecord.Forager > 0) { dropforager = true; }
                else if (xprecord.Hunter > 0) { drophunter = true; }
                else if (xprecord.Fisher > 0) { dropfisher = true; }
                else if (xprecord.Crafter > 0) { dropcrafter = true; }
                else if (xprecord.Framer > 0) { dropframer = true; }
                else if (xprecord.Medic > 0) { dropmedic = true; }
                else if (xprecord.Scavenger > 0) { dropscavenger = true; }
                else if (xprecord.Tamer > 0) { droptamer = true; }

                // Random Skill Chosen
                if (dropwoodcutter == true)
                {
                    skill = "WoodCutter";
                    if (xprecord.WoodCutter == 1)
                    {
                        skillpoints = config.woodcutter.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.WoodCutter * config.woodcutter.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.WoodCutter--;
                    xprecord.WoodCutterP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (dropsmithy == true)
                {
                    skill = "Smithy";
                    if (xprecord.Smithy == 1)
                    {
                        skillpoints = config.smithy.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Smithy * config.smithy.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Smithy--;
                    xprecord.SmithyP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (dropminer == true)
                {
                    skill = "Miner";
                    if (xprecord.Miner == 1)
                    {
                        skillpoints = config.miner.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Miner * config.miner.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Miner--;
                    xprecord.MinerP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (dropforager == true)
                {
                    skill = "Forager";
                    if (xprecord.Forager == 1)
                    {
                        skillpoints = config.forager.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Forager * config.forager.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Forager--;
                    xprecord.ForagerP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (drophunter == true)
                {
                    skill = "Hunter";
                    if (xprecord.Hunter == 1)
                    {
                        skillpoints = config.hunter.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Hunter * config.hunter.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Hunter--;
                    xprecord.HunterP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (dropfisher == true)
                {
                    skill = "Fisher";
                    if (xprecord.Fisher == 1)
                    {
                        skillpoints = config.fisher.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Fisher * config.fisher.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Fisher--;
                    xprecord.FisherP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (dropcrafter == true)
                {
                    skill = "Crafter";
                    if (xprecord.Crafter == 1)
                    {
                        skillpoints = config.crafter.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Crafter * config.crafter.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Crafter--;
                    xprecord.CrafterP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (dropframer == true)
                {
                    skill = "Framer";
                    if (xprecord.Framer == 1)
                    {
                        skillpoints = config.framer.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Framer * config.framer.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Framer--;
                    xprecord.FramerP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (dropmedic == true)
                {
                    skill = "Medic";
                    if (xprecord.Medic == 1)
                    {
                        skillpoints = config.medic.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Medic * config.medic.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Medic--;
                    xprecord.MedicP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (dropscavenger == true)
                {
                    skill = "Scavenger";
                    if (xprecord.Scavenger == 1)
                    {
                        skillpoints = config.scavenger.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Scavenger * config.scavenger.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Scavenger--;
                    xprecord.ScavengerP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                }
                else if (droptamer == true)
                {
                    skill = "Tamer";
                    if (xprecord.Tamer == 1)
                    {
                        skillpoints = config.tamer.pointcoststart;
                    }
                    else
                    {
                        skillpoints = xprecord.Tamer * config.tamer.costmultiplier;
                    }
                    pointadj = skillpoints - config.xpLevel.skillpointsperlvl;
                    xprecord.Tamer--;
                    xprecord.TamerP -= skillpoints;
                    xprecord.skillpoint = pointadj;
                    PetChecks(player, false, xprecord.Tamer);
                }
                // Make sure points do not go negative
                if (xprecord.skillpoint < 0)
                {
                    xprecord.skillpoint = 0;
                }
                // Archery Check
                if (Archery != null && config.archerymod.enablearchery)
                {
                    ArcheryChecks(player, skill, true);
                }
                // Wizardry Check
                if (Wizardry != null && config.wizardrymod.enablewizardry)
                {
                    WizardryChecks(player, skill, true);
                }

                player.ChatMessage(XPLang("skilldownextra", player.UserIDString, skill, config.xpLevel.skillpointsperlvl, pointadj));
            }
            // Econ
            if (Economics != null && config.xpEcon.econleveldown)
            {
                Economics.Call("Withdraw", player.UserIDString, config.xpEcon.econlevelreduction);
                player.ChatMessage(XPLang("econwidthdrawlevel", player.UserIDString, config.xpEcon.econlevelreduction));
            }
            // Server Rewards
            if (ServerRewards != null && config.sRewards.srewardleveldown)
            {
                ServerRewards?.Call("TakePoints", player.userID, config.sRewards.srewardleveldownamt);
                player.ChatMessage(XPLang("srewardsdown", player.UserIDString, config.sRewards.srewardleveldownamt));
            }
            //double prevlevel = Math.Round(xprecord.requiredxp / config.xpLevel.levelmultiplier);
            double prevlevel = xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier);
            if (prevlevel > xprecord.experience)
            {
                LvlDown(player);
            }
            LiveStats(player, true);
        }
        private void StatUp(BasePlayer player, string stat)
        {
            XPRecord xprecord = GetXPRecord(player);
            int nextlevel;
            int statcost;
            int pointsremaining;
            int pointsinstat;
            // Mentality
            if (stat == "mentality" && config.mentality.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermMentality)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Mentality < config.mentality.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econstatlevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econmentality;
                        if (config.xpEcon.econstatlevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econmentality * (config.xpEcon.econstatlevelcostmultiplier * xprecord.Mentality);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, stat, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, stat, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardstatlevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardmentality;
                        if (config.sRewards.srewardstatlevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardmentality * (config.sRewards.srewardstatlevelcostmultiplier * xprecord.Mentality);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, stat, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, stat, points));
                            return;
                        }
                    }
                    if (xprecord.Mentality == 0)
                    {
                        nextlevel = 1;
                        statcost = config.mentality.pointcoststart;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.MentalityP + statcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Mentality + 1;
                        statcost = nextlevel * config.mentality.costmultiplier;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.MentalityP + statcost;
                    }
                    if (xprecord.statpoint < statcost)
                    {
                        player.ChatMessage(XPLang("notenoughstatpoints", player.UserIDString, nextlevel, stat, statcost));
                        return;
                    }
                    xprecord.Mentality = nextlevel;
                    xprecord.statpoint = pointsremaining;
                    xprecord.MentalityP = pointsinstat;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, stat));
                    return;
                }
            }
            // Dexterity
            else if (stat == "dexterity" && config.dexterity.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermDexterity)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Dexterity < config.dexterity.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econstatlevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econdexterity;
                        if (config.xpEcon.econstatlevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econdexterity * (config.xpEcon.econstatlevelcostmultiplier * xprecord.Dexterity);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, stat, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, stat, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardstatlevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewarddexterity;
                        if (config.sRewards.srewardstatlevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewarddexterity * (config.sRewards.srewardstatlevelcostmultiplier * xprecord.Dexterity);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, stat, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, stat, points));
                            return;
                        }
                    }
                    if (xprecord.Dexterity == 0)
                    {
                        nextlevel = 1;
                        statcost = config.dexterity.pointcoststart;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.DexterityP + statcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Dexterity + 1;
                        statcost = nextlevel * config.dexterity.costmultiplier;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.DexterityP + statcost;
                    }
                    if (xprecord.statpoint < statcost)
                    {
                        player.ChatMessage(XPLang("notenoughstatpoints", player.UserIDString, nextlevel, stat, statcost));
                        return;
                    }
                    xprecord.Dexterity = nextlevel;
                    xprecord.statpoint = pointsremaining;
                    xprecord.DexterityP = pointsinstat;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, stat));
                    return;
                }
            }
            // Might
            else if (stat == "might" && config.might.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermMight)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Might < config.might.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econstatlevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econmight;
                        if (config.xpEcon.econstatlevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econmight * (config.xpEcon.econstatlevelcostmultiplier * xprecord.Might);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, stat, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, stat, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardstatlevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardmight;
                        if (config.sRewards.srewardstatlevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardmight * (config.sRewards.srewardstatlevelcostmultiplier * xprecord.Might);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, stat, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, stat, points));
                            return;
                        }
                    }
                    if (xprecord.Might == 0)
                    {
                        nextlevel = 1;
                        statcost = config.might.pointcoststart;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.MightP + statcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Might + 1;
                        statcost = nextlevel * config.might.costmultiplier;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.MightP + statcost;
                    }
                    if (xprecord.statpoint < statcost)
                    {
                        player.ChatMessage(XPLang("notenoughstatpoints", player.UserIDString, nextlevel, stat, statcost));
                        return;
                    }
                    xprecord.Might = nextlevel;
                    xprecord.statpoint = pointsremaining;
                    xprecord.MightP = pointsinstat;
                    PlayerArmor(player);
                    MightAttributes(player);
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, stat));
                    return;
                }

            }
            // Captaincy
            else if (stat == "captaincy" && config.captaincy.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermCaptaincy)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Captaincy < config.captaincy.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econstatlevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econcaptaincy;
                        if (config.xpEcon.econstatlevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econcaptaincy * (config.xpEcon.econstatlevelcostmultiplier * xprecord.Captaincy);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, stat, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, stat, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardstatlevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardcaptaincy;
                        if (config.sRewards.srewardstatlevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardcaptaincy * (config.sRewards.srewardstatlevelcostmultiplier * xprecord.Captaincy);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, stat, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, stat, points));
                            return;
                        }
                    }
                    if (xprecord.Captaincy == 0)
                    {
                        nextlevel = 1;
                        statcost = config.captaincy.pointcoststart;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.CaptaincyP + statcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Captaincy + 1;
                        statcost = nextlevel * config.captaincy.costmultiplier;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.CaptaincyP + statcost;
                    }
                    if (xprecord.statpoint < statcost)
                    {
                        player.ChatMessage(XPLang("notenoughstatpoints", player.UserIDString, nextlevel, stat, statcost));
                        return;
                    }
                    xprecord.Captaincy = nextlevel;
                    xprecord.statpoint = pointsremaining;
                    xprecord.CaptaincyP = pointsinstat;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, stat));
                    return;
                }
            }
            // Weaponry
            else if (stat == "weaponry" && config.weaponry.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermWeaponry)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Weaponry < config.weaponry.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econstatlevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econweaponry;
                        if (config.xpEcon.econstatlevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econweaponry * (config.xpEcon.econstatlevelcostmultiplier * xprecord.Weaponry);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, stat, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, stat, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardstatlevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardweaponry;
                        if (config.sRewards.srewardstatlevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardweaponry * (config.sRewards.srewardstatlevelcostmultiplier * xprecord.Weaponry);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, stat, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, stat, points));
                            return;
                        }
                    }
                    if (xprecord.Weaponry == 0)
                    {
                        nextlevel = 1;
                        statcost = config.weaponry.pointcoststart;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.WeaponryP + statcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Weaponry + 1;
                        statcost = nextlevel * config.weaponry.costmultiplier;
                        pointsremaining = xprecord.statpoint - statcost;
                        pointsinstat = xprecord.WeaponryP + statcost;
                    }
                    if (xprecord.statpoint < statcost)
                    {
                        player.ChatMessage(XPLang("notenoughstatpoints", player.UserIDString, nextlevel, stat, statcost));
                        return;
                    }
                    xprecord.Weaponry = nextlevel;
                    xprecord.statpoint = pointsremaining;
                    xprecord.WeaponryP = pointsinstat;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, stat));
                    return;
                }
            }
            else
            {
                player.ChatMessage(XPLang("nopermordisabled", player.UserIDString));
                return;
            }
            // Backpack Check
            if (Backpacks != null && config.backpacksmod.enablebackpacks)
            {
                BackPackChecks(player, stat, false);
            }
            // Archery Check
            if (Archery != null && config.archerymod.enablearchery)
            {
                ArcheryChecks(player, stat, false);
            }
            // Wizardry Check
            if (Wizardry != null && config.wizardrymod.enablewizardry)
            {
                WizardryChecks(player, stat, false);
            }
            player.ChatMessage(XPLang("statup", player.UserIDString, statcost, nextlevel, stat));
            // AddonDiscord
            if (XPerienceAddon != null)
            {
                XPerienceAddon?.Call("AddonDiscordStat", player, XPLang(stat, player.UserIDString), nextlevel);
                XPerienceAddon?.Call("NotifyUIBar", player, "stat", XPLang(stat, player.UserIDString), nextlevel);
                XPerienceAddon?.Call("NotifyUIBarGlobal", player, "stat", XPLang(stat, player.UserIDString), nextlevel);
            }
            LiveStats(player, true);
        }
        private void SkillUp(BasePlayer player, string skill)
        {
            XPRecord xprecord = GetXPRecord(player);
            int nextlevel = 0;
            int skillcost = 0;
            int pointsremaining;
            int pointsinskill;
            // WoodCutter
            if (skill == "woodcutter" && config.woodcutter.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermWoodCutter)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.WoodCutter < config.woodcutter.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econwoodcutter;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econwoodcutter * (config.xpEcon.econskilllevelcostmultiplier * xprecord.WoodCutter);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardwoodcutter;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardwoodcutter * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.WoodCutter);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.WoodCutter == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.woodcutter.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.WoodCutterP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.WoodCutter + 1;
                        skillcost = nextlevel * config.woodcutter.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.WoodCutterP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.WoodCutter = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.WoodCutterP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Smithy
            else if (skill == "smithy" && config.smithy.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermSmithy)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Smithy < config.smithy.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econsmithy;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econsmithy * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Smithy);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardsmithy;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardsmithy * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Smithy);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Smithy == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.smithy.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.SmithyP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Smithy + 1;
                        skillcost = nextlevel * config.smithy.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.SmithyP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Smithy = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.SmithyP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Miner
            else if (skill == "miner" && config.miner.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermMiner)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Miner < config.miner.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econminer;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econminer * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Miner);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardminer;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardminer * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Miner);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Miner == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.miner.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.MinerP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Miner + 1;
                        skillcost = nextlevel * config.miner.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.MinerP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Miner = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.MinerP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Forager
            else if (skill == "forager" && config.forager.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermForager)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Forager < config.forager.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econforager;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econforager * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Forager);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardforager;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardforager * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Forager);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Forager == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.forager.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.ForagerP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Forager + 1;
                        skillcost = nextlevel * config.forager.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.ForagerP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Forager = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.ForagerP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Hunter
            else if (skill == "hunter" && config.hunter.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermHunter)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Hunter < config.hunter.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econhunter;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econhunter * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Hunter);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardhunter;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardhunter * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Hunter);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Hunter == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.hunter.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.HunterP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Hunter + 1;
                        skillcost = nextlevel * config.hunter.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.HunterP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Hunter = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.HunterP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Fisher
            else if (skill == "fisher" && config.fisher.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermFisher)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Fisher < config.fisher.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econfisher;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econfisher * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Fisher);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardfisher;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardfisher * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Fisher);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Fisher == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.fisher.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.FisherP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Fisher + 1;
                        skillcost = nextlevel * config.fisher.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.FisherP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Fisher = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.FisherP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Crafter
            else if (skill == "crafter" && config.crafter.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermCrafter)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Crafter < config.crafter.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econcrafter;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econcrafter * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Crafter);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardcrafter;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardcrafter * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Crafter);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Crafter == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.crafter.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.CrafterP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Crafter + 1;
                        skillcost = nextlevel * config.crafter.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.CrafterP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Crafter = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.CrafterP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Framer
            else if (skill == "framer" && config.framer.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermFramer)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Framer < config.framer.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econframer;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econframer * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Framer);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardframer;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardframer * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Framer);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Framer == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.framer.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.FramerP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Framer + 1;
                        skillcost = nextlevel * config.framer.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.FramerP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Framer = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.FramerP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Medic
            else if (skill == "medic" && config.medic.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermMedic)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Medic < config.medic.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econmedic;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econmedic * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Medic);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardmedic;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardmedic * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Medic);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Medic == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.medic.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.MedicP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Medic + 1;
                        skillcost = nextlevel * config.medic.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.MedicP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Medic = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.MedicP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Scavenger
            else if (skill == "scavenger" && config.scavenger.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermScavenger)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Scavenger < config.scavenger.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econscavenger;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econscavenger * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Scavenger);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardscavenger;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardscavenger * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Scavenger);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Scavenger == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.scavenger.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.ScavengerP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Scavenger + 1;
                        skillcost = nextlevel * config.scavenger.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.ScavengerP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Scavenger = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.ScavengerP = pointsinskill;
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            // Tamer
            else if (skill == "tamer" && config.tamer.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermTamer)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Tamer < config.tamer.maxlvl)
                {
                    // Econ
                    if (Economics != null && config.xpEcon.econskilllevelcost)
                    {
                        double balance = Economics.Call<double>("Balance", player.UserIDString);
                        double econcostmultiplier = config.xpEcon.econtamer;
                        if (config.xpEcon.econskilllevelcostmultiplier > 0)
                        {
                            econcostmultiplier = config.xpEcon.econtamer * (config.xpEcon.econskilllevelcostmultiplier * xprecord.Tamer);
                        }
                        if (balance >= econcostmultiplier)
                        {
                            Economics.Call("Withdraw", player.UserIDString, econcostmultiplier);
                            double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                            player.ChatMessage(XPLang("econwidthdrawlevelup", player.UserIDString, econcostmultiplier, skill, newbalance));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("econwidthdrawlevelupfailed", player.UserIDString, econcostmultiplier, skill, balance));
                            return;
                        }
                    }
                    // Server Rewards
                    if (ServerRewards != null && config.sRewards.srewardskilllevelcost)
                    {
                        int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                        int srewardscostmultiplier = config.sRewards.srewardtamer;
                        if (config.sRewards.srewardskilllevelcostmultiplier > 0)
                        {
                            srewardscostmultiplier = config.sRewards.srewardtamer * (config.sRewards.srewardskilllevelcostmultiplier * xprecord.Tamer);
                        }
                        if (points >= srewardscostmultiplier)
                        {
                            ServerRewards?.Call("TakePoints", player.userID, srewardscostmultiplier);
                            int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                            player.ChatMessage(XPLang("srewardwidthdrawlevelup", player.UserIDString, srewardscostmultiplier, skill, newpoints));
                        }
                        else
                        {
                            player.ChatMessage(XPLang("srewardwidthdrawlevelupfailed", player.UserIDString, srewardscostmultiplier, skill, points));
                            return;
                        }
                    }
                    if (xprecord.Tamer == 0)
                    {
                        nextlevel = 1;
                        skillcost = config.tamer.pointcoststart;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.TamerP + skillcost;
                    }
                    else
                    {
                        nextlevel = xprecord.Tamer + 1;
                        skillcost = nextlevel * config.tamer.costmultiplier;
                        pointsremaining = xprecord.skillpoint - skillcost;
                        pointsinskill = xprecord.TamerP + skillcost;
                    }
                    if (xprecord.skillpoint < skillcost)
                    {
                        player.ChatMessage(XPLang("notenoughskillpoints", player.UserIDString, nextlevel, skill, skillcost));
                        return;
                    }
                    xprecord.Tamer = nextlevel;
                    xprecord.skillpoint = pointsremaining;
                    xprecord.TamerP = pointsinskill;
                    PetChecks(player, false, nextlevel);
                }
                else
                {
                    player.ChatMessage(XPLang("maxleveled", player.UserIDString, skill));
                }
            }
            else
            {
                player.ChatMessage(XPLang("nopermordisabled", player.UserIDString));
                return;
            }
            // Backpack Check
            if (Backpacks != null && config.backpacksmod.enablebackpacks)
            {
                BackPackChecks(player, skill, false);
            }
            // Archery Check
            if (Archery != null && config.archerymod.enablearchery)
            {
                ArcheryChecks(player, skill, false);
            }
            // Wizardry Check
            if (Wizardry != null && config.wizardrymod.enablewizardry)
            {
                WizardryChecks(player, skill, false);
            }
            player.ChatMessage(XPLang("skillup", player.UserIDString, skillcost, nextlevel, skill));
            // AddonDiscord
            if (XPerienceAddon != null)
            {
                XPerienceAddon?.Call("AddonDiscordSkill", player, XPLang(skill, player.UserIDString), nextlevel);
                XPerienceAddon?.Call("NotifyUIBar", player, "skill", XPLang(skill, player.UserIDString), nextlevel);
                XPerienceAddon?.Call("NotifyUIBarGlobal", player, "skill", XPLang(skill, player.UserIDString), nextlevel);
            }
            LiveStats(player, true);
        }
        private void StatsReset(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            int timer;
            if (permission.UserHasPermission(player.UserIDString, XPerience.VIP))
            {
                DateTime resettimestats = xprecord.resettimerstats.AddMinutes(config.defaultOptions.vipresetminstats);
                TimeSpan interval = resettimestats - DateTime.Now;
                timer = (int)interval.TotalMinutes;
            }
            else
            {
                DateTime resettimestats = xprecord.resettimerstats.AddMinutes(config.defaultOptions.resetminsstats);
                TimeSpan interval = resettimestats - DateTime.Now;
                timer = (int)interval.TotalMinutes;
            }
            if (config.defaultOptions.bypassadminreset && player.IsAdmin && permission.UserHasPermission(player.UserIDString, XPerience.Admin))
            {
                timer = 0;
            }
            if (timer > 0 && config.defaultOptions.restristresets)
            {
                player.ChatMessage(XPLang("resettimerstats", player.UserIDString, timer));
                return;
            }
            // Econ
            if (Economics != null && config.xpEcon.econresetstats)
            {
                double balance = Economics.Call<double>("Balance", player.UserIDString);
                if (balance >= config.xpEcon.econresetstatscost)
                {
                    Economics.Call("Withdraw", player.UserIDString, config.xpEcon.econresetstatscost);
                    double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                    player.ChatMessage(XPLang("econwidthdrawresetstat", player.UserIDString, config.xpEcon.econresetstatscost, newbalance));
                }
                else
                {
                    player.ChatMessage(XPLang("econwidthdrawresetstatfailed", player.UserIDString, config.xpEcon.econresetstatscost, balance));
                    return;
                }
            }
            // Server Rewards
            if (ServerRewards != null && config.sRewards.srewardresetstats)
            {
                int points = ServerRewards.Call<int>("CheckPoints", player.userID);
                if (points >= config.sRewards.srewardresetstatscost)
                {
                    ServerRewards?.Call("TakePoints", player.userID, config.sRewards.srewardresetstatscost);
                    int newpoints = ServerRewards.Call<int>("CheckPoints", player.userID);
                    player.ChatMessage(XPLang("srewardwidthdrawresetstat", player.UserIDString, config.sRewards.srewardresetstatscost, newpoints));
                }
                else
                {
                    player.ChatMessage(XPLang("srewardwidthdrawresetstatfailed", player.UserIDString, config.sRewards.srewardresetstatscost, points));
                    return;
                }
            }
            // Reset health if needed before removing points
            if (xprecord.Might >= 1)
            {
                // Max Health
                double armor = (xprecord.Might * config.might.armor) * 100;
                double newmaxhealth = player._maxHealth - armor;
                // Change Max Health
                if (newmaxhealth < 100)
                {
                    player._maxHealth = 100;
                }
                else
                {
                    player._maxHealth = (float)newmaxhealth;
                }
                // Player Current Health
                double defaulthealth = 100;
                double teahealth = 100;
                bool teamodified = false;
                double healthdifference = 0;
                if (GetTeaCooldown(player) != 0)
                {
                    // Check for Tea Modifier
                    if (TeaModifiers != null && xprecord.teatype != "none")
                    {
                        teahealth = defaulthealth + TeaModifiers.Call<float>("GetTeaValue", player, xprecord.teatype, Modifier.ModifierType.Max_Health) * 100;
                        teamodified = true;
                    }
                    switch (GetTeaTypes(player))
                    {
                        case "maxhealthtea":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 5;
                            }
                            break;
                        case "maxhealthtea.advanced":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 12.5;
                            }
                            break;
                        case "maxhealthtea.pure":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 20;
                            }
                            break;
                    }
                }
                if (player._health > teahealth)
                {
                    healthdifference = player._health - teahealth;
                }
                player._health -= (float)healthdifference;
            }
            // Add all spent points
            int statpoints = xprecord.statpoint + xprecord.MentalityP + xprecord.DexterityP + xprecord.MightP + xprecord.CaptaincyP + xprecord.WeaponryP;
            // Refund Points
            xprecord.statpoint = statpoints;
            // Reset Stat Levels
            xprecord.Mentality = 0;
            xprecord.Dexterity = 0;
            xprecord.Might = 0;
            xprecord.Captaincy = 0;
            xprecord.Weaponry = 0;
            // Reset Stat Spent Points
            xprecord.MentalityP = 0;
            xprecord.DexterityP = 0;
            xprecord.MightP = 0;
            xprecord.CaptaincyP = 0;
            xprecord.WeaponryP = 0;
            if (player.metabolism.calories.max > 500)
            {
                player.metabolism.calories.max = 500;
            }
            if (player.metabolism.hydration.max > 250)
            {
                player.metabolism.hydration.max = 250;
            }
            // New Reset Timer
            xprecord.resettimerstats = DateTime.Now;
            // Backpack Check
            if (Backpacks != null && config.backpacksmod.enablebackpacks)
            {
                string backpackstatorskill = config.backpacksmod.statorskill;
                if (backpackstatorskill == "Mentality" || backpackstatorskill == "Dexterity" || backpackstatorskill == "Might" || backpackstatorskill == "Captaincy")
                {
                    BackPackChecks(player, null, true);
                }
            }
            // Archery Check
            if (Archery != null && config.archerymod.enablearchery)
            {
                string archstatorskill = config.archerymod.statorskill;
                if (archstatorskill == "Mentality" || archstatorskill == "Dexterity" || archstatorskill == "Might" || archstatorskill == "Captaincy")
                {
                    ArcheryChecks(player, null, true);
                }
            }
            // Wizardry Check
            if (Wizardry != null && config.wizardrymod.enablewizardry)
            {
                string wizstatorskill = config.wizardrymod.statorskill;
                if (wizstatorskill == "Mentality" || wizstatorskill == "Dexterity" || wizstatorskill == "Might" || wizstatorskill == "Captaincy")
                {
                    WizardryChecks(player, null, true);
                }
            }
            // Message Player with number of stat points returned
            player.ChatMessage(XPLang("resetstats", player.UserIDString, statpoints));
            // Update Live UI
            LiveStats(player, true);
        }
        private void SkillsReset(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            int timer;
            if (permission.UserHasPermission(player.UserIDString, XPerience.VIP))
            {
                DateTime resettimeskills = xprecord.resettimerstats.AddMinutes(config.defaultOptions.resetminsskills);
                TimeSpan interval = resettimeskills - DateTime.Now;
                timer = (int)interval.TotalMinutes;
            }
            else
            {
                DateTime resettimeskills = xprecord.resettimerstats.AddMinutes(config.defaultOptions.resetminsskills);
                TimeSpan interval = resettimeskills - DateTime.Now;
                timer = (int)interval.TotalMinutes;
            }
            if (config.defaultOptions.bypassadminreset && player.IsAdmin && permission.UserHasPermission(player.UserIDString, XPerience.Admin))
            {
                timer = 0;
            }
            if (timer > 0 && config.defaultOptions.restristresets)
            {
                player.ChatMessage(XPLang("resettimerskills", player.UserIDString, timer));
                return;
            }
            // Econ
            if (Economics != null && config.xpEcon.econresetskills)
            {
                double balance = Economics.Call<double>("Balance", player.UserIDString);
                if (balance >= config.xpEcon.econresetskillscost)
                {
                    Economics.Call("Withdraw", player.UserIDString, config.xpEcon.econresetskillscost);
                    double newbalance = Economics.Call<double>("Balance", player.UserIDString);
                    player.ChatMessage(XPLang("econwidthdrawresetstat", player.UserIDString, config.xpEcon.econresetskillscost, newbalance));
                }
                else
                {
                    player.ChatMessage(XPLang("econwidthdrawresetstatfailed", player.UserIDString, config.xpEcon.econresetskillscost, balance));
                    return;
                }
            }
            // Server Rewards
            if (ServerRewards != null && config.sRewards.srewardresetskills)
            {
                int points = ServerRewards.Call<int>("CheckPoints", player.UserIDString);
                if (points >= config.sRewards.srewardresetskillscost)
                {
                    ServerRewards?.Call("TakePoints", player.UserIDString, config.sRewards.srewardresetskillscost);
                    int newpoints = ServerRewards.Call<int>("CheckPoints", player.UserIDString);
                    player.ChatMessage(XPLang("srewardwidthdrawresetstat", player.UserIDString, config.sRewards.srewardresetskillscost, newpoints));
                }
                else
                {
                    player.ChatMessage(XPLang("srewardwidthdrawresetstatfailed", player.UserIDString, config.sRewards.srewardresetskillscost, points));
                    return;
                }
            }
            // Add all spent points
            int skillpoints = xprecord.skillpoint + xprecord.WoodCutterP + xprecord.SmithyP + xprecord.MinerP + xprecord.ForagerP + xprecord.HunterP + xprecord.FisherP + xprecord.CrafterP + xprecord.FramerP + xprecord.MedicP + xprecord.ScavengerP + xprecord.TamerP;
            // Reset Skill Levels
            xprecord.skillpoint = skillpoints;
            xprecord.WoodCutter = 0;
            xprecord.Smithy = 0;
            xprecord.Miner = 0;
            xprecord.Forager = 0;
            xprecord.Hunter = 0;
            xprecord.Fisher = 0;
            xprecord.Crafter = 0;
            xprecord.Framer = 0;
            xprecord.Medic = 0;
            xprecord.Scavenger = 0;
            xprecord.Tamer = 0;
            // Reset Skill Spents Points
            xprecord.WoodCutterP = 0;
            xprecord.SmithyP = 0;
            xprecord.MinerP = 0;
            xprecord.ForagerP = 0;
            xprecord.HunterP = 0;
            xprecord.FisherP = 0;
            xprecord.CrafterP = 0;
            xprecord.FramerP = 0;
            xprecord.MedicP = 0;
            xprecord.ScavengerP = 0;
            xprecord.TamerP = 0;
            // Backpack Check
            if (Backpacks != null && config.backpacksmod.enablebackpacks)
            {
                string backpackskill = config.backpacksmod.statorskill;
                if (backpackskill == "WoodCutter" || backpackskill == "Smithy" || backpackskill == "Miner" || backpackskill == "Forager" || backpackskill == "Hunter" || backpackskill == "Fisher" || backpackskill == "Crafter" || backpackskill == "Framer" || backpackskill == "Medic" || backpackskill == "Scavenger")
                {
                    BackPackChecks(player, null, true);
                }
            }
            // Archery Check
            if (Archery != null && config.archerymod.enablearchery)
            {
                string archskill = config.archerymod.statorskill;
                if (archskill == "WoodCutter" || archskill == "Smithy" || archskill == "Miner" || archskill == "Forager" || archskill == "Hunter" || archskill == "Fisher" || archskill == "Crafter" || archskill == "Framer" || archskill == "Medic" || archskill == "Scavenger")
                {
                    ArcheryChecks(player, null, true);
                }
            }
            // Wizardry Check
            if (Wizardry != null && config.wizardrymod.enablewizardry)
            {
                string wizskill = config.wizardrymod.statorskill;
                if (wizskill == "WoodCutter" || wizskill == "Smithy" || wizskill == "Miner" || wizskill == "Forager" || wizskill == "Hunter" || wizskill == "Fisher" || wizskill == "Crafter" || wizskill == "Framer" || wizskill == "Medic" || wizskill == "Scavenger")
                {
                    WizardryChecks(player, null, true);
                }
            }
            // Check/Reset Tamer permissions
            PetChecks(player, true);
            // New Reset Timer
            xprecord.resettimerskills = DateTime.Now;
            // Message Player with number of skill points returned
            player.ChatMessage(XPLang("resetskills", player.UserIDString, skillpoints));
            // Update Live UI
            LiveStats(player, true);
        }
        private void PlayerFixDataAll(BasePlayer player, bool reset = false)
        {
            if (!player.IsAdmin && !permission.UserHasPermission(player.UserIDString, Admin)) return;
            foreach (var p in _xperienceCache)
            {
                if (!p.Key.IsSteamId()) continue;
                XPRecord xprecord = GetPlayerRecord(p.Key);
                // Check True experience before fixing data
                //if (config.xpLevelRanks.enableresetranks)
                //{
                if (xprecord.trueexperience <= 0 || xprecord.trueexperience < xprecord.experience)
                {
                    xprecord.trueexperience = (int)xprecord.experience;
                }
                //}
                // Reset Level, Required XP & Stat/Skill Points
                if (!reset)
                {
                    xprecord.rank = 0;
                    xprecord.truelevel = 0;
                }
                xprecord.level = 0;
                xprecord.experience = 0;
                xprecord.requiredxp = config.xpLevel.levelstart;
                xprecord.statpoint = 0;
                xprecord.skillpoint = 0;
                // Reset Stat Levels
                xprecord.Mentality = 0;
                xprecord.Dexterity = 0;
                xprecord.Might = 0;
                xprecord.Captaincy = 0;
                xprecord.Weaponry = 0;
                // Reset Stat Spent Points
                xprecord.MentalityP = 0;
                xprecord.DexterityP = 0;
                xprecord.MightP = 0;
                xprecord.CaptaincyP = 0;
                xprecord.WeaponryP = 0;
                // Reset Skill Levels
                xprecord.WoodCutter = 0;
                xprecord.Smithy = 0;
                xprecord.Miner = 0;
                xprecord.Forager = 0;
                xprecord.Hunter = 0;
                xprecord.Fisher = 0;
                xprecord.Crafter = 0;
                xprecord.Framer = 0;
                xprecord.Medic = 0;
                xprecord.Scavenger = 0;
                xprecord.Tamer = 0;
                // Reset Skill Spents Points
                xprecord.WoodCutterP = 0;
                xprecord.SmithyP = 0;
                xprecord.MinerP = 0;
                xprecord.ForagerP = 0;
                xprecord.HunterP = 0;
                xprecord.FisherP = 0;
                xprecord.CrafterP = 0;
                xprecord.FramerP = 0;
                xprecord.MedicP = 0;
                xprecord.ScavengerP = 0;
                xprecord.TamerP = 0;
                // Set LiveUI Location to Default
                xprecord.UILocation = config.defaultOptions.liveuistatslocation;
                // Check for Rank Group and Assign or Revoke
                foreach (var rankgroup in config.xpLevelRanks.ranks)
                {
                    if (config.xpLevelRanks.keepgrouponrank && xprecord.rank > rankgroup.Key && !permission.UserHasGroup(p.Key, rankgroup.Value.group))
                    {
                        permission.AddUserGroup(p.Key, rankgroup.Value.group);
                    }
                    if (xprecord.rank == rankgroup.Key && !permission.UserHasGroup(p.Key, rankgroup.Value.group))
                    {
                        permission.AddUserGroup(p.Key, rankgroup.Value.group);
                    }
                    if (xprecord.rank < rankgroup.Key && permission.UserHasGroup(p.Key, rankgroup.Value.group))
                    {
                        permission.RemoveUserGroup(p.Key, rankgroup.Value.group);
                    }
                    if (!config.xpLevelRanks.keepgrouponrank && xprecord.rank > rankgroup.Key && permission.UserHasGroup(p.Key, rankgroup.Value.group))
                    {
                        permission.RemoveUserGroup(p.Key, rankgroup.Value.group);
                    }
                }
                // Take Backpack Permissions
                if (permission.UserHasPermission(p.Key, Backpack1))
                {
                    permission.RevokeUserPermission(p.Key, Backpack1);
                }
                if (permission.UserHasPermission(p.Key, Backpack2))
                {
                    permission.RevokeUserPermission(p.Key, Backpack2);
                }
                if (permission.UserHasPermission(p.Key, Backpack3))
                {
                    permission.RevokeUserPermission(p.Key, Backpack3);
                }
                if (permission.UserHasPermission(p.Key, Backpack4))
                {
                    permission.RevokeUserPermission(p.Key, Backpack4);
                }
                if (permission.UserHasPermission(p.Key, Backpack5))
                {
                    permission.RevokeUserPermission(p.Key, Backpack5);
                }
                if (permission.UserHasPermission(p.Key, Backpack6))
                {
                    permission.RevokeUserPermission(p.Key, Backpack6);
                }
                if (permission.UserHasPermission(p.Key, Backpack7))
                {
                    permission.RevokeUserPermission(p.Key, Backpack7);
                }
                // Take Archery Permissions
                if (permission.UserHasPermission(p.Key, ArcheryNovice))
                {
                    permission.RevokeUserPermission(p.Key, ArcheryNovice);
                }
                if (permission.UserHasPermission(p.Key, ArcheryAdept))
                {
                    permission.RevokeUserPermission(p.Key, ArcheryAdept);
                }
                if (permission.UserHasPermission(p.Key, ArcheryMaster))
                {
                    permission.RevokeUserPermission(p.Key, ArcheryMaster);
                }
                // Take Wizardry Permissions
                if (permission.UserHasPermission(p.Key, WizardryNovice))
                {
                    permission.RevokeUserPermission(p.Key, WizardryNovice);
                }
                if (permission.UserHasPermission(p.Key, WizardryAdept))
                {
                    permission.RevokeUserPermission(p.Key, WizardryAdept);
                }
                if (permission.UserHasPermission(p.Key, WizardryMaster))
                {
                    permission.RevokeUserPermission(p.Key, WizardryMaster);
                }
                // Take Pet Permissions
                permission.RevokeUserPermission(p.Key, TameChicken);
                permission.RevokeUserPermission(p.Key, TameBoar);
                permission.RevokeUserPermission(p.Key, TameStag);
                permission.RevokeUserPermission(p.Key, TameWolf);
                permission.RevokeUserPermission(p.Key, TameBear);
                // Run Level Up to Recalculate Players Data
                if (!reset)
                {
                    GainExpAdminFix(p.Key, xprecord.trueexperience, xprecord.trueexperience, true);
                }
                var selectplayer = BasePlayer.FindByID(Convert.ToUInt64(p.Key));
                if (selectplayer != null)
                {
                    LiveStats(selectplayer, true);
                }
            }
            player.ChatMessage(XPLang("adminfixplayers", player.UserIDString));
        }
        private void PlayerFixData(BasePlayer player, bool reset = false)
        {
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            // Check True experience before fixing data
            if (config.xpLevelRanks.enableresetranks && !xprecord.DisableRank)
            {
                if (xprecord.trueexperience <= 0 || xprecord.trueexperience < xprecord.experience)
                {
                    xprecord.trueexperience = (int)xprecord.experience;
                }
            }
            if (!player.IsAdmin && !permission.UserHasPermission(player.UserIDString, Admin) && config.defaultOptions.disableplayerfixdata)
            {
                player.ChatMessage(XPLang("fixdatadisabled", player.UserIDString));
                return;
            }
            int timer;
            DateTime resettimedata = xprecord.playerfixdata.AddMinutes(config.defaultOptions.playerfixdatatimer);
            TimeSpan interval = resettimedata - DateTime.Now;
            timer = (int)interval.TotalMinutes;
            if (config.defaultOptions.bypassadminreset && player.IsAdmin && permission.UserHasPermission(player.UserIDString, Admin))
            {
                timer = 0;
            }
            if (timer > 0)
            {
                player.ChatMessage(XPLang("resettimerdata", player.UserIDString, timer));
                return;
            }
            // Reset Level, Required XP & Stat/Skill Points
            if (!reset)
            {
                xprecord.rank = 0;
                xprecord.truelevel = 0;
            }
            xprecord.level = 0;
            xprecord.experience = 0;
            xprecord.requiredxp = config.xpLevel.levelstart;
            xprecord.statpoint = 0;
            xprecord.skillpoint = 0;
            // Reset health if needed before removing points
            if (xprecord.Might >= 1)
            {
                // Max Health
                double armor = (xprecord.Might * config.might.armor) * 100;
                double newmaxhealth = player._maxHealth - armor;
                // Change Max Health
                if (newmaxhealth < 100)
                {
                    player._maxHealth = 100;
                }
                else
                {
                    player._maxHealth = (float)newmaxhealth;
                }
                // Player Current Health
                double defaulthealth = 100;
                double teahealth = 100;
                bool teamodified = false;
                double healthdifference = 0;
                if (GetTeaCooldown(player) != 0)
                {
                    // Check for Tea Modifier
                    if (TeaModifiers != null && xprecord.teatype != "none")
                    {
                        teahealth = defaulthealth + TeaModifiers.Call<float>("GetTeaValue", player, xprecord.teatype, Modifier.ModifierType.Max_Health) * 100;
                        teamodified = true;
                    }
                    switch (GetTeaTypes(player))
                    {
                        case "maxhealthtea":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 5;
                            }
                            break;
                        case "maxhealthtea.advanced":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 12.5;
                            }
                            break;
                        case "maxhealthtea.pure":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 20;
                            }
                            break;
                    }
                }
                if (player._health > teahealth)
                {
                    healthdifference = player._health - teahealth;
                }
                player._health -= (float)healthdifference;
            }
            // Reset Stat Levels
            xprecord.Mentality = 0;
            xprecord.Dexterity = 0;
            xprecord.Might = 0;
            xprecord.Captaincy = 0;
            xprecord.Weaponry = 0;
            // Reset Stat Spent Points
            xprecord.MentalityP = 0;
            xprecord.DexterityP = 0;
            xprecord.MightP = 0;
            xprecord.CaptaincyP = 0;
            xprecord.WeaponryP = 0;
            // Reset Skill Levels
            xprecord.WoodCutter = 0;
            xprecord.Smithy = 0;
            xprecord.Miner = 0;
            xprecord.Forager = 0;
            xprecord.Hunter = 0;
            xprecord.Fisher = 0;
            xprecord.Crafter = 0;
            xprecord.Framer = 0;
            xprecord.Medic = 0;
            xprecord.Scavenger = 0;
            xprecord.Tamer = 0;
            // Reset Skill Spents Points
            xprecord.WoodCutterP = 0;
            xprecord.SmithyP = 0;
            xprecord.MinerP = 0;
            xprecord.ForagerP = 0;
            xprecord.HunterP = 0;
            xprecord.FisherP = 0;
            xprecord.CrafterP = 0;
            xprecord.FramerP = 0;
            xprecord.MedicP = 0;
            xprecord.ScavengerP = 0;
            xprecord.TamerP = 0;
            // Reset calories/hydration if needed
            if (player.metabolism.calories.max > 500)
            {
                player.metabolism.calories.max = 500;
            }
            if (player.metabolism.hydration.max > 250)
            {
                player.metabolism.hydration.max = 250;
            }
            // Check/Reset RankGroup permissions
            RankCheck(player);
            // Backpack Check
            if (Backpacks != null && config.backpacksmod.enablebackpacks)
            {
                BackPackChecks(player, config.backpacksmod.statorskill, true);
            }
            // Archery Check
            if (Archery != null && config.archerymod.enablearchery)
            {
                ArcheryChecks(player, config.archerymod.statorskill, true);
            }
            // Wizardry Check
            if (Wizardry != null && config.wizardrymod.enablewizardry)
            {
                WizardryChecks(player, config.archerymod.statorskill, true);
            }
            // Check/Reset Tamer permissions
            PetChecks(player, true);
            // Set LiveUI Location to Default
            xprecord.UILocation = config.defaultOptions.liveuistatslocation;
            // Timer
            xprecord.playerfixdata = DateTime.Now;
            // Run Level Up to Recalculate Players Data
            if (!reset)
            {
                GainExpAdmin(player, xprecord.trueexperience, xprecord.trueexperience, true);
            }
            // Update Live UI
            LiveStats(player, true);
            // Notify Players
            player.ChatMessage(XPLang("playerfixdata", player.UserIDString));
        }
        private void PlayerReset(BasePlayer player)
        {
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            // Reset Level, Required XP & Stat/Skill Points
            xprecord.rank = 0;
            xprecord.truelevel = 0;
            xprecord.trueexperience = 0;
            xprecord.level = 0;
            xprecord.experience = 0;
            xprecord.requiredxp = config.xpLevel.levelstart;
            xprecord.statpoint = 0;
            xprecord.skillpoint = 0;
            // Reset health if needed before removing points
            if (xprecord.Might >= 1)
            {
                // Max Health
                double armor = (xprecord.Might * config.might.armor) * 100;
                double newmaxhealth = player._maxHealth - armor;
                // Change Max Health
                if (newmaxhealth < 100)
                {
                    player._maxHealth = 100;
                }
                else
                {
                    player._maxHealth = (float)newmaxhealth;
                }
                // Player Current Health
                double defaulthealth = 100;
                double teahealth = 100;
                bool teamodified = false;
                double healthdifference = 0;
                if (GetTeaCooldown(player) != 0)
                {
                    // Check for Tea Modifier
                    if (TeaModifiers != null && xprecord.teatype != "none")
                    {
                        teahealth = defaulthealth + TeaModifiers.Call<float>("GetTeaValue", player, xprecord.teatype, Modifier.ModifierType.Max_Health) * 100;
                        teamodified = true;
                    }
                    switch (GetTeaTypes(player))
                    {
                        case "maxhealthtea":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 5;
                            }
                            break;
                        case "maxhealthtea.advanced":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 12.5;
                            }
                            break;
                        case "maxhealthtea.pure":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 20;
                            }
                            break;
                    }
                }
                if (player._health > teahealth)
                {
                    healthdifference = player._health - teahealth;
                }
                player._health -= (float)healthdifference;
            }
            // Reset Stat Levels
            xprecord.Mentality = 0;
            xprecord.Dexterity = 0;
            xprecord.Might = 0;
            xprecord.Captaincy = 0;
            xprecord.Weaponry = 0;
            // Reset Stat Spent Points
            xprecord.MentalityP = 0;
            xprecord.DexterityP = 0;
            xprecord.MightP = 0;
            xprecord.CaptaincyP = 0;
            xprecord.WeaponryP = 0;
            // Reset Skill Levels
            xprecord.WoodCutter = 0;
            xprecord.Smithy = 0;
            xprecord.Miner = 0;
            xprecord.Forager = 0;
            xprecord.Hunter = 0;
            xprecord.Fisher = 0;
            xprecord.Crafter = 0;
            xprecord.Framer = 0;
            xprecord.Medic = 0;
            xprecord.Scavenger = 0;
            xprecord.Tamer = 0;
            // Reset Skill Spents Points
            xprecord.WoodCutterP = 0;
            xprecord.SmithyP = 0;
            xprecord.MinerP = 0;
            xprecord.ForagerP = 0;
            xprecord.HunterP = 0;
            xprecord.FisherP = 0;
            xprecord.CrafterP = 0;
            xprecord.FramerP = 0;
            xprecord.MedicP = 0;
            xprecord.ScavengerP = 0;
            xprecord.TamerP = 0;
            // Harvest Reset
            xprecord.Wood = 0;
            xprecord.Stone = 0;
            xprecord.Metal = 0;
            xprecord.Sulfur = 0;
            xprecord.Cactus = 0;
            xprecord.Berries = 0;
            xprecord.Pumpkin = 0;
            xprecord.Potato = 0;
            xprecord.Mushroom = 0;
            xprecord.Hemp = 0;
            xprecord.Seed = 0;
            // Reset calories/hydration if needed
            if (player.metabolism.calories.max > 500)
            {
                player.metabolism.calories.max = 500;
            }
            if (player.metabolism.hydration.max > 250)
            {
                player.metabolism.hydration.max = 250;
            }
            // Check/Reset Tamer permissions
            RankCheck(player, true);
            // Backpack Check
            if (Backpacks != null && config.backpacksmod.enablebackpacks)
            {
                BackPackChecks(player, config.backpacksmod.statorskill, true);
            }
            // Archery Check
            if (Archery != null && config.archerymod.enablearchery)
            {
                ArcheryChecks(player, config.archerymod.statorskill, true);
            }
            // Wizardry Check
            if (Wizardry != null && config.wizardrymod.enablewizardry)
            {
                WizardryChecks(player, config.archerymod.statorskill, true);
            }
            // Check/Reset Tamer permissions
            PetChecks(player, true);
            // Set LiveUI Location to Default
            xprecord.UILocation = config.defaultOptions.liveuistatslocation;
            // Update Live UI
            LiveStats(player, true);
            // Notify Players
            player.ChatMessage(XPLang("xpresetplayer", player.UserIDString));
        }
        private void HarvestReset(BasePlayer player)
        {
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            xprecord.Wood = 0;
            xprecord.Stone = 0;
            xprecord.Metal = 0;
            xprecord.Sulfur = 0;
            xprecord.Cactus = 0;
            xprecord.Berries = 0;
            xprecord.Pumpkin = 0;
            xprecord.Potato = 0;
            xprecord.Mushroom = 0;
            xprecord.Hemp = 0;
            xprecord.Seed = 0;
            player.ChatMessage(XPLang("playerharvestreset", player.UserIDString));
        }
        private void SelectedPlayerReset(BasePlayer player, BasePlayer selectplayer)
        {
            if (player == null || selectplayer == null) return;
            XPRecord xprecord = GetXPRecord(selectplayer);
            if (xprecord == null) return;
            // Reset Level, Required XP & Stat/Skill Points
            xprecord.rank = 0;
            xprecord.truelevel = 0;
            xprecord.trueexperience = 0;
            xprecord.level = 0;
            xprecord.experience = 0;
            xprecord.requiredxp = config.xpLevel.levelstart;
            xprecord.statpoint = 0;
            xprecord.skillpoint = 0;
            // Reset health if needed before removing points
            if (xprecord.Might >= 1)
            {
                // Max Health
                double armor = (xprecord.Might * config.might.armor) * 100;
                double newmaxhealth = selectplayer._maxHealth - armor;
                // Change Max Health
                if (newmaxhealth < 100)
                {
                    selectplayer._maxHealth = 100;
                }
                else
                {
                    selectplayer._maxHealth = (float)newmaxhealth;
                }
                // Player Current Health
                double defaulthealth = 100;
                double teahealth = 100;
                bool teamodified = false;
                double healthdifference = 0;
                if (GetTeaCooldown(player) != 0)
                {
                    // Check for Tea Modifier
                    if (TeaModifiers != null && xprecord.teatype != "none")
                    {
                        teahealth = defaulthealth + TeaModifiers.Call<float>("GetTeaValue", selectplayer, xprecord.teatype, Modifier.ModifierType.Max_Health) * 100;
                        teamodified = true;
                    }
                    switch (GetTeaTypes(player))
                    {
                        case "maxhealthtea":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 5;
                            }
                            break;
                        case "maxhealthtea.advanced":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 12.5;
                            }
                            break;
                        case "maxhealthtea.pure":
                            if (!teamodified)
                            {
                                teahealth = defaulthealth + 20;
                            }
                            break;
                    }
                }
                if (selectplayer._health > teahealth)
                {
                    healthdifference = selectplayer._health - teahealth;
                }
                selectplayer._health -= (float)healthdifference;
            }
            // Reset Stat Levels
            xprecord.Mentality = 0;
            xprecord.Dexterity = 0;
            xprecord.Might = 0;
            xprecord.Captaincy = 0;
            xprecord.Weaponry = 0;
            // Reset Stat Spent Points
            xprecord.MentalityP = 0;
            xprecord.DexterityP = 0;
            xprecord.MightP = 0;
            xprecord.CaptaincyP = 0;
            xprecord.WeaponryP = 0;
            // Reset Skill Levels
            xprecord.WoodCutter = 0;
            xprecord.Smithy = 0;
            xprecord.Miner = 0;
            xprecord.Forager = 0;
            xprecord.Hunter = 0;
            xprecord.Fisher = 0;
            xprecord.Crafter = 0;
            xprecord.Framer = 0;
            xprecord.Medic = 0;
            xprecord.Scavenger = 0;
            xprecord.Tamer = 0;
            // Reset Skill Spents Points
            xprecord.WoodCutterP = 0;
            xprecord.SmithyP = 0;
            xprecord.MinerP = 0;
            xprecord.ForagerP = 0;
            xprecord.HunterP = 0;
            xprecord.FisherP = 0;
            xprecord.CrafterP = 0;
            xprecord.FramerP = 0;
            xprecord.MedicP = 0;
            xprecord.ScavengerP = 0;
            xprecord.TamerP = 0;
            // Harvest Reset
            xprecord.Wood = 0;
            xprecord.Stone = 0;
            xprecord.Metal = 0;
            xprecord.Sulfur = 0;
            xprecord.Cactus = 0;
            xprecord.Berries = 0;
            xprecord.Pumpkin = 0;
            xprecord.Potato = 0;
            xprecord.Mushroom = 0;
            xprecord.Corn = 0;
            xprecord.Hemp = 0;
            xprecord.Seed = 0;
            // Reset calories/hydration if needed
            if (selectplayer.metabolism.calories.max > 500)
            {
                selectplayer.metabolism.calories.max = 500;
            }
            if (selectplayer.metabolism.hydration.max > 250)
            {
                selectplayer.metabolism.hydration.max = 250;
            }
            // Check/Reset Tamer permissions
            RankCheck(player, true);
            // Backpack Check
            if (Backpacks != null && config.backpacksmod.enablebackpacks)
            {
                BackPackChecks(player, config.backpacksmod.statorskill, true);
            }
            // Archery Check
            if (Archery != null && config.archerymod.enablearchery)
            {
                ArcheryChecks(player, config.archerymod.statorskill, true);
            }
            // Wizardry Check
            if (Wizardry != null && config.wizardrymod.enablewizardry)
            {
                WizardryChecks(player, config.archerymod.statorskill, true);
            }
            // Check/Reset Tamer permissions
            PetChecks(selectplayer, true);
            // Set LiveUI Location to Default
            xprecord.UILocation = config.defaultOptions.liveuistatslocation;
            // Update Live UI
            LiveStats(selectplayer, true);
            // Notify Players
            selectplayer.ChatMessage(XPLang("xpresetplayer", selectplayer.UserIDString));
            player.ChatMessage(XPLang("xpresetselectedplayer", player.UserIDString, xprecord.displayname));
        }
        private void SelectedHarvestReset(BasePlayer player, BasePlayer selectplayer)
        {
            if (player == null || selectplayer == null) return;
            XPRecord xprecord = GetXPRecord(selectplayer);
            if (xprecord == null) return;
            xprecord.Wood = 0;
            xprecord.Stone = 0;
            xprecord.Metal = 0;
            xprecord.Sulfur = 0;
            xprecord.Cactus = 0;
            xprecord.Berries = 0;
            xprecord.Pumpkin = 0;
            xprecord.Potato = 0;
            xprecord.Mushroom = 0;
            xprecord.Corn = 0;
            xprecord.Hemp = 0;
            xprecord.Seed = 0;
            selectplayer.ChatMessage(XPLang("playerharvestreset", selectplayer.UserIDString));
            player.ChatMessage(XPLang("selectedplayerharvestreset", player.UserIDString, xprecord.displayname));
        }
        private void SelectedLevelReset(BasePlayer player, BasePlayer selectplayer)
        {
            if (player == null || selectplayer == null) return;
            XPRecord xprecord = GetXPRecord(selectplayer);
            if (xprecord == null) return;
            xprecord.trueexperience -= (int)xprecord.experience;
            xprecord.truelevel -= (int)xprecord.level;
            xprecord.level = 0;
            xprecord.experience = 0;
            xprecord.requiredxp = config.xpLevel.levelstart;
            selectplayer.ChatMessage(XPLang("playerlevelreset", selectplayer.UserIDString));
            player.ChatMessage(XPLang("selectedplayerlevelreset", player.UserIDString, xprecord.displayname));
            PlayerFixData(selectplayer, true);
        }
        private void SelectedRankReset(BasePlayer player, BasePlayer selectplayer)
        {
            if (player == null || selectplayer == null) return;
            XPRecord xprecord = GetXPRecord(selectplayer);
            if (xprecord == null) return;
            xprecord.rank = 0;
            xprecord.truelevel = (int)xprecord.level;
            xprecord.trueexperience = (int)xprecord.experience;
            selectplayer.ChatMessage(XPLang("playerrankreset", selectplayer.UserIDString));
            player.ChatMessage(XPLang("selectedplayerrankreset", player.UserIDString, xprecord.displayname));
            PlayerFixData(selectplayer);
        }
        private void PlayerAllRankReset(BasePlayer player)
        {
            if (!player.IsAdmin && !permission.UserHasPermission(player.UserIDString, Admin)) return;
            foreach (var p in _xperienceCache)
            {
                if (!p.Key.IsSteamId()) continue;
                var selectplayer = BasePlayer.FindByID(Convert.ToUInt64(p.Key));
                if (selectplayer != null)
                {
                    SelectedRankReset(player, selectplayer);
                    continue;
                }
                XPRecord xprecord = GetPlayerRecord(p.Key);
                xprecord.rank = 0;
                xprecord.truelevel = (int)xprecord.level;
                xprecord.trueexperience = (int)xprecord.experience;
            }
            PlayerFixDataAll(player);
            player.ChatMessage(XPLang("allplayerrankreset", player.UserIDString));
        }
        private void PlayerAllLevelReset(BasePlayer player)
        {
            if (!player.IsAdmin && !permission.UserHasPermission(player.UserIDString, Admin)) return;
            foreach (var p in _xperienceCache)
            {
                if (!p.Key.IsSteamId()) continue;
                XPRecord xprecord = GetPlayerRecord(p.Key);
                xprecord.trueexperience -= (int)xprecord.experience;
                xprecord.truelevel -= (int)xprecord.level;
                xprecord.level = 0;
                xprecord.experience = 0;
                xprecord.requiredxp = config.xpLevel.levelstart;
            }
            PlayerFixDataAll(player, true);
            player.ChatMessage(XPLang("allplayerlevelreset", player.UserIDString));
        }
        private bool IsNight()
        {
            var dateTime = TOD_Sky.Instance.Cycle.DateTime;
            return dateTime.Hour >= config.nightBonus.StartTime || dateTime.Hour <= config.nightBonus.EndTime;
        }
        private void OnPlayerHealthChange(BasePlayer player)
        {
            if (player == null || !player.userID.IsSteamId() || player.IsNpc) return;
            LiveStats(player, true);
        }
        private void KRBonus(BasePlayer player, string KillType, int reqkills, double bonus, int bonusend, bool enablemultibonus, string multibonustype)
        {
            var playerid = player.userID.ToString();
            //XPRecord xprecord = GetXPRecord(player);
            int KillAmount = reqkills;
            int BonusEnd = bonusend;
            int GetKillRecord = KillRecords.Call<int>("GetKillRecord", playerid, KillType.ToLower());
            if (GetKillRecord == KillAmount)
            {
                GainExp(player, bonus);
                player.ChatMessage(XPLang("bonus", player.UserIDString, bonus, KillAmount, KillType));
            }
            else
            {
                if (enablemultibonus)
                {
                    int MultipleKA = KillAmount;
                    double Multibonus = bonus;
                    for (int k = 0; k < BonusEnd; ++k)
                    {
                        MultipleKA += reqkills + k / BonusEnd;
                        if (multibonustype == "increase")
                        {
                            Multibonus += bonus + k / BonusEnd;
                        }
                        if (MultipleKA >= BonusEnd) return;
                        if (GetKillRecord == MultipleKA)
                        {
                            GainExp(player, Multibonus);
                            player.ChatMessage(XPLang("bonus", player.UserIDString, Multibonus, MultipleKA, KillType));
                        }
                    }
                }
            }
        }
        private void XPTeams(BasePlayer player, double e, string type)
        {
            if (player == null || !player.userID.IsSteamId() || player.Team == null || player.Team.members.Count <= 1) return;
            foreach (var team in player.Team.members)
            {
                if (team == player.userID) continue;
                BasePlayer teammember = RelationshipManager.FindByID(team);
                if (teammember == null || !teammember.IsConnected || Vector3.Distance(player.transform.position, teammember.transform.position) >= config.xpTeams.teamdistance) continue;
                XPRecord xprecord = GetXPRecord(teammember);
                if (type == "addxp")
                {
                    double addxp = config.xpTeams.teamxpgainamount * e;
                    if (addxp < 1)
                    {
                        addxp = 1;
                    }
                    xprecord.experience = (int)xprecord.experience + addxp;
                    if (xprecord.experience >= xprecord.requiredxp)
                    {
                        LvlUp(teammember, 0, 0);
                    }
                    LiveStats(teammember, true);
                    if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.xpgainloss && addxp != 0)
                    {
                        UINotify.Call("SendNotify", teammember, config.UiNotifier.xpgainlosstype, XPLang("uinotify_xpgain", teammember.UserIDString, Math.Round(addxp)));
                    }
                }
                if (type == "takexp")
                {
                    if (e < 1)
                    {
                        e = 1;
                    }
                    double takexp = config.xpTeams.teamxplossamount * e;
                    if (takexp < 1)
                    {
                        takexp = 1;
                    }
                    double newxp = xprecord.experience - takexp;
                    double nextlevel = xprecord.requiredxp;
                    // Make sure XP does not go negative
                    if (newxp <= 0)
                    {
                        newxp = 0;
                    }
                    xprecord.experience = (int)newxp;
                    if (nextlevel == config.xpLevel.levelstart) return;
                    double prevlevel = xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier);
                    if (xprecord.experience < prevlevel)
                    {
                        LvlDown(teammember);
                    }
                    LiveStats(teammember, true);
                    // UINotify
                    if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.xpgainloss)
                    {
                        UINotify.Call("SendNotify", teammember, config.UiNotifier.xpgainlosstype, XPLang("uinotify_xploss", teammember.UserIDString, Math.Round(takexp)));
                    }
                }
            }
        }
        private void XPClans(BasePlayer player, double e, string type)
        {
            foreach (var allplayer in BasePlayer.activePlayerList)
            {
                bool isinclan = Clans.Call<bool>("IsClanMember", player.UserIDString, allplayer.UserIDString);
                if (isinclan && (allplayer != player))
                {
                    XPRecord xprecord = GetXPRecord(allplayer);
                    if (type == "addxp")
                    {
                        double addxp = config.xpclans.clanbonusamount * e;
                        if (addxp < 1)
                        {
                            addxp = 1;
                        }
                        xprecord.experience = (int)xprecord.experience + addxp;
                        if (xprecord.experience >= xprecord.requiredxp)
                        {
                            LvlUp(allplayer, 0, 0);
                        }
                        LiveStats(allplayer, true);
                        if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.xpgainloss && addxp != 0)
                        {
                            UINotify.Call("SendNotify", allplayer, config.UiNotifier.xpgainlosstype, XPLang("uinotify_xpgain", allplayer.UserIDString, Math.Round(addxp)));
                        }
                    }
                    if (type == "takexp")
                    {
                        if (e < 1)
                        {
                            e = 1;
                        }
                        double takexp = config.xpclans.clanreductionamount * e;
                        if (takexp < 1)
                        {
                            takexp = 1;
                        }
                        double newxp = xprecord.experience - takexp;
                        double nextlevel = xprecord.requiredxp;
                        // Make sure XP does not go negative
                        if (newxp <= 0)
                        {
                            newxp = 0;
                        }
                        xprecord.experience = (int)newxp;
                        if (nextlevel == config.xpLevel.levelstart) return;
                        double prevlevel = xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier);
                        if (xprecord.experience < prevlevel)
                        {
                            LvlDown(allplayer);
                        }
                        LiveStats(allplayer, true);
                        // UINotify
                        if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.xpgainloss)
                        {
                            UINotify.Call("SendNotify", allplayer, config.UiNotifier.xpgainlosstype, XPLang("uinotify_xploss", allplayer.UserIDString, Math.Round(takexp)));
                        }
                    }
                }
            }
        }
        private void HarvestRecord(BasePlayer player, string item, int amount)
        {
            if (player == null || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(player);
            switch (item)
            {
                case "wood":
                    xprecord.Wood += amount;
                    break;
                case "stone":
                    xprecord.Stone += amount;
                    break;
                case "metal":
                    xprecord.Metal += amount;
                    break;
                case "sulfur":
                    xprecord.Sulfur += amount;
                    break;
                case "cactus":
                    xprecord.Cactus += amount;
                    break;
                case "berries":
                    xprecord.Berries += amount;
                    break;
                case "pumpkin":
                    xprecord.Pumpkin += amount;
                    break;
                case "potato":
                    xprecord.Potato += amount;
                    break;
                case "corn":
                    xprecord.Corn += amount;
                    break;
                case "mushroom":
                    xprecord.Mushroom += amount;
                    break;
                case "hemp":
                    xprecord.Hemp += amount;
                    break;
                case "seed":
                    xprecord.Seed += amount;
                    break;
            }

        }
        #endregion

        #region Archery
        public const string ArcheryNovice = "archery.novice";
        public const string ArcheryAdept = "archery.adept";
        public const string ArcheryMaster = "archery.master";
        private void ArcheryChecks(BasePlayer player, string type = null, bool reset = false)
        {
            if (player == null || !player.userID.IsSteamId() || !config.archerymod.enablearchery) return;
            XPRecord xprecord = GetXPRecord(player);
            // Reset and Remove all Archery Permissions
            if (reset)
            {
                if (permission.UserHasPermission(player.UserIDString, ArcheryNovice))
                {
                    permission.RevokeUserPermission(player.UserIDString, ArcheryNovice);
                    player.ChatMessage(XPLang("archeryrevokenovice", player.UserIDString));
                }
                if (permission.UserHasPermission(player.UserIDString, ArcheryAdept))
                {
                    permission.RevokeUserPermission(player.UserIDString, ArcheryAdept);
                    player.ChatMessage(XPLang("archeryrevokeadept", player.UserIDString));
                }
                if (permission.UserHasPermission(player.UserIDString, ArcheryMaster))
                {
                    permission.RevokeUserPermission(player.UserIDString, ArcheryMaster);
                    player.ChatMessage(XPLang("archeryrevokemaster", player.UserIDString));
                }
                return;
            }
            // Stat/Skill Control
            if (type == null) return;
            string statorskill = config.archerymod.statorskill;
            // Rank & Stat/Skill Level Checks
            int rank = xprecord.rank;
            int skilllevel = 0;
            switch (statorskill)
            {
                case "Mentality":
                    skilllevel = xprecord.Mentality;
                    break;
                case "Dexterity":
                    skilllevel = xprecord.Dexterity;
                    break;
                case "Might":
                    skilllevel = xprecord.Might;
                    break;
                case "Captaincy":
                    skilllevel = xprecord.Captaincy;
                    break;
                case "WoodCutter":
                    skilllevel = xprecord.WoodCutter;
                    break;
                case "Smithy":
                    skilllevel = xprecord.Smithy;
                    break;
                case "Miner":
                    skilllevel = xprecord.Miner;
                    break;
                case "Forager":
                    skilllevel = xprecord.Forager;
                    break;
                case "Hunter":
                    skilllevel = xprecord.Hunter;
                    break;
                case "Fisher":
                    skilllevel = xprecord.Fisher;
                    break;
                case "Crafter":
                    skilllevel = xprecord.Crafter;
                    break;
                case "Framer":
                    skilllevel = xprecord.Framer;
                    break;
                case "Medic":
                    skilllevel = xprecord.Medic;
                    break;
                case "Scavenger":
                    skilllevel = xprecord.Scavenger;
                    break;
            }
            if (statorskill.ToLower() == type.ToLower())
            {
                // Archery Novice
                if (((config.archerymod.rankrequired && rank >= config.archerymod.ranklevel) || !config.archerymod.rankrequired) && (skilllevel == config.archerymod.novicelevel && skilllevel < config.archerymod.adeptlevel) && !permission.UserHasPermission(player.UserIDString, ArcheryNovice))
                {
                    permission.GrantUserPermission(player.UserIDString, ArcheryNovice, Archery);
                    player.ChatMessage(XPLang("archerygrantnovice", player.UserIDString));
                }
                if ((skilllevel < config.archerymod.novicelevel || (config.archerymod.rankrequired && rank < config.archerymod.ranklevel)) && permission.UserHasPermission(player.UserIDString, ArcheryNovice))
                {
                    permission.RevokeUserPermission(player.UserIDString, ArcheryNovice);
                    player.ChatMessage(XPLang("archeryrevokenovice", player.UserIDString));
                }
                // Archery Adept
                if (((config.archerymod.rankrequired && rank >= config.archerymod.ranklevel) || !config.archerymod.rankrequired) && (skilllevel == config.archerymod.adeptlevel && skilllevel < config.archerymod.masterlevel) && !permission.UserHasPermission(player.UserIDString, ArcheryAdept))
                {
                    if (permission.UserHasPermission(player.UserIDString, ArcheryNovice))
                    {
                        permission.RevokeUserPermission(player.UserIDString, ArcheryNovice);
                    }
                    permission.GrantUserPermission(player.UserIDString, ArcheryAdept, Archery);
                    player.ChatMessage(XPLang("archerygrantadept", player.UserIDString));
                }
                if ((skilllevel < config.archerymod.adeptlevel || (config.archerymod.rankrequired && rank < config.archerymod.ranklevel)) && permission.UserHasPermission(player.UserIDString, ArcheryAdept))
                {
                    permission.RevokeUserPermission(player.UserIDString, ArcheryAdept);
                    player.ChatMessage(XPLang("archeryrevokeadept", player.UserIDString));
                }
                // Archery Master
                if (((config.archerymod.rankrequired && rank >= config.archerymod.ranklevel) || !config.archerymod.rankrequired) && skilllevel == config.archerymod.masterlevel && !permission.UserHasPermission(player.UserIDString, ArcheryMaster))
                {
                    if (permission.UserHasPermission(player.UserIDString, ArcheryAdept))
                    {
                        permission.RevokeUserPermission(player.UserIDString, ArcheryAdept);
                    }
                    permission.GrantUserPermission(player.UserIDString, ArcheryMaster, Archery);
                    player.ChatMessage(XPLang("archerygrantmaster", player.UserIDString));
                }
                if ((skilllevel < config.archerymod.masterlevel || (config.archerymod.rankrequired && rank < config.archerymod.ranklevel)) && permission.UserHasPermission(player.UserIDString, ArcheryMaster))
                {
                    permission.RevokeUserPermission(player.UserIDString, ArcheryMaster);
                    player.ChatMessage(XPLang("archeryrevokemaster", player.UserIDString));
                }
            }
        }
        #endregion

        #region Wizardry
        public const string WizardryNovice = "wizardry.novice";
        public const string WizardryAdept = "wizardry.adept";
        public const string WizardryMaster = "wizardry.master";
        private void WizardryChecks(BasePlayer player, string type = null, bool reset = false)
        {
            if (player == null || !player.userID.IsSteamId() || !config.wizardrymod.enablewizardry) return;
            XPRecord xprecord = GetXPRecord(player);
            // Reset and Remove all Wizardry Permissions
            if (reset)
            {
                if (permission.UserHasPermission(player.UserIDString, WizardryNovice))
                {
                    permission.RevokeUserPermission(player.UserIDString, WizardryNovice);
                    player.ChatMessage(XPLang("wizardryrevokenovice", player.UserIDString));
                }
                if (permission.UserHasPermission(player.UserIDString, WizardryAdept))
                {
                    permission.RevokeUserPermission(player.UserIDString, WizardryAdept);
                    player.ChatMessage(XPLang("wizardryrevokeadept", player.UserIDString));
                }
                if (permission.UserHasPermission(player.UserIDString, WizardryMaster))
                {
                    permission.RevokeUserPermission(player.UserIDString, WizardryMaster);
                    player.ChatMessage(XPLang("wizardryrevokenmaster", player.UserIDString));
                }
                return;
            }
            // Stat/Skill Control
            if (type == null) return;
            string statorskill = config.wizardrymod.statorskill;
            // Rank & Stat/Skill Level Checks
            int rank = xprecord.rank;
            int skilllevel = 0;
            switch (statorskill)
            {
                case "Mentality":
                    skilllevel = xprecord.Mentality;
                    break;
                case "Dexterity":
                    skilllevel = xprecord.Dexterity;
                    break;
                case "Might":
                    skilllevel = xprecord.Might;
                    break;
                case "Captaincy":
                    skilllevel = xprecord.Captaincy;
                    break;
                case "WoodCutter":
                    skilllevel = xprecord.WoodCutter;
                    break;
                case "Smithy":
                    skilllevel = xprecord.Smithy;
                    break;
                case "Miner":
                    skilllevel = xprecord.Miner;
                    break;
                case "Forager":
                    skilllevel = xprecord.Forager;
                    break;
                case "Hunter":
                    skilllevel = xprecord.Hunter;
                    break;
                case "Fisher":
                    skilllevel = xprecord.Fisher;
                    break;
                case "Crafter":
                    skilllevel = xprecord.Crafter;
                    break;
                case "Framer":
                    skilllevel = xprecord.Framer;
                    break;
                case "Medic":
                    skilllevel = xprecord.Medic;
                    break;
                case "Scavenger":
                    skilllevel = xprecord.Scavenger;
                    break;
            }

            if (statorskill.ToLower() == type.ToLower())
            {
                // Wizardry Novice
                if (((config.wizardrymod.rankrequired && rank >= config.wizardrymod.ranklevel) || !config.wizardrymod.rankrequired) && (skilllevel == config.wizardrymod.novicelevel && skilllevel < config.wizardrymod.adeptlevel) && !permission.UserHasPermission(player.UserIDString, WizardryNovice))
                {
                    permission.GrantUserPermission(player.UserIDString, WizardryNovice, Wizardry);
                    player.ChatMessage(XPLang("wizardrygrantnovice", player.UserIDString));
                }
                if ((skilllevel < config.wizardrymod.novicelevel || (config.wizardrymod.rankrequired && rank < config.wizardrymod.ranklevel)) && permission.UserHasPermission(player.UserIDString, WizardryNovice))
                {
                    permission.RevokeUserPermission(player.UserIDString, WizardryNovice);
                    player.ChatMessage(XPLang("wizardryrevokenovice", player.UserIDString));
                }
                // Wizardy Adept
                if (((config.wizardrymod.rankrequired && rank >= config.wizardrymod.ranklevel) || !config.wizardrymod.rankrequired) && (skilllevel == config.wizardrymod.adeptlevel && skilllevel < config.wizardrymod.masterlevel) && !permission.UserHasPermission(player.UserIDString, WizardryAdept))
                {
                    if (permission.UserHasPermission(player.UserIDString, WizardryNovice))
                    {
                        permission.RevokeUserPermission(player.UserIDString, WizardryNovice);
                    }
                    permission.GrantUserPermission(player.UserIDString, WizardryAdept, Wizardry);
                    player.ChatMessage(XPLang("wizardrygrantadept", player.UserIDString));
                }
                if ((skilllevel < config.wizardrymod.adeptlevel || (config.wizardrymod.rankrequired && rank < config.wizardrymod.ranklevel)) && permission.UserHasPermission(player.UserIDString, WizardryAdept))
                {
                    permission.RevokeUserPermission(player.UserIDString, WizardryAdept);
                    player.ChatMessage(XPLang("wizardryrevokeadept", player.UserIDString));
                }
                // Wizardry Master
                if (((config.wizardrymod.rankrequired && rank >= config.wizardrymod.ranklevel) || !config.wizardrymod.rankrequired) && skilllevel == config.wizardrymod.masterlevel && !permission.UserHasPermission(player.UserIDString, WizardryMaster))
                {
                    if (permission.UserHasPermission(player.UserIDString, WizardryAdept))
                    {
                        permission.RevokeUserPermission(player.UserIDString, WizardryAdept);
                    }
                    permission.GrantUserPermission(player.UserIDString, WizardryMaster, Wizardry);
                    player.ChatMessage(XPLang("wizardrygrantmaster", player.UserIDString));
                }
                if ((skilllevel < config.wizardrymod.masterlevel || (config.wizardrymod.rankrequired && rank < config.wizardrymod.ranklevel)) && permission.UserHasPermission(player.UserIDString, WizardryMaster))
                {
                    permission.RevokeUserPermission(player.UserIDString, WizardryMaster);
                    player.ChatMessage(XPLang("wizardryrevokemaster", player.UserIDString));
                }
            }
        }
        #endregion

        #region Pets
        public const string Tame = "cannpc";
        public const string TameChicken = "pets.chicken";
        public const string TameBoar = "pets.boar";
        public const string TameStag = "pets.stag";
        public const string TameWolf = "pets.wolf";
        public const string TameBear = "pets.bear";
        public const string TamePolarBear = "pets.polarbear";
        private void PetChecks(BasePlayer player, bool reset = false, int leveldown = 0)
        {
            if (player == null || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(player);
            var skilllevel = xprecord.Tamer;

            if (!config.tamer.enabletame || Pets == null || !Pets.IsLoaded) return;

            if (reset)
            {
                permission.RevokeUserPermission(player.UserIDString, TameChicken);
                permission.RevokeUserPermission(player.UserIDString, TameBoar);
                permission.RevokeUserPermission(player.UserIDString, TameStag);
                permission.RevokeUserPermission(player.UserIDString, TameWolf);
                permission.RevokeUserPermission(player.UserIDString, TameBear);
                permission.RevokeUserPermission(player.UserIDString, TamePolarBear);
                return;
            }

            if (skilllevel >= config.tamer.chickenlevel && config.tamer.tamechicken && !permission.UserHasPermission(player.UserIDString, TameChicken))
            {
                permission.GrantUserPermission(player.UserIDString, TameChicken, Pets);
            }
            if (leveldown < config.tamer.chickenlevel)
            {
                permission.RevokeUserPermission(player.UserIDString, TameChicken);
            }
            if (skilllevel >= config.tamer.boarlevel && config.tamer.tameboar && !permission.UserHasPermission(player.UserIDString, TameBoar))
            {
                permission.GrantUserPermission(player.UserIDString, TameBoar, Pets);
            }
            if (leveldown < config.tamer.boarlevel)
            {
                permission.RevokeUserPermission(player.UserIDString, TameBoar);
            }
            if (skilllevel >= config.tamer.staglevel && config.tamer.tamestag && !permission.UserHasPermission(player.UserIDString, TameStag))
            {
                permission.GrantUserPermission(player.UserIDString, TameStag, Pets);
            }
            if (leveldown < config.tamer.staglevel)
            {
                permission.RevokeUserPermission(player.UserIDString, TameStag);
            }
            if (skilllevel >= config.tamer.wolflevel && config.tamer.tamewolf && !permission.UserHasPermission(player.UserIDString, TameWolf))
            {
                permission.GrantUserPermission(player.UserIDString, TameWolf, Pets);
            }
            if (leveldown < config.tamer.wolflevel)
            {
                permission.RevokeUserPermission(player.UserIDString, TameWolf);
            }
            if (skilllevel >= config.tamer.bearlevel && config.tamer.tamebear && !permission.UserHasPermission(player.UserIDString, TameBear))
            {
                permission.GrantUserPermission(player.UserIDString, TameBear, Pets);
            }
            if (leveldown < config.tamer.bearlevel)
            {
                permission.RevokeUserPermission(player.UserIDString, TameBear);
            }
            if (skilllevel >= config.tamer.polarbearlevel && config.tamer.tamebear && !permission.UserHasPermission(player.UserIDString, TamePolarBear))
            {
                permission.GrantUserPermission(player.UserIDString, TamePolarBear, Pets);
            }
            if (leveldown < config.tamer.polarbearlevel)
            {
                permission.RevokeUserPermission(player.UserIDString, TamePolarBear);
            }

        }
        #endregion

        #region Backpacks
        public const string UseBackpack = "backpacks.use";
        public const string GuiBackpack = "backpacks.gui";
        public const string Backpack1 = "backpacks.use.1";
        public const string Backpack2 = "backpacks.use.2";
        public const string Backpack3 = "backpacks.use.3";
        public const string Backpack4 = "backpacks.use.4";
        public const string Backpack5 = "backpacks.use.5";
        public const string Backpack6 = "backpacks.use.6";
        public const string Backpack7 = "backpacks.use.7";
        private void BackPackChecks(BasePlayer player, string type = null, bool reset = false)
        {
            if (player == null || !player.userID.IsSteamId() || !config.backpacksmod.enablebackpacks) return;
            XPRecord xprecord = GetXPRecord(player);
            // Reset and remove backpack permissions
            if (reset)
            {
                if (permission.UserHasPermission(player.UserIDString, UseBackpack) || permission.UserHasPermission(player.UserIDString, GuiBackpack) || permission.UserHasPermission(player.UserIDString, Backpack1) || permission.UserHasPermission(player.UserIDString, Backpack2) || permission.UserHasPermission(player.UserIDString, Backpack3) || permission.UserHasPermission(player.UserIDString, Backpack4) || permission.UserHasPermission(player.UserIDString, Backpack5) || permission.UserHasPermission(player.UserIDString, Backpack6) || permission.UserHasPermission(player.UserIDString, Backpack7))
                {
                    permission.RevokeUserPermission(player.UserIDString, UseBackpack);
                    permission.RevokeUserPermission(player.UserIDString, GuiBackpack);
                    permission.RevokeUserPermission(player.UserIDString, Backpack1);
                    permission.RevokeUserPermission(player.UserIDString, Backpack2);
                    permission.RevokeUserPermission(player.UserIDString, Backpack3);
                    permission.RevokeUserPermission(player.UserIDString, Backpack4);
                    permission.RevokeUserPermission(player.UserIDString, Backpack5);
                    permission.RevokeUserPermission(player.UserIDString, Backpack6);
                    permission.RevokeUserPermission(player.UserIDString, Backpack7);
                    player.ChatMessage(XPLang("backpackrevoke", player.UserIDString));
                }
                return;
            }
            if (type == null) return;
            string statorskill = config.backpacksmod.statorskill;
            int skilllevel = 0;
            switch (statorskill)
            {
                case "Mentality":
                    skilllevel = xprecord.Mentality;
                    break;
                case "Dexterity":
                    skilllevel = xprecord.Dexterity;
                    break;
                case "Might":
                    skilllevel = xprecord.Might;
                    break;
                case "Captaincy":
                    skilllevel = xprecord.Captaincy;
                    break;
                case "WoodCutter":
                    skilllevel = xprecord.WoodCutter;
                    break;
                case "Smithy":
                    skilllevel = xprecord.Smithy;
                    break;
                case "Miner":
                    skilllevel = xprecord.Miner;
                    break;
                case "Forager":
                    skilllevel = xprecord.Forager;
                    break;
                case "Hunter":
                    skilllevel = xprecord.Hunter;
                    break;
                case "Fisher":
                    skilllevel = xprecord.Fisher;
                    break;
                case "Crafter":
                    skilllevel = xprecord.Crafter;
                    break;
                case "Framer":
                    skilllevel = xprecord.Framer;
                    break;
                case "Medic":
                    skilllevel = xprecord.Medic;
                    break;
                case "Scavenger":
                    skilllevel = xprecord.Scavenger;
                    break;
            }
            if (statorskill.ToLower() == type.ToLower())
            {
                // 1 Row
                if (skilllevel >= config.backpacksmod.backpackrow1 && skilllevel < config.backpacksmod.backpackrow2 && !permission.UserHasPermission(player.UserIDString, Backpack1))
                {
                    permission.GrantUserPermission(player.UserIDString, UseBackpack, Backpacks);
                    permission.GrantUserPermission(player.UserIDString, GuiBackpack, Backpacks);
                    permission.GrantUserPermission(player.UserIDString, Backpack1, Backpacks);
                    player.ChatMessage(XPLang("backpackgrant", player.UserIDString, 1));
                }
                if (skilllevel < config.backpacksmod.backpackrow1 && permission.UserHasPermission(player.UserIDString, Backpack1))
                {
                    permission.RevokeUserPermission(player.UserIDString, UseBackpack);
                    permission.RevokeUserPermission(player.UserIDString, GuiBackpack);
                    permission.RevokeUserPermission(player.UserIDString, Backpack1);
                    player.ChatMessage(XPLang("backpackrevoke", player.UserIDString));
                }
                // 2 Row
                if (skilllevel >= config.backpacksmod.backpackrow2 && skilllevel < config.backpacksmod.backpackrow3 && !permission.UserHasPermission(player.UserIDString, Backpack2))
                {
                    permission.GrantUserPermission(player.UserIDString, Backpack2, Backpacks);
                    player.ChatMessage(XPLang("backpackgrant", player.UserIDString, 2));
                }
                if (skilllevel < config.backpacksmod.backpackrow2 && permission.UserHasPermission(player.UserIDString, Backpack2))
                {
                    permission.RevokeUserPermission(player.UserIDString, Backpack2);
                    player.ChatMessage(XPLang("backpackrevoke", player.UserIDString));
                }
                // 3 Row
                if (skilllevel >= config.backpacksmod.backpackrow3 && skilllevel < config.backpacksmod.backpackrow4 && !permission.UserHasPermission(player.UserIDString, Backpack3))
                {
                    permission.GrantUserPermission(player.UserIDString, Backpack3, Backpacks);
                    player.ChatMessage(XPLang("backpackgrant", player.UserIDString, 3));
                }
                if (skilllevel < config.backpacksmod.backpackrow3 && permission.UserHasPermission(player.UserIDString, Backpack3))
                {
                    permission.RevokeUserPermission(player.UserIDString, Backpack3);
                    player.ChatMessage(XPLang("backpackrevoke", player.UserIDString));
                }
                // 4 Row
                if (skilllevel >= config.backpacksmod.backpackrow4 && skilllevel < config.backpacksmod.backpackrow5 && !permission.UserHasPermission(player.UserIDString, Backpack4))
                {
                    permission.GrantUserPermission(player.UserIDString, Backpack4, Backpacks);
                    player.ChatMessage(XPLang("backpackgrant", player.UserIDString, 4));
                }
                if (skilllevel < config.backpacksmod.backpackrow4 && permission.UserHasPermission(player.UserIDString, Backpack4))
                {
                    permission.RevokeUserPermission(player.UserIDString, Backpack4);
                    player.ChatMessage(XPLang("backpackrevoke", player.UserIDString));
                }
                // 5 Row
                if (skilllevel >= config.backpacksmod.backpackrow5 && skilllevel < config.backpacksmod.backpackrow6 && !permission.UserHasPermission(player.UserIDString, Backpack5))
                {
                    permission.GrantUserPermission(player.UserIDString, Backpack5, Backpacks);
                    player.ChatMessage(XPLang("backpackgrant", player.UserIDString, 5));
                }
                if (skilllevel < config.backpacksmod.backpackrow5 && permission.UserHasPermission(player.UserIDString, Backpack5))
                {
                    permission.RevokeUserPermission(player.UserIDString, Backpack5);
                    player.ChatMessage(XPLang("backpackrevoke", player.UserIDString));
                }
                // 6 Row
                if (skilllevel >= config.backpacksmod.backpackrow6 && skilllevel < config.backpacksmod.backpackrow7 && !permission.UserHasPermission(player.UserIDString, Backpack6))
                {
                    permission.GrantUserPermission(player.UserIDString, Backpack6, Backpacks);
                    player.ChatMessage(XPLang("backpackgrant", player.UserIDString, 6));
                }
                if (skilllevel < config.backpacksmod.backpackrow6 && permission.UserHasPermission(player.UserIDString, Backpack6))
                {
                    permission.RevokeUserPermission(player.UserIDString, Backpack6);
                    player.ChatMessage(XPLang("backpackrevoke", player.UserIDString));
                }
                // 7 Row
                if (skilllevel >= config.backpacksmod.backpackrow7 && !permission.UserHasPermission(player.UserIDString, Backpack7))
                {
                    permission.GrantUserPermission(player.UserIDString, Backpack7, Backpacks);
                    player.ChatMessage(XPLang("backpackgrant", player.UserIDString, 7));
                }
                if (skilllevel < config.backpacksmod.backpackrow6 && permission.UserHasPermission(player.UserIDString, Backpack7))
                {
                    permission.RevokeUserPermission(player.UserIDString, Backpack7);
                    player.ChatMessage(XPLang("backpackrevoke", player.UserIDString));
                }
            }

        }
        #endregion

        #region Kills/Deaths/Loot
        private void OnLootSpawn(LootContainer container)
        {
            if (container != null && _lootCache.ContainsKey(container.net.ID))
            {
                _lootCache[container.net.ID].id.Clear();
            }
        }
        private void OnEntityDeath(BaseCombatEntity entity, HitInfo hitInfo)
        {
            // Check for null
            if (entity == null || hitInfo == null || hitInfo.Initiator == null) return;
            double addxp = 0;
            // Turret Kills
            if (hitInfo.Initiator is AutoTurret && config.xpGain.allowturretxp)
            {
                var turret = hitInfo.Initiator as AutoTurret;
                if (turret == null || !turret.OwnerID.IsSteamId()) return;
                var turretowner = FindPlayer(turret.OwnerID.ToString());
                if (turretowner == null) return;
                GainExp(turretowner, config.xpGain.turretxp);
                return;
            }
            // Count Player Suicide Separately If Enabled
            if (entity == hitInfo.Initiator)
            {
                var suicider = entity as BasePlayer;
                if (suicider == null || !suicider.userID.IsSteamId()) return;
                var r = GetXPRecord(suicider);
                double currentlevelamount = r.experience - (r.requiredxp - (r.level * config.xpLevel.levelmultiplier));
                var reducexp = Math.Round(currentlevelamount * config.xpReducer.suicidereduceamount);
                LoseExp(suicider, reducexp);
                suicider.ChatMessage(XPLang("suicide", suicider.UserIDString, reducexp));
                LiveStats(suicider, true);
                return;
            }
            // Get Killer Info
            var attacker = hitInfo.Initiator as BasePlayer;
            if (attacker == null || !attacker.userID.IsSteamId()) return;
            string KillType = entity?.GetType().Name.ToLower();
            XPRecord xprecord = GetXPRecord(attacker);
            if (xprecord == null) return;
            // Update DataCache On Kill
            switch (KillType)
            {
                case "chicken":
                    addxp = config.xpGain.chickenxp;
                    break;
                case "boar":
                    addxp = config.xpGain.boarxp;
                    break;
                case "stag":
                    addxp = config.xpGain.stagxp;
                    break;
                case "wolf":
                    addxp = config.xpGain.wolfxp;
                    break;
                case "bear":
                    addxp = config.xpGain.bearxp;
                    break;
                case "polarbear":
                    addxp = config.xpGain.polarbearxp;
                    break;
                case "simpleshark":
                    addxp = config.xpGain.sharkxp;
                    break;
                case "horse":
                case "ridablehorse":
                    addxp = config.xpGain.horsexp;
                    break;
                case "scientistnpc":
                case "scientist":
                    addxp = config.xpGain.scientistxp;
                    break;
                case "tunneldweller":
                case "underwaterdweller":
                    addxp = config.xpGain.dwellerxp;
                    break;
                case "baseplayer":
                    addxp = config.xpGain.playerxp;
                    break;
                case "lootcontainer":
                    addxp = config.xpGain.lootcontainerxp;
                    break;
                case "basecorpse":
                    addxp = config.xpGain.animalharvestxp;
                    break;
                case "npcplayercorpse":
                    addxp = config.xpGain.corpseharvestxp;
                    break;
                case "bradleyapc":
                    addxp = config.xpGain.bradley;
                    break;
                case "patrolhelicopter":
                    addxp = config.xpGain.patrolhelicopter;
                    break;
                case "scarecrownpc":
                    addxp = config.xpGain.scarecrownpc;
                    break;
                case "customscientistnpc":
                    addxp = config.xpGain.customnpc;
                    break;
                case "zombienpc":
                    addxp = config.xpGain.zombienpc;
                    break;
            }
            if (KillRecords != null && config.xpBonus.enablebonus)
            {
                KRBonus(attacker, KillType, config.xpBonus.requiredkills, config.xpBonus.bonusxp, config.xpBonus.endbonus, config.xpBonus.multibonus, config.xpBonus.multibonustype);
            }
            GainExp(attacker, addxp);
        }
        private void OnPlayerDeath(BasePlayer victim, HitInfo hitInfo)
        {
            // Check for null or NPC
            if (victim == null || !victim.userID.IsSteamId()) return;
            BaseEntity attacker = hitInfo?.Initiator;
            if (attacker == null) return;
            // If Suicide Ingnore Death
            if (attacker == victim) return;
            // Update Player Data On deaths if enabled
            if (config.xpReducer.deathreduce)
            {
                XPRecord xprecord = GetXPRecord(victim);
                double currentlevelamount = xprecord.experience - (xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier));
                var reducexp = Math.Round(currentlevelamount * config.xpReducer.deathreduceamount);
                LoseExp(victim, reducexp);
                victim.ChatMessage(XPLang("death", victim.UserIDString, reducexp));
                LiveStats(victim, true);
            }
        }
        private void OnLootEntity(BasePlayer player, LootContainer lootcontainer)
        {
            if (player == null || !player.userID.IsSteamId() || !lootcontainer.IsValid()) return;
            var loot = lootcontainer.GetType().Name.ToLower();
            var lootid = lootcontainer.net.ID;
            double addxp = 0;
            bool increaseloot = false;
            if (_lootCache.ContainsKey(lootid) && _lootCache[lootid].id.Contains(player.UserIDString))
            {
                return;
            }
            if (loot == "lootcontainer")
            {
                addxp = config.xpGain.lootcontainerxp;
                if (config.scavenger.crates)
                {
                    increaseloot = true;
                }
            }
            else if (loot == "freeablelootcontainer")
            {
                addxp = config.xpGain.underwaterlootcontainerxp;
                if (config.scavenger.uncrates)
                {
                    increaseloot = true;
                }
            }
            else if (loot == "lockedbyentcrate")
            {
                addxp = config.xpGain.lockedcratexp;
                if (config.scavenger.lockedcrates)
                {
                    increaseloot = true;
                }
            }
            else if (loot == "hackablelockedcrate")
            {
                addxp = config.xpGain.hackablecratexp;
                if (config.scavenger.hackcrates)
                {
                    increaseloot = true;
                }
            }
            GainExp(player, addxp);
            //Custom Items
            if (config.scavenger.usecustomscavlist)
            {
                RandomScavengerItem(player);
            }
            // Increase Loot
            if (increaseloot && config.scavenger.scavmultiplier != 0)
            {
                if (!_lootCache.ContainsKey(lootid))
                {
                    IncreaseLootContainers(player, lootcontainer);
                }
            }
            // Add player and container ID to LootData
            AddLootData(player, lootcontainer);
        }
        private void OnEntityTakeDamage(BaseCombatEntity entity, HitInfo hitInfo)
        {
            if (entity == null || hitInfo == null || hitInfo.Initiator == null) return;
            if (entity.GetType().Name.ToLower().Contains("corpse")) return;
            // Ignore if suicide
            if (entity == hitInfo.Initiator) return;
            double blockamount = 0.0;
            bool didblock = false;
            bool diddodge = false;
            var player = entity as BasePlayer;
            if (player != null && player.userID.IsSteamId())
            {
                XPRecord vxprecord = GetXPRecord(player);
                if (vxprecord != null)
                {
                    // If UI open then close
                    DestroyUi(player, XPeriencePlayerControlPrimary);
                    DestroyUi(player, XPeriencePlayerControlFullMain);
                    DestroyUi(player, XPerienceAdminPanelMain);
                    DestroyUi(player, XPerienceTopMain);
                    // Dexterity Armor Reduction
                    if (vxprecord.Dexterity > 0 && player._health > 100)
                    {
                        double defaultdmg = hitInfo.damageTypes.Total();
                        double armordmgreduction = vxprecord.Dexterity * config.dexterity.reducearmordmg;
                        // Ranks
                        if (config.xpLevelRanks.rankskillboost && !vxprecord.DisableRank)
                        {
                            armordmgreduction += vxprecord.rank * config.xpLevelRanks.rankstatboostamount;
                        }
                        hitInfo.damageTypes?.ScaleAll(1 - (float)armordmgreduction);
                        double damgdiff = defaultdmg - hitInfo.damageTypes.Total();
                        if (config.defaultOptions.disablearmorchat)
                        {
                            player.ChatMessage(XPLang("victimarmordmg", player.UserIDString, Math.Round(damgdiff, 2)));
                        }
                    }
                    // Random chance to Block or Dodge
                    double dodgechance = (vxprecord.Dexterity * config.dexterity.dodgechance) * 100;
                    double blockchance = (vxprecord.Dexterity * config.dexterity.blockchance) * 100;
                    int fifty = RandomNumber.Between(0, 101);
                    int roll = RandomNumber.Between(0, 110);
                    // Block
                    if (fifty < 50)
                    {
                        if (vxprecord.Dexterity > 0 && config.dexterity.blockchance != 0 && roll <= blockchance)
                        {
                            didblock = true;
                            double blockdmg = (vxprecord.Dexterity * config.dexterity.blockamount);
                            blockamount = hitInfo.damageTypes.Total() * blockdmg;
                            // Ranks
                            if (config.xpLevelRanks.rankstatboost && !vxprecord.DisableRank)
                            {
                                blockamount += vxprecord.rank * config.xpLevelRanks.rankstatboostamount;
                            }
                            hitInfo.damageTypes?.ScaleAll(1 - (float)blockdmg);
                            // UINotify
                            if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.dodgeblock)
                            {
                                UINotify.Call("SendNotify", player, config.UiNotifier.dodgeblocktype, XPLang("victimblock", player.UserIDString, Math.Round(blockamount)));
                            }
                            // Disable Chats
                            if (!config.UiNotifier.disablechats)
                            {
                                player.ChatMessage(XPLang("victimblock", player.UserIDString, Math.Round(blockamount)));
                            }
                        }
                    }
                    // Dodge
                    if (fifty > 50)
                    {
                        if (vxprecord.Dexterity > 0 && config.dexterity.dodgechance != 0 && roll <= dodgechance)
                        {
                            diddodge = true;
                            hitInfo.damageTypes?.ScaleAll(0);
                            // UINotify
                            if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.dodgeblock)
                            {
                                UINotify.Call("SendNotify", player, config.UiNotifier.dodgeblocktype, XPLang("victimdodge", player.UserIDString));
                            }
                            // Disable Chats
                            if (!config.UiNotifier.disablechats)
                            {
                                player.ChatMessage(XPLang("victimdodge", player.UserIDString));
                            }
                        }
                    }
                }
            }
            var attacker = hitInfo.Initiator as BasePlayer;
            if (attacker == null || !attacker.userID.IsSteamId()) return;
            var KillType = entity?.GetType().Name.ToLower();
            XPRecord xprecord = GetXPRecord(attacker);
            if (xprecord == null) return;
            if (diddodge && attacker)
            {
                if (GetPlayerCooldown(attacker.userID, "notify") != 0)
                {
                    // UINotify
                    if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.dodgeblock)
                    {
                        UINotify.Call("SendNotify", attacker, config.UiNotifier.dodgeblocktype, XPLang("attackerdodge", attacker.UserIDString));
                    }
                    // Disable Chats
                    if (!config.UiNotifier.disablechats)
                    {
                        attacker.ChatMessage(XPLang("attackerdodge", attacker.UserIDString));
                    }
                    _notifyCooldowns[attacker.userID] = CurrentTime + config.defaultOptions.NotifcationCooldown;
                    return;
                }
            }
            if (didblock && attacker)
            {
                if (GetPlayerCooldown(attacker.userID, "notify") != 0)
                {
                    // UINotify
                    if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.dodgeblock)
                    {
                        UINotify.Call("SendNotify", attacker, config.UiNotifier.dodgeblocktype, XPLang("attackerblock", attacker.UserIDString, Math.Round(blockamount)));
                    }
                    // Disable Chats
                    if (!config.UiNotifier.disablechats)
                    {
                        attacker.ChatMessage(XPLang("attackerblock", attacker.UserIDString, Math.Round(blockamount)));
                    }
                    _notifyCooldowns[attacker.userID] = CurrentTime + config.defaultOptions.NotifcationCooldown;
                    return;
                }
            }
            // Hunter Wildlife Increase
            if (KillType == "chicken" || KillType == "boar" || KillType == "stag" || KillType == "wolf" || KillType == "bear" || KillType == "polarbear" || KillType == "horse" || KillType == "ridablehorse" || KillType == "simpleshark")
            {
                double hunterdmg = xprecord.Hunter * config.hunter.damageincrease;
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                {
                    hunterdmg += xprecord.rank * config.xpLevelRanks.rankstatboostamount;
                }
                hitInfo.damageTypes?.ScaleAll(1 + (float)hunterdmg);
            }
            // Hunter Night Wildlife Increase
            if (IsNight() && config.nightBonus.enableskillboosts)
            {
                double nightdmg = xprecord.Hunter * config.hunter.nightdmgincrease;
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                {
                    nightdmg += xprecord.rank * config.xpLevelRanks.rankstatboostamount;
                }
                hitInfo.damageTypes?.ScaleAll(1 + (float)nightdmg);
            }
            // Mentality PVP/NPC and Critical Chance
            if (xprecord.Mentality >= 1)
            {
                if (entity.IsNpc)
                {
                    if (entity.GetType().Name.ToLower().Contains("scientist") || entity.GetType().Name.ToLower().Contains("customscientist") || entity.GetType().Name.ToLower().Contains("dweller") || entity.GetType().Name.ToLower().Contains("scarecrow") || entity.GetType().Name.ToLower().Contains("bradleyapc"))
                    {
                        double pvpnpcbonus = xprecord.Mentality * config.mentality.damageincrease;
                        hitInfo.damageTypes?.ScaleAll(1 + (float)pvpnpcbonus);
                    }
                }
                double critchance = (xprecord.Mentality * config.mentality.criticalchance) * 100;
                if (RandomNumber.Between(0, 101) <= critchance)
                {
                    hitInfo.damageTypes?.ScaleAll(1 + 0.10f);
                    double crithit = Math.Ceiling((int)hitInfo.damageTypes.Total() * 0.10f);
                    // UINotify
                    if (GetPlayerCooldown(attacker.userID, "notify") != 0)
                    {
                        if (UINotify != null && config.UiNotifier.useuinotify && config.UiNotifier.criticalhit)
                        {
                            UINotify.Call("SendNotify", attacker, config.UiNotifier.criticalhittype, XPLang("crithit", attacker.UserIDString, crithit));
                        }
                        // Disable Chats
                        if (!config.UiNotifier.disablechats)
                        {
                            attacker.ChatMessage(XPLang("crithit", attacker.UserIDString, crithit));
                        }
                        _notifyCooldowns[attacker.userID] = CurrentTime + config.defaultOptions.NotifcationCooldown;
                    }
                }
            }
            // Might Melee Increase
            if (xprecord.Might > 0 && hitInfo?.Weapon != null)
            {
                if (hitInfo.Weapon.ShortPrefabName.Contains("knife") ||
                    hitInfo.Weapon.ShortPrefabName.Contains("hatchet") ||
                    hitInfo.Weapon.ShortPrefabName.Contains("club") ||
                    hitInfo.Weapon.ShortPrefabName.Contains("mace") ||
                    hitInfo.Weapon.ShortPrefabName.Contains("pickaxe") ||
                    hitInfo.Weapon.ShortPrefabName.Contains("machete"))
                {
                    double meleeincrease = xprecord.Might * config.might.meleedmg;
                    // Ranks
                    if (config.xpLevelRanks.rankstatboost && !xprecord.DisableRank)
                    {
                        meleeincrease += xprecord.rank * config.xpLevelRanks.rankstatboostamount;
                    }
                    hitInfo.damageTypes?.ScaleAll(1 + (float)meleeincrease);
                }
            }
        }
        private void OnContainerDropItems(ItemContainer lootcontainer)
        {
            if (lootcontainer == null) return;
            var lootentity = lootcontainer.entityOwner as LootContainer;
            if (lootentity == null || lootentity.IsDestroyed) return;
            var player = lootentity.lastAttacker as BasePlayer;
            if (player == null) return;
            // Custom Item Drops
            if (config.scavenger.usecustomscavlist)
            {
                RandomScavengerItem(player);
            }
            // Increase Container Loot
            if (!config.scavenger.drops && config.scavenger.scavmultiplier == 0) return;
            IncreaseLootContainerDrops(lootcontainer);
        }
        private void CanLootEntity(BasePlayer player, LootableCorpse corpse)
        {
            if (player == null || corpse == null) return;
            if (config.scavenger.scientists && corpse.ShortPrefabName.Contains("scientist"))
            {
                if (!_corpseCache.ContainsKey(corpse.net.ID))
                {
                    IncreaseLootCorpse(player, corpse);
                }
                AddCorpseData(player, corpse);
            }
        }
        private void OnEntityKill(BaseMountable entity)
        {
            if (entity == null) return;
            // Boat
            Boat defaultboat;
            var boat = entity?.GetParentEntity() as BaseBoat;
            if (boat != null)
            {
                if (_boatCache.TryGetValue(boat.net.ID, out defaultboat))
                {
                    var captain = FindPlayer(defaultboat.player.ToString());
                    DashPanel(captain, false, 0, 0, "boat");
                    GetFuel(captain, boat, false);
                    GetSpeed(captain, boat, false, "boat");
                }
                _boatCache.Remove(entity.net.ID);
            }           
            // Vehicle
            Vehicle vehicle;
            var car = entity?.VehicleParent() as ModularCar;
            if (car != null)
            {
                if (_vehicleCache.TryGetValue(car.net.ID, out vehicle))
                {
                    var driver = FindPlayer(vehicle.player.ToString());
                    DashPanel(driver, false, 0, 0, "car");
                    GetFuel(driver, car, false);
                    GetSpeed(driver, car, false, "car");
                }
                _vehicleCache.Remove(entity.net.ID);
            }
            // Mini Copter
            Minicopter minicopter;
            var mini = entity?.VehicleParent() as MiniCopter;
            if (mini != null)
            {
                if (_minicopterCache.TryGetValue(mini.net.ID, out minicopter))
                {
                    var pilot = FindPlayer(minicopter.player.ToString());
                    DashPanel(pilot, false, 0, 0, "mini");
                    GetFuel(pilot, mini, false);
                    GetSpeed(pilot, mini, false, "mini");
                }
                _minicopterCache.Remove(entity.net.ID);
            }
        }
        #endregion

        #region Missions
        private void OnMissionSucceeded(BaseMission mission, BasePlayer assignee)
        {
            // Check for null or NPC
            if (assignee == null || !assignee.userID.IsSteamId()) return;
            if (mission == null) return;
            // Give XP
            double addxp = config.xpMissions.missionsucceededxp;
            GainExp(assignee, addxp);
        }
        private void OnMissionFailed(BaseMission mission, BasePlayer assignee)
        {
            // Check for null or NPC
            if (assignee == null || !assignee.userID.IsSteamId()) return;
            if (mission == null) return;
            // Take XP
            double reducexp = config.xpMissions.missionfailedxp;
            LoseExp(assignee, reducexp);
        }
        #endregion

        #region Crafting/Building
        public void CollectIngredient(int item, int amount, List<Item> collect, ItemCrafter itemCrafter, BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            int skilllevel = xprecord.Crafter;
            double craftcost = (config.crafter.craftcost * skilllevel) * amount;
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                craftcost += xprecord.rank * config.xpLevelRanks.rankstatboostamount;
            }
            double newamount = Math.Round(amount - craftcost);
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * newamount;
                newamount = Math.Round(newamount - captaincyboost);
            }
            if (((config.crafter.craftcost * skilllevel) * 100) > 45 && (item == -1938052175 || item == -1581843485))
            {
                craftcost = 0.45 * amount;
                newamount = Math.Round(amount - craftcost);
            }
            if (newamount < 1)
            {
                newamount = 1;
            }
            foreach (ItemContainer container in itemCrafter.containers)
            {
                amount -= container.Take(collect, item, (int)newamount);
                if (amount < 1)
                {
                    amount = 1;
                }
            }
        }
        bool? OnIngredientsCollect(ItemCrafter itemCrafter, ItemBlueprint blueprint, ItemCraftTask task, int amount, BasePlayer player)
        {
            //if (amount == 0 || amount == null) return;
            List<Item> collect = new List<Item>();
            foreach (ItemAmount ingredient in blueprint.ingredients)
                CollectIngredient(ingredient.itemid, (int)ingredient.amount * amount, collect, itemCrafter, player);
            task.potentialOwners = new List<ulong>();
            foreach (Item obj in collect)
            {
                obj.CollectedForCrafting(player);
                if (!task.potentialOwners.Contains(player.userID))
                    task.potentialOwners.Add(player.userID);
            }
            task.takenItems = collect;
            return true;
        }
        private void OnItemCraft(ItemCraftTask task, BasePlayer player)
        {
            if (task.cancelled) return;
            // Ignore keys
            if (task.blueprint.targetItem.shortname.Contains("key") || task.blueprint.name.Contains("(Clone)")) return;
            XPRecord xprecord = GetXPRecord(player);
            int skilllevel = xprecord.Crafter;
            if (skilllevel <= 0) return;
            var craftTime = task.blueprint.time;
            var itemlevel = task.blueprint.workbenchLevelRequired;
            float workbenchinuse = player.currentCraftLevel;
            // Items with no workbench requirement or same as workbench level
            if (itemlevel == workbenchinuse || workbenchinuse == 0)
            {
                double craftspeed = (config.crafter.craftspeed * skilllevel) * task.blueprint.time;
                craftTime = task.blueprint.time - (float)craftspeed;
            }
            // Items with no workbench requirement using level 1,2,3 workbench
            if (workbenchinuse == 1 && itemlevel == 0)
            {
                double craftspeed = (config.crafter.craftspeed * skilllevel) * (task.blueprint.time * 0.5);
                craftTime = task.blueprint.time - (float)craftspeed;
            }
            else if ((workbenchinuse == 2 || workbenchinuse == 3) && itemlevel == 0)
            {
                double craftspeed = (config.crafter.craftspeed * skilllevel) * (task.blueprint.time * 0.75);
                craftTime = task.blueprint.time - (float)craftspeed;
            }
            // Items with workbench requirement level 1
            if (workbenchinuse == 2 && itemlevel == 1)
            {
                double craftspeed = (config.crafter.craftspeed * skilllevel) * (task.blueprint.time * 0.5);
                craftTime = task.blueprint.time - (float)craftspeed;
            }
            else if (workbenchinuse == 3 && itemlevel == 1)
            {
                double craftspeed = (config.crafter.craftspeed * skilllevel) * (task.blueprint.time * 0.75);
                craftTime = task.blueprint.time - (float)craftspeed;
            }
            // Items with workbench requirement level 2
            if (workbenchinuse == 3 && itemlevel == 2)
            {
                double craftspeed = (config.crafter.craftspeed * skilllevel) * (task.blueprint.time * 0.5);
                craftTime = task.blueprint.time - (float)craftspeed;
            }
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * craftTime;
                craftTime = (float)craftTime - (float)captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * craftTime;
                craftTime = (float)craftTime - (float)rankboost;
            }
            task.blueprint = UnityEngine.Object.Instantiate(task.blueprint);
            task.blueprint.time = craftTime;
            return;
        }
        private void OnItemCraftFinished(ItemCraftTask task, Item item)
        {
            if (task == null || item == null) return;
            var player = task.owner.ToPlayer();
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            bool allowxp = true;
            if (config.xpGain.craftingxpdelay && GetPlayerCooldown(player.userID, "craft") != 0)
            {
                allowxp = false;
            }
            if (GetPlayerCooldown(player.userID, "craft") == 0)
            {
                _craftCooldowns[player.userID] = CurrentTime + config.xpGain.craftingxpdelayseconds;
            }
            if (allowxp)
            {
                GainExp(player, config.xpGain.craftingxp);
            }
            int skilllevel = xprecord.Crafter;
            if (skilllevel <= 0 || config.crafter.conditionchance == 0) return;
            double conditionchance = (config.crafter.conditionchance * skilllevel) * 100;
            float tenpercent = (float)(item._maxCondition / (config.crafter.conditionamount * 100));
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * conditionchance;
                conditionchance += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * conditionchance;
                conditionchance += rankboost;
            }
            if (Random.Range(0, 100) <= conditionchance)
            {
                if (item.GetHeldEntity() is BaseProjectile)
                {
                    BaseProjectile projectile = item?.GetHeldEntity() as BaseProjectile;
                    if (projectile == null) return;

                    item._maxCondition += tenpercent;
                    item.condition += tenpercent;
                    projectile.SendNetworkUpdateImmediate();
                    player.ChatMessage(XPLang("weaponcon", player.UserIDString, item.condition));
                }
                else
                {
                    item._maxCondition += tenpercent;
                    item.condition += tenpercent;
                    item.GetHeldEntity()?.SendNetworkUpdateImmediate();
                }
            }
        }
        private object OnItemUse(Item item)
        {
            if (item?.info.shortname != "lowgradefuel") return null;
            var shortName = item.parent?.parent?.info.shortname;
            if (shortName != "hat.candle" && shortName != "hat.miner") return null;
            var player = item.GetRootContainer()?.GetOwnerPlayer();
            XPRecord xprecord = GetXPRecord(player);
            var skilllevel = xprecord.Miner;
            double lessfueltotal = (config.miner.fuelconsumption * skilllevel) * 100;
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * lessfueltotal;
                lessfueltotal += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * lessfueltotal;
                lessfueltotal += rankboost;
            }
            if (Random.Range(0, 110) <= lessfueltotal)
            {
                return 0;
            }
            return null;
        }
        private List<ItemAmount> RepairItems(BasePlayer player, Item item)
        {
            ItemDefinition info = item.info;
            ItemBlueprint component = info.GetComponent<ItemBlueprint>();
            List<ItemAmount> list = Facepunch.Pool.GetList<ItemAmount>();
            RepairBench.GetRepairCostList(component, list);
            return ApplyItemCostReduction(player, list, item);
        }
        private List<ItemAmount> ApplyItemCostReduction(BasePlayer player, List<ItemAmount> list, Item item)
        {
            List<ItemAmount> reducedlist = new List<ItemAmount>();
            var repairCostreduction = RepairBench.RepairCostFraction(item);
            double defaultamount;
            double newamount;
            XPRecord xprecord = GetXPRecord(player);
            int skilllevel = xprecord.Crafter;
            if (skilllevel <= 0) return null;
            foreach (ItemAmount itemAmount in list)
            {
                if (itemAmount.itemDef.category != ItemCategory.Component)
                {
                    defaultamount = Math.Ceiling(itemAmount.amount * repairCostreduction);
                    newamount = Math.Ceiling(defaultamount - (config.crafter.repaircost * xprecord.Crafter) * defaultamount);
                    // Ranks
                    if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                    {
                        double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * newamount;
                        newamount -= Math.Ceiling(rankboost);
                    }
                    if (newamount < 1)
                    {
                        newamount = 1;
                    }
                    itemAmount.amount = (float)newamount;
                    reducedlist.Add(itemAmount);
                }
            }
            return reducedlist;
        }
        private bool PlayerCanRepair(BasePlayer player, List<ItemAmount> list)
        {
            foreach (ItemAmount itemAmount in list)
            {
                int amount = player.inventory.GetAmount(itemAmount.itemDef.itemid);
                if (itemAmount.amount > amount)
                {
                    return false;
                }
            }
            return true;
        }
        private void TakeItems(BasePlayer player, List<ItemAmount> list)
        {
            foreach (ItemAmount itemAmount in list)
            {
                player.inventory.Take((List<Item>)null, itemAmount.itemid, (int)itemAmount.amount);
            }
        }
        private void OnItemRepair(BasePlayer player, Item item)
        {
            if (player == null || item == null) return;
            XPRecord xprecord = GetXPRecord(player);
            int skilllevel = xprecord.Crafter;
            if (skilllevel <= 0) return;
            double repairincrease = (config.crafter.repairincrease * skilllevel) * 100;
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * repairincrease;
                repairincrease += rankboost;
            }
            var list = RepairItems(player, item);
            if (!PlayerCanRepair(player, list))
            {
                player.ChatMessage(XPLang("crafternotenough", player.UserIDString));
                return;
            }
            if (Random.Range(0, 101) <= repairincrease)
            {
                if (item.GetHeldEntity() is BaseProjectile)
                {
                    BaseProjectile projectile = item?.GetHeldEntity() as BaseProjectile;
                    if (projectile == null) return;
                    item.condition = item._maxCondition;
                    projectile.SendNetworkUpdateImmediate();
                    TakeItems(player, list);
                    return;
                }
                else
                {
                    item.condition = item._maxCondition;
                    item.GetHeldEntity()?.SendNetworkUpdateImmediate();
                    TakeItems(player, list);
                    return;
                }
            }
            //TakeItems(player, list);
        }
        private void OnEntityBuilt(Planner plan)
        {
            var player = plan.GetOwnerPlayer();
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            bool allowxp = true;
            double addxp = config.xpBuilding.twigstructure;
            if (config.xpBuilding.buildxpdelay && (GetPlayerCooldown(player.userID, "build") != 0))
            {
                _buildCooldowns[player.userID] = CurrentTime + config.xpBuilding.buildxpdelayseconds;
                allowxp = false;
            }
            _buildCooldowns[player.userID] = CurrentTime + config.xpBuilding.buildxpdelayseconds;
            if (allowxp) GainExp(player, addxp);
        }
        private void OnStructureUpgrade(BuildingBlock buildingBlock, BasePlayer player, BuildingGrade.Enum grade)
        {
            if (buildingBlock == null || player == null) return;
            BuildingPrivlidge isauth = player.GetBuildingPrivilege();
            if (isauth == null || !isauth.IsAuthed(player)) return;
            double addxp = 0;
            bool allowxp = true;
            if (buildingBlock.grade == BuildingGrade.Enum.Twigs)
            {
                addxp = config.xpBuilding.woodstructure;
            }
            if (buildingBlock.grade == BuildingGrade.Enum.Wood)
            {
                addxp = config.xpBuilding.stonestructure;
            }
            if (buildingBlock.grade == BuildingGrade.Enum.Stone)
            {
                addxp = config.xpBuilding.metalstructure;
            }
            if (buildingBlock.grade == BuildingGrade.Enum.Metal)
            {
                addxp = config.xpBuilding.armoredstructure;
            }
            if (buildingBlock.grade == BuildingGrade.Enum.TopTier)
            {
                addxp = config.xpBuilding.armoredstructure;
            }
            if (CanAffordUpgrade(buildingBlock, player, grade))
            {
                if (config.xpBuilding.buildxpdelay && (GetPlayerCooldown(player.userID, "build") != 0))
                {
                    allowxp = false;
                }
                if (GetPlayerCooldown(player.userID, "build") == 0)
                {
                    _buildCooldowns[player.userID] = CurrentTime + config.xpBuilding.buildxpdelayseconds;
                }
                if (allowxp) GainExp(player, addxp);
                RefundMaterials(buildingBlock, player, grade);
            }
        }
        public bool CanAffordUpgrade(BuildingBlock buildingBlock, BasePlayer player, BuildingGrade.Enum grade)
        {
            object building = Interface.CallHook("CanAffordUpgrade", player, buildingBlock, grade);
            if (building is bool)
            {
                return (bool)building;
            }

            bool canupgrade = true;
            foreach (var item in buildingBlock.blockDefinition.grades[(int)grade].costToBuild)
            {
                var missingAmount = item.amount - player.inventory.GetAmount(item.itemid);
                if (missingAmount > 0f)
                {
                    canupgrade = false;
                }
            }
            return canupgrade;
        }
        private void RefundMaterials(BuildingBlock buildingBlock, BasePlayer player, BuildingGrade.Enum grade)
        {
            if (buildingBlock == null || player == null) return;
            if (buildingBlock.OwnerID != player.userID) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.Framer == 0) return;
            var items = buildingBlock.blockDefinition.grades[(int)grade].costToBuild;
            foreach (var item in items)
            {
                double reducedcost = item.amount * (config.framer.upgradecost * xprecord.Framer);
                // Captaincy            
                if (player.Team != null && player.Team.members.Count > 1)
                {
                    double captaincyboost = CaptaincyTeamSkillBoost(player) * reducedcost;
                    reducedcost += captaincyboost;
                }
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                {
                    double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * reducedcost;
                    reducedcost += rankboost;
                }
                if (reducedcost < 1)
                {
                    reducedcost = 1;
                }
                player.GiveItem(ItemManager.CreateByItemID(item.itemid, (int)reducedcost));
            }
        }
        private void OnStructureRepair(BaseCombatEntity entity, BasePlayer player)
        {
            if (entity == null || player == null) return;
            BuildingPrivlidge isauth = player.GetBuildingPrivilege();
            if (isauth == null || !isauth.IsAuthed(player)) return;
            XPRecord xprecord = GetXPRecord(player);
            int skilllevel = xprecord.Framer;
            if (skilllevel == 0) return;
            double repairtime = config.framer.repairtime;
            double repaircost = config.framer.repaircost;

            // Reduce Repair Time
            entity.lastAttackedTime = (float)(entity.lastAttackedTime - (repairtime * skilllevel));
            if (entity.SecondsSinceAttacked < 30) return;

            // Reduce Repair Cost
            float missingHealth = entity.MaxHealth() - entity.health;
            float healthPercentage = missingHealth / entity.MaxHealth();
            if (missingHealth <= 0f || healthPercentage <= 0f)
            {
                entity.OnRepairFailed(null, string.Empty);
                return;
            }

            List<ItemAmount> itemAmounts = entity.RepairCost(healthPercentage);
            if (itemAmounts.Sum(x => x.amount) <= 0f)
            {
                entity.health += missingHealth;
                entity.SendNetworkUpdate();
                entity.OnRepairFinished();
                return;
            }

            foreach (ItemAmount amount in itemAmounts)
            {
                if (amount.amount > 40f)
                {
                    amount.amount = 40f;
                }
                amount.amount = (float)(amount.amount * (repaircost * skilllevel));
                // Captaincy
                if (player.Team != null && player.Team.members.Count > 1)
                {
                    double captaincyboost = CaptaincyTeamSkillBoost(player) * amount.amount;
                    amount.amount += (float)captaincyboost;
                }
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                {
                    double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * amount.amount;
                    amount.amount += (float)rankboost;
                }
            }

            if (itemAmounts.Any(ia => player.inventory.GetAmount(ia.itemid) < (int)ia.amount))
            {
                entity.OnRepairFailed(null, string.Empty);
                return;
            }

            foreach (ItemAmount amount in itemAmounts)
            {
                if (amount.amount < 1) return;
                Item item = ItemManager.CreateByItemID(amount.itemid, (int)amount.amount);
                player.GiveItem(item);
            }
        }
        private void OnFuelConsume(BaseOven oven, Item fuel, ItemModBurnable burnable)
        {
            if (oven == null || fuel == null) return;
            var player = FindPlayer(oven.OwnerID.ToString());
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.Smithy <= 0) return;
            // Fuel Consumption
            if (player.UserIDString == oven.OwnerID.ToString())
            {
                double lessfueltotal = (config.smithy.fuelconsumption * xprecord.Smithy) * 100;
                // Captaincy
                if (player.Team != null && player.Team.members.Count > 1)
                {
                    double captaincyboost = CaptaincyTeamSkillBoost(player) * lessfueltotal;
                    lessfueltotal += captaincyboost;
                }
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                {
                    double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * lessfueltotal;
                    lessfueltotal += rankboost;
                }
                if (Random.Range(0, 100) <= lessfueltotal)
                {
                    fuel.amount += 1;
                }
            }
            // Production Rate
            double increasechance = (config.smithy.productionrate * xprecord.Smithy) * 100;
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboostincreasechance = CaptaincyTeamSkillBoost(player) * increasechance;
                increasechance += captaincyboostincreasechance;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * increasechance;
                increasechance += rankboost;
            }
            var items = oven.inventory.itemList.ToArray();
            foreach (var item in items)
            {
                if (Random.Range(0, 100) < increasechance)
                {
                    double increaseamount = Math.Round((config.smithy.productionrate * xprecord.Smithy) * 5);
                    // Ranks
                    if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                    {
                        double rankboostin = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * increaseamount;
                        increaseamount += Math.Ceiling(rankboostin);
                    }
                    var itemModCookable = item.info.GetComponent<ItemModCookable>();
                    if (itemModCookable?.becomeOnCooked == null || item.temperature < itemModCookable.lowTemp || item.temperature > itemModCookable.highTemp || itemModCookable.cookTime < 0) continue;
                    if (oven.inventory.Take(null, item.info.itemid, 1) != 1) continue;
                    var itemToGive = ItemManager.Create(itemModCookable.becomeOnCooked, (1 + (int)increaseamount));
                    if (!itemToGive.MoveToContainer(oven.inventory))
                        itemToGive.Drop(oven.inventory.dropPosition, oven.inventory.dropVelocity);
                }
            }
        }
        #endregion

        #region Plants/Trees/Ores/Food
        private void OnDispenserGather(ResourceDispenser dispenser, BaseEntity entity, Item item)
        {
            var player = entity.ToPlayer();
            if (player == null || !player.userID.IsSteamId() || dispenser == null || entity == null || item == null) return;
            XPRecord xprecord = GetXPRecord(player);
            var gatherType = dispenser.gatherType;
            double addxp = 0;
            int skilllevel = 0;
            double gatherincrease = 0;
            int apples = 100;
            double metal = 100;
            var tool = player.GetActiveItem().ToString().ToLower();
            if (gatherType == ResourceDispenser.GatherType.Tree)
            {
                addxp = config.xpGather.treexp;
                double toolxpchance = config.xpGather.toolxpchance * 100;
                if (!config.xpGather.noxptools && tool.Contains("chainsaw"))
                {
                    if ((Random.Range(0, 101) <= toolxpchance) == true)
                    { addxp = config.xpGather.toolxppercent * config.xpGather.treexp; }
                    else
                    { 
                        addxp = 0; 
                    }
                    apples = 1;
                }
                else if (config.xpGather.noxptools && tool.Contains("chainsaw") || config.xpGather.onetimexp)
                {
                    addxp = 0;
                    apples = 1;
                }
                gatherincrease = config.woodcutter.gatherrate;
                skilllevel = xprecord.WoodCutter;
                double chance = (config.woodcutter.applechance * skilllevel) * apples;
                if ((Random.Range(0, 101) <= chance) == true)
                {
                    var roll = Random.Range(0, 11);
                    if (roll < 5)
                    {
                        // Bad
                        player.Command("note.inv", 352130972, 1.ToString());
                        ItemManager.CreateByName("apple.spoiled", 1)?.DropAndTossUpwards(entity.GetDropPosition());
                        player.RunEffect("assets/bundled/prefabs/fx/notice/loot.drag.itemdrop.fx.prefab");
                    }
                    if (roll > 5)
                    {
                        // good
                        player.Command("note.inv", 1548091822, 1.ToString());
                        ItemManager.CreateByName("apple", 1)?.DropAndTossUpwards(entity.GetDropPosition());
                        player.RunEffect("assets/bundled/prefabs/fx/notice/loot.drag.itemdrop.fx.prefab");
                    }
                }
            }
            else if (gatherType == ResourceDispenser.GatherType.Ore)
            {
                addxp = config.xpGather.orexp;
                double toolxpchance = config.xpGather.toolxpchance * 100;
                if (!config.xpGather.noxptools && tool.Contains("jackhammer"))
                {
                    if ((Random.Range(0, 101) <= toolxpchance) == true)
                    {
                        addxp = config.xpGather.toolxppercent * config.xpGather.orexp;
                    }
                    else
                    { 
                        addxp = 0; 
                    }
                    metal = 0.1;
                }
                else if (config.xpGather.noxptools && tool.Contains("jackhammer") || config.xpGather.onetimexp)
                {
                    addxp = 0;
                    metal = 0.1;
                }
                gatherincrease = config.miner.gatherrate;
                skilllevel = xprecord.Miner;
                if (item.info.shortname.Contains("metal") && skilllevel > 0)
                {
                    double metalchance = (skilllevel * config.miner.metalchance) * metal;
                    int metalamount = skilllevel * config.miner.metalamount;
                    // Ranks
                    if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                    {
                        double rankboostfragchance = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * metalchance;
                        int rankboostfragamt = (int)Math.Ceiling((xprecord.rank * config.xpLevelRanks.rankstatboostamount) * metalamount);
                        metalchance += rankboostfragchance;
                        metalamount += rankboostfragamt;
                    }
                    if ((Random.Range(0, 101) <= metalchance) == true)
                    {
                        player.Command("note.inv", 69511070, metalamount.ToString());
                        ItemManager.CreateByName("metal.fragments", metalamount)?.DropAndTossUpwards(entity.GetDropPosition());
                        player.RunEffect("assets/bundled/prefabs/fx/notice/loot.drag.itemdrop.fx.prefab");
                    }
                }
                if (item.info.shortname.Contains("metal") && xprecord.Smithy > 0)
                {
                    double hmetalchance = (xprecord.Smithy * config.smithy.metalchance) * metal;
                    int hmetalamount = xprecord.Smithy * config.smithy.metalamount;
                    // Ranks
                    if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                    {
                        double rankboostmetalchance = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * hmetalchance;
                        int rankboostmetalamt = (int)Math.Ceiling((xprecord.rank * config.xpLevelRanks.rankstatboostamount) * hmetalamount);
                        hmetalchance += rankboostmetalchance;
                        hmetalamount += rankboostmetalamt;
                    }
                    if ((Random.Range(0, 101) <= hmetalchance) == true)
                    {
                        player.Command("note.inv", 317398316, hmetalamount.ToString());
                        ItemManager.CreateByName("metal.refined", hmetalamount)?.DropAndTossUpwards(entity.GetDropPosition());
                        player.RunEffect("assets/bundled/prefabs/fx/notice/loot.drag.itemdrop.fx.prefab");
                    }
                }
            }
            else if (gatherType == ResourceDispenser.GatherType.Flesh || item.info.shortname == "cactusflesh")
            {
                addxp = config.xpGather.harvestxp;
                gatherincrease = config.hunter.gatherrate;
                skilllevel = xprecord.Hunter;
            }
            double results = item.amount + (item.amount * (gatherincrease * skilllevel));
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * results;
                results += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * results;
                results += rankboost;
            }
            if (skilllevel >= 1)
            {
                item.amount = (int)results;
            }
            GainExp(player, addxp);
            // Harvest Tracking
            if(item.info.shortname.Contains("wood"))
            {
                HarvestRecord(player, "wood", (int)results);
            }
            if(item.info.shortname.Contains("stone"))
            {
                HarvestRecord(player, "stone", (int)results);
            }
            if(item.info.shortname.Contains("metal"))
            {
                HarvestRecord(player, "metal", (int)results);
            }
            if(item.info.shortname.Contains("sulfur"))
            {
                HarvestRecord(player, "sulfur", (int)results);
            }
            if(item.info.shortname.Contains("cactus"))
            {
                HarvestRecord(player, "cactus", (int)results);
            }
        }
        private void OnDispenserBonus(ResourceDispenser dispenser, BasePlayer player, Item item)
        {
            if (player == null || !player.userID.IsSteamId() || dispenser == null || item == null) return;
            XPRecord xprecord = GetXPRecord(player);
            var gatherType = dispenser.gatherType;
            double addxp = 0;
            int skilllevel = 0;
            double bonus = 0;
            double increaseamount;

            if (gatherType == ResourceDispenser.GatherType.Tree)
            {
                addxp = config.xpGather.treexp;
                bonus = config.woodcutter.bonusincrease;
                skilllevel = xprecord.WoodCutter;
            }
            else if (gatherType == ResourceDispenser.GatherType.Ore)
            {
                addxp = config.xpGather.orexp;
                bonus = config.miner.bonusincrease;
                skilllevel = xprecord.Miner;
            }
            else if (gatherType == ResourceDispenser.GatherType.Flesh || item.info.shortname == "cactusflesh")
            {
                addxp = config.xpGather.harvestxp;
                bonus = config.hunter.bonusincrease;
                skilllevel = xprecord.Hunter;
            }
            increaseamount = item.amount + (item.amount * (bonus * skilllevel));
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * increaseamount;
                increaseamount += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * increaseamount;
                increaseamount += rankboost;
            }
            if (skilllevel >= 1)
            {
                item.amount = (int)increaseamount;
            }
            GainExp(player, addxp);
            // Harvest Tracking
            if (item.info.shortname.Contains("wood"))
            {
                HarvestRecord(player, "wood", (int)increaseamount);
            }
            if (item.info.shortname.Contains("stone"))
            {
                HarvestRecord(player, "stone", (int)increaseamount);
            }
            if (item.info.shortname.Contains("metal"))
            {
                HarvestRecord(player, "metal", (int)increaseamount);
            }
            if (item.info.shortname.Contains("sulfur"))
            {
                HarvestRecord(player, "sulfur", (int)increaseamount);
            }
            if (item.info.shortname.Contains("cactus"))
            {
                HarvestRecord(player, "cactus", (int)increaseamount);
            }
        }
        private void OnCollectiblePickup(Item item, BasePlayer player, CollectibleEntity entity)
        {
            if (player == null || !player.userID.IsSteamId() || item == null) return;
            XPRecord xprecord = GetXPRecord(player);
            double addxp = 0;
            double gatherincrease = config.forager.gatherrate;
            int skilllevel = xprecord.Forager;
            var name = item.info.shortname;
            // Seeds
            if (name.StartsWith("seed"))
            {
                double chance = (config.forager.chanceincrease * skilllevel) * 100;
                if ((Random.Range(0, 100) <= chance) == true)
                {
                    double addseeds = (config.forager.chanceincrease * skilllevel) * 10;
                    if (addseeds <= 1)
                    {
                        addseeds = 1;
                    }
                    item.amount += (int)addseeds;
                }
            }
            // Random Item
            double itemchance = (config.forager.randomchance * skilllevel) * 100;
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboostitem = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * itemchance;
                itemchance += rankboostitem;
            }
            if ((Random.Range(0, 100) <= itemchance) == true)
            {
                int randomroll = Random.Range(1, config.forager.randomChanceList.Count);
                var selected = config.forager.randomChanceList[randomroll];
                ItemDefinition definition = ItemManager.FindItemDefinition(selected.shortname);
                if (definition == null)
                {
                    Puts($"invalid shortname in config (forager) for item number {selected}");
                }
                player.Command("note.inv", definition.itemid, selected.amount);
                ItemManager.CreateByName(selected.shortname, selected.amount)?.DropAndTossUpwards(player.GetDropPosition());
                player.RunEffect("assets/bundled/prefabs/fx/notice/loot.drag.itemdrop.fx.prefab");
            }
            // XP / Gather Rate
            if (name.Contains("wood"))
            {
                addxp = config.xpGather.treexp;
            }
            else if (name.Contains("ore") || name.Contains("stone"))
            {
                addxp = config.xpGather.orexp;
            }
            else if (name.Contains("berry") || name == "mushroom" || name == "cloth" || name == "pumpkin" || name == "corn" || name == "potato")
            {
                addxp = config.xpGather.plantxp;
            }
            double results = item.amount + (item.amount * (gatherincrease * skilllevel));
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * results;
                results += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * results;
                results += rankboost;
            }
            if (skilllevel >= 1)
            {
                if (results <= 1.5 && gatherincrease != 0)
                {
                    item.amount = 2;
                }
                else
                {
                    item.amount = (int)results;
                }
            }
            GainExp(player, addxp);
            // Harvest Tracking
            if (name.Contains("wood"))
            {
                HarvestRecord(player, "wood", (int)results);
            }
            if (name.Contains("stone"))
            {
                HarvestRecord(player, "stone", (int)results);
            }
            if (name.Contains("metal"))
            {
                HarvestRecord(player, "metal", (int)results);
            }
            if (name.Contains("sulfur"))
            {
                HarvestRecord(player, "sulfur", (int)results);
            }
            if (name.Contains("cactus"))
            {
                HarvestRecord(player, "cactus", (int)results);
            }
            if (name.Contains("berry") && !name.Contains("seed"))
            {
                HarvestRecord(player, "berries", (int)results);
            }
            if (name.Contains("seed") && !name.Contains("berry"))
            {
                HarvestRecord(player, "seed", (int)results);
            }
            if (name.Contains("mushroom"))
            {
                HarvestRecord(player, "mushroom", (int)results);
            }
            if (name.Contains("cloth"))
            {
                HarvestRecord(player, "hemp", (int)results);
            }
            if (name.Contains("pumpkin"))
            {
                HarvestRecord(player, "pumpkin", (int)results);
            }
            if (name.Contains("corn"))
            {
                HarvestRecord(player, "corn", (int)results);
            }
            if (name.Contains("potato"))
            {
                HarvestRecord(player, "potato", (int)results);
            }
        }
        private void OnGrowableGathered(GrowableEntity growable, Item item, BasePlayer player)
        {
            if (player == null || !player.userID.IsSteamId() || growable == null || item == null) return;
            XPRecord xprecord = GetXPRecord(player);
            double addxp = 0;
            double gatherincrease = config.forager.gatherrate;
            int skilllevel = xprecord.Forager;
            var name = item.info.shortname;
            if (name.StartsWith("seed"))
            {
                double chance = (config.forager.chanceincrease * skilllevel) * 100;
                if ((Random.Range(0, 100) <= chance) == true)
                {
                    double addseeds = (config.forager.chanceincrease * skilllevel) * 2;
                    if (addseeds <= 1)
                    {
                        addseeds = 1;
                    }
                    item.amount += (int)addseeds;
                }
                return;
            }
            if (name.Contains("wood"))
            {
                addxp = config.xpGather.treexp;
            }
            if (name.Contains("berry") || name.Contains("clone") || name == "mushroom" || name == "cloth" || name == "pumpkin" || name == "corn" || name == "potato")
            {
                addxp = config.xpGather.plantxp;
            }
            //double results = item.amount * (gatherincrease * skilllevel);
            double results = item.amount + (item.amount * (gatherincrease * skilllevel));
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * results;
                results += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * results;
                results += rankboost;
            }
            if (skilllevel >= 1)
            {
                if (results <= 1.5 && gatherincrease != 0)
                {
                    item.amount = 2;
                }
                else
                {
                    item.amount = (int)results;
                }
            }
            GainExp(player, addxp);
            // Harvest Tracking
            if (name.Contains("wood"))
            {
                HarvestRecord(player, "wood", (int)results);
            }
            if (name.Contains("cactus"))
            {
                HarvestRecord(player, "cactus", (int)results);
            }
            if (name.Contains("berry") && !name.Contains("seed"))
            {
                HarvestRecord(player, "berries", (int)results);
            }
            if (name.Contains("seed") && !name.Contains("berry"))
            {
                HarvestRecord(player, "seed", (int)results);
            }
            if (name.Contains("mushroom"))
            {
                HarvestRecord(player, "mushroom", (int)results);
            }
            if (name.Contains("cloth"))
            {
                HarvestRecord(player, "hemp", (int)results);
            }
            if (name.Contains("pumpkin"))
            {
                HarvestRecord(player, "pumpkin", (int)results);
            }
            if (name.Contains("corn"))
            {
                HarvestRecord(player, "corn", (int)results);
            }
            if (name.Contains("potato"))
            {
                HarvestRecord(player, "potato", (int)results);
            }
        }
        #endregion

        #region Stat & Skill Hooks/Helpers
        private readonly Dictionary<Rarity, int> rarityValues = new Dictionary<Rarity, int>
        {
            {Rarity.None, 500},
            {Rarity.Common, 20},
            {Rarity.Uncommon, 75},
            {Rarity.Rare, 125},
            {Rarity.VeryRare, 500},
        };
        private object OnResearchCostDetermine(Item item, ResearchTable researchTable)
        {
            int rarityvalue = item.info != null ? rarityValues[item.info.rarity] : 500;
            if (config.mentality.researchcost == 0) return rarityvalue;
            if (researchTable == null || researchTable.user == null) return rarityvalue;
            XPRecord xprecord = GetXPRecord(researchTable.user);
            if (xprecord.Mentality == 0 || xprecord == null) return rarityvalue;
            double reducecost = (config.mentality.researchcost * xprecord.Mentality) * rarityvalue;
            // Captaincy
            if (researchTable.user.Team != null && researchTable.user.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(researchTable.user) * reducecost;
                reducecost += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * reducecost;
                reducecost += rankboost;
            }
            double researchcost = rarityvalue - reducecost;
            return (int)researchcost;
        }
        [HookMethod("OnResearchCost")]
        private int OnResearchCost(int rarityvalue, BasePlayer player)
        {
            if (player == null)
            {
                return rarityvalue;
            }
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.Mentality == 0) return rarityvalue;
            double reducecost = (config.mentality.researchcost * xprecord.Mentality) * rarityvalue;
            double researchcost = rarityvalue - reducecost;
            return (int)researchcost;
        }
        [HookMethod("OnItemResearchReduction")]
        private float OnItemResearchReduction(float value, BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null || xprecord.Mentality == 0) return value;
            double researchspeed = (config.mentality.researchspeed * xprecord.Mentality) * value;
            return value - (float)researchspeed;
        }
        private bool CheckUnlockPath(BasePlayer player, TechTreeData.NodeInstance node, TechTreeData techTree)
        {
            if (node.inputs.Count == 0) return true;
            var unlockPath = false;

            foreach (int nodeId in node.inputs)
            {
                var selectNode = techTree.GetByID(nodeId);
                if (selectNode.itemDef == null) return true;

                if (!techTree.HasPlayerUnlocked(player, selectNode)) continue;

                if (CheckUnlockPath(player, selectNode, techTree))
                    unlockPath = true;
            }

            return unlockPath;
        }
        private object CanUnlockTechTreeNode(BasePlayer player, TechTreeData.NodeInstance node, TechTreeData techTree)
        {
            if (player == null) return null;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null || xprecord.Mentality == 0) return null;
            int rarityvalue = rarityValues[node.itemDef.rarity];
            double reducecost = (config.mentality.researchcost * xprecord.Mentality) * rarityvalue;
            double researchcost = rarityvalue - reducecost;
            var cost = (int)researchcost;

            var itemdefinition = ItemManager.FindItemDefinition("scrap");
            techTree.GetEntryNode().costOverride = cost;

            if (player.inventory.GetAmount(itemdefinition.itemid) < cost)
            {
                player.ChatMessage(XPLang("techtreenode", player.UserIDString, cost, node.itemDef.displayName.english));
                return false;
            }

            return CheckUnlockPath(player, node, techTree);
        }
        private object OnTechTreeNodeUnlock(Workbench workbench, TechTreeData.NodeInstance node, BasePlayer player)
        {
            if (workbench == null || player == null) return null;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null || xprecord.Mentality == 0) return null;
            int rarityvalue = rarityValues[node.itemDef.rarity];
            double reducecost = (config.mentality.researchcost * xprecord.Mentality) * rarityvalue;
            double researchcost = rarityvalue - reducecost;
            var cost = (int)researchcost;
            int itemid = ItemManager.FindItemDefinition("scrap").itemid;
            player.inventory.Take((List<Item>)null, itemid, cost);
            player.blueprints.Unlock(node.itemDef);
            Interface.CallHook("OnTechTreeNodeUnlocked", workbench, node, player);
            return false;
        }
        private void OnItemResearch(ResearchTable table, Item targetItem, BasePlayer player)
        {
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            double researchspeed = (config.mentality.researchspeed * xprecord.Mentality) * table.researchDuration;
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * researchspeed;
                researchspeed += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * researchspeed;
                researchspeed += rankboost;
            }
            table.researchDuration -= (float)researchspeed;
        }
        private object OnPlayerAddModifiers(BasePlayer player, Item item, ItemModConsumable consumable)
        {
            // Update LiveUI for Armor
            if (item.info.shortname.Contains("maxhealthtea"))
            {
                LiveStats(player, true, item.info.shortname);
            }
            // Medic Skill Increase
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return null;
            if (xprecord.Medic <= 0) return null;
            string tea = item.info.shortname;
            double addhealth = xprecord.Medic * config.medic.teas;
            if (tea == "healingtea")
            {
                addhealth = 30 * addhealth;
            }
            if (tea == "healingtea.advanced")
            {
                addhealth = 50 * addhealth;
            }
            if (tea == "healingtea.pure")
            {
                addhealth = 75 * addhealth;
            }
            player._health += (float)addhealth;
            return null;
        }
        private void PlayerArmor(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            if (xprecord.Might < 0) return;
            var maxarmor = 100 + ((xprecord.Might * config.might.armor) * 100);
            player._maxHealth = (float)maxarmor;
            LiveStats(player, true);
        }
        private void MightAttributes(BasePlayer player)
        {
            if (player == null || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(player);

            if (xprecord.Might > 0)
            {
                // Increase Hunger Max - Reset to default then calculate new max
                player.metabolism.calories.max = 500;
                double maxcalories = (config.might.metabolism * xprecord.Might) * player.metabolism.calories.max;
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                {
                    maxcalories += xprecord.rank * config.xpLevelRanks.rankstatboostamount;
                }
                player.metabolism.calories.max += (float)maxcalories;
                // Increase Thirst Max - Reset to default then calculate new max
                player.metabolism.hydration.max = 250;
                double maxhydration = (config.might.metabolism * xprecord.Might) * player.metabolism.hydration.max;
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                {
                    maxhydration += xprecord.rank * config.xpLevelRanks.rankstatboostamount;
                }
                player.metabolism.hydration.max += (float)maxhydration;
            }
        }
        private void OnRunPlayerMetabolism(PlayerMetabolism metabolism, BasePlayer player, float delta)
        {
            if (player == null || metabolism == null || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            if (xprecord.Might > 0)
            {
                // Reduce Bleeding
                if (metabolism.bleeding.value > 0)
                {
                    metabolism.bleeding.value -= (((float)config.might.bleedreduction * xprecord.Might) * metabolism.bleeding.value);
                }
                // Reduce Radiation
                if (metabolism.radiation_level.value > 0)
                {
                    metabolism.radiation_level.value -= (((float)config.might.radreduction * xprecord.Might) * metabolism.radiation_level.value);
                }
                // Heat Reduction
                if (metabolism.temperature.value > PlayerMetabolism.HotThreshold)
                {
                    metabolism.temperature.value -= (((float)config.might.heattolerance * xprecord.Might) * 20);
                }
                // Cold Reduction
                if (metabolism.temperature.value < PlayerMetabolism.ColdThreshold)
                {
                    metabolism.temperature.value += (((float)config.might.coldtolerance * xprecord.Might) * 20);
                }
            }
            // Fisher
            if (xprecord.Fisher > 0 && metabolism.oxygen.value < 1)
            {
                metabolism.oxygen.value += (((float)config.fisher.oxygenreduction * xprecord.Fisher) * 0.1f);
            }
        }
        private void OnHealingItemUse(MedicalTool tool, BasePlayer player)
        {
            if (player == null || !player.userID.IsSteamId() || tool == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.Medic <= 0) return;
            double addhealth = xprecord.Medic * config.medic.tools;
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * addhealth;
                addhealth += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * addhealth;
                addhealth += rankboost;
            }
            player._health = (float)(player._health + addhealth);
            var toolused = tool.GetType().Name;
            player.ChatMessage(XPLang("medictooluse", player.UserIDString, addhealth, toolused));
            return;
        }
        private void OnPlayerRevive(BasePlayer reviver, BasePlayer player)
        {
            if (reviver == null || !reviver.userID.IsSteamId() || player == null || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(reviver);
            double addxp = config.xpGain.playerrevive;
            GainExp(reviver, addxp);
            if (xprecord.Medic <= 0) return;
            double addhealth = xprecord.Medic * config.medic.revivehp;
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * addhealth;
                addhealth += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * addhealth;
                addhealth += rankboost;
            }
            player._health = (float)(player._health + addhealth);
            player.ChatMessage(XPLang("medicreviveplayer", player.UserIDString, addhealth));
            reviver.ChatMessage(XPLang("medicrevivereviver", reviver.UserIDString, addhealth));
        }
        private void OnPlayerRecovered(BasePlayer player)
        {
            if (player == null || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.Medic <= 0) return;
            double addhealth = xprecord.Medic * config.medic.revivehp;
            // Captaincy
            if (player.Team != null && player.Team.members.Count > 1)
            {
                double captaincyboost = CaptaincyTeamSkillBoost(player) * addhealth;
                addhealth += captaincyboost;
            }
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * addhealth;
                addhealth += rankboost;
            }
            player._health = (float)(player._health + addhealth);
            player.ChatMessage(XPLang("medicrecoverplayer", player.UserIDString, addhealth));
        }
        private void OnMixingTableToggle(MixingTable table, BasePlayer player)
        {
            if (table.IsOn()) return;
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            if (xprecord.Medic > 0)
            {
                NextTick(() =>
                {
                    double reducetotal = (xprecord.Medic * config.medic.crafttime) * table.TotalMixTime;
                    double reduceremaining = (xprecord.Medic * config.medic.crafttime) * table.TotalMixTime;
                    table.TotalMixTime -= (float)reducetotal;
                    table.RemainingMixTime -= (float)reduceremaining;
                    table.SendNetworkUpdateImmediate();
                });
            }
        }
        private double CaptaincyTeamSkillBoost(BasePlayer player)
        {
            if (!CaptaincyTeamDistance(player) || player == null || !player.userID.IsSteamId() || player.Team == null || player.Team.members.Count <= 1) return 0;
            foreach (var team in player.Team.members)
            {
                if (team == player.userID) continue;
                BasePlayer teammember = RelationshipManager.FindByID(team);
                XPRecord teamxprecord = GetXPRecord(teammember);
                if (teamxprecord.Captaincy <= 0) continue;
                double skillboost = teamxprecord.Captaincy * config.captaincy.skillboost;
                return skillboost;
            }
            return 0;
        }
        private double CaptaincyTeamXPBoost(BasePlayer player)
        {
            if (!CaptaincyTeamDistance(player) || player == null || !player.userID.IsSteamId() || player.Team == null || player.Team.members.Count <= 1) return 0;
            foreach (var team in player.Team.members)
            {
                if (team == player.userID) continue;
                BasePlayer teammember = RelationshipManager.FindByID(team);
                XPRecord teamxprecord = GetXPRecord(teammember);
                if (teamxprecord.Captaincy <= 0) continue;
                double addxp = (teamxprecord.Captaincy * config.captaincy.xpboost);
                return addxp;
            }
            return 0;
        }
        private bool CaptaincyTeamDistance(BasePlayer player)
        {
            if (player == null || !player.userID.IsSteamId() || player.Team == null || player.Team.members.Count <= 1) return false;
            foreach (var team in player.Team.members)
            {
                if (team == player.userID) continue;
                BasePlayer teammember = RelationshipManager.FindByID(team);
                if (teammember == null || !teammember.IsConnected) continue;
                XPRecord teamxprecord = GetXPRecord(teammember);
                if (teamxprecord.Captaincy <= 0) continue;
                float teamdistance = teamxprecord.Captaincy * config.captaincy.captaincydistance;
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !teamxprecord.DisableRank)
                {
                    double rankboost = (teamxprecord.rank * config.xpLevelRanks.rankstatboostamount) * teamdistance;
                    teamdistance += (float)rankboost;
                }
                if (Vector3.Distance(player.transform.position, teammember.transform.position) >= teamdistance) continue;
                return true;
            }
            return false;
        }
        private void RandomScavengerItem(BasePlayer player)
        {
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null || xprecord.Scavenger <= 0) return;
            var scavChanceLists = new Dictionary<int, ScavChanceList>();
            int number = 0;
            foreach (var item in config.scavenger.scavChanceList)
            {
                if (item.Value.requiredlevel <= xprecord.Scavenger)
                {
                    scavChanceLists.Add(number, item.Value);
                    number++;
                }
            }
            double scavchance = (config.scavenger.scavchance * xprecord.Scavenger) * 100;
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboostchance = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * scavchance;
                scavchance += rankboostchance;
            }
            if ((Random.Range(0, 101) <= scavchance) == true)
            {
                int scavroll = Random.Range(0, scavChanceLists.Count);
                var scavitem = scavChanceLists[scavroll];
                ItemDefinition definition = ItemManager.FindItemDefinition(scavitem.shortname);
                if (definition == null)
                {
                    Puts($"invalid shortname in config (scavenger) for item number {scavitem}");
                }
                var scavmultiplier = Math.Ceiling(xprecord.Scavenger * (scavitem.amount * config.scavenger.customscavmultiplier));
                if (config.scavenger.customscavrandom)
                {
                    scavmultiplier = Random.Range(scavitem.amount, (float)scavmultiplier);
                }
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                {
                    double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * scavmultiplier;
                    scavmultiplier += rankboost;
                }
                if (scavmultiplier > scavitem.maxamount)
                {
                    scavmultiplier = scavitem.maxamount;
                }
                ItemManager.CreateByName(scavitem.shortname, (int)scavmultiplier)?.DropAndTossUpwards(player.GetDropPosition());
            }
        }
        private void IncreaseLootContainers(BasePlayer player, LootContainer lootcontainer)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.Scavenger <= 0) return;
            double scavlootchance = (config.scavenger.scavlootchance * xprecord.Scavenger) * 100;
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboostchance = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * scavlootchance;
                scavlootchance += rankboostchance;
            }
            if ((Random.Range(0, 101) <= scavlootchance) == true)
            {
                if (lootcontainer.inventory == null) return;
                lootcontainer.inventory.itemList.ForEach(item =>
                {
                    if (config.scavenger.componentsonly)
                    {
                        if (item != null && item.info.category == ItemCategory.Component)
                        {
                            int newamount = (int)Math.Ceiling((xprecord.Scavenger * config.scavenger.scavmultiplier) * item.amount);
                            // Ranks
                            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                            {
                                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * newamount;
                                newamount += (int)Math.Ceiling(rankboost);
                            }
                            item.amount = newamount;
                        }
                    }
                    else
                    {
                        if (item != null)
                        {
                            int newamount = (int)Math.Ceiling((xprecord.Scavenger * config.scavenger.scavmultiplier) * item.amount);
                            // Ranks
                            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                            {
                                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * newamount;
                                newamount += (int)Math.Ceiling(rankboost);
                            }
                            item.amount = newamount;
                        }
                    }
                });
            }
        }
        private void IncreaseLootContainerDrops(ItemContainer lootcontainer)
        {
            if (lootcontainer == null) return;
            var lootentity = lootcontainer.entityOwner as LootContainer;
            if (lootentity == null || lootentity.IsDestroyed) return;
            var player = lootentity.lastAttacker as BasePlayer;
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null || xprecord.Scavenger <= 0) return;
            double scavlootchance = (config.scavenger.scavlootchance * xprecord.Scavenger) * 100;
            // Ranks
            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
            {
                double rankboostchance = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * scavlootchance;
                scavlootchance += rankboostchance;
            }
            if ((Random.Range(0, 101) <= scavlootchance) == true)
            {
                lootcontainer.itemList.ForEach(item =>
                {
                    if (config.scavenger.componentsonly)
                    {
                        if (item != null && item.info.category == ItemCategory.Component)
                        {
                            int newamount = (int)Math.Ceiling((xprecord.Scavenger * config.scavenger.scavmultiplier) * item.amount);
                            // Ranks
                            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                            {
                                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * newamount;
                                newamount += (int)Math.Ceiling(rankboost);
                            }
                            item.amount = newamount;
                        }
                    }
                    else
                    {
                        if (item != null)
                        {
                            int newamount = (int)Math.Ceiling((xprecord.Scavenger * config.scavenger.scavmultiplier) * item.amount);
                            // Ranks
                            if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                            {
                                double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * newamount;
                                newamount += (int)Math.Ceiling(rankboost);
                            }
                            item.amount = newamount;
                        }
                    }
                });
            }
        }
        private void IncreaseLootCorpse(BasePlayer player, LootableCorpse corpse)
        {
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord.Scavenger <= 0) return;
            double scavlootchance = (config.scavenger.scavlootchance * xprecord.Scavenger) * 100;
            // Ranks
            if (config.xpLevelRanks.rankskillboost)
            {
                double rankboostchance = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * scavlootchance;
                scavlootchance += rankboostchance;
            }
            if ((Random.Range(0, 101) <= scavlootchance) == true)
            {
                foreach (var corpseContainer in corpse.containers)
                {
                    if (corpseContainer.itemList.Count == 0) continue;
                    foreach (var item in corpseContainer.itemList)
                    {
                        if (config.scavenger.componentsonly)
                        {
                            if (item != null && item.info.category == ItemCategory.Component)
                            {
                                int newamount = (int)Math.Ceiling((xprecord.Scavenger * config.scavenger.scavmultiplier) * item.amount);
                                // Ranks
                                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                                {
                                    double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * newamount;
                                    newamount += (int)Math.Ceiling(rankboost);
                                }
                                item.amount = newamount;
                            }
                        }
                        else
                        {
                            if (item != null)
                            {
                                int newamount = (int)Math.Ceiling((xprecord.Scavenger * config.scavenger.scavmultiplier) * item.amount);
                                // Ranks
                                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                                {
                                    double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * newamount;
                                    newamount += (int)Math.Ceiling(rankboost);
                                }
                                item.amount = newamount;
                            }
                        }
                    }
                }
            }
        }
        private void OnFishCatch(Item fish, BaseFishingRod fishingRod, BasePlayer player)
        {
            if (player == null || fish == null) return;
            XPRecord xprecord = GetXPRecord(player);
            double addxp = config.xpGain.fishxp;
            GainExp(player, addxp);
            if (xprecord.Fisher > 0)
            {
                var fishname = fish.info.shortname;
                if (fishname.Contains("anchovy") || fishname.Contains("catfish") || fishname.Contains("herring") || fishname.Contains("minnow") || fishname.Contains("roughy") || fishname.Contains("salmon") || fishname.Contains("sardine") || fishname.Contains("shark") || fishname.Contains("trout") || fishname.Contains("Perch"))
                {
                    double results = Math.Round(fish.amount + (xprecord.Fisher * config.fisher.fishamountincrease));
                    // Captaincy
                    if (player.Team != null && player.Team.members.Count > 1)
                    {
                        double captaincyboost = CaptaincyTeamSkillBoost(player) * results;
                        results += (int)Math.Ceiling(captaincyboost);
                    }
                    // Ranks
                    if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                    {
                        double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * results;
                        results += (int)Math.Ceiling(rankboost);
                    }
                    fish.amount = (int)results;
                }
                else
                {
                    double results = Math.Round(fish.amount + (xprecord.Fisher * config.fisher.itemamountincrease));
                    // Captaincy
                    if (player.Team != null && player.Team.members.Count > 1)
                    {
                        double captaincyboost = CaptaincyTeamSkillBoost(player) * results;
                        results += (int)Math.Ceiling(captaincyboost);
                    }
                    // Ranks
                    if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                    {
                        double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * results;
                        results += (int)Math.Ceiling(rankboost);
                    }
                    fish.amount = (int)results;
                }
            }
        }
        private void OnLoseCondition(Item item, ref float amount)
        {
            if (item == null) return;
            BasePlayer player = item.GetOwnerPlayer();
            if (player == null || !player.userID.IsSteamId() || player.IsNpc) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            // Weaponry Stat
            if (xprecord.Weaponry >= 1)
            {
                // Chance to reduce condition damage
                double reductionchance = (config.weaponry.reductionchance * xprecord.Weaponry) * 100;
                if ((Random.Range(0, 101) <= reductionchance) == true)
                {
                    //Tools
                    if (item.info.shortname.Contains("hatchet") || item.info.shortname.Contains("axe") || item.info.shortname.Contains("pickaxe") || item.info.shortname.Contains("icepick"))
                    {
                        double reducecondition = amount * (xprecord.Weaponry * config.weaponry.tool);
                        amount -= (float)reducecondition;
                        // Make sure reduction does not go 0 or add condition
                        if (amount < config.weaponry.mindamage)
                        {
                            amount = (float)config.weaponry.mindamage;
                        }
                    }
                    // Power Tools
                    if (item.info.shortname.Contains("chainsaw") || item.info.shortname.Contains("jackhammer"))
                    {
                        double reducecondition = amount * (xprecord.Weaponry * config.weaponry.powertools);
                        amount -= (float)reducecondition;
                        // Make sure reduction does not go 0 or add condition
                        if (amount < config.weaponry.mindamage)
                        {
                            amount = (float)config.weaponry.mindamage;
                        }
                    }
                    // Melee Weapons
                    if (item.info.shortname.Contains("spear") || item.info.shortname.Contains("knife") || item.info.shortname.Contains("mace") || item.info.shortname.Contains("machete") || item.info.shortname.Contains("club") || item.info.shortname.Contains("sword") || item.info.shortname.Contains("longsword") || item.info.shortname.Contains("cleaver"))
                    {
                        double reducecondition = amount * (xprecord.Weaponry * config.weaponry.meleeweapons);
                        amount -= (float)reducecondition;
                        // Make sure reduction does not go 0 or add condition
                        if (amount < config.weaponry.mindamage)
                        {
                            amount = (float)config.weaponry.mindamage;
                        }
                    }
                    // Projectile Weapons
                    if (item.info.shortname.Contains("rifle") || item.info.shortname.Contains("smg") || item.info.shortname.Contains("shotgun") || item.info.shortname.Contains("bow") || item.info.shortname.Contains("pistol") || item.info.shortname.Contains("lmg"))
                    {
                        double reducecondition = amount * (xprecord.Weaponry * config.weaponry.projectileweapons);
                        amount -= (float)reducecondition;
                        // Make sure reduction does not go 0 or add condition
                        if (amount < config.weaponry.mindamage)
                        {
                            amount = (float)config.weaponry.mindamage;
                        }
                    }
                }
            }
            // Fisher Diving Tank Reduction
            if (xprecord.Fisher >= 1 && item.info.shortname.Equals("diving.tank"))
            {
                double reducedair = amount * (xprecord.Fisher * config.fisher.oxygentankreduction);
                amount -= (float)reducedair;
                // Ranks
                if (config.xpLevelRanks.rankskillboost && !xprecord.DisableRank)
                {
                    double rankboost = (xprecord.rank * config.xpLevelRanks.rankstatboostamount) * amount;
                    amount -= (float)rankboost;
                }
                if (amount <= 0)
                {
                    amount = 0.25f;
                }
            }
        }
        private void OnReloadMagazine(BasePlayer player, BaseProjectile projectile)
        {
            if (player == null || !player.userID.IsSteamId() || player.IsNpc) return;
            if (config.weaponry.maxammo == 0) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            // Weaponry Stat
            if (!_weaponCache.ContainsKey(projectile.net.ID))
            {
                int defaultammo = projectile.primaryMagazine.capacity;
                int maxammo = projectile.primaryMagazine.capacity;
                if (xprecord.Weaponry >= 1)
                {
                    maxammo = (int)Math.Ceiling(projectile.primaryMagazine.capacity + ((config.weaponry.maxammo * xprecord.Weaponry) * projectile.primaryMagazine.capacity));
                }
                AddWeaponData(player, projectile, defaultammo, maxammo);
                projectile.primaryMagazine.capacity = maxammo;
            }
            else
            {
                Weapon weapon;
                if (_weaponCache.TryGetValue(projectile.net.ID, out weapon))
                {
                    if (weapon.player == player.userID)
                    {
                        int maxammo = weapon.defaultammo;
                        if (xprecord.Weaponry >= 1)
                        {
                            maxammo = (int)Math.Ceiling(weapon.defaultammo + ((config.weaponry.maxammo * xprecord.Weaponry) * weapon.defaultammo));
                        }
                        projectile.primaryMagazine.capacity = maxammo;
                    }
                    else
                    {
                        int maxammo = weapon.defaultammo;
                        if (xprecord.Weaponry >= 1)
                        {
                            maxammo = (int)Math.Ceiling(weapon.defaultammo + ((config.weaponry.maxammo * xprecord.Weaponry) * weapon.defaultammo));
                        }
                        projectile.primaryMagazine.capacity = maxammo;
                    }
                }
            }          
        }
        private void OnEntityMounted(BaseMountable entity, BasePlayer player)
        {
            if (player == null || entity == null || player.IsNpc || !player.userID.IsSteamId() || entity.GetParentEntity() == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            // Horse
            var horse = entity.GetParentEntity() as RidableHorse;
            if (horse != null)
            {
                if (xprecord.Dexterity >= 1)
                {
                    player.ChatMessage(XPLang("horsespeedmessage", player.UserIDString));
                }
            }
            // Boat
            var boat = entity.GetParentEntity() as BaseBoat;
            if (boat != null)
            {
                AddBoatData(player, boat);
                if (xprecord.dash == 1)
                {
                    DashPanel(player, true, 0, 0, "boat");
                    GetFuel(player, entity, true);
                    GetSpeed(player, entity, true, "boat");
                }
                if (xprecord.dash == 2)
                {
                    if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge)
                    {
                        GetFuel(player, entity, true);
                    }
                    if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                    {
                        GetSpeed(player, entity, true, "boat");
                    }
                }
                if (xprecord.Dexterity >= 1)
                {
                    player.ChatMessage(XPLang("boatspeedmessage", player.UserIDString));
                }
            }
            // Car
            var car = entity.VehicleParent() as ModularCar;
            if (car != null)
            {
                AddVehicleData(player, car);
                if (xprecord.dash == 1)
                {
                    DashPanel(player, true, 0, 0, "car");
                    GetFuel(player, entity, true);
                    GetSpeed(player, entity, true, "car");
                }
                if (xprecord.dash == 2)
                {
                    if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge)
                    {
                        GetFuel(player, entity, true);
                    }
                    if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                    {
                        GetSpeed(player, entity, true, "car");
                    }
                }
                if (xprecord.Dexterity >= 1)
                {
                    player.ChatMessage(XPLang("vehiclespeedmessage", player.UserIDString));
                }
            }
            // Mini Copter
            var mini = entity.VehicleParent() as MiniCopter;
            if (mini != null)
            {
                AddMiniCopterData(player, mini);
                if (xprecord.dash == 1)
                {
                    DashPanel(player, true, 0, 0, "mini");
                    GetFuel(player, entity, true);
                    GetSpeed(player, entity, true, "mini");
                }
                if (xprecord.dash == 2)
                {
                    if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge)
                    {
                        GetFuel(player, entity, true);
                    }
                    if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                    {
                        GetSpeed(player, entity, true, "mini");
                    }
                }
                if (xprecord.Dexterity >= 1)
                {
                    player.ChatMessage(XPLang("minispeedmessage", player.UserIDString));
                }

            }
        }
        private void OnEntityDismounted(BaseMountable entity, BasePlayer player)
        {
            if (player.IsNpc || !player.userID.IsSteamId()) return;
            XPRecord xprecord = GetXPRecord(player);
            // Horses
            var horse = entity.GetParentEntity() as RidableHorse;
            Horse defaulthorse;
            if (horse != null && _horseCache.ContainsKey(horse.net.ID))
            {
                if (_horseCache.TryGetValue(entity.GetParentEntity().net.ID, out defaulthorse))
                {
                   if (horse != null && horse.IsAlive()) DefaultHorseData(horse);
                }
            }
            // Boats
            var boat = entity.GetParentEntity() as BaseBoat;
            Boat defaultboat;
            if (boat != null && _boatCache.ContainsKey(boat.net.ID))
            {
                if (_boatCache.TryGetValue(boat.net.ID, out defaultboat))
                {
                    DefaultBoatData(boat);
                    if (xprecord.dash == 1)
                    {
                        DashPanel(player, false, 0, 0, "boat");
                        GetFuel(player, entity, false);
                        GetSpeed(player, entity, false, "boat");
                    }
                    if (xprecord.dash == 2)
                    {
                        if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge)
                        {
                            GetFuel(player, entity, false);
                        }
                        if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                        {
                            GetSpeed(player, entity, false, "boat");
                        }
                    }
                }
            }
            // Vehicles
            var car = entity.VehicleParent() as ModularCar;
            Vehicle vehicle;
            if (car != null && _vehicleCache.ContainsKey(car.net.ID))
            {
                if (_vehicleCache.TryGetValue(car.net.ID, out vehicle))
                {
                    DefaultVehicleData(car);
                    if (xprecord.dash == 1)
                    {
                        DashPanel(player, false, 0, 0, "car");
                        GetFuel(player, entity, false);
                        GetSpeed(player, entity, false, "car");
                    }
                    if (xprecord.dash == 2)
                    {
                        if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge)
                        {
                            GetFuel(player, entity, false);
                        }
                        if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                        {
                            GetSpeed(player, entity, false, "car");
                        }
                    }
                }
            }
            // Mini Copter
            Minicopter minicopter;
            var mini = entity.VehicleParent() as MiniCopter;
            if (mini != null && _minicopterCache.ContainsKey(mini.net.ID))
            {
                if (_minicopterCache.TryGetValue(mini.net.ID, out minicopter))
                {
                    DefaultMiniCopterData(mini);
                    if (xprecord.dash == 1)
                    {
                        DashPanel(player, false, 0, 0, "mini");
                        GetFuel(player, entity, false);
                        GetSpeed(player, entity, false, "mini");
                    }
                    if (xprecord.dash == 2)
                    {
                        if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge)
                        {
                            GetFuel(player, entity, false);
                        }
                        if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                        {
                            GetSpeed(player, entity, false, "mini");
                        }
                    }
                }
            }
        }
        private void DefaultHorseData(RidableHorse horse)
        {
            Horse defaulthorse;
            if (_horseCache.TryGetValue(horse.net.ID, out defaulthorse))
            {
                horse.maxSpeed = defaulthorse.maxSpeed;
                horse.runSpeed = defaulthorse.runSpeed;
                horse.trotSpeed = defaulthorse.trotSpeed;
                horse.walkSpeed = defaulthorse.walkSpeed;
            }
            _horseCache.Remove(horse.net.ID);
        }
        private void DefaultBoatData(BaseBoat boat)
        {
            Boat defaultboat;
            if (_boatCache.TryGetValue(boat.net.ID, out defaultboat))
            {
                boat.engineThrust = defaultboat.defaultSpeed;
            }
            _boatCache.Remove(boat.net.ID);
        }
        private void DefaultVehicleData(ModularCar car)
        {
            Vehicle vehicle;
            if (_vehicleCache.TryGetValue(car.net.ID, out vehicle))
            {
                car.carSettings.maxDriveSlip = vehicle.maxDriveSlip;
                car.carSettings.reversePercentSpeed = vehicle.reversePercentSpeed;
                car.carSettings.driveForceToMaxSlip = vehicle.driveForceToMaxSlip;
            }
            _vehicleCache.Remove(car.net.ID);
        }
        private void DefaultMiniCopterData(MiniCopter mini)
        {
            Minicopter minicopter;
            if (_minicopterCache.TryGetValue(mini.net.ID, out minicopter))
            {
                mini.maxRotorSpeed = minicopter.maxRotorSpeed;
            }
            _minicopterCache.Remove(mini.net.ID);
        }
        private void ChangeHorseSpeed(BasePlayer player)
        {
            if (player == null) return;
            var horse = player.GetMountedVehicle() as RidableHorse;
            if (horse == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            if (xprecord.Dexterity >= 1)
            {
                if (_horseCache.ContainsKey(horse.net.ID))
                {
                    DefaultHorseData(horse);
                    player.ChatMessage(XPLang("horsespeedoff", player.UserIDString));
                }
                else
                {
                    AddHorseData(player, horse);
                    var increase = (float)(xprecord.Dexterity * config.dexterity.horsespeed);
                    horse.maxSpeed += increase * horse.maxSpeed;
                    horse.runSpeed += increase * horse.runSpeed;
                    horse.trotSpeed += increase * horse.trotSpeed;
                    horse.walkSpeed += increase * horse.walkSpeed;
                    player.ChatMessage(XPLang("horsespeedon", player.UserIDString));
                }
            }
        }
        private void ChangeBoatSpeed(BasePlayer player)
        {
            if (player == null) return;
            var boat = player.GetMountedVehicle() as BaseBoat;
            if (boat == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            if (xprecord.Dexterity >= 1)
            {
                Boat boatdata;
                if (_boatCache.TryGetValue(boat.net.ID, out boatdata))
                {
                    if (boatdata.player == player.userID)
                    {
                        DefaultBoatData(boat);
                        player.ChatMessage(XPLang("boatspeedoff", player.UserIDString));
                    }
                }
                else
                {
                    AddBoatData(player, boat);
                    var increase = (float)(xprecord.Dexterity * config.dexterity.boatspeed);
                    boat.engineThrust += increase * boat.engineThrust;
                    player.ChatMessage(XPLang("boatspeedon", player.UserIDString));
                }
            }
        }
        private void ChangeVehicleSpeed(BasePlayer player)
        {
            if (player == null) return;
            var car = player.GetMountedVehicle() as ModularCar;
            if (car == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            if (xprecord.Dexterity >= 1)
            {
                Vehicle vehicle;
                if (_vehicleCache.TryGetValue(car.net.ID, out vehicle))
                {
                    if (vehicle.player == player.userID)
                    {
                        DefaultVehicleData(car);
                        player.ChatMessage(XPLang("vehiclespeedoff", player.UserIDString));
                    }
                }
                else
                {
                    AddVehicleData(player, car);
                    double increase = config.dexterity.vehiclespeed * xprecord.Dexterity;
                    car.GetMaxForwardSpeed();
                    car.carSettings.maxDriveSlip -= (float)(increase * car.carSettings.maxDriveSlip);
                    car.carSettings.reversePercentSpeed += (float)(increase * car.carSettings.reversePercentSpeed);
                    car.carSettings.driveForceToMaxSlip += (float)(increase * car.carSettings.driveForceToMaxSlip);
                    player.ChatMessage(XPLang("vehiclespeedon", player.UserIDString));
                }
            }
        }
        private void ChangeMiniCopterSpeed(BasePlayer player)
        {
            if (player == null) return;
            var mini = player.GetMountedVehicle() as MiniCopter;
            if (mini == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            if (xprecord.Dexterity >= 1)
            {
                Minicopter minicopter;
                if (_minicopterCache.TryGetValue(mini.net.ID, out minicopter))
                {
                    if (minicopter.player == player.userID)
                    {
                        DefaultMiniCopterData(mini);
                        player.ChatMessage(XPLang("minispeedoff", player.UserIDString));
                    }
                }
                else
                {
                    AddMiniCopterData(player, mini);
                    double increase = config.dexterity.vehiclespeed * xprecord.Dexterity;
                    mini.maxRotorSpeed += (float)(increase * mini.maxRotorSpeed);
                    player.ChatMessage(XPLang("minispeedon", player.UserIDString));
                }
            }
        }
        private object CanUseFuel(EntityFuelSystem fuelSystem)
        {
            // Boat
            var boat = fuelSystem.GetFuelContainer().GetParentEntity() as BaseBoat;
            if (boat != null)
            {
                Boat boatdata;
                if (_boatCache.TryGetValue(boat.net.ID, out boatdata))
                {
                    var player = FindPlayer(boatdata.player.ToString());
                    if (player == null) return null;
                    XPRecord xprecord = GetXPRecord(player);
                    if (xprecord == null) return null;
                    if (xprecord.Dexterity >= 1)
                    {
                        var chance = (config.dexterity.fuelreduce * xprecord.Dexterity) * 100;
                        if ((Random.Range(0, 101) <= chance) == true)
                        {
                            return 0;
                        }
                    }
                }
            }
            // Car
            var car = fuelSystem.GetFuelContainer().GetParentEntity() as ModularCar;
            if (car != null)
            {
                Vehicle vehicle;
                if (_vehicleCache.TryGetValue(car.net.ID, out vehicle))
                {
                    var player = FindPlayer(vehicle.player.ToString());
                    if (player == null) return null;
                    XPRecord xprecord = GetXPRecord(player);
                    if (xprecord == null) return null;
                    if (xprecord.Dexterity >= 1)
                    {
                        var chance = (config.dexterity.fuelreduce * xprecord.Dexterity) * 100;
                        if ((Random.Range(0, 101) <= chance) == true)
                        {
                            return 0;
                        }
                    }
                }
            }
            // MiniCopter
            var mini = fuelSystem.GetFuelContainer().GetParentEntity() as MiniCopter;
            if (mini != null)
            {
                Minicopter minicopter;
                if (_minicopterCache.TryGetValue(mini.net.ID, out minicopter))
                {
                    var player = FindPlayer(minicopter.player.ToString());
                    if (player == null) return null;
                    XPRecord xprecord = GetXPRecord(player);
                    if (xprecord == null) return null;
                    if (xprecord.Dexterity >= 1)
                    {
                        var chance = (config.dexterity.fuelreduce * xprecord.Dexterity) * 100;
                        if ((Random.Range(0, 101) <= chance) == true)
                        {
                            return 0;
                        }
                    }
                }
            }
            // Return Default
            return null;
        }
        private Timer fuelTimer;
        private int GetFuel(BasePlayer player, BaseMountable entity, bool status = false)
        {
            if (player == null || entity == null) return -1;
            XPRecord xprecord = GetXPRecord(player);
            if (!player.isMounted)
            {
                status = false;
            }
            int fuelamount = -1;
            if (!status && fuelTimer != null) 
            {
                fuelTimer.Destroy();
                FuelGauge(player, false, fuelamount);
                return fuelamount;
            }
            var boat = entity?.GetParentEntity() as BaseBoat;
            var car = entity?.VehicleParent() as ModularCar;
            var mini = entity?.VehicleParent() as MiniCopter;
            if (status)
            {
                fuelTimer = timer.Every(3f, () =>
                {
                    if (boat != null) 
                    { 
                        fuelamount = boat?.GetFuelSystem()?.GetFuelAmount() ?? 0;
                    }
                    if (car != null) 
                    { 
                        fuelamount = car?.GetFuelSystem()?.GetFuelAmount() ?? 0; 
                    }
                    if (mini != null) 
                    { 
                        fuelamount = mini?.GetFuelSystem()?.GetFuelAmount() ?? 0; 
                    }
                    if (xprecord.dash == 1)
                    {
                        DashFuel(player, fuelamount);
                    }
                    if (xprecord.dash == 2)
                    {
                        FuelGauge(player, true, fuelamount);
                    }
                });
                return fuelamount;
            }
            return fuelamount;
        }
        private Timer speedTimer;       
        private int GetSpeed(BasePlayer player, BaseMountable entity, bool status = false, string type = "none")
        {
            if (player == null || entity == null) return 0;
            XPRecord xprecord = GetXPRecord(player);
            if (!player.isMounted)
            {
                status = false;
            }
            int speed = 0;
            if (!status && speedTimer != null)
            {
                speedTimer.Destroy();
                Speedometer(player, false, speed, type);
                return speed;
            }
            var boat = entity?.GetParentEntity() as BaseBoat;
            var car = entity?.VehicleParent() as ModularCar;
            var mini = entity?.VehicleParent() as MiniCopter;
            if (status)
            {
                speedTimer = timer.Every(1f, () =>
                {
                    if (boat != null)
                    {
                        speed = (int)boat.engineThrust;
                    } 
                    if (car != null)
                    {
                        speed = (int)car.GetSpeed() * 2;
                    }
                    if (mini != null)
                    {
                        speed = (int)mini.maxRotorSpeed;
                    }
                    if(xprecord.dash == 1)
                    {
                        DashSpeed(player, speed, type);
                    }
                    if (xprecord.dash == 2)
                    { 
                        Speedometer(player, true, speed, type); 
                    }
                });
                return speed;
            }
            return speed;
        }
        private void OnPlayerInput(BasePlayer player, InputState input)
        {
            if (player == null || input == null) return;
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null) return;
            if (xprecord.Dexterity <= 0) return;          
            if (input.WasJustPressed(BUTTON.USE) && player.isMounted)
            {
                ChangeHorseSpeed(player);
            }
            if (input.WasJustPressed(BUTTON.RELOAD) && player.isMounted)
            {
                ChangeBoatSpeed(player);
                ChangeVehicleSpeed(player);
                ChangeMiniCopterSpeed(player);
            }
        }
        #endregion

        #region Chat Commands
        // Chat Commands
        private void Openhelp(BasePlayer player, string command, string[] args)
        {
            PlayerControlPanelFullMain(player);
            PlayerHelpPage(player, 0);
        }
        private void Openplayerstats(BasePlayer player, string command, string[] args)
        {
            if (!_isXPReady)
            {
                player.ChatMessage(XPLang("imgwaiting", player.UserIDString));
                return;
            }
            if (args.Length == 0)
            {
                DestroyUi(player, XPerienceAdminPanelMain);
                DestroyUi(player, XPeriencePlayerControlFullMain);
                PlayerControlPanelFullMain(player);
                PlayerInfoPage(player);
                if (XPerienceAddon != null)
                {
                    XPerienceAddon?.Call("ClearNotify", player);
                }
            }
            else
            {
                if (config.defaultOptions.allowplayersearch || (!config.defaultOptions.allowplayersearch && player.IsAdmin && permission.UserHasPermission(player.UserIDString, XPerience.Admin)))
                {
                    DestroyUi(player, XPeriencePlayerControlFullMain);
                    var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.displayname.ToString().ToLower().Contains(args[0].ToLower()));
                    if (user.Value == null) return;
                    SelectedPlayerPanelFullMain(player, user.Value.id);
                    SelectedPlayerInfoPage(player, user.Value.id);
                    if (XPerienceAddon != null)
                    {
                        XPerienceAddon?.Call("ClearNotify", player);
                    }
                }
                else
                {
                    player.ChatMessage(XPLang("playersearchdisabled", player.UserIDString));

                }
            }
        }
        private void Showplayerstatschat(BasePlayer player, string command, string[] args)
        {
            PlayerStatsChat(player);
        }
        private void Opentopplayers(BasePlayer player, string command, string[] args)
        {
            if (config.defaultOptions.allowplayersearch || (!config.defaultOptions.allowplayersearch && player.IsAdmin && permission.UserHasPermission(player.UserIDString, XPerience.Admin)))
            {
                TopPlayerPanelFullMain(player, "level");
                TopLevels(player, 1, "level", 0);
                return;
            }
            else
            {
                player.ChatMessage(XPLang("playersearchdisabled", player.UserIDString));
            }
        }
        private void Playeraddstat(BasePlayer player, string command, string[] args)
        {
            if (args.Length == 0)
            {
                PlayerControlPanelFullMain(player);
                PlayerHelpPage(player, 1);
                return;
            }
            StatUp(player, args[0].ToLower());
        }
        private void Playeraddskill(BasePlayer player, string command, string[] args)
        {
            if (args.Length == 0)
            {
                PlayerControlPanelFullMain(player);
                PlayerHelpPage(player, 1);
                return;
            }
            SkillUp(player, args[0].ToLower());
        }
        private void Playerresetstats(BasePlayer player, string command, string[] args)
        {
            if (config.defaultOptions.hardcorenoreset)
            {
                player.ChatMessage(XPLang("hardcorenoreset", player.UserIDString));
                return;
            }
            StatsReset(player);
        }
        private void Playerresetskills(BasePlayer player, string command, string[] args)
        {
            if (config.defaultOptions.hardcorenoreset)
            {
                player.ChatMessage(XPLang("hardcorenoreset", player.UserIDString));
                return;
            }
            SkillsReset(player);
        }
        private void Playerresetall(BasePlayer player, string command, string[] args)
        {
            if (!config.defaultOptions.allowplayerreset)
            {
                player.ChatMessage(XPLang("playerresetdisabled", player.UserIDString));
                return;
            }
            PlayerReset(player);
        }
        private void Playerliveuichange(BasePlayer player, string command, string[] args)
        {
            if (!config.defaultOptions.liveuistatslocationmoveable) return;
            if (args.Length == 0)
            {
                player.ChatMessage(XPLang("liveuilocation", player.UserIDString, _xperienceCache[player.UserIDString].UILocation));
                return;
            }
            var cmdArg = args[0].ToLower();

            switch (cmdArg)
            {
                case "0":
                    _xperienceCache[player.UserIDString].UILocation = 0;
                    player.ChatMessage(XPLang("liveuilocationoff", player.UserIDString, cmdArg));
                    LiveStats(player, true);
                    break;
                case "1":
                    _xperienceCache[player.UserIDString].UILocation = 1;
                    player.ChatMessage(XPLang("liveuilocation", player.UserIDString, cmdArg));
                    LiveStats(player, true);
                    break;
                case "2":
                    _xperienceCache[player.UserIDString].UILocation = 2;
                    player.ChatMessage(XPLang("liveuilocation", player.UserIDString, cmdArg));
                    LiveStats(player, true);
                    break;
                case "3":
                    _xperienceCache[player.UserIDString].UILocation = 3;
                    player.ChatMessage(XPLang("liveuilocation", player.UserIDString, cmdArg));
                    LiveStats(player, true);
                    break;
                case "4":
                    _xperienceCache[player.UserIDString].UILocation = 4;
                    player.ChatMessage(XPLang("liveuilocation", player.UserIDString, cmdArg));
                    LiveStats(player, true);
                    break;
                case "5":
                    _xperienceCache[player.UserIDString].UILocation = 5;
                    player.ChatMessage(XPLang("liveuilocation", player.UserIDString, cmdArg));
                    LiveStats(player, true);
                    break;
                default:
                    player.ChatMessage(XPLang("liveuilocationhelp", player.UserIDString, _xperienceCache[player.UserIDString].UILocation));
                    break;
            }
        }
        // Admin Commands
        private void Adminitemchange(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            var item = player.GetActiveItem();
            if (args.Length == 0 || args.Length == 1)
            {
                player.ChatMessage(XPLang("adminitemchangerequirement", player.UserIDString, item.info.displayName.english, item.condition, item._maxCondition, config.adminchatCommands.adminitemchange));
                return;
            }
            float condition = float.Parse(args[0]);
            float maxcondition = float.Parse(args[1]);
            item.condition = condition;
            item._maxCondition = maxcondition;
            player.ChatMessage(XPLang("adminitemchange", player.UserIDString, item.info.displayName.english, condition, maxcondition));
        }
        private void Showadminhelp(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            player.ChatMessage(XPLang("xphelpadmin", player.UserIDString, config.adminchatCommands.openadminpanel, config.adminchatCommands.adminresetxperience, config.adminchatCommands.adminresetplayer, config.adminchatCommands.adminxpgive, config.adminchatCommands.adminxptake, config.adminchatCommands.adminitemchange));
        }
        private void Openadminpanel(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            if (!_isXPReady)
            {
                player.ChatMessage("Waiting On ImageLibrary to finish the load order");
                return;
            }
            DestroyUi(player, XPeriencePlayerControlFullMain);
            DestroyUi(player, XPerienceAdminPanelMain);
            DestroyUi(player, XPerienceTopMain);
            if (XPerienceAddon != null)
            {
                XPerienceAddon?.Call("ClearNotify", player);
            }
            AdminControlPanel(player);
            AdminInfoPage(player);
        }
        private void Adminresetxperience(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            _xperienceCache.Clear();
            _lootCache.Clear();
            _XPerienceData.Clear();
            _LootContainData.Clear();
            _corpseCache.Clear();
            _CorpseContainData.Clear();
            if (config.sql.enablesql)
            {
                DeleteSQL();
            }
            player.ChatMessage(XPLang("resetxperience", player.UserIDString));
            Interface.Oxide.ReloadPlugin("XPerience");
        }
        private void Adminxpgive(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            if (args.Length == 0)
            {
                player.ChatMessage(XPLang("xpgiveneedtype", player.UserIDString));
                return;
            }    
            if (args.Length == 1)
            {
                player.ChatMessage(XPLang("xpgiveneedname", player.UserIDString));
                return;
            }
            if (args.Length == 2)
            {
                player.ChatMessage(XPLang("xpgiveneedamount", player.UserIDString));
                return;
            }
            var type = args[0].ToLower();
            if (type == "name")
            {
                var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.displayname.ToString().ToLower().Contains(args[1].ToLower()));
                if (user.Value == null)
                {
                    player.ChatMessage(XPLang("xpgivenotfound", player.UserIDString));
                    return;
                }
                double amount = Convert.ToDouble(args[2]);
                var selectplayer = FindPlayer(user.Value.id.ToString());
                XPRecord xprecord = GetXPRecord(selectplayer);
                if (xprecord != null)
                {
                    GainExpAdmin(selectplayer, amount);
                    player.ChatMessage(XPLang("xpgiveplayer", player.UserIDString, user.Value.displayname, amount, xprecord.experience));
                }
                else
                {
                    XPRecord vxprecord = GetPlayerRecord(user.Value.id);
                    GainExpAdminFix(user.Value.id, amount);
                    player.ChatMessage(XPLang("xpgiveplayer", player.UserIDString, user.Value.displayname, amount, vxprecord.experience));
                }
            }
            if (type == "id")
            {
                var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.id.ToString().ToLower().Contains(args[1].ToLower()));
                if (user.Value == null)
                {
                    player.ChatMessage(XPLang("xpgivenotfound", player.UserIDString));
                    return;
                }
                double amount = Convert.ToDouble(args[2]);
                var selectplayer = FindPlayer(user.Value.id.ToString());
                XPRecord xprecord = GetXPRecord(selectplayer);
                if (xprecord != null)
                {
                    GainExpAdmin(selectplayer, amount);
                    player.ChatMessage(XPLang("xpgiveplayer", player.UserIDString, user.Value.displayname, amount, xprecord.experience));
                }
                else
                {
                    XPRecord vxprecord = GetPlayerRecord(user.Value.id);
                    GainExpAdminFix(user.Value.id, amount);
                    player.ChatMessage(XPLang("xpgiveplayer", player.UserIDString, user.Value.displayname, amount, vxprecord.experience));
                }
            }

        }
        private void Adminxpgiveall(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            if (args.Length == 0)
            {
                player.ChatMessage(XPLang("xpgiveneedamount", player.UserIDString));
                return;
            }
            double amount = Convert.ToDouble(args[0]);
            foreach(var allplayer in BasePlayer.allPlayerList)
            {
                GainExpAdmin(allplayer, amount);
            }
            player.ChatMessage(XPLang("xpgiveall", player.UserIDString, amount));
        }
        private void Adminxptake(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            if (args.Length == 0)
            {
                player.ChatMessage(XPLang("xptakeneedtype", player.UserIDString));
                return;
            }
            if (args.Length == 1)
            {
                player.ChatMessage(XPLang("xptakeneedname", player.UserIDString));
                return;
            }
            if (args.Length == 2)
            {
                player.ChatMessage(XPLang("xptakeneedamount", player.UserIDString));
                return;
            }
            var type = args[0].ToLower();
            if (type == "name")
            {
                var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.displayname.ToString().ToLower().Contains(args[1].ToLower()));
                if (user.Value == null)
                {
                    player.ChatMessage(XPLang("xptakenotfound", player.UserIDString));
                    return;
                }
                double amount = Convert.ToDouble(args[2]);
                var selectplayer = FindPlayer(user.Value.id.ToString());
                XPRecord xprecord = GetXPRecord(selectplayer);
                LoseExpAdmin(selectplayer, amount);
                player.ChatMessage(XPLang("xptakeplayer", player.UserIDString, amount, user.Value.displayname, xprecord.experience));
            }
            if (type == "id")
            {
                var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.id.ToString().ToLower().Contains(args[1].ToLower()));
                if (user.Value == null)
                {
                    player.ChatMessage(XPLang("xptakenotfound", player.UserIDString));
                    return;
                }
                double amount = Convert.ToDouble(args[2]);
                var selectplayer = FindPlayer(user.Value.id.ToString());
                XPRecord xprecord = GetXPRecord(selectplayer);
                LoseExpAdmin(selectplayer, amount);
                player.ChatMessage(XPLang("xptakeplayer", player.UserIDString, amount, user.Value.displayname, xprecord.experience));
            }
        }
        private void Adminfixdata(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            PlayerFixDataAll(player);
        }
        private void Adminxpresetplayer(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            if (args.Length == 0)
            {
                player.ChatMessage(XPLang("xpresetneedtype", player.UserIDString));
                return;
            }
            if (args.Length == 1)
            {
                player.ChatMessage(XPLang("xpresetneedname", player.UserIDString));
                return;
            }
            var type = args[0].ToLower();
            if (type == "name")
            {
                var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.displayname.ToString().ToLower().Contains(args[1].ToLower()));
                if (user.Value == null)
                {
                    player.ChatMessage(XPLang("xpresetnotfound", player.UserIDString));
                    return;
                }
                var selectplayer = FindPlayer(user.Value.id.ToString());
                SelectedPlayerReset(player, selectplayer);
            }
            if (type == "id")
            {
                var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.id.ToString().ToLower().Contains(args[1].ToLower()));
                if (user.Value == null)
                {
                    player.ChatMessage(XPLang("xpresetnotfound", player.UserIDString));
                    return;
                }
                var selectplayer = FindPlayer(user.Value.id.ToString());
                SelectedPlayerReset(player, selectplayer);
            }
        }
        private void AdminHarvestReset(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            if (args.Length == 0)
            {
                player.ChatMessage(XPLang("xpresetneedname", player.UserIDString));
                return;
            }
            var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.displayname.ToString().ToLower().Contains(args[0].ToLower()));
            if (user.Value == null)
            {
                player.ChatMessage(XPLang("xpresetnotfound", player.UserIDString));
                return;
            }
            var selectplayer = FindPlayer(user.Value.id.ToString());
            SelectedHarvestReset(player, selectplayer);
        }
        private void AdminLevelReset(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            if (args.Length == 0)
            {
                player.ChatMessage(XPLang("xpresetneedname", player.UserIDString));
                return;
            }
            var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.displayname.ToString().ToLower().Contains(args[0].ToLower()));
            if (user.Value == null)
            {
                player.ChatMessage(XPLang("xpresetnotfound", player.UserIDString));
                return;
            }
            var selectplayer = FindPlayer(user.Value.id.ToString());
            SelectedLevelReset(player, selectplayer);
        }
        private void AdminRankReset(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin && !permission.UserHasPermission(player.UserIDString, Admin)) return;
            if (args.Length == 0)
            {
                player.ChatMessage(XPLang("xpresetneedname", player.UserIDString));
                return;
            }
            var user = _xperienceCache.ToList().FirstOrDefault(x => x.Value.displayname.ToString().ToLower().Contains(args[0].ToLower()));
            if (user.Value == null)
            {
                player.ChatMessage(XPLang("xpresetnotfound", player.UserIDString));
                return;
            }
            var selectplayer = FindPlayer(user.Value.id.ToString());
            SelectedRankReset(player, selectplayer);
        }
        private void AdminLevelResetAll(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            PlayerAllLevelReset(player);
        }
        private void AdminRankResetAll(BasePlayer player, string command, string[] args)
        {
            if (!player.IsAdmin || !permission.UserHasPermission(player.UserIDString, Admin)) return;
            PlayerAllRankReset(player);
        }
        #endregion

        #region UI Helpers
        private void PlayerStatsChat(BasePlayer player)
        {
            XPRecord xprecord = GetXPRecord(player);
            player.ChatMessage(XPLang("playerprofilechat", player.UserIDString, xprecord.level, (int)xprecord.experience, (int)xprecord.requiredxp, xprecord.statpoint, xprecord.skillpoint, xprecord.Mentality, xprecord.Dexterity, xprecord.Might, xprecord.Captaincy, xprecord.Weaponry, xprecord.WoodCutter, xprecord.Smithy, xprecord.Miner, xprecord.Forager, xprecord.Hunter, xprecord.Fisher, xprecord.Crafter, xprecord.Framer, xprecord.Medic, xprecord.Scavenger, xprecord.Tamer));
        }
        private object ServerSettings(string option)
        {
            var value = "none";
            // Main
            if (option == "levelstart")
            {
                value = config.xpLevel.levelstart.ToString();
            }
            if (option == "levelmultiplier")
            {
                value = config.xpLevel.levelmultiplier.ToString();
            }
            if (option == "levelxpboost")
            {
                double boost = config.xpLevel.levelxpboost * 100;
                value = boost.ToString();
            }
            if (option == "statpointsperlvl")
            {
                value = config.xpLevel.statpointsperlvl.ToString();
            }
            if (option == "skillpointsperlvl")
            {
                value = config.xpLevel.skillpointsperlvl.ToString();
            }
            if (option == "resettimerenabled")
            {
                value = config.defaultOptions.restristresets.ToString();
            }
            if (option == "resettimerstats")
            {
                value = config.defaultOptions.resetminsstats.ToString();
            }
            if (option == "resettimerskills")
            {
                value = config.defaultOptions.resetminsskills.ToString();
            }
            if (option == "vipresettimerstats")
            {
                value = config.defaultOptions.vipresetminstats.ToString();
            }
            if (option == "vipresettimerskills")
            {
                value = config.defaultOptions.vipresetminsskills.ToString();
            }
            if (option == "nightbonusenable")
            {
                value = config.nightBonus.Enable.ToString();
            }
            if (option == "nightbonus")
            {
                double nightboost = config.nightBonus.Bonus * 100;
                value = nightboost.ToString();
            }
            if (option == "nightstart")
            {
                value = config.nightBonus.StartTime.ToString();
            }
            if (option == "nightend")
            {
                value = config.nightBonus.EndTime.ToString();
            }
            if (option == "nightskill")
            {
                value = config.nightBonus.enableskillboosts.ToString();
            }
            // Kills
            if (option == "chicken")
            {
                value = config.xpGain.chickenxp.ToString();
            }
            if (option == "fish")
            {
                value = config.xpGain.fishxp.ToString();
            }
            if (option == "boar")
            {
                value = config.xpGain.boarxp.ToString();
            }
            if (option == "stag")
            {
                value = config.xpGain.stagxp.ToString();
            }
            if (option == "wolf")
            {
                value = config.xpGain.wolfxp.ToString();
            }
            if (option == "bear")
            {
                value = config.xpGain.bearxp.ToString();
            }
            if (option == "shark")
            {
                value = config.xpGain.sharkxp.ToString();
            }
            if (option == "horse")
            {
                value = config.xpGain.horsexp.ToString();
            }
            if (option == "scientist")
            {
                value = config.xpGain.scientistxp.ToString();
            }
            if (option == "dweller")
            {
                value = config.xpGain.dwellerxp.ToString();
            }
            if (option == "player")
            {
                value = config.xpGain.playerxp.ToString();
            }
            if (option == "bradley")
            {
                value = config.xpGain.bradley.ToString();
            }
            if (option == "heli")
            {
                value = config.xpGain.patrolhelicopter.ToString();
            }
            if (option == "revive")
            {
                value = config.xpGain.playerrevive.ToString();
            }
            // Gathering / Loot
            if (option == "loot")
            {
                value = config.xpGain.lootcontainerxp.ToString();
            }
            if (option == "uloot")
            {
                value = config.xpGain.underwaterlootcontainerxp.ToString();
            }
            if (option == "lloot")
            {
                value = config.xpGain.lockedcratexp.ToString();
            }
            if (option == "hloot")
            {
                value = config.xpGain.hackablecratexp.ToString();
            }
            if (option == "aharvest")
            {
                value = config.xpGain.animalharvestxp.ToString();
            }
            if (option == "charvest")
            {
                value = config.xpGain.corpseharvestxp.ToString();
            }
            if (option == "tree")
            {
                value = config.xpGather.treexp.ToString();
            }
            if (option == "ore")
            {
                value = config.xpGather.orexp.ToString();
            }
            if (option == "gather")
            {
                value = config.xpGather.harvestxp.ToString();
            }
            if (option == "plant")
            {
                value = config.xpGather.plantxp.ToString();
            }
            // Crafting / Building
            if (option == "craft")
            {
                value = config.xpGain.craftingxp.ToString();
            }
            if (option == "wood")
            {
                value = config.xpBuilding.woodstructure.ToString();
            }
            if (option == "stone")
            {
                value = config.xpBuilding.stonestructure.ToString();
            }
            if (option == "metal")
            {
                value = config.xpBuilding.metalstructure.ToString();
            }
            if (option == "armored")
            {
                value = config.xpBuilding.armoredstructure.ToString();
            }
            // Missions
            if (option == "missionsucceed")
            {
                value = config.xpMissions.missionsucceededxp.ToString();
            }
            if (option == "missionfailed")
            {
                value = config.xpMissions.missionfailed.ToString();
            }
            if (option == "missionfailedxp")
            {
                value = config.xpMissions.missionsucceededxp.ToString();
            }
            // Reductions
            if (option == "death")
            {
                double death = config.xpReducer.deathreduceamount * 100;
                value = death.ToString();
            }
            if (option == "deathenable")
            {
                value = config.xpReducer.deathreduce.ToString();
            }
            if (option == "suicide")
            {
                double suicide = config.xpReducer.suicidereduceamount * 100;
                value = suicide.ToString();
            }
            if (option == "suicideenable")
            {
                value = config.xpReducer.suicidereduce.ToString();
            }
            // Mentality
            if (option == "mentalitylevel")
            {
                value = config.mentality.maxlvl.ToString();
            }
            if (option == "mentalitycost")
            {
                value = config.mentality.pointcoststart.ToString();
            }
            if (option == "mentalitymultiplier")
            {
                value = config.mentality.costmultiplier.ToString();
            }
            if (option == "mentalityresearchcost")
            {
                double mentcost = config.mentality.researchcost * 100;
                value = mentcost.ToString();
            }
            if (option == "mentalityresearchspeed")
            {
                double mentspeed = config.mentality.researchspeed * 100;
                value = mentspeed.ToString();
            }
            if (option == "mentalitycrit")
            {
                double mentcrit = config.mentality.criticalchance * 100;
                value = mentcrit.ToString();
            }
            // Dexterity
            if (option == "dexlevel")
            {
                value = config.dexterity.maxlvl.ToString();
            }
            if (option == "dexcost")
            {
                value = config.dexterity.pointcoststart.ToString();
            }
            if (option == "dexmultiplier")
            {
                value = config.dexterity.costmultiplier.ToString();
            }
            if (option == "dexblock")
            {
                double mentcost = config.dexterity.blockchance * 100;
                value = mentcost.ToString();
            }
            if (option == "dexblockamt")
            {
                double mentspeed = config.dexterity.blockamount * 100;
                value = mentspeed.ToString();
            }
            if (option == "dexdodge")
            {
                double mentcrit = config.dexterity.dodgechance * 100;
                value = mentcrit.ToString();
            }
            if (option == "dexarmor")
            {
                double mentcrit = config.dexterity.reducearmordmg * 100;
                value = mentcrit.ToString();
            }
            // Might
            if (option == "mightlevel")
            {
                value = config.might.maxlvl.ToString();
            }
            if (option == "mightcost")
            {
                value = config.might.pointcoststart.ToString();
            }
            if (option == "mightmultiplier")
            {
                value = config.might.costmultiplier.ToString();
            }
            if (option == "mightarmor")
            {
                double might = config.might.armor * 100;
                value = might.ToString();
            }
            if (option == "mightmelee")
            {
                double might = config.might.meleedmg * 100;
                value = might.ToString();
            }
            if (option == "mightmeta")
            {
                double might = config.might.metabolism * 100;
                value = might.ToString();
            }
            if (option == "mightbleed")
            {
                double might = config.might.bleedreduction * 100;
                value = might.ToString();
            }
            if (option == "mightrad")
            {
                double might = config.might.radreduction * 100;
                value = might.ToString();
            }
            if (option == "mightheat")
            {
                double might = config.might.heattolerance * 100;
                value = might.ToString();
            }
            if (option == "mightcold")
            {
                double might = config.might.coldtolerance * 100;
                value = might.ToString();
            }
            // Captaincy
            if (option == "captlevel")
            {
                value = config.captaincy.maxlvl.ToString();
            }
            if (option == "captcost")
            {
                value = config.captaincy.pointcoststart.ToString();
            }
            if (option == "captmultiplier")
            {
                value = config.captaincy.costmultiplier.ToString();
            }
            if (option == "captdistance")
            {
                value = config.captaincy.captaincydistance.ToString();
            }
            if (option == "captskillboost")
            {
                double captskillboost = config.captaincy.skillboost * 100;
                value = captskillboost.ToString();
            }
            if (option == "captxpboost")
            {
                double captxpboost = config.captaincy.xpboost * 100;
                value = captxpboost.ToString();
            }
            if (option == "captxpboostenabled")
            {
                value = config.captaincy.enablexpboost.ToString();
            }
            // WoodCutter
            if (option == "woodcutterlev")
            {
                value = config.woodcutter.maxlvl.ToString();
            }
            if (option == "woodcuttercost")
            {
                value = config.woodcutter.pointcoststart.ToString();
            }
            if (option == "woodcuttermulti")
            {
                value = config.woodcutter.pointcoststart.ToString();
            }
            if (option == "woodcuttergather")
            {
                double woodgather = config.woodcutter.gatherrate * 100;
                value = woodgather.ToString();
            }
            if (option == "woodcutterbonus")
            {
                double woodbonus = config.woodcutter.bonusincrease * 100;
                value = woodbonus.ToString();
            }
            if (option == "woodcutterapple")
            {
                double woodapple = config.woodcutter.applechance * 100;
                value = woodapple.ToString();
            }
            // Smithy
            if (option == "smithylev")
            {
                value = config.smithy.maxlvl.ToString();
            }
            if (option == "smithycost")
            {
                value = config.smithy.pointcoststart.ToString();
            }
            if (option == "smithymulti")
            {
                value = config.smithy.pointcoststart.ToString();
            }
            if (option == "smithyproduction")
            {
                double smithyrate = config.smithy.productionrate * 100;
                value = smithyrate.ToString();
            }
            if (option == "smithyfuel")
            {
                double smithyfuel = config.smithy.fuelconsumption * 100;
                value = smithyfuel.ToString();
            }
            // Miner
            if (option == "minerlev")
            {
                value = config.forager.maxlvl.ToString();
            }
            if (option == "minercost")
            {
                value = config.forager.pointcoststart.ToString();
            }
            if (option == "minermulti")
            {
                value = config.forager.costmultiplier.ToString();
            }
            if (option == "minergather")
            {
                double minergather = config.miner.gatherrate * 100;
                value = minergather.ToString();
            }
            if (option == "minerbonus")
            {
                double minerbonus = config.miner.bonusincrease * 100;
                value = minerbonus.ToString();
            }
            if (option == "minerfuel")
            {
                double minerfuel = config.miner.fuelconsumption * 100;
                value = minerfuel.ToString();
            }
            // Forager
            if (option == "foragerlev")
            {
                value = config.forager.maxlvl.ToString();
            }
            if (option == "foragercost")
            {
                value = config.forager.pointcoststart.ToString();
            }
            if (option == "foragermulti")
            {
                value = config.forager.costmultiplier.ToString();
            }
            if (option == "foragergather")
            {
                double forgrate = config.forager.gatherrate * 100;
                value = forgrate.ToString();
            }
            if (option == "foragerseed")
            {
                double seedchance = config.forager.chanceincrease * 100;
                value = seedchance.ToString();
            }
            if (option == "foragerseedamt")
            {
                double seedamt = config.forager.chanceincrease * 10;
                value = seedamt.ToString();
            }
            if (option == "forageritem")
            {
                double forgitem = config.forager.randomchance * 100;
                value = forgitem.ToString();
            }
            // Hunter
            if (option == "hunterlev")
            {
                value = config.hunter.maxlvl.ToString();
            }
            if (option == "huntercost")
            {
                value = config.hunter.pointcoststart.ToString();
            }
            if (option == "huntermulti")
            {
                value = config.hunter.costmultiplier.ToString();
            }
            if (option == "huntergather")
            {
                double huntrate = config.hunter.gatherrate * 100;
                value = huntrate.ToString();
            }
            if (option == "hunterbonus")
            {
                double huntbonus = config.hunter.bonusincrease * 100;
                value = huntbonus.ToString();
            }
            if (option == "hunterdmg")
            {
                double huntdmg = config.hunter.damageincrease * 100;
                value = huntdmg.ToString();
            }
            if (option == "hunterdmgnight")
            {
                double huntdmgnight = config.hunter.nightdmgincrease * 100;
                value = huntdmgnight.ToString();
            }
            // Fisher
            if (option == "fisherlev")
            {
                value = config.fisher.maxlvl.ToString();
            }
            if (option == "fishercost")
            {
                value = config.fisher.pointcoststart.ToString();
            }
            if (option == "fishermulti")
            {
                value = config.fisher.costmultiplier.ToString();
            }
            if (option == "fisheramt")
            {
                double huntrate = Math.Round(config.fisher.fishamountincrease);
                value = huntrate.ToString();
            }
            if (option == "fisheramtitem")
            {
                double huntbonus = Math.Round(config.fisher.itemamountincrease);
                value = huntbonus.ToString();
            }
            // Crafter
            if (option == "craftlev")
            {
                value = config.crafter.maxlvl.ToString();
            }
            if (option == "craftcost")
            {
                value = config.crafter.pointcoststart.ToString();
            }
            if (option == "craftmulti")
            {
                value = config.crafter.costmultiplier.ToString();
            }
            if (option == "craftspeed")
            {
                double craftspeed = config.crafter.craftspeed * 100;
                value = craftspeed.ToString();
            }
            if (option == "craftcostitem")
            {
                double craftcost = config.crafter.craftcost * 100;
                value = craftcost.ToString();
            }
            if (option == "craftrepair")
            {
                double craftrepair = config.crafter.repairincrease * 100;
                value = craftrepair.ToString();
            }
            if (option == "craftcond")
            {
                double craftcond = config.crafter.conditionchance * 100;
                value = craftcond.ToString();
            }
            // Framer
            if (option == "framerlev")
            {
                value = config.framer.maxlvl.ToString();
            }
            if (option == "framercost")
            {
                value = config.framer.pointcoststart.ToString();
            }
            if (option == "framermulti")
            {
                value = config.framer.costmultiplier.ToString();
            }
            if (option == "framerupgrade")
            {
                double framerupgrade = config.framer.upgradecost * 100;
                value = framerupgrade.ToString();
            }
            if (option == "framerrepair")
            {
                double framerrepair = config.framer.repaircost * 100;
                value = framerrepair.ToString();
            }
            if (option == "framertime")
            {
                double framertime = config.framer.repairtime * 100;
                value = framertime.ToString();
            }
            // Medic
            if (option == "mediclev")
            {
                value = config.medic.maxlvl.ToString();
            }
            if (option == "mediccost")
            {
                value = config.medic.pointcoststart.ToString();
            }
            if (option == "medicmulti")
            {
                value = config.medic.costmultiplier.ToString();
            }
            if (option == "medichpp")
            {
                value = config.medic.revivehp.ToString();
            }
            if (option == "medichp")
            {
                value = config.medic.recoverhp.ToString();
            }
            if (option == "mediccraft")
            {
                double mediccraft = config.medic.crafttime * 100;
                value = mediccraft.ToString();
            }
            // Tamer
            if (option == "tamerenabled")
            {
                value = config.tamer.enabletame.ToString();
            }
            if (option == "tamerlev")
            {
                value = config.tamer.maxlvl.ToString();
            }
            if (option == "tamercost")
            {
                value = config.tamer.pointcoststart.ToString();
            }
            if (option == "tamermulti")
            {
                value = config.tamer.costmultiplier.ToString();
            }
            if (option == "tamerchicken")
            {
                value = config.tamer.tamechicken.ToString();
            }
            if (option == "tamerchickenlev")
            {
                value = config.tamer.chickenlevel.ToString();
            }
            if (option == "tamerboar")
            {
                value = config.tamer.tameboar.ToString();
            }
            if (option == "tamerboarlev")
            {
                value = config.tamer.boarlevel.ToString();
            }
            if (option == "tamerstag")
            {
                value = config.tamer.tamestag.ToString();
            }
            if (option == "tamerstaglev")
            {
                value = config.tamer.staglevel.ToString();
            }
            if (option == "tamerwolf")
            {
                value = config.tamer.tamewolf.ToString();
            }
            if (option == "tamerwolflev")
            {
                value = config.tamer.wolflevel.ToString();
            }
            if (option == "tamerbear")
            {
                value = config.tamer.tamebear.ToString();
            }
            if (option == "tamerbearlev")
            {
                value = config.tamer.bearlevel.ToString();
            }
            // Return Values
            return value;
        }
        private double RankBoosts(BasePlayer player, double amount)
        {
            XPRecord record = GetXPRecord(player);
            if (record.rank <= 0 || record.DisableRank) return amount;
            if(config.xpLevelRanks.rankstatboost && !record.DisableRank)
            {
                amount += config.xpLevelRanks.rankskillboostamount * record.rank; 
            }
             if(config.xpLevelRanks.rankskillboost && !record.DisableRank)
            {
                amount += config.xpLevelRanks.rankskillboostamount * record.rank;
            }
            return amount;
        }
        #endregion

        #region UI Constants
        // Player Info
        private const string XPeriencePlayerInfoBox = "XPeriencePlayerInfoBox";
        // Live Stats
        private const string XPerienceLivePrimary = "XPerienceLivePrimary";
        private const string XPerienceLiveIcon = "XPerienceLiveIcon";
        private const string XPerienceLiveData = "XPerienceLiveData";
        private const string XPerienceLiveFuel = "XPerienceLiveFuel";
        private const string XPerienceLiveFuelBar = "XPerienceLiveFuelBar";
        private const string XPerienceLiveSpeed = "XPerienceLiveSpeed";
        private const string XPerienceLiveSpeedIcon = "XPerienceLiveSpeedIcon";
        private const string XPerienceLiveSpeedBar = "XPerienceLiveSpeedBar";
        private const string XPerienceLiveDashPanel = "XPerienceLiveDashPanel";
        private const string XPerienceLiveDashPanelSet = "XPerienceLiveDashPanelSet";
        // Player Panels
        private const string XPeriencePlayerControlPrimary = "XPeriencePlayerControlPrimary";
        private const string XPeriencePlayerControlMain = "XPeriencePlayerControlMain";
        private const string XPeriencePlayerControlStats = "XPeriencePlayerControlStats";
        private const string XPeriencePlayerControlSkills = "XPeriencePlayerControlSkills";
        private const string XPeriencePlayerControlSkillsL = "XPeriencePlayerControlSkillsL";
        private const string XPeriencePlayerControlSkillsR = "XPeriencePlayerControlSkillsR";
        // New Player Panels
        private const string XPeriencePlayerControlFullMain = "XPeriencePlayerControlFullMain";
        private const string XPeriencePlayerControlFullInfo = "XPeriencePlayerControlFullInfo";
        private const string XPeriencePlayerControlFullHelp = "XPeriencePlayerControlFullHelp";
        private const string XPeriencePlayerControlFullHelpNav = "XPeriencePlayerControlFullHelpNav";
        private const string XPeriencePlayerControlFullMenu = "XPeriencePlayerControlFullMenu";
        private const string XPeriencePlayerControlFullKR = "XPeriencePlayerControlFullKR";
        private const string XPeriencePlayerControlFullLiveStatLoc = "XPeriencePlayerControlFullLiveStatLoc";
        private const string XPeriencePlayerControlFullDisableRankLoc = "XPeriencePlayerControlFullDisableRankLoc";
        private const string XPeriencePlayerControlFullFixData = "XPeriencePlayerControlFullFixData";
        private const string XPeriencePlayerControlFullTamerBox = "XPeriencePlayerControlFullTamerBox";
        private const string XPeriencePlayerControlFullArcheryBox = "XPeriencePlayerControlFullArcheryBox";
        private const string XPeriencePlayerControlFullWizardryBox = "XPeriencePlayerControlFullWizardryBox";
        // Top List UI
        private const string XPerienceTopMain = "XPerienceTopMain";
        private const string XPerienceTopSelection = "XPerienceTopSelection";
        private const string XPerienceTopInner = "XPerienceTopInner";
        private const string XPerienceTopPageSelection = "XPerienceTopPageSelection";
        private const string XPerienceHelp = "XPerienceHelp";
        // Admin Panels
        private const string XPerienceAdminPanelMain = "XPerienceAdminPanelMain";
        private const string XPerienceAdminPanelMenu = "XPerienceAdminPanelMenu";
        private const string XPerienceAdminPanelInfo = "XPerienceAdminPanelInfo";
        private const string XPerienceAdminPanelLevelXP = "XPerienceAdminPanelLevelXP";
        private const string XPerienceAdminPanelStats = "XPerienceAdminPanelStats";
        private const string XPerienceAdminPanelSkills = "XPerienceAdminPanelSkills";
        private const string XPerienceAdminPanelTimerColor = "XPerienceAdminPanelTimerColor";
        private const string XPerienceAdminPanelOtherMods = "XPerienceAdminPanelOtherMods";
        private const string XPerienceAdminPanelSQL = "XPerienceAdminPanelSQL";
        private const string XPerienceAdminPanelReset = "XPerienceAdminPanelReset";
        private const string XPerienceAdminPanelInfoBox = "XPerienceAdminPanelInfoBox";
        private const string XPerienceAdminPanelAddon = "XPerienceAdminPanelAddon";
        // Images
        private const string XPerienceicon = "XPerienceicon";
        private const string XPeriencelogo = "XPeriencelogo";
        private const string XPeriencementality = "XPeriencementality";
        private const string XPeriencedexterity = "XPeriencedexterity";
        private const string XPeriencemight = "XPeriencemight";
        private const string XPeriencecaptaincy = "XPeriencecaptaincy";
        private const string XPerienceweaponry = "XPerienceweaponry";
        private const string XPeriencewoodcutter = "XPeriencewoodcutter";
        private const string XPeriencesmithy = "XPeriencesmithy";
        private const string XPerienceminer = "XPerienceminer";
        private const string XPerienceforager = "XPerienceforager";
        private const string XPeriencehunter = "XPeriencehunter";
        private const string XPeriencefisher = "XPeriencefisher";
        private const string XPeriencecrafter = "XPeriencecrafter";
        private const string XPerienceframer = "XPerienceframer";
        private const string XPeriencemedic = "XPeriencemedic";
        private const string XPeriencescavenger = "XPeriencescavenger";
        private const string XPeriencetamer = "XPeriencetamer";
        private const string XPeriencechicken = "XPeriencechicken";
        private const string XPerienceboar = "XPerienceboar";
        private const string XPeriencestag = "XPeriencestag";
        private const string XPeriencewolf = "XPeriencewolf";
        private const string XPeriencebear = "XPeriencebear";
        private const string XPeriencepolarbear = "XPeriencepolarbear";
        private const string XPeriencearchery = "XPeriencearchery";
        private const string XPeriencewizardry = "XPeriencewizardry";
        private const string XPerienceonline = "XPerienceonline";
        private const string XPerienceoffline = "XPerienceoffline";
        private const string XPeriencebackpack = "XPeriencebackpack";
        private const string XPeriencelevel = "XPeriencelevel";
        private const string XPeriencexp = "XPeriencexp";
        private const string XPeriencearmor = "XPeriencearmor";
        private const string XPeriencelevel0 = "XPeriencelevel0";
        private const string XPeriencelevel2 = "XPeriencelevel2";
        private const string XPeriencelevel4 = "XPeriencelevel4";
        private const string XPeriencelevel6 = "XPeriencelevel6";
        private const string XPeriencelevel8 = "XPeriencelevel8";
        private const string XPeriencelevel10 = "XPeriencelevel10";
        private const string XPeriencefuelguage = "XPeriencefuelguage";
        private const string XPeriencespeedometer = "XPeriencespeedometer";
        private const string XPeriencedash = "XPeriencedash";
        #endregion

        #region Colors/Symbols
        private object TextColor(BasePlayer player, string type, double value)
        {
            string color = config.uitextColor.defaultcolor;
            if (value > 0)
                switch (type)
                {
                    case "default":
                        color = config.uitextColor.defaultcolor;
                        break;
                    case "mainlevel":
                        color = config.uitextColor.level;
                        break;
                    case "experience":
                        color = config.uitextColor.experience;
                        break;
                    case "nextlevel":
                        color = config.uitextColor.nextlevel;
                        break;
                    case "remainingxp":
                        color = config.uitextColor.remainingxp;
                        break;
                    case "level":
                        color = config.uitextColor.statskilllevels;
                        break;
                    case "perk":
                        color = config.uitextColor.perks;
                        break;
                    case "unspent":
                        color = config.uitextColor.unspentpoints;
                        break;
                    case "spent":
                        color = config.uitextColor.spentpoints;
                        break;
                    case "pets":
                        color = config.uitextColor.pets;
                        break;
                    case "rankname":
                        color = config.uitextColor.rankname;
                        break;
                    case "ranklevel":
                        color = config.uitextColor.ranklevel;
                        break;
                    case "rankxp":
                        color = config.uitextColor.rankxp;
                        break;
                }
            if (value < 0)
                color = "red";
            return color;
        }
        private object ValueSymbol(string type, double value, string symbol)
        {
            if (type == "perk" && value > 0 && symbol == "neg")
            {
                symbol = "-";
            }
            if (type == "perk" && value > 0 && symbol == "pos")
            {
                symbol = "+";
            }
            if (type == "perk" && value < 0 && (symbol == "neg" || symbol == "pos"))
            {
                symbol = "";
            }

            // Return Symbol
            return symbol;
        }
        private object LiveUISelection(string selection, int value)
        {
            string color = "1 1 1 1";
            switch (selection)
            {
                case "UI0":
                    if (value == 0)
                        color = "0 1 0 1";
                    break;
                case "UI1":
                    if (value == 1)
                        color = "0 1 0 1";
                    break;
                case "UI2":
                    if (value == 2)
                        color = "0 1 0 1";
                    break;
                case "UI3":
                    if (value == 3)
                        color = "0 1 0 1";
                    break;
                case "UI4":
                    if (value == 4)
                        color = "0 1 0 1";
                    break;
                case "UI5":
                    if (value == 5)
                        color = "0 1 0 1";
                    break;
            }
            // Return Color
            return color;
        }
        private object DashSelection(int selection, int value)
        {
            string color = "1 1 1 1";
            switch (selection)
            {
                case 1:
                    if (value == 1)
                        color = "0 1 0 1";
                    break;
                case 2:
                    if (value == 2)
                        color = "0 1 0 1";
                    break;
            }
            // Return Color
            return color;
        }
        private object DisableRankSelection(string selection, bool value, string color = "1 0 0 1")
        {
            switch (selection)
            {
                case "Yes":
                    if(value)
                    color = "0 1 0 1";
                    break;
                case "No":
                    if(!value)
                    color = "0 1 0 1";
                    break;
            }
            // Return Color
            return color;
        }
        private object ColorConverter(string color) 
        {
            string hexcolor = color;
            switch(color)
            {
                case "white":
                    hexcolor = "#FFFFFF";
                    break;
                case "red":
                    hexcolor = "#FF0000";
                    break;
                case "green":
                    hexcolor = "#00FF00";
                    break;
                case "blue":
                    hexcolor = "#0000FF";
                    break;
                case "cyan":
                    hexcolor = "#00FFFF";
                    break;
                case "grey":
                    hexcolor = "#808080";
                    break;
                case "magenta":
                    hexcolor = "#FF00FF";
                    break;
                case "yellow":
                    hexcolor = "#FFFF00";
                    break;
            }
            return hexcolor; 
        }
        #endregion

        #region Default UI Panels
        // UI Defaults
        private CuiPanel XPUIPanel(string anchorMin, string anchorMax, string color = "0 0 0 0")
        {
            return new CuiPanel
            {
                RectTransform =
                {
                    AnchorMin = anchorMin,
                    AnchorMax = anchorMax
                },
                Image =
                {
                    Color = color
                }
            };
        }
        private CuiPanel XPUIPanel2(string anchorMin, string anchorMax, string offsetMin, string offsetMax, string color = "0 0 0 0")
        {
            return new CuiPanel
            {
                RectTransform =
                {
                    AnchorMin = anchorMin,
                    AnchorMax = anchorMax,
                    OffsetMin = offsetMin,
                    OffsetMax = offsetMax
                },
                Image =
                {
                    Color = color
                }
            };
        }
        private CuiLabel XPUILabel(string text, int i, float height, TextAnchor align = TextAnchor.MiddleLeft, int fontSize = 13, string xMin = "0", string xMax = "1", string color = "1.0 1.0 1.0 1.0")
        {
            return new CuiLabel
            {
                RectTransform =
                {
                    AnchorMin = $"{xMin} {1 - height*i + i * .002f}",
                    AnchorMax = $"{xMax} {1 - height*(i-1) + i * .002f}"
                },
                Text =
                {
                    Text = text,
                    FontSize = fontSize,
                    Align = align,
                    Color = color
                }
            };
        }
        private CuiButton XPUIButton(string command, double i, float rowHeight, int fontSize = 11, string color = "1.0 0.0 0.0 0.7", string content = "+", string xMin = "0", string xMax = "1", TextAnchor align = TextAnchor.MiddleLeft, string fcolor = "1.0 1.0 1.0 1.0")
        {
            return new CuiButton
            {
                Button =
                {
                    Command = command,
                    Color = $"{color}"
                },
                RectTransform =
                {
                    AnchorMin = $"{xMin} {1 - rowHeight*i + i * .002f}",
                    AnchorMax = $"{xMax} {1 - rowHeight*(i-1) + i * .002f}"
                },
                Text =
                {
                    Text = content,
                    FontSize = fontSize,
                    Align = align,
                    Color = fcolor,
                }
            };
        }
        private CuiElement XPUIImage(string parent, string image, int i, float imgheight, string xMin = "0", string xMax = "1")
        {
            return new CuiElement
            {
                Parent = parent,
                Components =
                {
                    new CuiRawImageComponent
                    {
                        Png = ImageLibrary?.Call<string>("GetImage", image)
                    },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = $"{xMin} {1 - imgheight*i + i * .002f}",
                        AnchorMax = $"{xMax} {1 - imgheight*(i-1) + i * .002f}"
                    }
                }
            };
        }
        private void DestroyUi(BasePlayer player, string name)
        {
            CuiHelper.DestroyUi(player, name);
        }
        #endregion

        #region Player Panels
        // Handlers
        [ConsoleCommand("xp.playercontrol")]
        private void Cmdplayercontrolnew(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            string page = arg.GetString(0);
            string type = arg.GetString(1);
            switch (page)
            {
                case "main":
                    DestroyUi(player, XPeriencePlayerControlFullMain);
                    DestroyUi(player, XPerienceTopMain);
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    PlayerControlPanelFullMain(player);
                    PlayerInfoPage(player);
                    break;
                case "selectedplayer":
                    string selectedplayer = arg.GetString(1);
                    DestroyUi(player, XPeriencePlayerControlFullMain);
                    DestroyUi(player, XPerienceTopMain);
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    SelectedPlayerPanelFullMain(player, selectedplayer);
                    SelectedPlayerInfoPage(player, selectedplayer);
                    break;
                case "topplayers":
                    DestroyUi(player, XPeriencePlayerControlFullMain);
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    TopPlayerPanelFullMain(player, "level");
                    TopLevels(player, 1, "level", 0);
                    break;
                case "reset":
                    switch (type)
                    {
                        case "stats":
                            if (config.defaultOptions.hardcorenoreset)
                            {
                                player.ChatMessage(XPLang("hardcorenoreset", player.UserIDString));
                                return;
                            }
                            StatsReset(player);
                            DestroyUi(player, XPeriencePlayerControlFullMain);
                            PlayerControlPanelFullMain(player);
                            PlayerInfoPage(player);
                            break;
                        case "skills":
                            if (config.defaultOptions.hardcorenoreset)
                            {
                                player.ChatMessage(XPLang("hardcorenoreset", player.UserIDString));
                                return;
                            }
                            SkillsReset(player);
                            DestroyUi(player, XPeriencePlayerControlFullMain);
                            PlayerControlPanelFullMain(player);
                            PlayerInfoPage(player);
                            break;
                    }
                    break;
                case "killrecords":
                    string selectedplayerkr = arg.GetString(1);
                    DestroyUi(player, XPeriencePlayerControlFullInfo);
                    DestroyUi(player, XPeriencePlayerControlFullKR);
                    DestroyUi(player, XPeriencePlayerControlFullLiveStatLoc);
                    DestroyUi(player, XPeriencePlayerControlFullFixData);
                    DestroyUi(player, XPeriencePlayerControlFullHelp);
                    DestroyUi(player, XPeriencePlayerControlFullHelpNav);
                    DestroyUi(player, XPeriencePlayerControlFullTamerBox);
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    DestroyUi(player, XPerienceTopMain);
                    PlayerKillRecordsPage(player, selectedplayerkr);
                    break;
                case "deathrecords":
                    if (XPerienceAddon != null)
                    {
                        DestroyUi(player, XPeriencePlayerControlFullMain);
                        XPerienceAddon.Call<string>("PlayerControlPanel", player);
                        XPerienceAddon.Call<string>("PlayerDeathRecordsList", player);
                    }
                    break;
                case "close":
                    DestroyUi(player, XPeriencePlayerControlFullMain);
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    break;
                case "openbox":
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    string selectedplayerbox = arg.GetString(1);
                    PlayerInfoBox(player, selectedplayerbox);
                    break;
                case "closebox":
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    break;
                case "help":
                    DestroyUi(player, XPeriencePlayerControlFullInfo);
                    DestroyUi(player, XPeriencePlayerControlFullKR);
                    DestroyUi(player, XPeriencePlayerControlFullLiveStatLoc);
                    DestroyUi(player, XPeriencePlayerControlFullFixData);
                    DestroyUi(player, XPeriencePlayerControlFullHelp);
                    DestroyUi(player, XPeriencePlayerControlFullHelpNav);
                    DestroyUi(player, XPeriencePlayerControlFullTamerBox);
                    DestroyUi(player, XPerienceTopMain);
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    PlayerHelpPage(player, 0);
                    break;
                case "fix":
                    PlayerFixData(player);
                    DestroyUi(player, XPeriencePlayerControlFullMain);
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    PlayerControlPanelFullMain(player);
                    PlayerInfoPage(player);
                    break;
                case "admin":
                    if (!player.IsAdmin && !permission.UserHasPermission(player.UserIDString, Admin)) return;
                    DestroyUi(player, XPeriencePlayerControlFullMain);
                    DestroyUi(player, XPerienceAdminPanelMain);
                    DestroyUi(player, XPerienceTopMain);
                    DestroyUi(player, XPeriencePlayerInfoBox);
                    AdminControlPanel(player);
                    AdminInfoPage(player);
                    break;
            }
        }
        [ConsoleCommand("xp.playeredits")]
        private void Cmdplayeredits(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            string type = arg.GetString(0);
            switch (type)
            {
                case "liveui":
                    int location = arg.GetInt(1);
                    _xperienceCache[player.UserIDString].UILocation = location;
                    LiveStats(player, true);
                    DestroyUi(player, XPeriencePlayerControlFullInfo);
                    PlayerInfoPage(player);
                    break;
                case "dash":
                    int dash = arg.GetInt(1);
                    _xperienceCache[player.UserIDString].dash = (int)dash;
                    if (dash == 1)
                    {
                        FuelGauge(player, false, 0);
                        Speedometer(player, false, 0, "none");
                    }
                    if (dash == 2)
                    {
                        FuelGauge(player, false, 0);
                        Speedometer(player, false, 0, "none");
                        DashPanel(player, false, 0, 0, "none");
                    }
                    DestroyUi(player, XPeriencePlayerControlFullInfo);
                    PlayerInfoPage(player);
                    break;
                case "fuelgauge":
                    bool fuelgauge = arg.GetBool(1);
                    _xperienceCache[player.UserIDString].fuelgauge = fuelgauge;
                    FuelGauge(player, fuelgauge, 0);
                    DestroyUi(player, XPeriencePlayerControlFullInfo);
                    PlayerInfoPage(player);
                    break;
                case "speedometer":
                    bool speedometer = arg.GetBool(1);
                    _xperienceCache[player.UserIDString].speedometer = speedometer;
                    Speedometer(player, speedometer, 0, "none");
                    DestroyUi(player, XPeriencePlayerControlFullInfo);
                    PlayerInfoPage(player);
                    break;
                case "speedometertype":
                    int speedometertype = arg.GetInt(1);
                    _xperienceCache[player.UserIDString].speedometertype = (int)speedometertype;
                    DestroyUi(player, XPeriencePlayerControlFullInfo);
                    PlayerInfoPage(player);
                    break;
                case "stat":
                    StatUp(player, arg.GetString(1));
                    DestroyUi(player, XPeriencePlayerControlFullInfo);
                    PlayerInfoPage(player);
                    break;
                case "skill":
                    SkillUp(player, arg.GetString(1));
                    DestroyUi(player, XPeriencePlayerControlFullInfo);
                    PlayerInfoPage(player);
                    break;
                case "help":
                    int page = arg.GetInt(1);
                    DestroyUi(player, XPeriencePlayerControlFullHelp);
                    PlayerHelpPage(player, page);
                    break;
                case "disableranks":
                    bool option = arg.GetBool(1);
                    _xperienceCache[player.UserIDString].DisableRank = option;
                    LiveStats(player, true);
                    DestroyUi(player, XPeriencePlayerControlFullMain);
                    PlayerControlPanelFullMain(player);
                    PlayerInfoPage(player);
                    break;
            }
        }
        private string LevelIcon(BasePlayer player, int percent)
        {
            object levelicon = XPeriencelevel;
            if (percent < 20)
            {
                levelicon = XPeriencelevel0;
            }
            else if (percent >= 20 && percent < 40) 
            {
                levelicon = XPeriencelevel2;
            }
            else if (percent >= 40 && percent < 60) 
            {
                levelicon = XPeriencelevel4;
            }
            else if (percent >= 60 && percent < 80) 
            {
                levelicon = XPeriencelevel6;
            }
            else if (percent >= 80 && percent < 95) 
            {
                levelicon = XPeriencelevel8;
            }
            else if (percent >= 95) 
            {
                levelicon = XPeriencelevel10;
            }
            return levelicon.ToString();
        }
        private object PlayerTimeValues(BasePlayer player, string type, double value)
        {
            if(type == "lifespan"){value = CurrentTime - value;}
            double minutes = (int)(value % 3600) / 60;
            double hours = (int)(value % 86400) / 3600;
            double days = (int)(value % (86400 * 30)) / 86400;
            string showdays = "";
            string showhours = "";
            string showmins = "";
            if(days > 0)
            {
                showdays = $"Days: <color={TextColor(player, "level", days)}>{days}</color> ";
            }
            if(hours > 0)
            {
                showhours = $"Hours: <color={TextColor(player, "level", hours)}>{hours}</color> ";
            }
            if(minutes > 0)
            {
                showmins = $"Mins: <color={TextColor(player, "level", minutes)}>{minutes}</color> ";
            }
            if(days == 0 && hours == 0 && minutes == 0)
            {
                return 0;
            }
            string playertime = $"{showdays}{showhours}{showmins}";
            return playertime;     
        }
        private object PlayerInfoValues(BasePlayer player, BaseEntity entity, string type)
        {
            string DMGType = entity?.GetType().Name;
            switch (type)
            {
                case "dmgrecieved":
                    if (DMGType == "BasePlayer")
                    {
                        var playername = entity as BasePlayer;
                        DMGType = playername.displayName; 
                    }
                    return DMGType;
                case "dmgdelt":
                    if (DMGType == "BasePlayer") 
                    {
                        var playername = entity as BasePlayer;
                        DMGType = playername.displayName; 
                    }
                    return DMGType;
            }
            return DMGType;
        }
        // Live Stats
        private void LiveStats(BasePlayer player, bool update = false, string consumable = "none")
        {
            if (player == null || !player.userID.IsSteamId() || player.IsNpc) return;
            DestroyUi(player, XPerienceLivePrimary);
            XPRecord xprecord = GetXPRecord(player);
            Ranks rank = GetXPRank(xprecord.rank);
            if (xprecord == null || xprecord.UILocation == 0)
            {
                DestroyUi(player, XPerienceLivePrimary);
                return;
            }
            if (update)
            {
                DestroyUi(player, XPerienceLivePrimary);
            }
            // XP Bar Calculations
            double lastlevel;
            double nextlevel;
            double currentxp;
            double reqxpperc;
            double remainingxp;
            double levelpercent;
            if (xprecord.experience == 0 || xprecord.level == 0)
            {
                lastlevel = 0;
                nextlevel = config.xpLevel.levelstart;
                currentxp = xprecord.experience - lastlevel;
                reqxpperc = (xprecord.experience - lastlevel) / nextlevel;
                remainingxp = nextlevel - currentxp;
                levelpercent = reqxpperc * 100;
            }
            else
            {
                lastlevel = xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier);
                nextlevel = xprecord.requiredxp - lastlevel;
                currentxp = xprecord.experience - lastlevel;
                reqxpperc = (xprecord.experience - lastlevel) / nextlevel;
                remainingxp = nextlevel - currentxp;
                levelpercent = reqxpperc * 100;
            }
            // Armor Bar Calculations
            if (GetTeaCooldown(player) == 0)
            {
                xprecord.teacooldown = 0;
                xprecord.teatype = consumable;
            }
            double armor = (xprecord.Might * config.might.armor) * 100;
            double maxhealth = player._maxHealth - armor;
            double playerhealth = player._health;
            double currentarmor = 0;
            // Default Armor - No Tea Effects
            if (player._health > maxhealth)
            {
                currentarmor = Math.Ceiling((player._health - maxhealth));
            }
            // Extra Armor - Add Tea Effects
            double teatime = 1200;
            double teaboost = 0;
            bool teamodified = false;
            // Check for TeaModifier Plugin and Values
            if (TeaModifiers != null)
            {
                teatime = TeaModifiers.Call<float>("GetTeaDuration", player, consumable, Modifier.ModifierType.Max_Health);
                teaboost = TeaModifiers.Call<float>("GetTeaValue", player, consumable, Modifier.ModifierType.Max_Health) * 100;
                teamodified = true;
            }
            // Update PlayerData
            if (consumable.Contains("maxhealthtea"))
            {
                xprecord.teacooldown = (double)CurrentTime + teatime;
                xprecord.teatype = consumable;
            }
            // Get Updated Data
            if (GetTeaCooldown(player) != 0)
            {
                if (teamodified)
                {
                    teaboost = TeaModifiers.Call<float>("GetTeaValue", player, xprecord.teatype, Modifier.ModifierType.Max_Health) * 100;
                }
                switch (GetTeaTypes(player))
                {
                    case "none":
                        teaboost = 0;
                        break;
                    case "maxhealthtea":
                        if (!teamodified)
                        {
                            teaboost = 5;
                        }
                        break;
                    case "maxhealthtea.advanced":
                        if (!teamodified)
                        {
                            teaboost = 12.5;
                        }
                        break;
                    case "maxhealthtea.pure":
                        if (!teamodified)
                        {
                            teaboost = 20;
                        }
                        break;
                }
            }
            // Apply Results to Armor
            if (GetTeaCooldown(player) != 0)
            {
                playerhealth += teaboost;
                if (playerhealth > maxhealth)
                {
                    if (teamodified)
                    {
                        currentarmor = Math.Ceiling((player._health - maxhealth) - teaboost);
                    }
                    if (!teamodified)
                    {
                        currentarmor = Math.Ceiling((player._health - maxhealth) - teaboost);
                    }
                    if (currentarmor < 0) currentarmor = 0;
                    armor += Math.Ceiling((teaboost * config.might.armor) * xprecord.Might);
                }
            }
            // Calculate Armor Bar Display
            var armorperc = currentarmor / armor;
            // Live Stats Display
            var LIVEelements = new CuiElementContainer();
            string levelicon = XPeriencelevel;
            if (config.defaultOptions.useprogressivelevelicons) 
            {
                levelicon = LevelIcon(player, (int)levelpercent);
            }
            switch (xprecord.UILocation)
            {           
                case 1:
                    #region LIVEloc1
                    // Live UI Box
                    LIVEelements.Add(XPUIPanel2("1 0", "1 0", "-392 16", "-210 126", "0.5 0.5 0.5 0"), "Hud", XPerienceLivePrimary);
                    // Rank
                    if (config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui && !xprecord.DisableRank)
                    {
                        if (xprecord.Might > 0 && config.might.armor > 0)
                        {
                            LIVEelements.Add(XPUIPanel("0 0.76", "0.125 0.95"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.13 0.76", "0.99 0.99", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                        else
                        {
                            LIVEelements.Add(XPUIPanel("0 0.51", "0.125 0.70"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.13 0.51", "0.99 0.735", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                    }
                    // Armor
                    if (xprecord.Might > 0 && config.might.armor > 0)
                    {
                        LIVEelements.Add(XPUIPanel("0 0.51", "0.125 0.70"), XPerienceLivePrimary, XPerienceLiveIcon);
                        LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencearmor, 1, .9f, "0.15", "0.85"));
                        LIVEelements.Add(XPUIPanel("0.13 0.51", "0.99 0.735", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                        LIVEelements.Add(XPUIPanel("0.01 0.145", $"{armorperc - 0.01} 0.845", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        LIVEelements.Add(XPUILabel($"{currentarmor}   /   {armor}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    }
                    // Level
                    LIVEelements.Add(XPUIPanel("0 0.255", "0.125 0.44"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, levelicon, 1, .9f, "0.15", "0.95"));
                    LIVEelements.Add(XPUIPanel("0.13 0.255", "0.99 0.480", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{XPLang("level", player.UserIDString)}: {xprecord.level} ({(int)levelpercent}%)", 1, 1.06f, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    // XP
                    LIVEelements.Add(XPUIPanel("0 0", "0.125 0.185"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencexp, 1, .9f, "0.15", "0.80"));
                    LIVEelements.Add(XPUIPanel("0.13 0", "0.99 0.23", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUIPanel("0.01 0.135", $"{reqxpperc - 0.01} 0.845", "0.05 1.05 0.05 0.80"), XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{(int)remainingxp}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    #endregion
                    break;
                case 2:
                    #region LIVEloc2
                    // Live UI Box
                    LIVEelements.Add(XPUIPanel2("0 0", "0 0", "10 16", "210 126", "0.5 0.5 0.5 0"), "Hud", XPerienceLivePrimary);
                    // Rank
                    if (config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui && !xprecord.DisableRank)
                    {
                        if (xprecord.Might > 0 && config.might.armor > 0)
                        {
                            LIVEelements.Add(XPUIPanel("0 0.76", "0.125 0.95"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.13 0.76", "0.99 0.99", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                        else
                        {
                            LIVEelements.Add(XPUIPanel("0 0.51", "0.125 0.70"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.13 0.51", "0.99 0.735", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                    }
                    // Armor
                    if (xprecord.Might > 0 && config.might.armor > 0)
                    {
                        LIVEelements.Add(XPUIPanel("0 0.51", "0.125 0.70"), XPerienceLivePrimary, XPerienceLiveIcon);
                        LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencearmor, 1, .9f, "0.15", "0.85"));
                        LIVEelements.Add(XPUIPanel("0.13 0.51", "0.99 0.735", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                        LIVEelements.Add(XPUIPanel("0.01 0.145", $"{armorperc - 0.01} 0.845", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        LIVEelements.Add(XPUILabel($"{currentarmor}   /   {armor}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    }
                    // Level
                    LIVEelements.Add(XPUIPanel("0 0.255", "0.125 0.44"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, levelicon, 1, .9f, "0.15", "0.95"));
                    LIVEelements.Add(XPUIPanel("0.13 0.255", "0.99 0.480", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{XPLang("level", player.UserIDString)}: {xprecord.level} ({(int)levelpercent}%)", 1, 1.06f, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    // XP
                    LIVEelements.Add(XPUIPanel("0 0", "0.125 0.185"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencexp, 1, .9f, "0.15", "0.80"));
                    LIVEelements.Add(XPUIPanel("0.13 0", "0.99 0.23", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUIPanel("0.01 0.135", $"{reqxpperc - 0.01} 0.845", "0.05 1.05 0.05 0.80"), XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{(int)remainingxp}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    #endregion
                    break;
                case 3:
                    #region LIVEloc3
                    // Live UI Box
                    LIVEelements.Add(XPUIPanel2("0 1", "0 1", "10 -126", "210 -16", "0.5 0.5 0.5 0"), "Hud", XPerienceLivePrimary);
                    // Rank
                    if (config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui && !xprecord.DisableRank)
                    {
                        if (xprecord.Might > 0 && config.might.armor > 0)
                        {
                            LIVEelements.Add(XPUIPanel("0 0.76", "0.125 0.95"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.13 0.76", "0.99 0.99", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                        else
                        {
                            LIVEelements.Add(XPUIPanel("0 0.51", "0.125 0.70"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.13 0.51", "0.99 0.735", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                    }
                    // Armor
                    if (xprecord.Might > 0 && config.might.armor > 0)
                    {
                        LIVEelements.Add(XPUIPanel("0 0.51", "0.125 0.70"), XPerienceLivePrimary, XPerienceLiveIcon);
                        LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencearmor, 1, .9f, "0.15", "0.85"));
                        LIVEelements.Add(XPUIPanel("0.13 0.51", "0.99 0.735", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                        LIVEelements.Add(XPUIPanel("0.01 0.145", $"{armorperc - 0.01} 0.845", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        LIVEelements.Add(XPUILabel($"{currentarmor}   /   {armor}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    }
                    // Level
                    LIVEelements.Add(XPUIPanel("0 0.255", "0.125 0.44"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, levelicon, 1, .9f, "0.15", "0.95"));
                    LIVEelements.Add(XPUIPanel("0.13 0.255", "0.99 0.480", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{XPLang("level", player.UserIDString)}: {xprecord.level} ({(int)levelpercent}%)", 1, 1.06f, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    // XP
                    LIVEelements.Add(XPUIPanel("0 0", "0.125 0.185"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencexp, 1, .9f, "0.15", "0.80"));
                    LIVEelements.Add(XPUIPanel("0.13 0", "0.99 0.23", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUIPanel("0.01 0.135", $"{reqxpperc - 0.01} 0.845", "0.05 1.05 0.05 0.80"), XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{(int)remainingxp}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    #endregion
                    break;
                case 4:
                    #region LIVEloc4
                    // Live UI Box
                    LIVEelements.Add(XPUIPanel2("1 1", "1 1", "-210 -126", "-10 -16", "0.5 0.5 0.5 0"), "Hud", XPerienceLivePrimary);
                    // Rank
                    if (config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui && !xprecord.DisableRank)
                    {
                        if (xprecord.Might > 0 && config.might.armor > 0)
                        {
                            LIVEelements.Add(XPUIPanel("0 0.76", "0.125 0.95"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.13 0.76", "0.99 0.99", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                        else
                        {
                            LIVEelements.Add(XPUIPanel("0 0.51", "0.125 0.70"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.13 0.51", "0.99 0.735", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                    }
                    // Armor
                    if (xprecord.Might > 0 && config.might.armor > 0)
                    {
                        LIVEelements.Add(XPUIPanel("0 0.51", "0.125 0.70"), XPerienceLivePrimary, XPerienceLiveIcon);
                        LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencearmor, 1, .9f, "0.15", "0.85"));
                        LIVEelements.Add(XPUIPanel("0.13 0.51", "0.99 0.735", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                        LIVEelements.Add(XPUIPanel("0.01 0.145", $"{armorperc - 0.01} 0.845", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        LIVEelements.Add(XPUILabel($"{currentarmor}   /   {armor}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    }
                    // Level
                    LIVEelements.Add(XPUIPanel("0 0.255", "0.125 0.44"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, levelicon, 1, .9f, "0.15", "0.95"));
                    LIVEelements.Add(XPUIPanel("0.13 0.255", "0.99 0.480", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{XPLang("level", player.UserIDString)}: {xprecord.level} ({(int)levelpercent}%)", 1, 1.06f, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    // XP
                    LIVEelements.Add(XPUIPanel("0 0", "0.125 0.185"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencexp, 1, .9f, "0.15", "0.80"));
                    LIVEelements.Add(XPUIPanel("0.13 0", "0.99 0.23", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUIPanel("0.01 0.135", $"{reqxpperc - 0.01} 0.845", "0.05 1.05 0.05 0.80"), XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{(int)remainingxp}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    #endregion
                    break;
                case 5:
                    #region LIVEloc5
                    // Live UI Box
                    LIVEelements.Add(XPUIPanel2("0.5 0", "0.5 0", "-200 0", "181.5 115", "0 0 0 0"), "Hud", XPerienceLivePrimary);
                    // Rank
                    if (config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui && !xprecord.DisableRank)
                    {
                        if (xprecord.Might > 0 && config.might.armor > 0)
                        {
                            LIVEelements.Add(XPUIPanel("0 0.845", "0.06 1"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.062 0.845", "0.995 0.99", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                        else
                        {
                            LIVEelements.Add(XPUIPanel("0 0.69", "0.06 0.80"), XPerienceLivePrimary, XPerienceLiveIcon);
                            LIVEelements.Add(XPUIImage(XPerienceLiveIcon, rank.name, 1, .9f, "0.05", "0.90"));
                            LIVEelements.Add(XPUIPanel("0.062 0.69", "0.995 0.825", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                            LIVEelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        }
                    }
                    // Armor
                    if (xprecord.Might > 0 && config.might.armor > 0)
                    {
                        LIVEelements.Add(XPUIPanel("0 0.69", "0.06 0.80"), XPerienceLivePrimary, XPerienceLiveIcon);
                        LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencearmor, 1, .9f, "0.17", "0.82"));
                        LIVEelements.Add(XPUIPanel("0.062 0.69", "0.995 0.825", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                        LIVEelements.Add(XPUIPanel("0 0.015", $"{armorperc - 0.002} 0.90", "1.50 0.05 0.05 0.70"), XPerienceLiveData);
                        LIVEelements.Add(XPUILabel($"{currentarmor}   /   {armor}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    }
                    // Level
                    LIVEelements.Add(XPUIPanel("0 0", "0.06 0.12"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, levelicon, 1, .9f, "0.17", "0.82"));
                    LIVEelements.Add(XPUIPanel("0.062 0", "0.492 0.14", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{XPLang("level", player.UserIDString)}: {xprecord.level} ({(int)levelpercent}%)", 1, 1.06f, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    // XP
                    LIVEelements.Add(XPUIPanel("0.505 0", "0.56 0.12"), XPerienceLivePrimary, XPerienceLiveIcon);
                    LIVEelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencexp, 1, .9f, "0.15", "0.80"));
                    LIVEelements.Add(XPUIPanel("0.562 0", "0.995 0.14", "0.6 0.6 0.6 0.25"), XPerienceLivePrimary, XPerienceLiveData);
                    LIVEelements.Add(XPUIPanel("0.015 0.1", $"{reqxpperc - 0.001} 0.9", "0.05 1.05 0.05 0.80"), XPerienceLiveData);
                    LIVEelements.Add(XPUILabel($"{(int)remainingxp}", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveData);
                    #endregion
                    break;
            }
            CuiHelper.AddUi(player, LIVEelements);
        }
        private void FuelGauge(BasePlayer player, bool active, int fuel)
        {
            if (player == null || !player.userID.IsSteamId() || player.IsNpc) return;
            DestroyUi(player, XPerienceLiveFuel);
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null || xprecord.UILocation == 0)
            {
                DestroyUi(player, XPerienceLiveFuel);
                return;
            }
            if (!active)
            {
                DestroyUi(player, XPerienceLiveFuel);
            }
            var FUELelements = new CuiElementContainer();
            if (fuel > 500)
            {
                fuel = 500;
            }
            double fuelpercent = (fuel / 500.0) - 0.01;
            double fuelpercentd = Math.Ceiling((fuel / 500.0) * 100);
            switch (xprecord.UILocation)
            {
                case 1:
                    if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge && fuel > 0)
                    {
                        if (xprecord.Might > 0 && !xprecord.DisableRank && config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui)
                        {
                            FUELelements.Add(XPUIPanel2("1 0", "1 0", "-392 128", "-210 153", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                            FUELelements.Add(XPUIPanel("0 0", "0.125 0.85"), XPerienceLiveFuel, XPerienceLiveIcon);
                            FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.15", "0.95"));
                            FUELelements.Add(XPUIPanel("0.13 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                            FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                            FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                        }
                        else if ((xprecord.Might <= 0 || config.might.armor <= 0) && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui))
                        {
                            FUELelements.Add(XPUIPanel2("1 0", "1 0", "-392 72", "-210 97", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                            FUELelements.Add(XPUIPanel("0 0", "0.125 0.85"), XPerienceLiveFuel, XPerienceLiveIcon);
                            FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.15", "0.95"));
                            FUELelements.Add(XPUIPanel("0.13 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                            FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                            FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                        }
                        else if ((xprecord.Might > 0 && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui)) || (xprecord.Might <= 0 && (!xprecord.DisableRank || config.xpLevelRanks.enableresetranks || config.xpLevelRanks.showrankinliveui)))
                        {
                            FUELelements.Add(XPUIPanel2("1 0", "1 0", "-392 100", "-210 125", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                            FUELelements.Add(XPUIPanel("0 0", "0.125 0.85"), XPerienceLiveFuel, XPerienceLiveIcon);
                            FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.15", "0.95"));
                            FUELelements.Add(XPUIPanel("0.13 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                            FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                            FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                        }
                    }
                    break;
                case 2:
                    if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge && fuel > 0)
                    {
                        if (xprecord.Might > 0 && !xprecord.DisableRank && config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui)
                        {
                            FUELelements.Add(XPUIPanel2("0 0", "0 0", "10 128", "210 153", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                            FUELelements.Add(XPUIPanel("0 0", "0.125 0.85"), XPerienceLiveFuel, XPerienceLiveIcon);
                            FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.15", "0.95"));
                            FUELelements.Add(XPUIPanel("0.13 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                            FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                            FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                        }
                        else if ((xprecord.Might <= 0 || config.might.armor <= 0) && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui))
                        {
                            FUELelements.Add(XPUIPanel2("0 0", "0 0", "10 72", "210 97", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                            FUELelements.Add(XPUIPanel("0 0", "0.125 0.85"), XPerienceLiveFuel, XPerienceLiveIcon);
                            FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.15", "0.95"));
                            FUELelements.Add(XPUIPanel("0.13 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                            FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                            FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                        }
                        else if ((xprecord.Might > 0 && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui)) || (xprecord.Might <= 0 && (!xprecord.DisableRank || config.xpLevelRanks.enableresetranks || config.xpLevelRanks.showrankinliveui)))
                        {
                            FUELelements.Add(XPUIPanel2("0 0", "0 0", "10 100", "210 125", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                            FUELelements.Add(XPUIPanel("0 0", "0.125 0.85"), XPerienceLiveFuel, XPerienceLiveIcon);
                            FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.15", "0.95"));
                            FUELelements.Add(XPUIPanel("0.13 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                            FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                            FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                        }
                    }
                    break;
                case 3:
                    if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge && fuel > 0)
                    {
                        FUELelements.Add(XPUIPanel2("0 1", "0 1", "10 -153", "210 -129", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                        FUELelements.Add(XPUIPanel("0 0", "0.125 0.85"), XPerienceLiveFuel, XPerienceLiveIcon);
                        FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.15", "0.95"));
                        FUELelements.Add(XPUIPanel("0.13 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                        FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                        FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                    }
                    break;
                case 4:
                    if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge && fuel > 0)
                    {
                        FUELelements.Add(XPUIPanel2("1 1", "1 1", "-210 -153", "-10 -129", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                        FUELelements.Add(XPUIPanel("0 0", "0.125 0.85"), XPerienceLiveFuel, XPerienceLiveIcon);
                        FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.15", "0.95"));
                        FUELelements.Add(XPUIPanel("0.13 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                        FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                        FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 15, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                    }
                    break;
                case 5:
                    if (config.defaultOptions.showfuelguage && !xprecord.fuelgauge && fuel > 0)
                    {
                        if (xprecord.Might > 0 && !xprecord.DisableRank && config.xpLevelRanks.enableresetranks || config.xpLevelRanks.showrankinliveui)
                        {
                            FUELelements.Add(XPUIPanel2("0.5 0", "0.5 0", "-200 116", "183.5 134", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                            FUELelements.Add(XPUIPanel("0 0", "0.06 .90"), XPerienceLiveFuel, XPerienceLiveIcon);
                            FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.05", "0.92"));
                            FUELelements.Add(XPUIPanel("0.062 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                            FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                            FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                        }
                        else if ((xprecord.Might <= 0 || config.might.armor <= 0) && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui))
                        {
                            FUELelements.Add(XPUIPanel2("0.5 0", "0.5 0", "-200 80", "183.5 97", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                            FUELelements.Add(XPUIPanel("0 0", "0.06 .90"), XPerienceLiveFuel, XPerienceLiveIcon);
                            FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.05", "0.95"));
                            FUELelements.Add(XPUIPanel("0.062 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                            FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                            FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                        }
                        else if ((xprecord.Might > 0 && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui)) || (xprecord.Might <= 0 && (!xprecord.DisableRank || config.xpLevelRanks.enableresetranks || config.xpLevelRanks.showrankinliveui)))
                        {
                            FUELelements.Add(XPUIPanel2("0.5 0", "0.5 0", "-200 97", "183.5 114", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveFuel);
                            FUELelements.Add(XPUIPanel("0 0", "0.06 .90"), XPerienceLiveFuel, XPerienceLiveIcon);
                            FUELelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencefuelguage, 1, .9f, "0.05", "0.95"));
                            FUELelements.Add(XPUIPanel("0.062 0", "0.99 1", "0.6 0.6 0.6 0.25"), XPerienceLiveFuel, XPerienceLiveFuelBar);
                            FUELelements.Add(XPUIPanel("0.01 0.135", $"{fuelpercent} 0.845", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
                            FUELelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
                        }
                    }
                    break;
            }
            CuiHelper.AddUi(player, FUELelements);
        }
        private void Speedometer(BasePlayer player, bool active, int speed, string type)
        {
            if (player == null || !player.userID.IsSteamId() || player.IsNpc) return;
            DestroyUi(player, XPerienceLiveSpeed);
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null || xprecord.UILocation == 0)
            {
                DestroyUi(player, XPerienceLiveSpeed);
                return;
            }
            if (!active)
            {
                DestroyUi(player, XPerienceLiveSpeed);
                return;
            }
            var SPEEDelements = new CuiElementContainer();
            string speedometer = $"{speed} MPH";
            switch (type)
            {
                case "car":
                    switch (xprecord.speedometertype)
                    {
                        case 1:
                            speedometer = $"{speed} MPH";
                            break;
                        case 2:
                            speedometer = $"{(int)Math.Ceiling(speed * 1.609344)} KMH";
                            break;
                    }
                    break;
                case "boat":
                    speedometer = $"{speed} ≜";
                    break;
                case "mini":
                    speedometer = $"{speed} ✈";
                    break;
            }
            switch (xprecord.UILocation)
            {
                case 1:
                    if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                    {
                        if (xprecord.Might > 0 && !xprecord.DisableRank && config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui)
                        {
                            SPEEDelements.Add(XPUIPanel2("1 0", "1 0", "-392 155", "-210 180", "0 0 0 0"), "Hud", XPerienceLiveSpeed);
                            SPEEDelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveSpeed, XPerienceLiveSpeedIcon);
                            SPEEDelements.Add(XPUIImage(XPerienceLiveSpeedIcon, XPeriencespeedometer, 1, .9f, "0", "1"));
                            SPEEDelements.Add(XPUIPanel("0 0.2", "1 1", "0 0 0 0"), XPerienceLiveSpeed, XPerienceLiveSpeedBar);
                            SPEEDelements.Add(XPUILabel($"{speedometer}", 1, 1, TextAnchor.MiddleRight, 14, "0", "0.90", "1.0 1.0 1.0 0.70"), XPerienceLiveSpeedBar);
                        }
                        else if ((xprecord.Might <= 0 || config.might.armor <= 0) && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui))
                        {
                            SPEEDelements.Add(XPUIPanel2("1 0", "1 0", "-392 98", "-210 123", "0 0 0 0"), "Hud", XPerienceLiveSpeed);
                            SPEEDelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveSpeed, XPerienceLiveSpeedIcon);
                            SPEEDelements.Add(XPUIImage(XPerienceLiveSpeedIcon, XPeriencespeedometer, 1, .9f, "0", "1"));
                            SPEEDelements.Add(XPUIPanel("0 0.2", "1 1", "0 0 0 0"), XPerienceLiveSpeed, XPerienceLiveSpeedBar);
                            SPEEDelements.Add(XPUILabel($"{speedometer}", 1, 1, TextAnchor.MiddleRight, 14, "0", "0.90", "1.0 1.0 1.0 0.70"), XPerienceLiveSpeedBar);
                        }
                        else if ((xprecord.Might > 0 && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui)) || (xprecord.Might <= 0 && (!xprecord.DisableRank || config.xpLevelRanks.enableresetranks || config.xpLevelRanks.showrankinliveui)))
                        {
                            SPEEDelements.Add(XPUIPanel2("1 0", "1 0", "-392 126", "-210 151", "0 0 0 0"), "Hud", XPerienceLiveSpeed);
                            SPEEDelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveSpeed, XPerienceLiveSpeedIcon);
                            SPEEDelements.Add(XPUIImage(XPerienceLiveSpeedIcon, XPeriencespeedometer, 1, .9f, "0", "1"));
                            SPEEDelements.Add(XPUIPanel("0 0.2", "1 1", "0 0 0 0"), XPerienceLiveSpeed, XPerienceLiveSpeedBar);
                            SPEEDelements.Add(XPUILabel($"{speedometer}", 1, 1, TextAnchor.MiddleRight, 14, "0", "0.90", "1.0 1.0 1.0 0.70"), XPerienceLiveSpeedBar);
                        }
                    }
                    break;
                case 2:
                    if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                    {
                        if (xprecord.Might > 0 && !xprecord.DisableRank && config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui)
                        {
                            SPEEDelements.Add(XPUIPanel2("0 0", "0 0", "10 154", "210 179", "0 0 0 0"), "Hud", XPerienceLiveSpeed);
                            SPEEDelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveSpeed, XPerienceLiveSpeedIcon);
                            SPEEDelements.Add(XPUIImage(XPerienceLiveSpeedIcon, XPeriencespeedometer, 1, .9f, "0", "1"));
                            SPEEDelements.Add(XPUIPanel("0 0.2", "1 1", "0 0 0 0"), XPerienceLiveSpeed, XPerienceLiveSpeedBar);
                            SPEEDelements.Add(XPUILabel($"{speedometer}", 1, 1, TextAnchor.MiddleRight, 14, "0", "0.90", "1.0 1.0 1.0 0.70"), XPerienceLiveSpeedBar);
                        }
                        else if ((xprecord.Might <= 0 || config.might.armor <= 0) && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui))
                        {
                            SPEEDelements.Add(XPUIPanel2("0 0", "0 0", "10 98", "210 121", "0 0 0 0"), "Hud", XPerienceLiveSpeed);
                            SPEEDelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveSpeed, XPerienceLiveSpeedIcon);
                            SPEEDelements.Add(XPUIImage(XPerienceLiveSpeedIcon, XPeriencespeedometer, 1, .9f, "0", "1"));
                            SPEEDelements.Add(XPUIPanel("0 0.2", "1 1", "0 0 0 0"), XPerienceLiveSpeed, XPerienceLiveSpeedBar);
                            SPEEDelements.Add(XPUILabel($"{speedometer}", 1, 1, TextAnchor.MiddleRight, 14, "0", "0.90", "1.0 1.0 1.0 0.70"), XPerienceLiveSpeedBar);
                        }
                        else if ((xprecord.Might > 0 && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui)) || (xprecord.Might <= 0 && (!xprecord.DisableRank || config.xpLevelRanks.enableresetranks || config.xpLevelRanks.showrankinliveui)))
                        {
                            SPEEDelements.Add(XPUIPanel2("0 0", "0 0", "10 126", "210 151", "0 0 0 0"), "Hud", XPerienceLiveSpeed);
                            SPEEDelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveSpeed, XPerienceLiveSpeedIcon);
                            SPEEDelements.Add(XPUIImage(XPerienceLiveSpeedIcon, XPeriencespeedometer, 1, .9f, "0", "1"));
                            SPEEDelements.Add(XPUIPanel("0 0.2", "1 1", "0 0 0 0"), XPerienceLiveSpeed, XPerienceLiveSpeedBar);
                            SPEEDelements.Add(XPUILabel($"{speedometer}", 1, 1, TextAnchor.MiddleRight, 14, "0", "0.90", "1.0 1.0 1.0 0.70"), XPerienceLiveSpeedBar);
                        }
                    }
                    break;
                case 3:
                    if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                    {
                        SPEEDelements.Add(XPUIPanel2("0 1", "0 1", "10 -183", "210 -157", "0 0 0 0"), "Hud", XPerienceLiveSpeed);
                        SPEEDelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveSpeed, XPerienceLiveSpeedIcon);
                        SPEEDelements.Add(XPUIImage(XPerienceLiveSpeedIcon, XPeriencespeedometer, 1, .9f, "0", "1"));
                        SPEEDelements.Add(XPUIPanel("0 0.2", "1 1", "0 0 0 0"), XPerienceLiveSpeed, XPerienceLiveSpeedBar);
                        SPEEDelements.Add(XPUILabel($"{speedometer}", 1, 1, TextAnchor.MiddleRight, 14, "0", "0.90", "1.0 1.0 1.0 0.70"), XPerienceLiveSpeedBar);
                    }
                    break;
                case 4:
                    if (config.defaultOptions.showspeedometer && !xprecord.speedometer)
                    {
                        SPEEDelements.Add(XPUIPanel2("1 1", "1 1", "-210 -183", "-10 -157", "0 0 0 0"), "Hud", XPerienceLiveSpeed);
                        SPEEDelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveSpeed, XPerienceLiveSpeedIcon);
                        SPEEDelements.Add(XPUIImage(XPerienceLiveSpeedIcon, XPeriencespeedometer, 1, .9f, "0", "1"));
                        SPEEDelements.Add(XPUIPanel("0 0.2", "1 1", "0 0 0 0"), XPerienceLiveSpeed, XPerienceLiveSpeedBar);
                        SPEEDelements.Add(XPUILabel($"{speedometer}", 1, 1, TextAnchor.MiddleRight, 14, "0", "0.90", "1.0 1.0 1.0 0.70"), XPerienceLiveSpeedBar);
                    }
                    break;
                case 5:
                    break;
            }
            CuiHelper.AddUi(player, SPEEDelements);        
        }
        private void DashPanel(BasePlayer player, bool active, int fuel, int speed, string type)
        {
            if (player == null || !player.userID.IsSteamId() || player.IsNpc) return;
            DestroyUi(player, XPerienceLiveDashPanel);
            XPRecord xprecord = GetXPRecord(player);
            if (xprecord == null || xprecord.UILocation == 0)
            {
                DestroyUi(player, XPerienceLiveDashPanel);
                return;
            }
            if (!active)
            {
                DestroyUi(player, XPerienceLiveDashPanel);
                return;
            }
            var Dashelements = new CuiElementContainer();
            if (fuel > 500)
            {
                fuel = 500;
            }
            switch (xprecord.UILocation)
            {
                case 1:
                    if (xprecord.Might > 0 && !xprecord.DisableRank && config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui)
                    {
                        Dashelements.Add(XPUIPanel2("1 0", "1 0", "-392 125", "-210 150", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                        Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                        Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                        DashSpeed(player, speed, type);
                        DashFuel(player, fuel);
                    }
                    else if ((xprecord.Might <= 0 || config.might.armor <= 0) && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui))
                    {
                        Dashelements.Add(XPUIPanel2("1 0", "1 0", "-392 67", "-210 92", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                        Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                        Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                        DashSpeed(player, speed, type);
                        DashFuel(player, fuel);
                    }
                    else if ((xprecord.Might > 0 && (!config.xpLevelRanks.enableresetranks  || !config.xpLevelRanks.showrankinliveui || xprecord.DisableRank)) || (xprecord.Might <= 0 && (!xprecord.DisableRank || config.xpLevelRanks.enableresetranks || config.xpLevelRanks.showrankinliveui)))
                    {
                        Dashelements.Add(XPUIPanel2("1 0", "1 0", "-392 95", "-210 120", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                        Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                        Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                        DashSpeed(player, speed, type);
                        DashFuel(player, fuel);
                    }
                    break;
                case 2:
                    if (xprecord.Might > 0 && !xprecord.DisableRank && config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui)
                    {
                        Dashelements.Add(XPUIPanel2("0 0", "0 0", "10 125", "210 150", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                        Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                        Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                        DashSpeed(player, speed, type);
                        DashFuel(player, fuel);
                    }
                    else if ((xprecord.Might <= 0 || config.might.armor <= 0) && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui))
                    {
                        Dashelements.Add(XPUIPanel2("0 0", "0 0", "10 67", "210 92", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                        Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                        Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                        DashSpeed(player, speed, type);
                        DashFuel(player, fuel);
                    }
                    else if ((xprecord.Might > 0 && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui)) || (xprecord.Might <= 0 && (!xprecord.DisableRank || config.xpLevelRanks.enableresetranks || config.xpLevelRanks.showrankinliveui)))
                    {
                        Dashelements.Add(XPUIPanel2("0 0", "0 0", "10 95", "210 120", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                        Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                        Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                        DashSpeed(player, speed, type);
                        DashFuel(player, fuel);
                    }
                    break;
                case 3:
                    Dashelements.Add(XPUIPanel2("0 1", "0 1", "10 -155", "210 -130", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                    Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                    Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                    DashSpeed(player, speed, type);
                    DashFuel(player, fuel);
                    break;
                case 4:
                    Dashelements.Add(XPUIPanel2("1 1", "1 1", "-210 -155", "-10 -130", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                    Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                    Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                    DashSpeed(player, speed, type);
                    DashFuel(player, fuel);
                    break;
                case 5:
                    if (xprecord.Might > 0 && !xprecord.DisableRank && config.xpLevelRanks.enableresetranks && config.xpLevelRanks.showrankinliveui)
                    {
                        Dashelements.Add(XPUIPanel2("0.5 0", "0.5 0", "-100 110", "83.5 135", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                        Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                        Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                        DashSpeed(player, speed, type);
                        DashFuel(player, fuel);
                    }
                    else if ((xprecord.Might <= 0 || config.might.armor <= 0) && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui))
                    {
                        Dashelements.Add(XPUIPanel2("0.5 0", "0.5 0", "-100 76", "83.5 101", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                        Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                        Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                        DashSpeed(player, speed, type);
                        DashFuel(player, fuel);
                    }
                    else if ((xprecord.Might > 0 && (xprecord.DisableRank || !config.xpLevelRanks.enableresetranks || !config.xpLevelRanks.showrankinliveui)) || (xprecord.Might <= 0 && (!xprecord.DisableRank || config.xpLevelRanks.enableresetranks || config.xpLevelRanks.showrankinliveui)))
                    {
                        Dashelements.Add(XPUIPanel2("0.5 0", "0.5 0", "-100 92", "83.5 122", "0.5 0.5 0.5 0"), "Hud", XPerienceLiveDashPanel);
                        Dashelements.Add(XPUIPanel("0 0", "1 1"), XPerienceLiveDashPanel, XPerienceLiveIcon);
                        Dashelements.Add(XPUIImage(XPerienceLiveIcon, XPeriencedash, 1, .9f, "0", "1"));
                        DashSpeed(player, speed, type);
                        DashFuel(player, fuel);
                    }
                    break;
            }
            CuiHelper.AddUi(player, Dashelements);
        }
        private void DashSpeed(BasePlayer player, int speed, string type)
        {
            if (player == null || !player.userID.IsSteamId() || player.IsNpc) return;
            DestroyUi(player, XPerienceLiveSpeedBar);
            XPRecord xprecord = GetXPRecord(player);
            var Dashelements = new CuiElementContainer();
            string speedometer = $"{speed} MPH";
            switch(type)
            {
                case "car":
                    switch(xprecord.speedometertype)
                    {
                        case 1:
                            speedometer = $"{speed} MPH";
                            break;
                        case 2:
                            speedometer = $"{(int)Math.Ceiling(speed * 1.609344)} KMH";
                            break;
                    }
                    break;
                case "boat":
                    speedometer = $"{speed} ≜";
                    break;
                case "mini":
                    speedometer = $"{speed} ✈";
                    break;
            }
            Dashelements.Add(XPUIPanel("0 0.2", "0.45 1", "0 0 0 0"), XPerienceLiveDashPanel, XPerienceLiveSpeedBar);
            Dashelements.Add(XPUILabel($"{speedometer}", 1, 1, TextAnchor.MiddleRight, 12, "0", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveSpeedBar);
            CuiHelper.AddUi(player, Dashelements);
        }
        private void DashFuel(BasePlayer player, int fuel)
        {
            if (player == null || !player.userID.IsSteamId() || player.IsNpc) return;
            DestroyUi(player, XPerienceLiveFuelBar);
            XPRecord xprecord = GetXPRecord(player);
            var Dashelements = new CuiElementContainer();
            if (fuel > 500)
            {
                fuel = 500;
            }
            double fuelpercent = (fuel / 500.0) - 0.01;
            double fuelpercentd = Math.Ceiling((fuel / 500.0) * 100);
            Dashelements.Add(XPUIPanel("0.61 0.35", "0.95 0.95", "0 0 0 0"), XPerienceLiveDashPanel, XPerienceLiveFuelBar);
            Dashelements.Add(XPUIPanel("0.01 0.04", $"{fuelpercent} 0.82", "1 0.5 0 0.80"), XPerienceLiveFuelBar);
            Dashelements.Add(XPUILabel($"{fuel} ({fuelpercentd}%)", 1, 1, TextAnchor.MiddleLeft, 11, "0.05", "1", "1.0 1.0 1.0 0.70"), XPerienceLiveFuelBar);
            CuiHelper.AddUi(player, Dashelements);
        }
        private void PlayerInfoBox(BasePlayer player, string selectedplayer)
        {
            DestroyUi(player, XPeriencePlayerInfoBox);
            if (player == null || selectedplayer == null) return;
            var playerinfo = FindPlayer(selectedplayer);
            XPRecord xprecord = GetPlayerRecord(selectedplayer);
            if (playerinfo == null) return;
            float height = 0.033f;
            int row = 1;
            // Create Box
            var FullScreenelements = new CuiElementContainer();
            FullScreenelements.Add(new CuiPanel
            {
                Image =
                {
                    Color = "0 0 0 1"
                },
                RectTransform =
                {
                    AnchorMin = "0.16 0.20",
                    AnchorMax = "0.39 0.95"
                },
                CursorEnabled = true
            }, "Overlay", XPeriencePlayerInfoBox);
            // Box Content
            FullScreenelements.Add(XPUILabel($"{XPLang("playerinfoalive", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            if (config.playerinfoBoxsettings.alivetime)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timealive", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.lifeStory.secondsAlive)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.sleepingtime)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timesleeping", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.lifeStory.secondsSleeping)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.swimingtime)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timeswimming", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.lifeStory.secondsSwimming)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.drivingtime)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timedriving", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.lifeStory.secondsDriving)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.flyingtime)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timeflying", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.lifeStory.secondsFlying)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.boatingtime)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timeboating", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.lifeStory.secondsBoating)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.basetime)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timeinbase", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.lifeStory.secondsInBase)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.monumenttime)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timeinmonument", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.lifeStory.secondsInMonument)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.wildernesstime)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timeinwild", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.lifeStory.secondsWilderness)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.metersran)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("metersran", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{Math.Round(playerinfo.lifeStory.metersRun, 2)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.meterswalked)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("meterswalk", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{Math.Round(playerinfo.lifeStory.metersWalked, 2)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.lastdmgrec)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timedmgrec", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "dmgrecieved", playerinfo.SecondsSinceAttacked)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.lastdmgrecby)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timedmgrecfrom", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerInfoValues(player, playerinfo.lastAttacker, "dmgrecieved")}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.lastdmgdelt)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timedmgdelt", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerTimeValues(player, "", playerinfo.SecondsSinceDealtDamage)}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            if (config.playerinfoBoxsettings.lastdmgdeltto)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("timedeltto", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                FullScreenelements.Add(XPUILabel($"{PlayerInfoValues(player, playerinfo.lastDealtDamageTo, "dmgdelt")}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
                row++;
            }
            row++;
            FullScreenelements.Add(XPUILabel($"{XPLang("playerharveststats", player.UserIDString)}: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Wood: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Wood}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Stone: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Stone}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Metal: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Metal}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Sulfur: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Sulfur}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Cactus: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Cactus}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Berries: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Berries}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Pumpkins: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Pumpkin}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Potatos: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Potato}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Corn: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Corn}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Mushrooms: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Mushroom}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Hemp: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Hemp}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            FullScreenelements.Add(XPUILabel($"Seeds: ", row, height, TextAnchor.MiddleLeft, 12, "0.01", "0.40", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            FullScreenelements.Add(XPUILabel($"{xprecord.Seed}", row, height, TextAnchor.MiddleLeft, 12, "0.40", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerInfoBox);
            row++;
            row++;
            FullScreenelements.Add(XPUIButton("xp.playercontrol closebox", row, height, 12, "1 0 0 1", "〘Close Info Box〙", "0.25", "0.75", TextAnchor.MiddleCenter, "1 1 1 1"), XPeriencePlayerInfoBox);
            CuiHelper.AddUi(player, FullScreenelements);
        }
        // Current Player Panels
        private void PlayerControlPanelFullMain(BasePlayer player)
        {
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            Ranks rank = GetXPRank(xprecord.rank);
            if (xprecord == null) return;
            var FullScreenelements = new CuiElementContainer();
            var height = 0.050f;
            // Main UI | Title | Icon
            FullScreenelements.Add(new CuiPanel
            {
                Image =
                {
                    Color = "0.1 0.1 0.1 0.99"
                },
                RectTransform =
                {
                    AnchorMin = $"0 0",
                    AnchorMax = $"1 1"
                },
                CursorEnabled = true
            }, "Overlay", XPeriencePlayerControlFullMain);
            FullScreenelements.Add(XPUILabel($"{player.displayName}", 1, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.18", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullMain);
            if (config.xpLevelRanks.enableresetranks && !rank.image.IsNullOrEmpty() && !xprecord.DisableRank)
            {
                FullScreenelements.Add(new CuiElement
                {
                    Parent = XPeriencePlayerControlFullMain,
                    Components =
                {
                    new CuiRawImageComponent
                    {
                        Png = ImageLibrary?.Call<string>("GetImage", rank.name)
                    },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = "0.01 0.75",
                        AnchorMax = "0.15 0.95"
                    }
                }
                });
            }
            else
            {
                FullScreenelements.Add(new CuiElement
                {
                    Parent = XPeriencePlayerControlFullMain,
                    Components =
                {
                    new CuiRawImageComponent
                    {
                        Png = ImageLibrary?.Call<string>("GetImage", XPerienceicon)
                    },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = "0.01 0.75",
                        AnchorMax = "0.15 0.95"
                    }
                }
                });
            }
            // Spacer
            int row = 4;
            // Navigation Menu
            FullScreenelements.Add(XPUIPanel("0.0 0.0", "0.15 0.85", "1.0 1.0 1.0 0.0"), XPeriencePlayerControlFullMain, XPeriencePlayerControlFullMenu);
            FullScreenelements.Add(XPUIButton("xp.playercontrol main", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("adminmenu_014", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            // Kill Records Button
            if (KillRecords != null && config.xpBonus.showkrbutton)
            {
                row++;
                row++;
                FullScreenelements.Add(XPUIButton($"xp.playercontrol killrecords {player.UserIDString}", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("mykillrecords", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            }
            // Death Records Button
            if (XPerienceAddon != null)
            {
                row++;
                row++;
                FullScreenelements.Add(XPUIButton($"xp.playercontrol deathrecords {player.UserIDString}", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("mydeathrecords", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            }
            // Top Players Buttom
            row++;
            row++;
            FullScreenelements.Add(XPUIButton($"xp.playercontrol topplayers", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("topplayers", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            // Help Button
            row++;
            row++;
            FullScreenelements.Add(XPUIButton("xp.playercontrol help", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("help", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            // Close Button
            row++;
            row++;
            FullScreenelements.Add(XPUIButton("xp.playercontrol close", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("adminmenu_009", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            // Admin Button
            if (player.IsAdmin && permission.UserHasPermission(player.UserIDString, Admin))
            {
                row++;
                row++;
                FullScreenelements.Add(XPUIButton("xp.playercontrol admin", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("adminpanel", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            }
            // UI End
            CuiHelper.AddUi(player, FullScreenelements);
            return;
        }
        private void PlayerInfoPage(BasePlayer player)
        {
            if (player == null) return;
            XPRecord xprecord = GetXPRecord(player);
            Ranks rank = GetXPRank(xprecord.rank);
            string textcolor = "perk";
            if(xprecord.rank > 0 && !xprecord.DisableRank)
            {
                textcolor = "ranklevel";
            }
            if (xprecord == null) return;
            float height = 0.027f;
            float skillheight = 0.029f;
            float resetheight = 0.020f;
            float infoheight = 0.020f;
            int row = 1;
            var FullScreenelements = new CuiElementContainer();
            // Timer Data
            DateTime resettimestats = xprecord.resettimerstats.AddMinutes(config.defaultOptions.resetminsstats);
            DateTime resettimeskills = xprecord.resettimerskills.AddMinutes(config.defaultOptions.resetminsskills);
            TimeSpan statsinterval = resettimestats - DateTime.Now;
            TimeSpan skillinterval = resettimeskills - DateTime.Now;
            int statstimer = (int)statsinterval.TotalMinutes;
            int skilltimer = (int)skillinterval.TotalMinutes;
            if (!config.defaultOptions.restristresets || config.defaultOptions.bypassadminreset && player.IsAdmin && permission.UserHasPermission(player.UserIDString, XPerience.Admin))
            {
                statstimer = 0;
                skilltimer = 0;
            }
            // Main UI
            FullScreenelements.Add(XPUIPanel("0.16 0.0", "1 1", "0 0 0 0.75"), XPeriencePlayerControlFullMain, XPeriencePlayerControlFullInfo);
            // Player Name, Rank, & Status
            FullScreenelements.Add(XPUILabel($"Player Details:", row, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            if (config.playerinfoBoxsettings.showinfobox)
            {
                FullScreenelements.Add(XPUIButton($"xp.playercontrol openbox {xprecord.id}", row + 1, infoheight, 13, "1.0 0.0 0.0 0.7", $"〘Info Box〙", "0.13", "0.20", TextAnchor.MiddleCenter), XPeriencePlayerControlFullInfo);
            }
            row++;
            // Main - Player Info
            int statpoints = xprecord.MentalityP + xprecord.DexterityP + xprecord.MightP + xprecord.CaptaincyP + xprecord.WeaponryP;
            int skillpoints = xprecord.WoodCutterP + xprecord.SmithyP + xprecord.MinerP + xprecord.ForagerP + xprecord.HunterP + xprecord.FisherP + xprecord.CrafterP + xprecord.FramerP + xprecord.TamerP + xprecord.MedicP + xprecord.ScavengerP;
            // XP Calulations
            double levelpercent;
            if (xprecord.experience == 0 || xprecord.level == 0)
            {
                levelpercent = ((xprecord.experience - 0) / config.xpLevel.levelstart) * 100;
            }
            else
            {
                levelpercent = ((xprecord.experience - (xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier))) / (xprecord.requiredxp - (xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier)))) * 100;
            }
            // Main Info
            #region Main Info
            FullScreenelements.Add(XPUILabel($"----------------------------------------------------------------", row, 0.035f, TextAnchor.MiddleLeft, 9, "0.0", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            // Online Status
            if (config.defaultOptions.showonlinestatus)
            {
                if (xprecord.Status)
                {
                    FullScreenelements.Add(XPUILabel($"{XPLang("status", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceonline, row, height, "0.11", "0.117"));
                    FullScreenelements.Add(XPUILabel($" {XPLang("online", player.UserIDString)}", row, height, TextAnchor.MiddleLeft, 11, "0.12", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    row++;
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"{XPLang("status", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceoffline, row, height, "0.11", "0.117"));
                    FullScreenelements.Add(XPUILabel($" {XPLang("offline", player.UserIDString)}", row, height, TextAnchor.MiddleLeft, 11, "0.12", "0.25", "1 1 1 1"), XPeriencePlayerControlFullInfo);
                    row++;
                }
            }
            // Rank
            if (config.xpLevelRanks.enableresetranks && !xprecord.DisableRank)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("rank", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.05", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                row++;
                FullScreenelements.Add(XPUILabel($"{XPLang("ranksig", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.sig}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                row++;
                if (config.xpLevelRanks.showtruelevelprofile)
                {
                    FullScreenelements.Add(XPUILabel($"{XPLang("ranklevel", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "ranklevel", xprecord.truelevel)}>{xprecord.truelevel}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    row++;
                }
                if (config.xpLevelRanks.showtruexpprofile)
                {
                    FullScreenelements.Add(XPUILabel($"{XPLang("rankxp", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "rankxp", xprecord.trueexperience)}>{xprecord.trueexperience}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    row++;
                }
            }
            // Disable Ranks
            FullScreenelements.Add(XPUILabel($"{XPLang("playerdisableranks", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            // Yes
            FullScreenelements.Add(XPUIButton($"xp.playeredits disableranks true", row, height, 10, "0 0 0 0", "Yes", "0.11", "0.13", TextAnchor.MiddleCenter, $"{DisableRankSelection("Yes", xprecord.DisableRank)}"), XPeriencePlayerControlFullInfo);
            // No
            FullScreenelements.Add(XPUIButton($"xp.playeredits disableranks false", row, height, 10, "0 0 0 0", "No", "0.14", "0.16", TextAnchor.MiddleCenter, $"{DisableRankSelection("No", xprecord.DisableRank)}"), XPeriencePlayerControlFullInfo);
            row++;
            // Level
            FullScreenelements.Add(XPUILabel($"{XPLang("level", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "mainlevel", (int)xprecord.level)}>{xprecord.level} ({(int)levelpercent}%)</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            // XP
            FullScreenelements.Add(XPUILabel($"{XPLang("experience", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "experience", (int)xprecord.experience)}>{(int)xprecord.experience}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            // Next Level
            FullScreenelements.Add(XPUILabel($"{XPLang("nextlevel", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "nextlevel", (int)xprecord.requiredxp)}>{(int)xprecord.requiredxp}</color> (<color={TextColor(player, "remainingxp", (int)(xprecord.requiredxp - xprecord.experience))}>{(int)(xprecord.requiredxp - xprecord.experience)}</color>)", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            // Unspent Points
            FullScreenelements.Add(XPUILabel($"{XPLang("unusedstatpoints", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "unspent", xprecord.statpoint)}>{xprecord.statpoint}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            FullScreenelements.Add(XPUILabel($"{XPLang("unusedskillpoints", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "unspent", xprecord.skillpoint)}>{xprecord.skillpoint}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            FullScreenelements.Add(XPUILabel($"{XPLang("totalspent", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "spent", statpoints + skillpoints)}>{statpoints + skillpoints}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            #endregion
            // Live UI Location Selection
            #region LiveUI
            if (config.defaultOptions.liveuistatslocationmoveable)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("liveuiselection", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                // UI Off
                FullScreenelements.Add(XPUIButton($"xp.playeredits liveui 0", row, height, 11, "0 0 0 0", "off", "0.11", "0.13", TextAnchor.MiddleCenter, $"{LiveUISelection("UI0", xprecord.UILocation)}"), XPeriencePlayerControlFullInfo);
                // UI 1
                FullScreenelements.Add(XPUIButton($"xp.playeredits liveui 1", row, height, 11, "0 0 0 0", "1", "0.14", "0.145", TextAnchor.MiddleCenter, $"{LiveUISelection("UI1", xprecord.UILocation)}"), XPeriencePlayerControlFullInfo);
                // UI 2
                FullScreenelements.Add(XPUIButton($"xp.playeredits liveui 2", row, height, 11, "0 0 0 0", "2", "0.15", "0.155", TextAnchor.MiddleCenter, $"{LiveUISelection("UI2", xprecord.UILocation)}"), XPeriencePlayerControlFullInfo);
                // UI 3
                FullScreenelements.Add(XPUIButton($"xp.playeredits liveui 3", row, height, 11, "0 0 0 0", "3", "0.16", "0.165", TextAnchor.MiddleCenter, $"{LiveUISelection("UI3", xprecord.UILocation)}"), XPeriencePlayerControlFullInfo);
                // UI 4
                FullScreenelements.Add(XPUIButton($"xp.playeredits liveui 4", row, height, 11, "0 0 0 0", "4", "0.17", "0.175", TextAnchor.MiddleCenter, $"{LiveUISelection("UI4", xprecord.UILocation)}"), XPeriencePlayerControlFullInfo);
                // UI 5
                FullScreenelements.Add(XPUIButton($"xp.playeredits liveui 5", row, height, 11, "0 0 0 0", "5", "0.18", "0.185", TextAnchor.MiddleCenter, $"{LiveUISelection("UI5", xprecord.UILocation)}"), XPeriencePlayerControlFullInfo);
                row++;
            }
            #endregion
            // DashPanel Type
            #region DashPanel
            FullScreenelements.Add(XPUILabel($"{XPLang("playerdashpaneltype", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            // Yes
            FullScreenelements.Add(XPUIButton($"xp.playeredits dash 1", row, height, 10, "0 0 0 0", "1", "0.11", "0.13", TextAnchor.MiddleCenter, $"{DashSelection(1, xprecord.dash)}"), XPeriencePlayerControlFullInfo);
            // No
            FullScreenelements.Add(XPUIButton($"xp.playeredits dash 2", row, height, 10, "0 0 0 0", "2", "0.14", "0.16", TextAnchor.MiddleCenter, $"{DashSelection(2, xprecord.dash)}"), XPeriencePlayerControlFullInfo);
            row++;
            if (xprecord.dash == 2)
            {
                // Fuel Gauge
                FullScreenelements.Add(XPUILabel($"{XPLang("playerdisablefuelgauge", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                // Yes
                FullScreenelements.Add(XPUIButton($"xp.playeredits fuelgauge true", row, height, 10, "0 0 0 0", "Yes", "0.11", "0.13", TextAnchor.MiddleCenter, $"{DisableRankSelection("Yes", xprecord.fuelgauge)}"), XPeriencePlayerControlFullInfo);
                // No
                FullScreenelements.Add(XPUIButton($"xp.playeredits fuelgauge false", row, height, 10, "0 0 0 0", "No", "0.14", "0.16", TextAnchor.MiddleCenter, $"{DisableRankSelection("No", xprecord.fuelgauge)}"), XPeriencePlayerControlFullInfo);
                row++;
                // Speedometer
                FullScreenelements.Add(XPUILabel($"{XPLang("playerdisablespeedometer", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                // Yes
                FullScreenelements.Add(XPUIButton($"xp.playeredits speedometer true", row, height, 10, "0 0 0 0", "Yes", "0.11", "0.13", TextAnchor.MiddleCenter, $"{DisableRankSelection("Yes", xprecord.speedometer)}"), XPeriencePlayerControlFullInfo);
                // No
                FullScreenelements.Add(XPUIButton($"xp.playeredits speedometer false", row, height, 10, "0 0 0 0", "No", "0.14", "0.16", TextAnchor.MiddleCenter, $"{DisableRankSelection("No", xprecord.speedometer)}"), XPeriencePlayerControlFullInfo);
                row++;
            }
            // Speedometer Type
            FullScreenelements.Add(XPUILabel($"{XPLang("playerspeedometertype", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 11, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            // Yes
            FullScreenelements.Add(XPUIButton($"xp.playeredits speedometertype 1", row, height, 10, "0 0 0 0", "MPH", "0.11", "0.13", TextAnchor.MiddleCenter, $"{DashSelection(1, xprecord.speedometertype)}"), XPeriencePlayerControlFullInfo);
            // No
            FullScreenelements.Add(XPUIButton($"xp.playeredits speedometertype 2", row, height, 10, "0 0 0 0", "KMH", "0.14", "0.16", TextAnchor.MiddleCenter, $"{DashSelection(2, xprecord.speedometertype)}"), XPeriencePlayerControlFullInfo);
            row++;
            #endregion
            // Stats
            #region Stats Control
            FullScreenelements.Add(XPUILabel($"----------------------------------------------------------------", row, height, TextAnchor.MiddleLeft, 9, "0.0", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            if (config.mentality.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermMentality)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Mentality < config.mentality.maxlvl && (((xprecord.Mentality + 1) * config.mentality.costmultiplier) <= xprecord.statpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits stat mentality {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.mentality}>{XPLang("mentality", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Mentality)}>{xprecord.Mentality}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Mentality < config.mentality.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Mentality)}>{(xprecord.Mentality + 1) * config.mentality.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.MentalityP)}>{xprecord.MentalityP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.MentalityP)}>{xprecord.MentalityP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Mentality")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Mentality")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Mentality")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.dexterity.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermDexterity)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Dexterity < config.dexterity.maxlvl && (((xprecord.Dexterity + 1) * config.dexterity.costmultiplier) <= xprecord.statpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits stat dexterity {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.dexterity}>{XPLang("dexterity", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Dexterity)}>{xprecord.Dexterity}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Dexterity < config.dexterity.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Dexterity)}>{(xprecord.Dexterity + 1) * config.dexterity.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.DexterityP)}>{xprecord.DexterityP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.DexterityP)}>{xprecord.DexterityP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Dexterity")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Dexterity")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Dexterity")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.might.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermMight)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Might < config.might.maxlvl && (((xprecord.Might + 1) * config.might.costmultiplier) <= xprecord.statpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits stat might {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.might}>{XPLang("might", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Might)}>{xprecord.Might}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Might < config.might.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Might)}>{(xprecord.Might + 1) * config.might.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.MightP)}>{xprecord.MightP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.MightP)}>{xprecord.MightP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Might")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Might")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Might")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.captaincy.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermCaptaincy)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Captaincy < config.captaincy.maxlvl && (((xprecord.Captaincy + 1) * config.captaincy.costmultiplier) <= xprecord.statpoint) && (config.captaincy.allownoteam || (!config.captaincy.allownoteam && player.Team != null)))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits stat captaincy {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecaptaincy, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.captaincy}>{XPLang("captaincy", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Captaincy)}>{xprecord.Captaincy}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Captaincy < config.captaincy.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Captaincy)}>{(xprecord.Captaincy + 1) * config.captaincy.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.CaptaincyP)}>{xprecord.CaptaincyP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.CaptaincyP)}>{xprecord.CaptaincyP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Captaincy")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Captaincy")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Captaincy")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.weaponry.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermWeaponry)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Weaponry < config.weaponry.maxlvl && (((xprecord.Weaponry + 1) * config.weaponry.costmultiplier) <= xprecord.statpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits stat weaponry {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.weaponry}>{XPLang("weaponry", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Weaponry)}>{xprecord.Weaponry}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Weaponry < config.weaponry.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Weaponry)}>{(xprecord.Weaponry + 1) * config.weaponry.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.WeaponryP)}>{xprecord.WeaponryP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.WeaponryP)}>{xprecord.WeaponryP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Weaponry")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Weaponry")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Weaponry")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            #endregion
            // Skills
            #region Skills Control
            FullScreenelements.Add(XPUILabel($"----------------------------------------------------------------", row, height, TextAnchor.MiddleLeft, 9, "0.0", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            if (config.woodcutter.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermWoodCutter)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.WoodCutter < config.woodcutter.maxlvl && (((xprecord.WoodCutter + 1) * config.woodcutter.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill woodcutter {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewoodcutter, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.woodcutter}>{XPLang("woodcutter", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.WoodCutter)}>{xprecord.WoodCutter}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.WoodCutter < config.woodcutter.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.WoodCutter)}>{(xprecord.WoodCutter + 1) * config.woodcutter.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.WoodCutterP)}>{xprecord.WoodCutterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.WoodCutterP)}>{xprecord.WoodCutterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "WoodCutter")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "WoodCutter")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "WoodCutter")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.smithy.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermSmithy)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Smithy < config.smithy.maxlvl && (((xprecord.Smithy + 1) * config.smithy.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill smithy {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.smithy}>{XPLang("smithy", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Smithy)}>{xprecord.Smithy}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Smithy < config.smithy.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Smithy)}>{(xprecord.Smithy + 1) * config.smithy.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.SmithyP)}>{xprecord.SmithyP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.SmithyP)}>{xprecord.SmithyP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Smithy")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Smithy")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Smithy")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.miner.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermMiner)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Miner < config.miner.maxlvl && (((xprecord.Miner + 1) * config.miner.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill miner {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.miner}>{XPLang("miner", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Miner)}>{xprecord.Miner}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Miner < config.miner.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Miner)}>{(xprecord.Miner + 1) * config.miner.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.MinerP)}>{xprecord.MinerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.MinerP)}>{xprecord.MinerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Miner")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Miner")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Miner")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.forager.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermForager)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Forager < config.forager.maxlvl && (((xprecord.Forager + 1) * config.forager.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill forager {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceforager, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.forager}>{XPLang("forager", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Forager)}>{xprecord.Forager}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Forager < config.forager.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Forager)}>{(xprecord.Forager + 1) * config.forager.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.ForagerP)}>{xprecord.ForagerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.ForagerP)}>{xprecord.ForagerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Forager")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Forager")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Forager")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.hunter.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermHunter)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Hunter < config.hunter.maxlvl && (((xprecord.Hunter + 1) * config.hunter.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill hunter {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.hunter}>{XPLang("hunter", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Hunter)}>{xprecord.Hunter}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Hunter < config.hunter.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Hunter)}>{(xprecord.Hunter + 1) * config.hunter.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.HunterP)}>{xprecord.HunterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.HunterP)}>{xprecord.HunterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Hunter")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Hunter")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Hunter")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.crafter.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermCrafter)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Crafter < config.crafter.maxlvl && (((xprecord.Crafter + 1) * config.crafter.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill crafter {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.crafter}>{XPLang("crafter", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Crafter)}>{xprecord.Crafter}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Crafter < config.crafter.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Crafter)}>{(xprecord.Crafter + 1) * config.crafter.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.CrafterP)}>{xprecord.CrafterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.CrafterP)}>{xprecord.CrafterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Crafter")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Crafter")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Crafter")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.framer.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermFramer)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Framer < config.framer.maxlvl && (((xprecord.Framer + 1) * config.framer.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill framer {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceframer, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.framer}>{XPLang("framer", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Framer)}>{xprecord.Framer}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Framer < config.framer.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Framer)}>{(xprecord.Framer + 1) * config.framer.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.FramerP)}>{xprecord.FramerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.FramerP)}>{xprecord.FramerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Framer")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Framer")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Framer")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.fisher.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermFisher)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Fisher < config.fisher.maxlvl && (((xprecord.Fisher + 1) * config.fisher.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill fisher {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.fisher}>{XPLang("fisher", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Fisher)}>{xprecord.Fisher}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Fisher < config.fisher.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Fisher)}>{(xprecord.Fisher + 1) * config.fisher.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.FisherP)}>{xprecord.FisherP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.FisherP)}>{xprecord.FisherP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Fisher")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Fisher")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Fisher")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.medic.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermMedic)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Medic < config.medic.maxlvl && (((xprecord.Medic + 1) * config.medic.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill medic {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.medic}>{XPLang("medic", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Medic)}>{xprecord.Medic}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Medic < config.medic.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Medic)}>{(xprecord.Medic + 1) * config.medic.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.MedicP)}>{xprecord.MedicP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.MedicP)}>{xprecord.MedicP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Medic")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Medic")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Medic")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.scavenger.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermScavenger)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Scavenger < config.scavenger.maxlvl && (((xprecord.Scavenger + 1) * config.scavenger.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill scavenger {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.scavenger}>{XPLang("scavenger", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Scavenger)}>{xprecord.Scavenger}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Scavenger < config.scavenger.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Scavenger)}>{(xprecord.Scavenger + 1) * config.scavenger.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.ScavengerP)}>{xprecord.ScavengerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.ScavengerP)}>{xprecord.ScavengerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                double iconpos = 0.205;
                if (Wizardry != null && config.wizardrymod.enablewizardry && config.wizardrymod.statorskill == "Scavenger")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Archery != null && config.archerymod.enablearchery && config.archerymod.statorskill == "Scavenger")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                    iconpos += 0.015;
                }
                if (Backpacks != null && config.backpacksmod.enablebackpacks && config.backpacksmod.statorskill == "Scavenger")
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, row, height, $"{iconpos}", $"{iconpos + 0.01}"));
                }
                row++;
            }
            if (config.tamer.enabletame && ((config.defaultOptions.userpermissions && permission.UserHasPermission(player.UserIDString, PermTamer)) || !config.defaultOptions.userpermissions))
            {
                if (xprecord.Tamer < config.tamer.maxlvl && (((xprecord.Tamer + 1) * config.tamer.costmultiplier) <= xprecord.skillpoint))
                {
                    FullScreenelements.Add(XPUIButton($"xp.playeredits skill tamer {player.UserIDString}", row, height, 18, "0 0 0 0", "⇧", "0", "0.025", TextAnchor.MiddleCenter, "0 1 0 1"), XPeriencePlayerControlFullInfo);
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencetamer, row, height, "0.025", "0.035"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.tamer}>{XPLang("tamer", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 11, "0.040", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Tamer)}>{xprecord.Tamer}</color>", row, height, TextAnchor.MiddleLeft, 11, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Tamer < config.tamer.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Tamer)}>{(xprecord.Tamer + 1) * config.tamer.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.TamerP)}>{xprecord.TamerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.TamerP)}>{xprecord.TamerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
            }
            #endregion
            // Fix Data Button
            #region FixData
            DateTime resettimedata = xprecord.playerfixdata.AddMinutes(config.defaultOptions.playerfixdatatimer);
            TimeSpan datainterval = resettimedata - DateTime.Now;
            int datatimer = (int)datainterval.TotalMinutes;
            var button = $"{XPLang("playerfixdatabutton", player.UserIDString)}";
            if (!config.defaultOptions.restristresets || config.defaultOptions.bypassadminreset && player.IsAdmin && permission.UserHasPermission(player.UserIDString, XPerience.Admin))
            {
                datatimer = 0;
            }
            if (datatimer > 0)
            {
                button = $"{XPLang("resettimerdata", player.UserIDString, datatimer)}";
            }
            if (!config.defaultOptions.disableplayerfixdata || (config.defaultOptions.disableplayerfixdata && config.defaultOptions.bypassadminreset && player.IsAdmin && permission.UserHasPermission(player.UserIDString, XPerience.Admin)))
            {
                FullScreenelements.Add(XPUIPanel("0.01 0.025", "0.1 0.045", "0 0 0 0"), XPeriencePlayerControlFullInfo, XPeriencePlayerControlFullFixData);
                FullScreenelements.Add(XPUIButton("xp.playercontrol fix", 1, 1f, 12, "0.5 0.0 0.0 0.7", $"〖 {button} 〗", "0", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullFixData);
            }
            #endregion
            // Column Two Stat Effects
            #region Stat Effects List
            int rowtwo = 1;
            FullScreenelements.Add(XPUILabel($"Stat Effects:", rowtwo, 0.055f, TextAnchor.MiddleLeft, 18, "0.285", "0.38", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            // Reset Stats Button
            if (!config.defaultOptions.hardcorenoreset || (config.defaultOptions.hardcorenoreset && config.defaultOptions.bypassadminreset && player.IsAdmin && permission.UserHasPermission(player.UserIDString, XPerience.Admin)))
            {
                if (statstimer > 0)
                {
                    FullScreenelements.Add(XPUIButton("", rowtwo + 1, resetheight, 13, "1.0 0.0 0.0 0.7", $"〘{XPLang("canresetstats", player.UserIDString, statstimer)}〙", "0.38", "0.48", TextAnchor.MiddleCenter), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUIButton("xp.playercontrol reset stats", rowtwo + 1, resetheight, 13, "1.0 0.0 0.0 0.7", $"〘{XPLang("resetstatsbutton", player.UserIDString)}〙", "0.38", "0.48", TextAnchor.MiddleCenter), XPeriencePlayerControlFullInfo);
                }
            }
            // Stat List
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"----------------------------------------------------------------", rowtwo, 0.045f, TextAnchor.UpperLeft, 9, "0.285", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            rowtwo++;
            if ((xprecord.Mentality > 0 || config.defaultOptions.showunusedeffects) && config.mentality.maxlvl != 0)
            {
                if (config.mentality.researchcost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.mentality}>{XPLang("researchcost", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.mentality.researchcost)}>-{RankBoosts(player, (xprecord.Mentality * config.mentality.researchcost)) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.mentality.researchspeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.mentality}>{XPLang("researchspeed", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.mentality.researchspeed)}>-{RankBoosts(player, (xprecord.Mentality * config.mentality.researchspeed)) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.mentality.criticalchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.mentality}>{XPLang("critchance", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.mentality.criticalchance)}>+{(xprecord.Mentality * config.mentality.criticalchance) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.mentality.damageincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.mentality}>{XPLang("damagenpc", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.mentality.damageincrease)}>+{(xprecord.Mentality * config.mentality.damageincrease) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            if ((xprecord.Dexterity > 0 || config.defaultOptions.showunusedeffects) && config.dexterity.maxlvl != 0)
            {
                if (config.dexterity.blockchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("blockchance", player.UserIDString)}</color>: (<color=yellow>Damage</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.blockchance)}>+{(xprecord.Dexterity * config.dexterity.blockchance) * 100}%</color> (<color={TextColor(player, $"{textcolor}", config.dexterity.blockamount)}>-{RankBoosts(player, (xprecord.Dexterity * config.dexterity.blockamount)) * 100}%</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.blockamount != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("dodgechance", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.dodgechance)}>+{(xprecord.Dexterity * config.dexterity.dodgechance) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.reducearmordmg != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("armordmgabsorb", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.dexterity.reducearmordmg)}>-{RankBoosts(player, (xprecord.Dexterity * config.dexterity.reducearmordmg)) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.horsespeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("horsespeed", player.UserIDString)}</color>: (<color=yellow>USE key</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.horsespeed)}>+{(xprecord.Dexterity * config.dexterity.horsespeed) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.boatspeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("boatspeed", player.UserIDString)}</color>: (<color=yellow>RELOAD key</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.boatspeed)}>+{(xprecord.Dexterity * config.dexterity.boatspeed) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.vehiclespeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("vehiclespeed", player.UserIDString)}</color>: (<color=yellow>RELOAD key</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.vehiclespeed)}>+{(xprecord.Dexterity * config.dexterity.vehiclespeed) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.fuelreduce != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("vehiclefuelreduce", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.fuelreduce)}>+{(xprecord.Dexterity * config.dexterity.fuelreduce) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            if ((xprecord.Might > 0 || config.defaultOptions.showunusedeffects) && config.might.maxlvl != 0)
            {
                if (config.might.armor != 0)
                {
                    double teatime = 0;
                    double teaboost = 0;
                    bool teamodified = false;
                    // Check for TeaModifier Plugin and Values
                    if (TeaModifiers != null)
                    {
                        teatime = TeaModifiers.Call<float>("GetTeaDuration", player, xprecord.teatype, Modifier.ModifierType.Max_Health);
                        teaboost = TeaModifiers.Call<float>("GetTeaValue", player, xprecord.teatype, Modifier.ModifierType.Max_Health) * 100;
                        teamodified = true;
                    }
                   if (GetTeaCooldown(player) != 0)
                    {
                        switch (GetTeaTypes(player))
                        {
                            case "none":
                                teaboost = 0;
                                break;
                            case "maxhealthtea":
                                if (teamodified)
                                { teaboost = (teaboost * config.might.armor) * xprecord.Might; }
                                if (!teamodified)
                                { teaboost = (5 * config.might.armor) *xprecord.Might; }
                                break;
                            case "maxhealthtea.advanced":
                                if (teamodified)
                                { teaboost =(teaboost * config.might.armor) * xprecord.Might; }
                                if (!teamodified)
                                { teaboost = (12.5 * config.might.armor) *xprecord.Might; }
                                break;
                            case "maxhealthtea.pure":
                                if (teamodified)
                                { teaboost = (teaboost * config.might.armor) * xprecord.Might; }
                                if (!teamodified)
                                { teaboost = (20 * config.might.armor) *xprecord.Might; }
                                break;
                        }
                        teatime = Math.Ceiling(GetTeaCooldown(player) / 60);
                    }
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("armor", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.34", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($" (<color=yellow>{XPLang("tea", player.UserIDString)}: {XPLang($"teatype{xprecord.teatype}", player.UserIDString)} ({teatime} mins)</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 8, "0.34", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.armor)}>+{(xprecord.Might * config.might.armor) * 100}</color> (<color=yellow>+{Math.Ceiling(teaboost)}</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.meleedmg != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("melee", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.might.meleedmg)}>+{RankBoosts(player, (xprecord.Might * config.might.meleedmg)) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.metabolism != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("calories", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.might.metabolism)}>+{(int)(RankBoosts(player, (config.might.metabolism * xprecord.Might) * player.metabolism.calories.max))}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.metabolism != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("hydration", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.might.metabolism)}>+{(int)(RankBoosts(player, (config.might.metabolism * xprecord.Might) * player.metabolism.hydration.max))}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.bleedreduction != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("bleed", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.bleedreduction)}>-{(config.might.bleedreduction * xprecord.Might) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.radreduction != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("radiation", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.radreduction)}>-{(config.might.radreduction * xprecord.Might) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.heattolerance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("heat", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.heattolerance)}>+{(config.might.heattolerance * xprecord.Might) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.coldtolerance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("cold", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.coldtolerance)}>+{(config.might.coldtolerance * xprecord.Might) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            if ((xprecord.Captaincy > 0 || config.defaultOptions.showunusedeffects) && config.captaincy.maxlvl != 0)
            {
                if (config.captaincy.skillboost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecaptaincy, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.captaincy}>{XPLang("captaincyskillboost", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.captaincy.skillboost)}>+{(xprecord.Captaincy * config.captaincy.skillboost) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.captaincy.xpboost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecaptaincy, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.captaincy}>{XPLang("captaincyxpboost", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.captaincy.xpboost)}>+{(xprecord.Captaincy * config.captaincy.xpboost) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.captaincy.captaincydistance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecaptaincy, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.captaincy}>{XPLang("captaincydistance", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.captaincy.captaincydistance)}>+{RankBoosts(player, xprecord.Captaincy * config.captaincy.captaincydistance)} FT</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            if ((xprecord.Weaponry > 0 || config.defaultOptions.showunusedeffects) && config.weaponry.maxlvl != 0)
            {
                if (config.weaponry.reductionchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponrychance", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.reductionchance)}>+{(xprecord.Weaponry * config.weaponry.reductionchance) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;             
                    if (config.weaponry.tool != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponrytools", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.tool)}>-{(xprecord.Weaponry * config.weaponry.tool) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowtwo++;
                    }
                    if (config.weaponry.powertools != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponrypowertools", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.powertools)}>-{(xprecord.Weaponry * config.weaponry.powertools) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowtwo++;
                    }
                    if (config.weaponry.meleeweapons != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponryweaponsmelee", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.meleeweapons)}>-{(xprecord.Weaponry * config.weaponry.meleeweapons) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowtwo++;
                    }
                    if (config.weaponry.projectileweapons != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponryweaponsprojectile", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.projectileweapons)}>-{(xprecord.Weaponry * config.weaponry.projectileweapons) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowtwo++;
                    }
                }
                if (config.weaponry.maxammo != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponryweaponsammo", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.maxammo)}>+{(xprecord.Weaponry * config.weaponry.maxammo) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            #endregion
            // Other Abilities
            #region Other Abilities
            FullScreenelements.Add(XPUILabel($"<b>Other Abilities:</b>", rowtwo, skillheight, TextAnchor.MiddleLeft, 11, "0.285", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            rowtwo++;
            // Backpacks
            if (config.backpacksmod.enablebackpacks && (permission.UserHasPermission(player.UserIDString, Backpack1) || permission.UserHasPermission(player.UserIDString, Backpack2) || permission.UserHasPermission(player.UserIDString, Backpack3) || permission.UserHasPermission(player.UserIDString, Backpack4) || permission.UserHasPermission(player.UserIDString, Backpack5) || permission.UserHasPermission(player.UserIDString, Backpack6) || permission.UserHasPermission(player.UserIDString, Backpack7)))
            {
                int backpackrows = 0;
                int backpackslots = 0;
                if (permission.UserHasPermission(player.UserIDString, Backpack1))
                {
                    backpackrows = 1;
                    backpackslots = 6;
                }
                if (permission.UserHasPermission(player.UserIDString, Backpack2))
                {
                    backpackrows = 2;
                    backpackslots = 12;
                }
                if (permission.UserHasPermission(player.UserIDString, Backpack3))
                {
                    backpackrows = 3;
                    backpackslots = 18;
                }
                if (permission.UserHasPermission(player.UserIDString, Backpack4))
                {
                    backpackrows = 4;
                    backpackslots = 24;
                }
                if (permission.UserHasPermission(player.UserIDString, Backpack5))
                {
                    backpackrows = 5;
                    backpackslots = 30;
                }
                if (permission.UserHasPermission(player.UserIDString, Backpack6))
                {
                    backpackrows = 6;
                    backpackslots = 36;
                }
                if (permission.UserHasPermission(player.UserIDString, Backpack7))
                {
                    backpackrows = 7;
                    backpackslots = 42;
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, rowtwo, skillheight, "0.285", "0.295"));
                FullScreenelements.Add(XPUILabel($"Backpack Rows (<color=yellow>slots</color>):", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{backpackrows}</color> (<color=yellow>{backpackslots}</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 11, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                rowtwo++;
            }
            // Archery Line           
            if (config.archerymod.enablearchery && (permission.UserHasPermission(player.UserIDString, ArcheryNovice) || permission.UserHasPermission(player.UserIDString, ArcheryAdept) || permission.UserHasPermission(player.UserIDString, ArcheryMaster)))
            {
                if (permission.UserHasPermission(player.UserIDString, ArcheryNovice))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Archery Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("archerynovice", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (permission.UserHasPermission(player.UserIDString, ArcheryAdept))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Archery Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("archeryadept", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (permission.UserHasPermission(player.UserIDString, ArcheryMaster))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Archery Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("archerymaster", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            // Wizardy Line
            if (config.wizardrymod.enablewizardry && (permission.UserHasPermission(player.UserIDString, WizardryNovice) || permission.UserHasPermission(player.UserIDString, WizardryAdept) || permission.UserHasPermission(player.UserIDString, WizardryMaster)))
            {
                if (permission.UserHasPermission(player.UserIDString, WizardryNovice))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Wizardry Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("wizardrynovice", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (permission.UserHasPermission(player.UserIDString, WizardryAdept))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Wizardry Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("wizardryadept", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (permission.UserHasPermission(player.UserIDString, WizardryMaster))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Wizardry Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("wizardrymaster", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            #endregion
            // Colum Three Skill Effects
            #region Skill Effects List
            int rowthree = 1;
            FullScreenelements.Add(XPUILabel($"Skill Effects:", rowthree, 0.055f, TextAnchor.MiddleLeft, 18, "0.55", "0.65", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            // Reset Skills Button
            if (!config.defaultOptions.hardcorenoreset || (config.defaultOptions.hardcorenoreset && config.defaultOptions.bypassadminreset && player.IsAdmin && permission.UserHasPermission(player.UserIDString, XPerience.Admin)))
            {
                if (skilltimer > 0)
                {
                    FullScreenelements.Add(XPUIButton("", rowthree + 1, resetheight, 13, "1.0 0.0 0.0 0.7", $"〘{XPLang("canresetskills", player.UserIDString, skilltimer)}〙", "0.65", "0.78", TextAnchor.MiddleCenter), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUIButton("xp.playercontrol reset skills", rowthree + 1, resetheight, 13, "1.0 0.0 0.0 0.7", $"〘{XPLang("resetskillsbutton", player.UserIDString)}〙", "0.65", "0.78", TextAnchor.MiddleCenter), XPeriencePlayerControlFullInfo);
                }
            }
            // Skill List
            rowthree++;
            FullScreenelements.Add(XPUILabel($"---------------------------------------------------------------------------", rowthree, 0.045f, TextAnchor.UpperLeft, 9, "0.55", "1", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            rowthree++;
            string skilliconleft = "0.55";
            string skilliconright = "0.56";
            string skilllabelleft = "0.565";
            string skilllabelright = "0.715";
            string skillvalueleft = "0.715";
            string skillvalueright = "0.80";
            int rowthreenew = rowthree;
            if ((xprecord.WoodCutter > 0 || config.defaultOptions.showunusedeffects) && config.woodcutter.maxlvl != 0)
            {
                if (config.woodcutter.gatherrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewoodcutter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.woodcutter}>{XPLang("woodgather", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.woodcutter.gatherrate)}>{ValueSymbol("perk", config.woodcutter.gatherrate, "pos")}{RankBoosts(player, (xprecord.WoodCutter * config.woodcutter.gatherrate))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.woodcutter.bonusincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewoodcutter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.woodcutter}>Wood Bonus</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.woodcutter.bonusincrease)}>{ValueSymbol("perk", config.woodcutter.bonusincrease, "pos")}{RankBoosts(player, (xprecord.WoodCutter * config.woodcutter.bonusincrease))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.woodcutter.applechance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewoodcutter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.woodcutter}>{XPLang("woodapple", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.woodcutter.applechance)}>{ValueSymbol("perk", config.woodcutter.applechance, "pos")}{(xprecord.WoodCutter * config.woodcutter.applechance) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
               }
            }
            if ((xprecord.Smithy > 0 || config.defaultOptions.showunusedeffects) && config.smithy.maxlvl != 0)
            {
                if (config.smithy.productionrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.smithy}>{XPLang("productionrate", player.UserIDString)}</color>: (<color=yellow>{XPLang("productionamount", player.UserIDString)}</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Smithy)}>{ValueSymbol("perk", config.smithy.productionrate, "pos")}{RankBoosts(player, (xprecord.Smithy * config.smithy.productionrate)) * 100}%</color> (<color=yellow>+{ Math.Ceiling(RankBoosts(player,(xprecord.Smithy * config.smithy.productionrate) * 5))}</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.smithy.fuelconsumption != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.smithy}>{XPLang("fuelconsumption", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Smithy)}>{ValueSymbol("perk", config.smithy.fuelconsumption, "neg")}{RankBoosts(player, (xprecord.Smithy * config.smithy.fuelconsumption)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.smithy.metalchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.smithy}>{XPLang("hmetalchance", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Smithy)}>{ValueSymbol("perk", config.smithy.metalchance, "pos")}{RankBoosts(player, (xprecord.Smithy * config.smithy.metalchance)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.smithy.metalamount != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.smithy}>{XPLang("hmetalamount", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Smithy)}>{ValueSymbol("perk", config.smithy.metalamount, "pos")}{RankBoosts(player, xprecord.Smithy * config.smithy.metalamount)}</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Miner > 0 || config.defaultOptions.showunusedeffects) && config.miner.maxlvl != 0)
            {
                if (config.miner.gatherrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("oregather", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.gatherrate, "pos")}{RankBoosts(player, (xprecord.Miner * config.miner.gatherrate))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.miner.bonusincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>Ore Bonus</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.bonusincrease, "pos")}{RankBoosts(player, (xprecord.Miner * config.miner.bonusincrease))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.miner.fuelconsumption != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("fuelconsumptionhats", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.fuelconsumption, "neg")}{RankBoosts(player, (xprecord.Miner * config.miner.fuelconsumption)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.miner.metalchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("metalchance", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.metalchance, "pos")}{RankBoosts(player, (xprecord.Miner * config.miner.metalchance)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.miner.metalamount != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("metalamount", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.metalamount, "pos")}{RankBoosts(player, xprecord.Miner * config.miner.metalamount)}</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (XPerienceAddon != null)
                {
                    double quarryboost = Convert.ToDouble(XPerienceAddon.Call("GetMinerSkill", player, "amount"));
                    if (quarryboost != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("quarryboost", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", xprecord.Miner)}>{ValueSymbol("perk", quarryboost, "pos")}{quarryboost * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowthree++;
                        int quarryduration = Convert.ToInt32(XPerienceAddon.Call("GetMinerSkill", player, "duration"));
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("quarryduration", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", xprecord.Miner)}>{(xprecord.Miner * quarryduration) / 60} mins</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowthree++;
                        int quarrycooldown = Convert.ToInt32(XPerienceAddon.Call("GetMinerSkill", player, "cooldown"));
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("quarrycooldown", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", xprecord.Miner)}>{((xprecord.Miner * 60) - quarrycooldown) / 60} mins</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowthree++;
                    }
                }
            }
            if ((xprecord.Forager > 0 || config.defaultOptions.showunusedeffects) && config.forager.maxlvl != 0)
            {
                if (config.forager.gatherrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceforager, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.forager}>Ground {XPLang("gather", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Forager)}>{ValueSymbol("perk", config.forager.gatherrate, "pos")}{RankBoosts(player, (xprecord.Forager * config.forager.gatherrate))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.forager.chanceincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceforager, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.forager}>{XPLang("seedbonus", player.UserIDString)}</color>: (<color=yellow>Amount</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", xprecord.Forager)}>{ValueSymbol("perk", config.forager.chanceincrease, "pos")}{(config.forager.chanceincrease * xprecord.Forager) * 100}%</color> (<color=yellow>{(config.forager.chanceincrease * xprecord.Forager) * 10}</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.forager.randomchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceforager, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.forager}>{XPLang("randomitem", player.UserIDString)} Chance</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Forager)}>{ValueSymbol("perk", config.forager.randomchance, "pos")}{RankBoosts(player, (xprecord.Forager * config.forager.randomchance)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Hunter > 0 || config.defaultOptions.showunusedeffects) && config.hunter.maxlvl != 0)
            {
                if (config.hunter.gatherrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.hunter}>{XPLang("foodgather", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Hunter)}>{ValueSymbol("perk", config.hunter.gatherrate, "pos")}{RankBoosts(player, (xprecord.Hunter * config.hunter.gatherrate))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.hunter.bonusincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.hunter}>Food Bonus</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Hunter)}>{ValueSymbol("perk", config.hunter.bonusincrease, "pos")}{RankBoosts(player, (xprecord.Hunter * config.hunter.bonusincrease))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.hunter.damageincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.hunter}>{XPLang("damagewildlife", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Hunter)}>{ValueSymbol("perk", config.hunter.damageincrease, "pos")}{RankBoosts(player, (xprecord.Hunter * config.hunter.damageincrease))* 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.hunter.nightdmgincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.hunter}>{XPLang("nightdamage", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Hunter)}>{ValueSymbol("perk", config.hunter.nightdmgincrease, "pos")}{RankBoosts(player, (xprecord.Hunter * config.hunter.nightdmgincrease)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Crafter > 0 || config.defaultOptions.showunusedeffects) && config.crafter.maxlvl != 0)
            {
                if (config.crafter.craftspeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>{XPLang("craftspeed", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.craftspeed)}>{ValueSymbol("perk", config.crafter.craftspeed, "neg")}{RankBoosts(player, (config.crafter.craftspeed * xprecord.Crafter)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.crafter.craftcost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>Craft {XPLang("costreduction", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.craftcost)}>{ValueSymbol("perk", config.crafter.craftcost, "neg")}{RankBoosts(player, (xprecord.Crafter * config.crafter.craftcost)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.crafter.repairincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>{XPLang("fullrepair", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.repairincrease)}>{RankBoosts(player, (xprecord.Crafter * config.crafter.repairincrease)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.crafter.repaircost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>{XPLang("repaircost", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.repaircost)}>{ValueSymbol("perk", config.crafter.repaircost, "neg")}{RankBoosts(player, (xprecord.Crafter * config.crafter.repaircost)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.crafter.conditionchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>{XPLang("highcond", player.UserIDString)}</color>: (<color=yellow>Amount</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.conditionchance)}>{ValueSymbol("perk", config.crafter.conditionchance, "pos")}{RankBoosts(player, (config.crafter.conditionchance * xprecord.Crafter)) * 100}%</color> (<color=yellow>+{config.crafter.conditionamount * 100}%</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Framer > 0 || config.defaultOptions.showunusedeffects) && config.framer.maxlvl != 0)
            {
                if (config.framer.upgradecost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceframer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.framer}>Building {XPLang("upgradecost", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.framer.upgradecost)}>{ValueSymbol("perk", config.framer.upgradecost, "neg")}{RankBoosts(player, (config.framer.upgradecost * xprecord.Framer)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.framer.repairtime != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceframer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.framer}>Building {XPLang("repairtime", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.framer.repairtime)}>{ValueSymbol("perk", config.framer.repairtime, "neg")}{(xprecord.Framer * config.framer.repairtime) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.framer.repaircost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceframer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.framer}>Building {XPLang("repaircost", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.framer.repaircost)}>{ValueSymbol("perk", config.framer.repaircost, "neg")}{RankBoosts(player, (xprecord.Framer * config.framer.repaircost)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Fisher > 0 || config.defaultOptions.showunusedeffects) && config.fisher.maxlvl != 0)
            {
                if (config.fisher.fishamountincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.fisher}>{XPLang("fishamount", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.fisher.fishamountincrease)}>{ValueSymbol("perk", config.fisher.fishamountincrease, "pos")}{Math.Round(RankBoosts(player, xprecord.Fisher * config.fisher.fishamountincrease))}</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.fisher.itemamountincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.fisher}>{XPLang("fishitems", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.fisher.itemamountincrease)}>{ValueSymbol("perk", config.fisher.itemamountincrease, "pos")}{Math.Round(RankBoosts(player, xprecord.Fisher * config.fisher.itemamountincrease))}</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.fisher.oxygenreduction != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.fisher}>{XPLang("fishoxygen", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.fisher.oxygenreduction)}>{ValueSymbol("perk", config.fisher.oxygenreduction, "neg")}{Math.Round((xprecord.Fisher * config.fisher.oxygenreduction) * 100)}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.fisher.oxygentankreduction != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.fisher}>{XPLang("fishoxygentank", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.fisher.oxygentankreduction)}>{ValueSymbol("perk", config.fisher.oxygentankreduction, "neg")}{Math.Round(RankBoosts(player, (xprecord.Fisher * config.fisher.oxygentankreduction)) * 100)}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if (rowthree >= 29)
            {
                skilliconleft = "0.80";
                skilliconright = "0.81";
                skilllabelleft = "0.815";
                skilllabelright = "0.945";
                skillvalueleft = "0.945";
                skillvalueright = "1";
            }
            else
            {
                rowthreenew = rowthree;
            }
            if ((xprecord.Medic > 0 || config.defaultOptions.showunusedeffects) && config.medic.maxlvl != 0)
            {
                if (config.medic.recoverhp != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.medic}>{XPLang("medicrevive", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.medic.recoverhp)}>{ValueSymbol("perk", config.medic.recoverhp, "pos")}{Math.Round(RankBoosts(player, xprecord.Medic * config.medic.recoverhp))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.medic.revivehp != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.medic}>{XPLang("medicrecover", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.medic.revivehp)}>{ValueSymbol("perk", config.medic.revivehp, "pos")}{Math.Round(RankBoosts(player, xprecord.Medic * config.medic.revivehp))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.medic.tools != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.medic}>{XPLang("medictools", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.medic.tools)}>{ValueSymbol("perk", config.medic.tools, "pos")}{Math.Round(RankBoosts(player, xprecord.Medic * config.medic.tools))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.medic.crafttime != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.medic}>{XPLang("mediccrafting", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.medic.crafttime)}>{ValueSymbol("perk", config.medic.crafttime, "pos")}{Math.Round((xprecord.Medic * config.medic.crafttime) * 100)}%</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.medic.teas != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.medic}>{XPLang("medicteas", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.medic.teas)}>{ValueSymbol("perk", config.medic.teas, "pos")}{Math.Round((xprecord.Medic * config.medic.teas) * 100)}%</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
            }
            if ((xprecord.Scavenger > 0 || config.defaultOptions.showunusedeffects) && config.scavenger.maxlvl != 0)
            {
                if (config.scavenger.scavlootchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.scavenger}>{XPLang("scavchance", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.scavenger.scavlootchance)}>{ValueSymbol("perk", config.scavenger.scavlootchance, "pos")}{Math.Round(RankBoosts(player, (xprecord.Scavenger * config.scavenger.scavlootchance)) * 100)}%</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.scavenger.scavmultiplier != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.scavenger}>{XPLang("scavmultiplier", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.scavenger.scavmultiplier)}>x{Math.Ceiling(RankBoosts(player, xprecord.Scavenger * config.scavenger.scavmultiplier))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.scavenger.scavchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.scavenger}>{XPLang("customscavchance", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.scavenger.scavchance)}>{ValueSymbol("perk", config.scavenger.scavchance, "pos")}{Math.Round(RankBoosts(player, (xprecord.Scavenger * config.scavenger.scavchance)) * 100)}%</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.scavenger.customscavmultiplier != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.scavenger}>{XPLang("customscavmultiplier", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.scavenger.customscavmultiplier)}>x{Math.Ceiling(RankBoosts(player, xprecord.Scavenger * config.scavenger.customscavmultiplier))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
            }
            // Taming Ability
            if (xprecord.Tamer > 0)
            {
                rowthreenew = 27;
                skilliconleft = "0.80";
                skilliconright = "0.81";
                skilllabelleft = "0.815";
                skilllabelright = "0.945";
                FullScreenelements.Add(XPUILabel($"Taming Abilities:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 12, skilliconleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                rowthreenew++;
                if (xprecord.Tamer >= config.tamer.chickenlevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencechicken, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("chicken", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.boarlevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceboar, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("boar", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.staglevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencestag, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("stag", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.wolflevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewolf, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("wolf", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.bearlevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebear, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("bear", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.polarbearlevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencepolarbear, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("polarbear", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
            }
            #endregion
            CuiHelper.AddUi(player, FullScreenelements);
        }
        // Other Player Panels
        private void SelectedPlayerPanelFullMain(BasePlayer player, string selectedplayer)
        {
            if (player == null || selectedplayer == null) return;
            XPRecord xprecord = GetPlayerRecord(selectedplayer);
            Ranks rank = GetXPRank(xprecord.rank);
            var FullScreenelements = new CuiElementContainer();
            var height = 0.050f;
            // Main UI | Title | Icon
            FullScreenelements.Add(new CuiPanel
            {
                Image =
                {
                    Color = "0.1 0.1 0.1 0.99"
                },
                RectTransform =
                {
                    AnchorMin = $"0 0",
                    AnchorMax = $"1 1"
                },
                CursorEnabled = true
            }, "Overlay", XPeriencePlayerControlFullMain);
            FullScreenelements.Add(XPUILabel($"{xprecord.displayname}", 1, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.18", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullMain);
            if (config.xpLevelRanks.enableresetranks && !rank.image.IsNullOrEmpty() && !xprecord.DisableRank)
            {
                FullScreenelements.Add(new CuiElement
                {
                    Parent = XPeriencePlayerControlFullMain,
                    Components =
                {
                    new CuiRawImageComponent
                    {
                        Png = ImageLibrary?.Call<string>("GetImage", rank.name)
                    },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = "0.01 0.75",
                        AnchorMax = "0.15 0.95"
                    }
                }
                });
            }
            else
            {
                FullScreenelements.Add(new CuiElement
                {
                    Parent = XPeriencePlayerControlFullMain,
                    Components =
                {
                    new CuiRawImageComponent
                    {
                        Png = ImageLibrary?.Call<string>("GetImage", XPerienceicon)
                    },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = "0.01 0.75",
                        AnchorMax = "0.15 0.95"
                    }
                }
                });
            }
            // Spacer
            int row = 4;
            // Navigation Menu
            FullScreenelements.Add(XPUIPanel("0.0 0.0", "0.15 0.85", "1.0 1.0 1.0 0.0"), XPeriencePlayerControlFullMain, XPeriencePlayerControlFullMenu);
            //Current Player Button
            FullScreenelements.Add(XPUIButton("xp.playercontrol main", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("adminmenu_014", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            // Selected Player Buttom
            row++;
            row++;
            FullScreenelements.Add(XPUIButton($"xp.playercontrol selectedplayer {selectedplayer}", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("adminmenu_015", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            // Kill Records Button
            if (KillRecords != null && config.xpBonus.showkrbutton)
            {
                row++;
                row++;
                FullScreenelements.Add(XPUIButton($"xp.playercontrol killrecords {selectedplayer}", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("playerkillrecords", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            }
            // Top Players Buttom
            row++;
            row++;
            FullScreenelements.Add(XPUIButton($"xp.playercontrol topplayers", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("topplayers", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            // Help Button
            row++;
            row++;
            FullScreenelements.Add(XPUIButton("xp.playercontrol help", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("help", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            // Close Button
            row++;
            row++;
            FullScreenelements.Add(XPUIButton("xp.playercontrol close", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("adminmenu_009", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            // Admin Button
            if (player.IsAdmin && permission.UserHasPermission(player.UserIDString, Admin))
            {
                row++;
                row++;
                FullScreenelements.Add(XPUIButton("xp.playercontrol admin", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("adminpanel", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPeriencePlayerControlFullMenu);
            }
            // UI End
            CuiHelper.AddUi(player, FullScreenelements);
            return;
        }
        private void SelectedPlayerInfoPage(BasePlayer player, string selectedplayer)
        {
            if (player == null || selectedplayer == null) return;
            XPRecord xprecord = GetPlayerRecord(selectedplayer);
            Ranks rank = GetXPRank(xprecord.rank);
            string textcolor = "perk";
            if (xprecord.rank > 0 && !xprecord.DisableRank)
            {
                textcolor = "ranklevel";
            }
            if (xprecord == null) return;
            float height = 0.030f;
            float skillheight = 0.030f;
            float infoheight = 0.020f;
            int row = 1;
            var FullScreenelements = new CuiElementContainer();
            // No Display if player search disabled
            if(!config.defaultOptions.allowplayersearch)
            {
                // Main UI
                FullScreenelements.Add(XPUIPanel("0.16 0.0", "1 1", "0 0 0 0.75"), XPeriencePlayerControlFullMain, XPeriencePlayerControlFullInfo);
                // Player Name
                FullScreenelements.Add(XPUILabel($"{xprecord.displayname}", row, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                row++; 
                FullScreenelements.Add(XPUILabel($"{XPLang("playersearchdisabled", player.UserIDString)}", row, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                CuiHelper.AddUi(player, FullScreenelements);
                return;
            }
            // Continue with full profile
            // Main UI
            FullScreenelements.Add(XPUIPanel("0.16 0.0", "1 1", "0 0 0 0.75"), XPeriencePlayerControlFullMain, XPeriencePlayerControlFullInfo);
            // Player Name
            FullScreenelements.Add(XPUILabel($"Player Details:", row, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            if (config.playerinfoBoxsettings.showinfobox)
            {
                FullScreenelements.Add(XPUIButton($"xp.playercontrol openbox {xprecord.id}", row + 1, infoheight, 13, "1.0 0.0 0.0 0.7", $"〘Info Box〙", "0.13", "0.20", TextAnchor.MiddleCenter), XPeriencePlayerControlFullInfo);
            }
            row++;
            // Main - Player Info
            int statpoints = xprecord.MentalityP + xprecord.DexterityP + xprecord.MightP + xprecord.CaptaincyP + xprecord.WeaponryP;
            int skillpoints = xprecord.WoodCutterP + xprecord.SmithyP + xprecord.MinerP + xprecord.ForagerP + xprecord.HunterP + xprecord.FisherP + xprecord.CrafterP + xprecord.FramerP + xprecord.TamerP + xprecord.MedicP + xprecord.ScavengerP;
            // XP Calulations
            double levelpercent;
            if (xprecord.experience == 0 || xprecord.level == 0)
            {
                levelpercent = ((xprecord.experience - 0) / config.xpLevel.levelstart) * 100;
            }
            else
            {
                levelpercent = ((xprecord.experience - (xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier))) / (xprecord.requiredxp - (xprecord.requiredxp - (xprecord.level * config.xpLevel.levelmultiplier)))) * 100;
            }
            // Level / XP Info
            FullScreenelements.Add(XPUILabel($"----------------------------------------------------------------", row, 0.035f, TextAnchor.MiddleLeft, 9, "0.0", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            if (config.defaultOptions.showonlinestatus)
            {
                if (xprecord.Status)
                {
                    FullScreenelements.Add(XPUILabel($"{XPLang("status", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceonline, row, height, "0.11", "0.117"));
                    FullScreenelements.Add(XPUILabel($" {XPLang("online", player.UserIDString)}", row, height, TextAnchor.MiddleLeft, 12, "0.12", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    row++;
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"{XPLang("status", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceoffline, row, height, "0.11", "0.117"));
                    FullScreenelements.Add(XPUILabel($" {XPLang("offline", player.UserIDString)}", row, height, TextAnchor.MiddleLeft, 12, "0.12", "0.25", "1 1 1 1"), XPeriencePlayerControlFullInfo);
                    row++;
                }
            }
            if (config.xpLevelRanks.enableresetranks && !xprecord.DisableRank)
            {
                FullScreenelements.Add(XPUILabel($"{XPLang("rank", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.name}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.05", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                row++;
                FullScreenelements.Add(XPUILabel($"{XPLang("ranksig", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "rankname", xprecord.rank)}>{rank.sig}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                row++;
                if (config.xpLevelRanks.showtruelevelprofile)
                {
                    FullScreenelements.Add(XPUILabel($"{XPLang("ranklevel", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "ranklevel", xprecord.truelevel)}>{xprecord.truelevel}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    row++;
                }
                if (config.xpLevelRanks.showtruexpprofile)
                {
                    FullScreenelements.Add(XPUILabel($"{XPLang("rankxp", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "rankxp", xprecord.trueexperience)}>{xprecord.trueexperience}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    row++;
                }
            }
            FullScreenelements.Add(XPUILabel($"{XPLang("level", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "mainlevel", (int)xprecord.level)}>{xprecord.level} ({(int)levelpercent}%)</color>", row, height, TextAnchor.MiddleLeft, 13, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            FullScreenelements.Add(XPUILabel($"{XPLang("experience", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "experience", (int)xprecord.experience)}>{(int)xprecord.experience}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            FullScreenelements.Add(XPUILabel($"{XPLang("nextlevel", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "nextlevel", (int)xprecord.requiredxp)}>{(int)xprecord.requiredxp}</color> (<color={TextColor(player, "remainingxp", (int)(xprecord.requiredxp - xprecord.experience))}>{(int)(xprecord.requiredxp - xprecord.experience)}</color>)", row, height, TextAnchor.MiddleLeft, 13, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            // Unspent Points
            FullScreenelements.Add(XPUILabel($"{XPLang("unusedstatpoints", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "unspent", xprecord.statpoint)}>{xprecord.statpoint}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            FullScreenelements.Add(XPUILabel($"{XPLang("unusedskillpoints", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "unspent", xprecord.skillpoint)}>{xprecord.skillpoint}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            FullScreenelements.Add(XPUILabel($"{XPLang("totalspent", player.UserIDString)}:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "spent", statpoints + skillpoints)}>{statpoints + skillpoints}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.11", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            // Stats
            FullScreenelements.Add(XPUILabel($"----------------------------------------------------------------", row, height, TextAnchor.MiddleLeft, 9, "0.0", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            if (config.mentality.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermMentality)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.mentality}>{XPLang("mentality", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Mentality)}>{xprecord.Mentality}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Mentality < config.mentality.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Mentality)}>{(xprecord.Mentality + 1) * config.mentality.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.MentalityP)}>{xprecord.MentalityP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.MentalityP)}>{xprecord.MentalityP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.dexterity.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermDexterity)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.dexterity}>{XPLang("dexterity", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Dexterity)}>{xprecord.Dexterity}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Dexterity < config.dexterity.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Dexterity)}>{(xprecord.Dexterity + 1) * config.dexterity.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.DexterityP)}>{xprecord.DexterityP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.DexterityP)}>{xprecord.DexterityP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.might.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermMight)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.might}>{XPLang("might", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Might)}>{xprecord.Might}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Might < config.might.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Might)}>{(xprecord.Might + 1) * config.might.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.MightP)}>{xprecord.MightP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.MightP)}>{xprecord.MightP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.captaincy.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermCaptaincy)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecaptaincy, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.captaincy}>{XPLang("captaincy", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Captaincy)}>{xprecord.Captaincy}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Captaincy < config.captaincy.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Captaincy)}>{(xprecord.Captaincy + 1) * config.captaincy.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.CaptaincyP)}>{xprecord.CaptaincyP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.CaptaincyP)}>{xprecord.CaptaincyP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.weaponry.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermWeaponry)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.weaponry}>{XPLang("weaponry", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Weaponry)}>{xprecord.Weaponry}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Weaponry < config.weaponry.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Weaponry)}>{(xprecord.Weaponry + 1) * config.weaponry.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.WeaponryP)}>{xprecord.WeaponryP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.WeaponryP)}>{xprecord.WeaponryP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            // Skills
            FullScreenelements.Add(XPUILabel($"----------------------------------------------------------------", row, height, TextAnchor.MiddleLeft, 9, "0.0", "0.25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            row++;
            if (config.woodcutter.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermWoodCutter)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewoodcutter, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.woodcutter}>{XPLang("woodcutter", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.WoodCutter)}>{xprecord.WoodCutter}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.WoodCutter < config.woodcutter.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.WoodCutter)}>{(xprecord.WoodCutter + 1) * config.woodcutter.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.WoodCutterP)}>{xprecord.WoodCutterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.WoodCutterP)}>{xprecord.WoodCutterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.smithy.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermSmithy)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.smithy}>{XPLang("smithy", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Smithy)}>{xprecord.Smithy}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Smithy < config.smithy.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Smithy)}>{(xprecord.Smithy + 1) * config.smithy.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.SmithyP)}>{xprecord.SmithyP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.SmithyP)}>{xprecord.SmithyP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.miner.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermMiner)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.miner}>{XPLang("miner", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Miner)}>{xprecord.Miner}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Miner < config.miner.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Miner)}>{(xprecord.Miner + 1) * config.miner.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.MinerP)}>{xprecord.MinerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.MinerP)}>{xprecord.MinerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.forager.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermForager)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceforager, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.forager}>{XPLang("forager", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Forager)}>{xprecord.Forager}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Forager < config.forager.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Forager)}>{(xprecord.Forager + 1) * config.forager.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.ForagerP)}>{xprecord.ForagerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.ForagerP)}>{xprecord.ForagerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.hunter.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermHunter)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.hunter}>{XPLang("hunter", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Hunter)}>{xprecord.Hunter}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Hunter < config.hunter.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Hunter)}>{(xprecord.Hunter + 1) * config.hunter.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.HunterP)}>{xprecord.HunterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.HunterP)}>{xprecord.HunterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.crafter.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermCrafter)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.crafter}>{XPLang("crafter", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Crafter)}>{xprecord.Crafter}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Crafter < config.crafter.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Crafter)}>{(xprecord.Crafter + 1) * config.crafter.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.CrafterP)}>{xprecord.CrafterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.CrafterP)}>{xprecord.CrafterP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.framer.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermFramer)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceframer, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.framer}>{XPLang("framer", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Framer)}>{xprecord.Framer}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Framer < config.framer.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Framer)}>{(xprecord.Framer + 1) * config.framer.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.FramerP)}>{xprecord.FramerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.FramerP)}>{xprecord.FramerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.fisher.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermFisher)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.fisher}>{XPLang("fisher", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Fisher)}>{xprecord.Fisher}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Fisher < config.fisher.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Fisher)}>{(xprecord.Fisher + 1) * config.fisher.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.FisherP)}>{xprecord.FisherP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.FisherP)}>{xprecord.FisherP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.medic.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermMedic)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.medic}>{XPLang("medic", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Medic)}>{xprecord.Medic}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Medic < config.medic.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Medic)}>{(xprecord.Medic + 1) * config.medic.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.MedicP)}>{xprecord.MedicP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.MedicP)}>{xprecord.MedicP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.scavenger.maxlvl != 0 && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermScavenger)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.scavenger}>{XPLang("scavenger", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Scavenger)}>{xprecord.Scavenger}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Scavenger < config.scavenger.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Scavenger)}>{(xprecord.Scavenger + 1) * config.scavenger.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.ScavengerP)}>{xprecord.ScavengerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.ScavengerP)}>{xprecord.ScavengerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                row++;
            }
            if (config.tamer.enabletame && ((config.defaultOptions.userpermissions && permission.UserHasPermission(xprecord.id.ToString(), PermTamer)) || !config.defaultOptions.userpermissions))
            {
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencetamer, row, height, "0.01", "0.021"));
                FullScreenelements.Add(XPUILabel($"<color={config.uitextColor.tamer}>{XPLang("tamer", player.UserIDString)}</color>:", row, height, TextAnchor.MiddleLeft, 12, "0.026", "0.11", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "level", xprecord.Tamer)}>{xprecord.Tamer}</color>", row, height, TextAnchor.MiddleLeft, 12, "0.11", "0.15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                if (xprecord.Tamer < config.tamer.maxlvl)
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "nextlevel", xprecord.Tamer)}>{(xprecord.Tamer + 1) * config.tamer.costmultiplier}</color> / <color={TextColor(player, "spent", xprecord.TamerP)}>{xprecord.TamerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
                else
                {
                    FullScreenelements.Add(XPUILabel($"( <color={TextColor(player, "spent", xprecord.TamerP)}>{xprecord.TamerP}</color> )", row, height, TextAnchor.MiddleCenter, 10, "0.15", "0.20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
            }
            // Column Two Stat Effects
            int rowtwo = 1;
            FullScreenelements.Add(XPUILabel($"Stat Effects:", rowtwo, 0.055f, TextAnchor.MiddleLeft, 18, "0.285", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"----------------------------------------------------------------", rowtwo, 0.045f, TextAnchor.UpperLeft, 9, "0.285", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            rowtwo++;
            if ((xprecord.Mentality > 0 || config.defaultOptions.showunusedeffects) && config.mentality.maxlvl != 0)
            {
                if (config.mentality.researchcost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.mentality}>{XPLang("researchcost", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.mentality.researchcost)}>-{RankBoosts(player, (xprecord.Mentality * config.mentality.researchcost)) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.mentality.researchspeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.mentality}>{XPLang("researchspeed", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.mentality.researchspeed)}>-{RankBoosts(player, (xprecord.Mentality * config.mentality.researchspeed)) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.mentality.criticalchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.mentality}>{XPLang("critchance", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.mentality.criticalchance)}>+{(xprecord.Mentality * config.mentality.criticalchance) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.mentality.damageincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencementality, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.mentality}>{XPLang("damagenpc", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.mentality.damageincrease)}>+{(xprecord.Mentality * config.mentality.damageincrease) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            if ((xprecord.Dexterity > 0 || config.defaultOptions.showunusedeffects) && config.dexterity.maxlvl != 0)
            {
                if (config.dexterity.blockchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("blockchance", player.UserIDString)}</color>: (<color=yellow>Damage</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.blockchance)}>+{(xprecord.Dexterity * config.dexterity.blockchance) * 100}%</color> (<color={TextColor(player, $"{textcolor}", config.dexterity.blockamount)}>-{RankBoosts(player, (xprecord.Dexterity * config.dexterity.blockamount)) * 100}%</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.blockamount != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("dodgechance", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.dodgechance)}>+{(xprecord.Dexterity * config.dexterity.dodgechance) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.reducearmordmg != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("armordmgabsorb", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.dexterity.reducearmordmg)}>-{RankBoosts(player, (xprecord.Dexterity * config.dexterity.reducearmordmg)) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.horsespeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("horsespeed", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.horsespeed)}>+{(xprecord.Dexterity * config.dexterity.horsespeed) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.boatspeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("boatspeed", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.boatspeed)}>+{(xprecord.Dexterity * config.dexterity.boatspeed) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.vehiclespeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("vehiclespeed", player.UserIDString)}</color>: (<color=yellow>RELOAD key</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.vehiclespeed)}>+{(xprecord.Dexterity * config.dexterity.vehiclespeed) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.dexterity.fuelreduce != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencedexterity, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.dexterity}>{XPLang("vehiclefuelreduce", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.dexterity.fuelreduce)}>+{(xprecord.Dexterity * config.dexterity.fuelreduce) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            if ((xprecord.Might > 0 || config.defaultOptions.showunusedeffects) && config.might.maxlvl != 0)
            {
                if (config.might.armor != 0)
                {
                    double teatime = 0;
                    double teaboost = 0;
                    bool teamodified = false;
                    //double armor = (xprecord.Might * config.might.armor) * 100;
                    // Check for TeaModifier Plugin and Values
                    if (TeaModifiers != null)
                    {
                        teatime = TeaModifiers.Call<float>("GetTeaDuration", player, xprecord.teatype, Modifier.ModifierType.Max_Health);
                        teaboost = TeaModifiers.Call<float>("GetTeaValue", player, xprecord.teatype, Modifier.ModifierType.Max_Health) * 100;
                        teamodified = true;
                    }
                    if (GetTeaCooldown(player) != 0)
                    {
                        switch (GetTeaTypes(player))
                        {
                            case "none":
                                teaboost = 0;
                                break;
                            case "maxhealthtea":
                                if (teamodified)
                                { teaboost = (teaboost * config.might.armor) * xprecord.Might; }
                                if (!teamodified)
                                { teaboost = (5 * config.might.armor) * xprecord.Might; }
                                break;
                            case "maxhealthtea.advanced":
                                if (teamodified)
                                { teaboost = (teaboost * config.might.armor) * xprecord.Might; }
                                if (!teamodified)
                                { teaboost = (12.5 * config.might.armor) * xprecord.Might; }
                                break;
                            case "maxhealthtea.pure":
                                if (teamodified)
                                { teaboost = (teaboost * config.might.armor) * xprecord.Might; }
                                if (!teamodified)
                                { teaboost = (20 * config.might.armor) * xprecord.Might; }
                                break;
                        }
                        teatime = Math.Ceiling(GetTeaCooldown(player) / 60);
                    }
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("armor", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.34", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($" (<color=yellow>{XPLang("tea", player.UserIDString)}: {XPLang($"teatype{xprecord.teatype}", player.UserIDString)} ({teatime} mins)</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 8, "0.34", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.armor)}>+{(xprecord.Might * config.might.armor) * 100}</color> (<color=yellow>+{Math.Ceiling(teaboost)}</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.meleedmg != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("melee", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.might.meleedmg)}>+{RankBoosts(player, (xprecord.Might * config.might.meleedmg)) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.metabolism != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("calories", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.might.metabolism)}>+{(int)(RankBoosts(player, (config.might.metabolism * xprecord.Might) * player.metabolism.calories.max))}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.metabolism != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("hydration", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.might.metabolism)}>+{(int)(RankBoosts(player, (config.might.metabolism * xprecord.Might) * player.metabolism.hydration.max))}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.bleedreduction != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("bleed", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.bleedreduction)}>-{(config.might.bleedreduction * xprecord.Might) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.radreduction != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("radiation", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.radreduction)}>-{(config.might.radreduction * xprecord.Might) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.heattolerance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("heat", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.heattolerance)}>+{(config.might.heattolerance * xprecord.Might) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.might.coldtolerance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemight, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.might}>{XPLang("cold", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.might.coldtolerance)}>+{(config.might.coldtolerance * xprecord.Might) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            if ((xprecord.Captaincy > 0 || config.defaultOptions.showunusedeffects) && config.captaincy.maxlvl != 0)
            {
                if (config.captaincy.skillboost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecaptaincy, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.captaincy}>{XPLang("captaincyskillboost", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.captaincy.skillboost)}>+{(xprecord.Captaincy * config.captaincy.skillboost) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.captaincy.xpboost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecaptaincy, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.captaincy}>{XPLang("captaincyxpboost", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.captaincy.xpboost)}>+{(xprecord.Captaincy * config.captaincy.xpboost) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (config.captaincy.captaincydistance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecaptaincy, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.captaincy}>{XPLang("captaincydistance", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.captaincy.captaincydistance)}>+{RankBoosts(player, xprecord.Captaincy * config.captaincy.captaincydistance)} FT</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            if ((xprecord.Weaponry > 0 || config.defaultOptions.showunusedeffects) && config.weaponry.maxlvl != 0)
            {
                if (config.weaponry.reductionchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponrychance", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.reductionchance)}>+{(xprecord.Weaponry * config.weaponry.reductionchance) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                    if (config.weaponry.tool != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponrytools", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.tool)}>-{(xprecord.Weaponry * config.weaponry.tool) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowtwo++;
                    }
                    if (config.weaponry.powertools != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponrypowertools", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.powertools)}>-{(xprecord.Weaponry * config.weaponry.powertools) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowtwo++;
                    }
                    if (config.weaponry.meleeweapons != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponryweaponsmelee", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.meleeweapons)}>-{(xprecord.Weaponry * config.weaponry.meleeweapons) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowtwo++;
                    }
                    if (config.weaponry.projectileweapons != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponryweaponsprojectile", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.projectileweapons)}>-{(xprecord.Weaponry * config.weaponry.projectileweapons) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowtwo++;
                    }
                }
                if (config.weaponry.maxammo != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceweaponry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.weaponry}>{XPLang("weaponryweaponsammo", player.UserIDString)}</color>:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.weaponry.maxammo)}>+{(xprecord.Weaponry * config.weaponry.maxammo) * 100}%</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            // Other Abilities
            FullScreenelements.Add(XPUILabel($"Other Abilities:", rowtwo, skillheight, TextAnchor.MiddleLeft, 12, "0.285", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            rowtwo++;
            // Backpacks
            if (config.backpacksmod.enablebackpacks && (permission.UserHasPermission(xprecord.id, Backpack1) || permission.UserHasPermission(xprecord.id, Backpack2) || permission.UserHasPermission(xprecord.id, Backpack3) || permission.UserHasPermission(xprecord.id, Backpack4) || permission.UserHasPermission(xprecord.id, Backpack5) || permission.UserHasPermission(xprecord.id, Backpack6) || permission.UserHasPermission(xprecord.id, Backpack7)))
            {
                int backpackrows = 0;
                int backpackslots = 0;
                if (permission.UserHasPermission(xprecord.id, Backpack1))
                {
                    backpackrows = 1;
                    backpackslots = 6;
                }
                if (permission.UserHasPermission(xprecord.id, Backpack2))
                {
                    backpackrows = 2;
                    backpackslots = 12;
                }
                if (permission.UserHasPermission(xprecord.id, Backpack3))
                {
                    backpackrows = 3;
                    backpackslots = 18;
                }
                if (permission.UserHasPermission(xprecord.id, Backpack4))
                {
                    backpackrows = 4;
                    backpackslots = 24;
                }
                if (permission.UserHasPermission(xprecord.id, Backpack5))
                {
                    backpackrows = 5;
                    backpackslots = 30;
                }
                if (permission.UserHasPermission(xprecord.id, Backpack6))
                {
                    backpackrows = 6;
                    backpackslots = 36;
                }
                if (permission.UserHasPermission(xprecord.id, Backpack7))
                {
                    backpackrows = 7;
                    backpackslots = 42;
                }
                FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebackpack, rowtwo, skillheight, "0.285", "0.295"));
                FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Backpack Rows (<color=yellow>slots</color>):", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{backpackrows}</color> (<color=yellow>{backpackslots}</color>)", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                rowtwo++;
            }
            // Archery Line
            if (config.archerymod.enablearchery && (permission.UserHasPermission(xprecord.id, ArcheryNovice) || permission.UserHasPermission(xprecord.id, ArcheryAdept) || permission.UserHasPermission(xprecord.id, ArcheryMaster)))
            {
                if (permission.UserHasPermission(xprecord.id, ArcheryNovice))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Archery Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("archerynovice", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                     rowtwo++;
               }
                if (permission.UserHasPermission(xprecord.id, ArcheryAdept))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Archery Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("archeryadept", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                     rowtwo++;
               }
                if (permission.UserHasPermission(xprecord.id, ArcheryMaster))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencearchery, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Archery Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("archerymaster", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                     rowtwo++;
               }
            }
            // Wizardy Line
            if (config.wizardrymod.enablewizardry && (permission.UserHasPermission(xprecord.id, WizardryNovice) || permission.UserHasPermission(xprecord.id, WizardryAdept) || permission.UserHasPermission(xprecord.id, WizardryMaster)))
            {
                if (permission.UserHasPermission(xprecord.id, WizardryNovice))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Wizardry Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("wizardrynovice", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
                if (permission.UserHasPermission(xprecord.id, WizardryAdept))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Wizardry Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("wizardryadept", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                     rowtwo++;
               }
                if (permission.UserHasPermission(xprecord.id, WizardryMaster))
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewizardry, rowtwo, skillheight, "0.285", "0.295"));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> Wizardry Level:", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.3", "0.45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "pets", 1)}>{XPLang("wizardrymaster", player.UserIDString)}</color>", rowtwo, skillheight, TextAnchor.MiddleLeft, 10, "0.45", "0.6", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowtwo++;
                }
            }
            // Colum Three Skill Effects
            int rowthree = 1;
            FullScreenelements.Add(XPUILabel($"Skill Effects:", rowthree, 0.055f, TextAnchor.MiddleLeft, 18, "0.55", "0.65", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            // Skill List
            rowthree++;
            FullScreenelements.Add(XPUILabel($"---------------------------------------------------------------------------", rowthree, 0.045f, TextAnchor.UpperLeft, 9, "0.55", "1", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
            rowthree++;
            string skilliconleft = "0.55";
            string skilliconright = "0.56";
            string skilllabelleft = "0.565";
            string skilllabelright = "0.715";
            string skillvalueleft = "0.715";
            string skillvalueright = "0.80";
            int rowthreenew = rowthree;
            if ((xprecord.WoodCutter > 0 || config.defaultOptions.showunusedeffects) && config.woodcutter.maxlvl != 0)
            {
                if (config.woodcutter.gatherrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewoodcutter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.woodcutter}>{XPLang("woodgather", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.woodcutter.gatherrate)}>{ValueSymbol("perk", config.woodcutter.gatherrate, "pos")}{RankBoosts(player, (xprecord.WoodCutter * config.woodcutter.gatherrate))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.woodcutter.bonusincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewoodcutter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.woodcutter}>Wood Bonus</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.woodcutter.bonusincrease)}>{ValueSymbol("perk", config.woodcutter.bonusincrease, "pos")}{RankBoosts(player, (xprecord.WoodCutter * config.woodcutter.bonusincrease))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.woodcutter.applechance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewoodcutter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.woodcutter}>{XPLang("woodapple", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.woodcutter.applechance)}>{ValueSymbol("perk", config.woodcutter.applechance, "pos")}{(xprecord.WoodCutter * config.woodcutter.applechance) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Smithy > 0 || config.defaultOptions.showunusedeffects) && config.smithy.maxlvl != 0)
            {
                if (config.smithy.productionrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.smithy}>{XPLang("productionrate", player.UserIDString)}</color>: (<color=yellow>{XPLang("productionamount", player.UserIDString)}</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Smithy)}>{ValueSymbol("perk", config.smithy.productionrate, "pos")}{RankBoosts(player, (xprecord.Smithy * config.smithy.productionrate)) * 100}%</color> (<color=yellow>+{ Math.Ceiling(RankBoosts(player, (xprecord.Smithy * config.smithy.productionrate) * 5))}</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.smithy.fuelconsumption != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.smithy}>{XPLang("fuelconsumption", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Smithy)}>{ValueSymbol("perk", config.smithy.fuelconsumption, "neg")}{RankBoosts(player, (xprecord.Smithy * config.smithy.fuelconsumption)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.smithy.metalchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.smithy}>{XPLang("hmetalchance", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Smithy)}>{ValueSymbol("perk", config.smithy.metalchance, "pos")}{RankBoosts(player, (xprecord.Smithy * config.smithy.metalchance)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.smithy.metalamount != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencesmithy, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.smithy}>{XPLang("hmetalamount", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Smithy)}>{ValueSymbol("perk", config.smithy.metalamount, "pos")}{RankBoosts(player, xprecord.Smithy * config.smithy.metalamount)}</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Miner > 0 || config.defaultOptions.showunusedeffects) && config.miner.maxlvl != 0)
            {
                if (config.miner.gatherrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("oregather", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.gatherrate, "pos")}{RankBoosts(player, (xprecord.Miner * config.miner.gatherrate))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.miner.bonusincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>Ore Bonus</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.bonusincrease, "pos")}{RankBoosts(player, (xprecord.Miner * config.miner.bonusincrease))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.miner.fuelconsumption != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("fuelconsumptionhats", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.fuelconsumption, "neg")}{RankBoosts(player, (xprecord.Miner * config.miner.fuelconsumption)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.miner.metalchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("metalchance", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.metalchance, "pos")}{RankBoosts(player, (xprecord.Miner * config.miner.metalchance)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.miner.metalamount != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("metalamount", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Miner)}>{ValueSymbol("perk", config.miner.metalamount, "pos")}{RankBoosts(player, xprecord.Miner * config.miner.metalamount)}</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (XPerienceAddon != null)
                {
                    double quarryboost = Convert.ToDouble(XPerienceAddon.Call("GetMinerSkill", player, "amount"));
                    if (quarryboost != 0)
                    {
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("quarryboost", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", xprecord.Miner)}>{ValueSymbol("perk", quarryboost, "pos")}{quarryboost * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowthree++;
                        int quarryduration = Convert.ToInt32(XPerienceAddon.Call("GetMinerSkill", player, "duration"));
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("quarryduration", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", xprecord.Miner)}>{(xprecord.Miner * quarryduration) / 60} mins</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowthree++;
                        int quarrycooldown = Convert.ToInt32(XPerienceAddon.Call("GetMinerSkill", player, "cooldown"));
                        FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceminer, rowthree, skillheight, skilliconleft, skilliconright));
                        FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.miner}>{XPLang("quarrycooldown", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", xprecord.Miner)}>{((xprecord.Miner * 60) - quarrycooldown) / 60} mins</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                        rowthree++;
                    }
                }
            }
            if ((xprecord.Forager > 0 || config.defaultOptions.showunusedeffects) && config.forager.maxlvl != 0)
            {
                if (config.forager.gatherrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceforager, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.forager}>Ground {XPLang("gather", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Forager)}>{ValueSymbol("perk", config.forager.gatherrate, "pos")}{RankBoosts(player, (xprecord.Forager * config.forager.gatherrate))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.forager.chanceincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceforager, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.forager}>{XPLang("seedbonus", player.UserIDString)}</color>: (<color=yellow>Amount</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", xprecord.Forager)}>{ValueSymbol("perk", config.forager.chanceincrease, "pos")}{(config.forager.chanceincrease * xprecord.Forager) * 100}%</color> (<color=yellow>{(config.forager.chanceincrease * xprecord.Forager) * 10}</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.forager.randomchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceforager, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.forager}>{XPLang("randomitem", player.UserIDString)} Chance</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Forager)}>{ValueSymbol("perk", config.forager.randomchance, "pos")}{RankBoosts(player, (xprecord.Forager * config.forager.randomchance)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Hunter > 0 || config.defaultOptions.showunusedeffects) && config.hunter.maxlvl != 0)
            {
                if (config.hunter.gatherrate != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.hunter}>{XPLang("foodgather", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Hunter)}>{ValueSymbol("perk", config.hunter.gatherrate, "pos")}{RankBoosts(player, (xprecord.Hunter * config.hunter.gatherrate))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.hunter.bonusincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.hunter}>Food Bonus</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Hunter)}>{ValueSymbol("perk", config.hunter.bonusincrease, "pos")}{RankBoosts(player, (xprecord.Hunter * config.hunter.bonusincrease))}x</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.hunter.damageincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.hunter}>{XPLang("damagewildlife", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Hunter)}>{ValueSymbol("perk", config.hunter.damageincrease, "pos")}{RankBoosts(player, (xprecord.Hunter * config.hunter.damageincrease)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.hunter.nightdmgincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencehunter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.hunter}>{XPLang("nightdamage", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", xprecord.Hunter)}>{ValueSymbol("perk", config.hunter.nightdmgincrease, "pos")}{RankBoosts(player, (xprecord.Hunter * config.hunter.nightdmgincrease)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Crafter > 0 || config.defaultOptions.showunusedeffects) && config.crafter.maxlvl != 0)
            {
                if (config.crafter.craftspeed != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>{XPLang("craftspeed", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.craftspeed)}>{ValueSymbol("perk", config.crafter.craftspeed, "neg")}{RankBoosts(player, (config.crafter.craftspeed * xprecord.Crafter)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.crafter.craftcost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>Craft {XPLang("costreduction", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.craftcost)}>{ValueSymbol("perk", config.crafter.craftcost, "neg")}{RankBoosts(player, (xprecord.Crafter * config.crafter.craftcost)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.crafter.repairincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>{XPLang("fullrepair", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.repairincrease)}>{RankBoosts(player, (xprecord.Crafter * config.crafter.repairincrease)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.crafter.repaircost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>{XPLang("repaircost", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.repaircost)}>{ValueSymbol("perk", config.crafter.repaircost, "neg")}{RankBoosts(player, (xprecord.Crafter * config.crafter.repaircost)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.crafter.conditionchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencecrafter, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.crafter}>{XPLang("highcond", player.UserIDString)}</color>: (<color=yellow>Amount</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.crafter.conditionchance)}>{ValueSymbol("perk", config.crafter.conditionchance, "pos")}{RankBoosts(player, (config.crafter.conditionchance * xprecord.Crafter)) * 100}%</color> (<color=yellow>+{config.crafter.conditionamount * 100}%</color>)", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Framer > 0 || config.defaultOptions.showunusedeffects) && config.framer.maxlvl != 0)
            {
                if (config.framer.upgradecost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceframer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.framer}>Building {XPLang("upgradecost", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.framer.upgradecost)}>{ValueSymbol("perk", config.framer.upgradecost, "neg")}{RankBoosts(player, (config.framer.upgradecost * xprecord.Framer)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.framer.repairtime != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceframer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.framer}>Building {XPLang("repairtime", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.framer.repairtime)}>{ValueSymbol("perk", config.framer.repairtime, "neg")}{(xprecord.Framer * config.framer.repairtime) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.framer.repaircost != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceframer, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.framer}>Building {XPLang("repaircost", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.framer.repaircost)}>{ValueSymbol("perk", config.framer.repaircost, "neg")}{RankBoosts(player, (xprecord.Framer * config.framer.repaircost)) * 100}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if ((xprecord.Fisher > 0 || config.defaultOptions.showunusedeffects) && config.fisher.maxlvl != 0)
            {
                if (config.fisher.fishamountincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.fisher}>{XPLang("fishamount", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.fisher.fishamountincrease)}>{ValueSymbol("perk", config.fisher.fishamountincrease, "pos")}{Math.Round(RankBoosts(player, xprecord.Fisher * config.fisher.fishamountincrease))}</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.fisher.itemamountincrease != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.fisher}>{XPLang("fishitems", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.fisher.itemamountincrease)}>{ValueSymbol("perk", config.fisher.itemamountincrease, "pos")}{Math.Round(RankBoosts(player, xprecord.Fisher * config.fisher.itemamountincrease))}</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.fisher.oxygenreduction != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.fisher}>{XPLang("fishoxygen", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.fisher.oxygenreduction)}>{ValueSymbol("perk", config.fisher.oxygenreduction, "neg")}{Math.Round((xprecord.Fisher * config.fisher.oxygenreduction) * 100)}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
                if (config.fisher.oxygentankreduction != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencefisher, rowthree, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.fisher}>{XPLang("fishoxygentank", player.UserIDString)}</color>:", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.fisher.oxygentankreduction)}>{ValueSymbol("perk", config.fisher.oxygentankreduction, "neg")}{Math.Round(RankBoosts(player, (xprecord.Fisher * config.fisher.oxygentankreduction)) * 100)}%</color>", rowthree, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthree++;
                }
            }
            if (rowthree >= 29)
            {
                skilliconleft = "0.80";
                skilliconright = "0.81";
                skilllabelleft = "0.815";
                skilllabelright = "0.945";
                skillvalueleft = "0.945";
                skillvalueright = "1";
            }
            else
            {
                rowthreenew = rowthree;
            }
            if ((xprecord.Medic > 0 || config.defaultOptions.showunusedeffects) && config.medic.maxlvl != 0)
            {
                if (config.medic.recoverhp != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.medic}>{XPLang("medicrevive", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.medic.recoverhp)}>{ValueSymbol("perk", config.medic.recoverhp, "pos")}{Math.Round(RankBoosts(player, xprecord.Medic * config.medic.recoverhp))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.medic.revivehp != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.medic}>{XPLang("medicrecover", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.medic.revivehp)}>{ValueSymbol("perk", config.medic.revivehp, "pos")}{Math.Round(RankBoosts(player, xprecord.Medic * config.medic.revivehp))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.medic.tools != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.medic}>{XPLang("medictools", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.medic.tools)}>{ValueSymbol("perk", config.medic.tools, "pos")}{Math.Round(RankBoosts(player, xprecord.Medic * config.medic.tools))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.medic.crafttime != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencemedic, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.medic}>{XPLang("mediccrafting", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, "perk", config.medic.crafttime)}>{ValueSymbol("perk", config.medic.crafttime, "pos")}{Math.Round((xprecord.Medic * config.medic.crafttime) * 100)}%</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
            }
            if ((xprecord.Scavenger > 0 || config.defaultOptions.showunusedeffects) && config.scavenger.maxlvl != 0)
            {
                if (config.scavenger.scavlootchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.scavenger}>{XPLang("scavchance", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.scavenger.scavlootchance)}>{ValueSymbol("perk", config.scavenger.scavlootchance, "pos")}{Math.Round(RankBoosts(player, (xprecord.Scavenger * config.scavenger.scavlootchance)) * 100)}%</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.scavenger.scavmultiplier != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.scavenger}>{XPLang("scavmultiplier", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.scavenger.scavmultiplier)}>x{Math.Ceiling(RankBoosts(player, xprecord.Scavenger * config.scavenger.scavmultiplier))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.scavenger.scavchance != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.scavenger}>{XPLang("customscavchance", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.scavenger.scavchance)}>{ValueSymbol("perk", config.scavenger.scavchance, "pos")}{Math.Round(RankBoosts(player, (xprecord.Scavenger * config.scavenger.scavchance)) * 100)}%</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (config.scavenger.customscavmultiplier != 0)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencescavenger, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={config.uitextColor.scavenger}>{XPLang("customscavmultiplier", player.UserIDString)}</color>:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    FullScreenelements.Add(XPUILabel($"<color={TextColor(player, $"{textcolor}", config.scavenger.customscavmultiplier)}>x{Math.Ceiling(RankBoosts(player, xprecord.Scavenger * config.scavenger.customscavmultiplier))}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skillvalueleft, skillvalueright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
            }
            // Taming Ability
            if (xprecord.Tamer > 0)
            {
                rowthreenew = 27;
                skilliconleft = "0.80";
                skilliconright = "0.81";
                skilllabelleft = "0.815";
                skilllabelright = "0.945";
                FullScreenelements.Add(XPUILabel($"Taming Abilities:", rowthreenew, skillheight, TextAnchor.MiddleLeft, 12, skilliconleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                rowthreenew++;
                if (xprecord.Tamer >= config.tamer.chickenlevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencechicken, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("chicken", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.boarlevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPerienceboar, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("boar", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.staglevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencestag, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("stag", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.wolflevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencewolf, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("wolf", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.bearlevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencebear, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("bear", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                    rowthreenew++;
                }
                if (xprecord.Tamer >= config.tamer.polarbearlevel)
                {
                    FullScreenelements.Add(XPUIImage(XPeriencePlayerControlFullInfo, XPeriencepolarbear, rowthreenew, skillheight, skilliconleft, skilliconright));
                    FullScreenelements.Add(XPUILabel($"<color=red>▫ </color> <color={TextColor(player, "pets", xprecord.Tamer)}>{XPLang("polarbear", player.UserIDString)}</color>", rowthreenew, skillheight, TextAnchor.MiddleLeft, 10, skilllabelleft, skilllabelright, "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                }
            }
            CuiHelper.AddUi(player, FullScreenelements);
        }
        // Kill Records
        private object GetKillRecords(string player, string entity)
        {
            if (KillRecords == null) return 0;
            object value = KillRecords.Call("GetKillRecord", player, entity);
            if (value == null) return 0;
            return (int)value;
        }
        private void PlayerKillRecordsPage(BasePlayer player, string selectedplayer)
        {
            if (player == null || selectedplayer == null) return;
            XPRecord xprecord = GetPlayerRecord(selectedplayer);
            var getplayer = selectedplayer;
            if (KillRecords == null || getplayer == null) return;
            float height = 0.036f;
            int row = 1;
            var FullScreenelements = new CuiElementContainer();
            // No Display if player search disabled
            if (!config.defaultOptions.allowplayersearch)
            {
                // Main UI
                FullScreenelements.Add(XPUIPanel("0.16 0.0", "1 1", "0 0 0 0.75"), XPeriencePlayerControlFullMain, XPeriencePlayerControlFullInfo);
                // Player Name
                FullScreenelements.Add(XPUILabel($"{xprecord.displayname}", row, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                row++;
                FullScreenelements.Add(XPUILabel($"{XPLang("playersearchdisabled", player.UserIDString)}", row, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullInfo);
                CuiHelper.AddUi(player, FullScreenelements);
                return;
            }
            // Continue with full profile
            // Main UI
            FullScreenelements.Add(XPUIPanel("0.16 0.0", "1 1", "0 0 0 0.75"), XPeriencePlayerControlFullMain, XPeriencePlayerControlFullKR);
            // Player Name
            FullScreenelements.Add(XPUILabel($"{xprecord.displayname} | ☠ {XPLang("killrecords", player.UserIDString)}", row, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            row++;
            // Kill Records
            FullScreenelements.Add(XPUILabel($"Kills:", row, height, TextAnchor.MiddleLeft, 15, "0.01", "25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Chickens:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "chicken"))}>{GetKillRecords(getplayer, "chicken")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Boars:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "boar"))}>{GetKillRecords(getplayer, "boar")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Stags:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "stag"))}>{GetKillRecords(getplayer, "stag")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Wolves:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "wolf"))}>{GetKillRecords(getplayer, "wolf")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Bears:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "bear"))}>{GetKillRecords(getplayer, "bear")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Polar Bears:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "polarbear"))}>{GetKillRecords(getplayer, "polarbear")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Sharks:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "shark"))}>{GetKillRecords(getplayer, "shark")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Horses:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "horse"))}>{GetKillRecords(getplayer, "horse")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Fish:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "fish"))}>{GetKillRecords(getplayer, "fish")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Scientist:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "scientistnpcnew"))}>{GetKillRecords(getplayer, "scientistnpcnew")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Scare Crow:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "scarecrow"))}>{GetKillRecords(getplayer, "scarecrow")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Dwellers:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "tunneldweller"))}>{GetKillRecords(getplayer, "tunneldweller")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Players:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "baseplayer"))}>{GetKillRecords(getplayer, "baseplayer")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Bradley APCs:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "bradleyapc"))}>{GetKillRecords(getplayer, "bradleyapc")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Patrol Helicopters:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "patrolhelicopter"))}>{GetKillRecords(getplayer, "patrolhelicopter")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Turret:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "turret"))}>{GetKillRecords(getplayer, "turret")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            row++;
            FullScreenelements.Add(XPUILabel($"Deaths:", row, height, TextAnchor.MiddleLeft, 15, "0.01", "25", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Deaths:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "death"))}>{GetKillRecords(getplayer, "death")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            row++;
            FullScreenelements.Add(XPUILabel($"Suicides:", row, height, TextAnchor.MiddleLeft, 13, "0.01", "15", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "suicide"))}>{GetKillRecords(getplayer, "suicide")}</color>", row, height, TextAnchor.MiddleLeft, 13, "0.15", "20", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            // Column Two
            int rowtwo = 3;
            FullScreenelements.Add(XPUILabel($"Harvests:", rowtwo, height, TextAnchor.MiddleLeft, 15, "0.26", "50", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Animal Harvested:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "basecorpse"))}>{GetKillRecords(getplayer, "basecorpse")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Corpse Harvested:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "npcplayercorpse"))}>{GetKillRecords(getplayer, "npcplayercorpse")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Trees:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "trees"))}>{GetKillRecords(getplayer, "trees")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Ore Mined:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "oremined"))}>{GetKillRecords(getplayer, "oremined")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Wood Picked Up:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "wood"))}>{GetKillRecords(getplayer, "wood")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Ore Picked Up:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "orepickup"))}>{GetKillRecords(getplayer, "orepickup")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Berries:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "berries"))}>{GetKillRecords(getplayer, "berries")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Seeds:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "seed"))}>{GetKillRecords(getplayer, "seed")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Hemp:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "hemp"))}>{GetKillRecords(getplayer, "hemp")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Potatos:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "potato"))}>{GetKillRecords(getplayer, "potato")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Pumpkin:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "pumpkin"))}>{GetKillRecords(getplayer, "pumpkin")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Mushroom:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "mushroom"))}>{GetKillRecords(getplayer, "mushroom")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Corn:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "corn"))}>{GetKillRecords(getplayer, "corn")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Loots:", rowtwo, height, TextAnchor.MiddleLeft, 15, "0.26", "50", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Loot Containers:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "lootcontainer"))}>{GetKillRecords(getplayer, "lootcontainer")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Underwater Containers:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "underwaterlootcontainer"))}>{GetKillRecords(getplayer, "underwaterlootcontainer")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Brad/Heli Crates:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "lockedbyentcrate"))}>{GetKillRecords(getplayer, "lockedbyentcrate")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            rowtwo++;
            FullScreenelements.Add(XPUILabel($"Hackable Crates:", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.26", "40", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            FullScreenelements.Add(XPUILabel($"|  <color={TextColor(player, "level", (int)GetKillRecords(getplayer, "hackablelockedcrate"))}>{GetKillRecords(getplayer, "hackablelockedcrate")}</color>", rowtwo, height, TextAnchor.MiddleLeft, 13, "0.40", "45", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullKR);
            CuiHelper.AddUi(player, FullScreenelements);
        }
        // Help Panel
        private void PlayerHelpPage(BasePlayer player, int page)
        {
            if (player == null) return;
            float height = 0.5f;
            var FullScreenelements = new CuiElementContainer();
            // Main UI
            FullScreenelements.Add(XPUIPanel("0.16 0", "1 1", "0 0 0 0.75"), XPeriencePlayerControlFullMain, XPeriencePlayerControlFullHelp);
            // Navigation Buttons
            string selected0 = "1 1 1 1";
            string selected1 = "1 1 1 1";
            string selected2 = "1 1 1 1";
            string selected3 = "1 1 1 1";
            string selected4 = "1 1 1 1";
            string selected5 = "1 1 1 1";
            switch (page)
            {
                case 0:
                    selected0 = "0 1 0 1";
                    break;
                case 1:
                    selected1 = "0 1 0 1";
                    break;
                case 2:
                    selected2 = "0 1 0 1";
                    break;
                case 3:
                    selected3 = "0 1 0 1";
                    break;
                case 4:
                    selected4 = "0 1 0 1";
                    break;
                case 5:
                    selected5 = "0 1 0 1";
                    break;
            }
            FullScreenelements.Add(XPUIPanel("0.20 0.95", "0.80 1", "0 0 0 0.75"), XPeriencePlayerControlFullHelp, XPeriencePlayerControlFullHelpNav);
            FullScreenelements.Add(XPUILabel($"〚 Help Page Navigation 〛", 1, height, TextAnchor.MiddleCenter, 15, "0", "1", "1.0 1.0 1.0 1.0"), XPeriencePlayerControlFullHelpNav);
            FullScreenelements.Add(XPUIButton($"xp.playeredits help 0", 2, height, 13, "0 0 0 0", "〘 About 〙", "0.01", "0.16", TextAnchor.MiddleCenter, $"{selected0}"), XPeriencePlayerControlFullHelpNav);
            FullScreenelements.Add(XPUIButton($"xp.playeredits help 1", 2, height, 13, "0 0 0 0", "〘 Commands 〙", "0.17", "0.32", TextAnchor.MiddleCenter, $"{selected1}"), XPeriencePlayerControlFullHelpNav);
            FullScreenelements.Add(XPUIButton($"xp.playeredits help 2", 2, height, 13, "0 0 0 0", "〘 Stats 〙", "0.33", "0.48", TextAnchor.MiddleCenter, $"{selected2}"), XPeriencePlayerControlFullHelpNav);
            FullScreenelements.Add(XPUIButton($"xp.playeredits help 3", 2, height, 13, "0 0 0 0", "〘 Skills 〙", "0.49", "0.64", TextAnchor.MiddleCenter, $"{selected3}"), XPeriencePlayerControlFullHelpNav);
            FullScreenelements.Add(XPUIButton($"xp.playeredits help 4", 2, height, 13, "0 0 0 0", "〘 Server 〙", "0.65", "0.78", TextAnchor.MiddleCenter, $"{selected4}"), XPeriencePlayerControlFullHelpNav);
            FullScreenelements.Add(XPUIButton($"xp.playeredits help 5", 2, height, 13, "0 0 0 0", "〘 Steam Privacy 〙", "0.79", "0.99", TextAnchor.MiddleCenter, $"{selected5}"), XPeriencePlayerControlFullHelpNav);
            // Pages
            if(page == 0)
            {
                FullScreenelements.Add(new CuiElement
                {
                    Parent = XPeriencePlayerControlFullHelp,
                    Components =
                {
                    new CuiRawImageComponent
                    {
                        Png = ImageLibrary?.Call<string>("GetImage", XPeriencelogo)
                    },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = "0.43 0.60",
                        AnchorMax = "0.57 0.80"
                    }
                }
                });
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("moddetails", player.UserIDString)} MACHIN3{XPLang("aboutxperience", player.UserIDString)}",
                    FontSize = 18,
                    Align = TextAnchor.UpperCenter,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.0",
                    AnchorMax = "0.98 0.60"
                }
                }, XPeriencePlayerControlFullHelp);
            }
            if(page == 1)
            {
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("helpcommandslist", player.UserIDString, config.playerchatCommands.openhelp, config.playerchatCommands.openplayerstats, config.playerchatCommands.showplayerstatschat, config.playerchatCommands.opentopplayers, config.playerchatCommands.playeraddstat, config.playerchatCommands.playeraddskill, config.playerchatCommands.playerresetstats, config.playerchatCommands.playerresetskills, config.playerchatCommands.playerliveuichange)} \n{XPLang("bindkey", player.UserIDString, config.playerchatCommands.openplayerstats)}",
                    FontSize = 11,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.0",
                    AnchorMax = "0.98 0.83"
                }
                }, XPeriencePlayerControlFullHelp);
            }
            if(page == 2)
            {
                // About Stats
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutstats", player.UserIDString)}\n-----------------------------------------------------------------------------------------------------------------------\n\n",
                    FontSize = 15,
                    Align = TextAnchor.UpperCenter,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.85",
                    AnchorMax = "0.99 0.93"
                }
                }, XPeriencePlayerControlFullHelp);
                // Mentality
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("mentality", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.82",
                    AnchorMax = "0.98 0.85"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutmentality", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.70",
                    AnchorMax = "0.98 0.82"
                }
                }, XPeriencePlayerControlFullHelp);
                // Dexterity
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("dexterity", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.67",
                    AnchorMax = "0.98 0.70"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutdexterity", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.55",
                    AnchorMax = "0.98 0.67"
                }
                }, XPeriencePlayerControlFullHelp);
                // Might
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("might", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.52",
                    AnchorMax = "0.98 0.55"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutmight", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.40",
                    AnchorMax = "0.98 0.52"
                }
                }, XPeriencePlayerControlFullHelp);
                // Captaincy
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("captaincy", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.37",
                    AnchorMax = "0.98 0.40"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutcaptaincy", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.29",
                    AnchorMax = "0.98 0.37"
                }
                }, XPeriencePlayerControlFullHelp);
                // Weaponry
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("weaponry", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.24",
                    AnchorMax = "0.98 0.27"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutweaponry", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.01",
                    AnchorMax = "0.98 0.24"
                }
                }, XPeriencePlayerControlFullHelp);
            }
            if(page == 3)
            {
                // About Skills
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutskills", player.UserIDString)}\n-----------------------------------------------------------------------------------------------------------------------\n\n",
                    FontSize = 15,
                    Align = TextAnchor.UpperCenter,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.85",
                    AnchorMax = "0.98 0.93"
                }
                }, XPeriencePlayerControlFullHelp);
                // WoodCutter
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("woodcutter", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.82",
                    AnchorMax = "0.98 0.85"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutwoodcutter", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.78",
                    AnchorMax = "0.98 0.82"
                }
                }, XPeriencePlayerControlFullHelp);
                // Smithy
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("smithy", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.75",
                    AnchorMax = "0.98 0.78"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutsmithy", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.71",
                    AnchorMax = "0.98 0.75"
                }
                }, XPeriencePlayerControlFullHelp);
                // Miner
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("miner", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.68",
                    AnchorMax = "0.98 0.71"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutminer", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.64",
                    AnchorMax = "0.98 0.68"
                }
                }, XPeriencePlayerControlFullHelp);
                // Forager
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("forager", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.61",
                    AnchorMax = "0.98 0.64"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutforager", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.55",
                    AnchorMax = "0.98 0.61"
                }
                }, XPeriencePlayerControlFullHelp);
                // Hunter
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("hunter", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.52",
                    AnchorMax = "0.98 0.55"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("abouthunter", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.48",
                    AnchorMax = "0.98 0.52"
                }
                }, XPeriencePlayerControlFullHelp);
                // Fisher
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("fisher", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.45",
                    AnchorMax = "0.98 0.48"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutfisher", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.41",
                    AnchorMax = "0.98 0.45"
                }
                }, XPeriencePlayerControlFullHelp);
                // Crafter
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("crafter", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.38",
                    AnchorMax = "0.98 0.41"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutcrafter", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.34",
                    AnchorMax = "0.98 0.38"
                }
                }, XPeriencePlayerControlFullHelp);
                // Framer
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("framer", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.31",
                    AnchorMax = "0.98 0.34"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutframer", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.28",
                    AnchorMax = "0.98 0.31"
                }
                }, XPeriencePlayerControlFullHelp);
                // Medic
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("medic", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.25",
                    AnchorMax = "0.75 0.28"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutmedic", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.22",
                    AnchorMax = "0.98 0.25"
                }
                }, XPeriencePlayerControlFullHelp);
                // Scavenger
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("scavenger", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.19",
                    AnchorMax = "0.75 0.22"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("aboutscavenger", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.15",
                    AnchorMax = "0.98 0.19"
                }
                }, XPeriencePlayerControlFullHelp);
                // Tamer
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"[{XPLang("tamer", player.UserIDString)}]",
                    FontSize = 15,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.12",
                    AnchorMax = "0.98 0.15"
                }
                }, XPeriencePlayerControlFullHelp);
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("abouttamer", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.08",
                    AnchorMax = "0.75 0.12"
                }
                }, XPeriencePlayerControlFullHelp);
            }
            if(page == 4)
            {
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("serversettings", player.UserIDString, ServerSettings("levelstart"), ServerSettings("levelmultiplier"), ServerSettings("levelxpboost"), ServerSettings("statpointsperlvl"), ServerSettings("skillpointsperlvl"), ServerSettings("resettimerenabled"), ServerSettings("resettimerstats"), ServerSettings("resettimerskills"), ServerSettings("vipresettimerstats"), ServerSettings("vipresettimerskills"), ServerSettings("nightbonusenable"), ServerSettings("nightbonus"), ServerSettings("nightstart"), ServerSettings("nightend"), ServerSettings("nightskill"))}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.50",
                    AnchorMax = "0.99 0.80"
                }
                }, XPeriencePlayerControlFullHelp);

                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("xpsettings", player.UserIDString)}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.46",
                    AnchorMax = "0.99 0.50"
                }
                }, XPeriencePlayerControlFullHelp);

                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("xpsettingskills", player.UserIDString, ServerSettings("chicken"), ServerSettings("fish"), ServerSettings("boar"), ServerSettings("stag"), ServerSettings("wolf"), ServerSettings("bear"), ServerSettings("shark"), ServerSettings("horse"), ServerSettings("scientist"), ServerSettings("dweller"), ServerSettings("player"), ServerSettings("bradley"), ServerSettings("heli"), ServerSettings("revive"))}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.0",
                    AnchorMax = "0.15 0.46"
                }
                }, XPeriencePlayerControlFullHelp);

                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("xpsettingsloot", player.UserIDString, ServerSettings("loot"), ServerSettings("uloot"), ServerSettings("lloot"), ServerSettings("hloot"), ServerSettings("aharvest"), ServerSettings("charvest"), ServerSettings("tree"), ServerSettings("ore"), ServerSettings("gather"), ServerSettings("plant"))}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.16 0.0",
                    AnchorMax = "0.37 0.46"
                }
                }, XPeriencePlayerControlFullHelp);

                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("xpsettingscraft", player.UserIDString, ServerSettings("craft"), ServerSettings("wood"), ServerSettings("stone"), ServerSettings("metal"), ServerSettings("armored"))}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.38 0.0",
                    AnchorMax = "0.55 0.46"
                }
                }, XPeriencePlayerControlFullHelp);

                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("xpmissionsettings", player.UserIDString, ServerSettings("missionsucceed"), ServerSettings("missionfailed"), ServerSettings("missionfailedxp"))}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.56 0.0",
                    AnchorMax = "0.80 0.46"
                }
                }, XPeriencePlayerControlFullHelp);

                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"{XPLang("xpreductionsettings", player.UserIDString, ServerSettings("death"), ServerSettings("deathenable"), ServerSettings("suicide"), ServerSettings("suicideenable"))}",
                    FontSize = 12,
                    Align = TextAnchor.UpperLeft,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.81 0.0",
                    AnchorMax = "0.99 0.46"
                }
                }, XPeriencePlayerControlFullHelp);
            }
            if(page == 5)
            {
                FullScreenelements.Add(new CuiLabel
                {
                    Text =
                {
                    Text = $"Steam allows public viewing of all player data through Steamworks API as stated in their Steam Privacy Policy Agreement section 5.5\n https://store.steampowered.com/privacy_agreement/ \n\n 5.5 We make certain data related to your Steam User Account available to other players and our partners through the Steamworks API.This information can be accessed by anyone by querying your Steam ID.At a minimum, the public persona name you have chosen to represent you on Steam and your Avatar picture are accessible this way, as well as whether you have received a ban for cheating in a multiplayer game.The accessibility of any additional info about you can be controlled through your Steam Community user profile page; data publicly available on your profile page can be accessed automatically through the Steamworks API.In addition to the publicly available information, game developers and publishers have access to certain information from the Steamworks API directly relating to the users of the games they operate.This information includes as a minimum your ownership of the game in question.Depending on which Steamworks services are implemented in the game it may also include leaderboard information, your progress in the game, achievements you have completed, your multiplayer game matchmaking information, in-game items and other information needed to operate the game and provide support for it.For more information on what Steamworks services a specific game has implemented, please review its store page.While we do not knowingly share Personally Identifying Information about you through the Steamworks API such as your real name or your email address, any information you share about yourself on your public Steam Profile can be accessed through the Steamworks API, including information that may make you identifiable.",
                    FontSize = 18,
                    Align = TextAnchor.UpperCenter,
                    Color = "1.0 1.0 1.0 1.0"
                },
                    RectTransform =
                {
                    AnchorMin = "0.02 0.0",
                    AnchorMax = "0.98 0.80"
                }
                }, XPeriencePlayerControlFullHelp);
            }

            CuiHelper.AddUi(player, FullScreenelements);
        }
        #endregion

        #region Top Player Panel
        private IEnumerable<XPRecord> GetTopXP(int page, int takeCount, string selection)
        {
            IEnumerable<XPRecord> data = null;
            switch (selection)
            {
                case "rank":
                    data = _xperienceCache.Values.OrderByDescending(i => i.trueexperience);
                    break;
                case "level":
                    data = _xperienceCache.Values.OrderByDescending(i => i.truelevel);
                    break;
                case "experience":
                    data = _xperienceCache.Values.OrderByDescending(i => i.trueexperience);
                    break;
                case "mentality":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Mentality);
                    break;
                case "dexterity":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Dexterity);
                    break;
                case "might":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Might);
                    break;
                case "captaincy":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Captaincy);
                    break;
                case "weaponry":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Weaponry);
                    break;
                case "woodcutter":
                    data = _xperienceCache.Values.OrderByDescending(i => i.WoodCutter);
                    break;
                case "smithy":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Smithy);
                    break;
                case "miner":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Miner);
                    break;
                case "forager":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Forager);
                    break;
                case "hunter":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Hunter);
                    break;
                case "fisher":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Fisher);
                    break;
                case "crafter":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Crafter);
                    break;
                case "framer":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Framer);
                    break;
                case "medic":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Medic);
                    break;
                case "scavenger":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Scavenger);
                    break;
                case "tamer":
                    data = _xperienceCache.Values.OrderByDescending(i => i.Tamer);
                    break;
            }
            return data?
            .Skip((page - 1) * takeCount)
            .Take(takeCount);
        }
        [ConsoleCommand("xp.player")]
        private void Cmdplayerxpui(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            var info = arg.GetString(0);
            DestroyUi(player, XPerienceTopMain);
            SelectedPlayerPanelFullMain(player, info);
            SelectedPlayerInfoPage(player, info);
        }
        [ConsoleCommand("xp.topplayers")]
        private void Cmdtopplayernew(ConsoleSystem.Arg arg)
        {
            var player = arg.Player();
            if (player == null) return;
            int page = arg.GetInt(0);
            string type = arg.GetString(1);
            string selection = arg.GetString(2);
            int number = arg.GetInt(3);
            switch(type)
            {
                case "levels":
                    DestroyUi(player, XPerienceTopInner);
                    TopLevels(player, page, selection, number);
                    break;
                case "stats":
                    DestroyUi(player, XPerienceTopInner);
                    TopStats(player, page, selection, number);
                    break;
                case "close":
                    DestroyUi(player, XPerienceTopMain);
                    break;
            }
        }
        private void TopPlayerPanelFullMain(BasePlayer player, string selection)
        {
            if (player == null) return;
            var FullScreenelements = new CuiElementContainer();
            //var getplayer = FindPlayer(selectedplayer);
            var height = 0.050f;
            var buttonheight = 0.036f;
            // Main UI | Title | Icon
            FullScreenelements.Add(new CuiPanel
            {
                Image =
                {
                    Color = "0.1 0.1 0.1 0.99"
                },
                RectTransform =
                {
                    AnchorMin = $"0 0",
                    AnchorMax = $"1 1"
                },
                CursorEnabled = true
            }, "Overlay", XPerienceTopMain);
            FullScreenelements.Add(XPUILabel($"ⓍⓅerience", 1, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.18", "1.0 1.0 1.0 1.0"), XPerienceTopMain);
            FullScreenelements.Add(new CuiElement
            {
                Parent = XPerienceTopMain,
                Components =
                {
                    new CuiRawImageComponent
                    {
                        Png = ImageLibrary?.Call<string>("GetImage", XPerienceicon)
                    },
                    new CuiRectTransformComponent
                    {
                        AnchorMin = "0.01 0.75",
                        AnchorMax = "0.15 0.95"
                    }
                }
            });
            // Spacer
            double row = 4;
            // Navigation Menu
            FullScreenelements.Add(XPUIPanel("0.0 0.0", "0.15 0.85", "1.0 1.0 1.0 0.0"), XPerienceTopMain, XPerienceTopSelection);
            //Current Player Button
            FullScreenelements.Add(XPUIButton("xp.playercontrol main", row, height, 18, "0.0 0.0 0.0 0.7", $"{XPLang("adminmenu_014", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            double pagerow = 7;
            double spacing = 0.2;
            //Page Buttons
            if (config.xpLevelRanks.enableresetranks)
            {
                FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats rank 0", pagerow, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("rank", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
                pagerow++;
            }
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 levels level 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("level", player.UserIDString)} / XP", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats mentality 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("mentality", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats dexterity 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("dexterity", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection); ;
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats might 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("might", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats captaincy 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("captaincy", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats weaponry 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("weaponry", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats woodcutter 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("woodcutter", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats smithy 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("smithy", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats miner 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("miner", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats forager 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("forager", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats hunter 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("hunter", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats crafter 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("crafter", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats framer 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("framer", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats fisher 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("fisher", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats medic 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("medic", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats scavenger 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("scavenger", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            if (config.tamer.enabletame)
            {
                pagerow++;
                spacing += 0.2;
                FullScreenelements.Add(XPUIButton("xp.topplayers 1 stats tamer 0", pagerow + spacing, buttonheight, 15, "0.0 0.0 0.0 0.7", $"{XPLang("tamer", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            }
            // Close Button            
            pagerow++;
            spacing += 0.2;
            FullScreenelements.Add(XPUIButton("xp.topplayers 0 close", pagerow + spacing, buttonheight, 18, "0.0 0.0 0.0 0.7", $"{XPLang("adminmenu_009", player.UserIDString)}", "0.03", "1", TextAnchor.MiddleCenter), XPerienceTopSelection);
            // UI End
            CuiHelper.AddUi(player, FullScreenelements);
            return;
        }
        private void TopLevels(BasePlayer player, int page, string selection, int number)
        {
            if (player == null) return;
            if (selection == null) { selection = "level"; }
            var FullScreenelements = new CuiElementContainer();
            var height = 0.04f;
            int maxplayers = config.defaultOptions.topplayersperpage;
            if (maxplayers > 40)
            {
                maxplayers = 40;
            }
            var vals = GetTopXP(page, maxplayers, "experience");
            if (vals == null) { return; }
            var index = 0;
            int row = 3;
            int rowtwo = 3;
            int start = number;
            FullScreenelements.Add(XPUIPanel("0.16 0.0", "1 1", "0 0 0 0.75"), XPerienceTopMain, XPerienceTopInner);
            FullScreenelements.Add(XPUILabel($"{XPLang("topplayers", player.UserIDString)}: 〘{XPLang(selection, player.UserIDString)} / XP〙", 1, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
            FullScreenelements.Add(XPUILabel($"Player", row, height, TextAnchor.MiddleLeft, 20, "0.03", "0.30", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
            FullScreenelements.Add(XPUILabel($"{XPLang(selection, player.UserIDString)}", row, height, TextAnchor.MiddleLeft, 20, "0.30", "0.35", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
            FullScreenelements.Add(XPUILabel($"XP", row, height, TextAnchor.MiddleRight, 20, "0.35", "0.45", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
            if (maxplayers > 20)
            {
                FullScreenelements.Add(XPUILabel($"Player", row, height, TextAnchor.MiddleLeft, 20, "0.52", "0.79", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
                FullScreenelements.Add(XPUILabel($"{XPLang(selection, player.UserIDString)}", row, height, TextAnchor.MiddleLeft, 20, "0.79", "0.84", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
                FullScreenelements.Add(XPUILabel($"XP", row, height, TextAnchor.MiddleRight, 20, "0.84", "0.95", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
            }
            row++;
            rowtwo++;
            int totalrows = row + maxplayers;
            for (row = 4; row < totalrows; row++)
            {
                if (vals.ElementAtOrDefault(index) == null)
                {
                    continue;
                }
                var playerdata = vals.ElementAtOrDefault(index);
                if (playerdata == null) continue;
                Ranks rank = GetXPRank(playerdata.rank);
                if (playerdata.level > 0)
                {
                    number++;
                    if (row < 24)
                    {
                        if (playerdata.displayname == player.displayName)
                        {
                            FullScreenelements.Add(XPUILabel(("➤"), row, height, TextAnchor.MiddleLeft, 15, "0.01", "0.03", "1 0.92 0.016 1"), XPerienceTopInner);
                        }
                        else
                        {
                            if (config.defaultOptions.showonlinestatus)
                            {
                                if (playerdata.Status)
                                {
                                    FullScreenelements.Add(XPUIImage(XPerienceTopInner, XPerienceonline, row, height, "0.01", "0.02"));
                                }
                                else
                                {
                                    FullScreenelements.Add(XPUIImage(XPerienceTopInner, XPerienceoffline, row, height, "0.01", "0.02"));
                                }
                            }
                        }
                        FullScreenelements.Add(XPUIButton($"xp.player {playerdata.id}", row, height, 15, "0 0 0 0", $"{number}. <color={TextColor(player, "rankname", playerdata.rank)}>{rank.sig}</color>{playerdata.displayname}", "0.03", "0.30"), XPerienceTopInner);
                        FullScreenelements.Add(XPUILabel($"{playerdata.truelevel}", row, height, TextAnchor.MiddleCenter, 15, "0.30", "0.35", "1 1 1 1"), XPerienceTopInner);
                        FullScreenelements.Add(XPUILabel($"{playerdata.trueexperience}", row, height, TextAnchor.MiddleRight, 15, "0.35", "0.45", "1 1 1 1"), XPerienceTopInner);
                    }
                    else
                    {   
                        if (playerdata.displayname == player.displayName)
                        {
                            FullScreenelements.Add(XPUILabel(("➤"), rowtwo, height, TextAnchor.MiddleLeft, 15, "0.50", "0.52", "1 0.92 0.016 1"), XPerienceTopInner);
                        }
                        else
                        {
                            if (config.defaultOptions.showonlinestatus)
                            {
                                if (playerdata.Status)
                                {
                                    FullScreenelements.Add(XPUIImage(XPerienceTopInner, XPerienceonline, rowtwo, height, "0.50", "0.51"));
                                }
                                else
                                {
                                    FullScreenelements.Add(XPUIImage(XPerienceTopInner, XPerienceoffline, rowtwo, height, "0.50", "0.51"));
                                }
                            }
                        }
                        FullScreenelements.Add(XPUIButton($"xp.player {playerdata.id}", rowtwo, height, 15, "0 0 0 0", $"{number}. <color={TextColor(player, "rankname", playerdata.rank)}>{rank.sig}</color>{playerdata.displayname}", "0.52", "0.79"), XPerienceTopInner);
                        FullScreenelements.Add(XPUILabel($"{playerdata.truelevel}", rowtwo, height, TextAnchor.MiddleLeft, 15, "0.79", "0.84", "1 1 1 1"), XPerienceTopInner);
                        FullScreenelements.Add(XPUILabel($"{playerdata.trueexperience}", rowtwo, height, TextAnchor.MiddleRight, 15, "0.84", "0.95", "1 1 1 1"), XPerienceTopInner);
                        rowtwo++;
                    }
                }
                index++;
            }
            // Page Selection
            FullScreenelements.Add(XPUIPanel("0 0.02", "1 0.05", "0 0 0 0"), XPerienceTopInner, XPerienceTopPageSelection);
            if (page > 1)
            {
                FullScreenelements.Add(XPUIButton($"xp.topplayers {page - 1} levels {selection} {start - config.defaultOptions.topplayersperpage}", 1, 1f, 18, "0 0 0 1", "⋘ Prev", "0.03", "0.13", TextAnchor.MiddleCenter), XPerienceTopPageSelection);
            }
            int totalplayers = start + maxplayers;
            if (number >= totalplayers)
            {
                FullScreenelements.Add(XPUIButton($"xp.topplayers {page + 1} levels {selection} {number}", 1, 1f, 18, "0 0 0 1", "Next ⋙", "0.23", "0.33", TextAnchor.MiddleCenter), XPerienceTopPageSelection);
            }
            CuiHelper.AddUi(player, FullScreenelements);
        }
        private void TopStats(BasePlayer player, int page, string selection, int number)
        {
            if (player == null) return;
            if (selection == null) { selection = "mentality"; }
            var FullScreenelements = new CuiElementContainer();
            var height = 0.04f;
            int maxplayers = config.defaultOptions.topplayersperpage;
            if (maxplayers > 40)
            {
                maxplayers = 40;
            }
            var vals = GetTopXP(page, maxplayers, selection);
            if (vals == null) { return; }
            var index = 0;
            int row = 3;
            int rowtwo = 3;
            int start = number;
            FullScreenelements.Add(XPUIPanel("0.16 0.0", "1 1", "0 0 0 0.75"), XPerienceTopMain, XPerienceTopInner);
            FullScreenelements.Add(XPUILabel($"{XPLang("topplayers", player.UserIDString)}: 〘{XPLang(selection, player.UserIDString)}〙", 1, 0.060f, TextAnchor.MiddleLeft, 20, "0.01", "0.99", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
            FullScreenelements.Add(XPUILabel($"Player", row, height, TextAnchor.MiddleLeft, 20, "0.03", "0.35", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
            FullScreenelements.Add(XPUILabel($"{XPLang(selection, player.UserIDString)}", row, height, TextAnchor.MiddleRight, 20, "0.35", "0.45", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
            if (maxplayers > 20)
            {
                FullScreenelements.Add(XPUILabel($"Player", row, height, TextAnchor.MiddleLeft, 20, "0.52", "0.84", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
                FullScreenelements.Add(XPUILabel($"{XPLang(selection, player.UserIDString)}", row, height, TextAnchor.MiddleRight, 20, "0.84", "0.95", "1.0 1.0 1.0 1.0"), XPerienceTopInner);
            }
            row++;
            rowtwo++;
            int totalrows = row + maxplayers;
            for (row = 4; row < totalrows; row++)
            {
                if (vals.ElementAtOrDefault(index) == null)
                {
                    continue;
                }
                var playerdata = vals.ElementAtOrDefault(index);
                if (playerdata == null) continue;
                Ranks rank = GetXPRank(playerdata.rank);
                var playerdatatype = playerdata.Mentality;
                switch (selection)
                {
                    case "rank":
                        playerdatatype = playerdata.rank;
                        break;
                    case "mentality":
                        playerdatatype = playerdata.Mentality;
                        break;
                    case "dexterity":
                        playerdatatype = playerdata.Dexterity;
                        break;
                    case "might":
                        playerdatatype = playerdata.Might;
                        break;
                    case "captaincy":
                        playerdatatype = playerdata.Captaincy;
                        break;
                    case "weaponry":
                        playerdatatype = playerdata.Weaponry;
                        break;
                    case "woodcutter":
                        playerdatatype = playerdata.WoodCutter;
                        break;
                    case "smithy":
                        playerdatatype = playerdata.Smithy;
                        break;
                    case "miner":
                        playerdatatype = playerdata.Miner;
                        break;
                    case "forager":
                        playerdatatype = playerdata.Forager;
                        break;
                    case "hunter":
                        playerdatatype = playerdata.Hunter;
                        break;
                    case "fisher":
                        playerdatatype = playerdata.Fisher;
    