using UnityEngine;
using System.Collections.Generic;
using Oxide.Game.Rust.Cui;
using System;
using Newtonsoft.Json;
using Oxide.Core.Plugins;
using Oxide.Core;

namespace Oxide.Plugins
{
	[Info("ZBoxesUI", "ZH3LL", "3.2.2")]
	[Description("Z Boxes UI")]
	internal class ZBoxesUI : RustPlugin
	{	
		[PluginReference]
		private Plugin ZBoxesPack, FridgeFarmZ, Economics, ServerRewards, RecyclerBox, MiningQuarryBox, ResearcHBox, RepairBox, FurnaceBox, DroppedItemBoxCollectorZ;

		private PluginConfig _ZBoxesUI { get; set;}		
		protected override void SaveConfig() => Config.WriteObject(_ZBoxesUI);		
		private void OnPlayerDisconnected(BasePlayer player)
		{
			CuiHelper.DestroyUi(player, "ZbUi");
			CuiHelper.DestroyUi(player, "ZbUih");	
		}
		private void OnPlayerRespawned(BasePlayer player)
		{
			CuiHelper.DestroyUi(player, "ZbUi");
			CuiHelper.DestroyUi(player, "ZbUih");	
		}
		private void OnLootEntityEnd(BasePlayer player, BaseCombatEntity entity)
		{
			CuiHelper.DestroyUi(player, "ZbUi");
			CuiHelper.DestroyUi(player, "ZbUih");	
		}
		
		private void OnServerInitialized()
		{		

			NextTick(() =>
			{			
			if(ZBoxesPack != null)
			{
			Puts("Duplicated plugin: ZBoxesUI.cs found in ZBoxesPack! Unload ZBoxesUI");
			Server.Command("o.unload ZBoxesUI");			
			}		
			});
			
			permission.RegisterPermission("ZBoxesUI.CanUse", this);
			permission.RegisterPermission("ZBoxesUI.FreeBuy", this);
			
		if(_ZBoxesUI.BoxtypeZBUICost == 2 && !Economics){Puts("Economics plugin missing!"); rust.RunServerCommand("o.unload ZBoxesUI");}
		if(_ZBoxesUI.BoxtypeZBUICost == 3 && !ServerRewards){Puts("ServerRewards plugin missing!"); rust.RunServerCommand("o.unload ZBoxesUI");}			
		}
		
		void OnLootEntity(BasePlayer player, BaseEntity entity)
		{
			if(player == null || entity == null){return;}
			if(!player.userID.IsSteamId()){return;}			
			if(entity.skinID == 3084640228 || entity.skinID == 3137708597 || entity.skinID == 3144201633 || entity.skinID == 3247770012 || entity.skinID == 3171493217 || entity.skinID == 3299450471 || entity.skinID == 3252660967)
			{
			if(_ZBoxesUI.BoxtypeSELL > 0)
			ZBOXuiOPEN(player, entity, false, 0, true);
			}
			else
			{
			
			if(!permission.UserHasPermission(player.userID.ToString(), "ZBoxesUI.CanUse")){return;}	
			if(entity.ShortPrefabName != "box.wooden.large" && entity.ShortPrefabName != "woodbox_deployed" && entity.ShortPrefabName != "fridge.deployed"){return;}
				if(player.userID == entity.OwnerID )
				{
				ZBOXuiOPEN(player, entity, false, 0, false);	
				}
			}
		}	
		
		[ConsoleCommand("ZBPinfo")]
		void ZBPinfo(ConsoleSystem.Arg arg)
		{
			BasePlayer player = arg.Connection.player as BasePlayer;
			if(player == null){return;}
			ZBOXuiOPENhelp(player);
		}

		[ConsoleCommand("ZBOXuiOPENhelpclose")]
		private void CloSeATTTZ(ConsoleSystem.Arg arg)
		{
			BasePlayer player = arg.Connection.player as BasePlayer;
			if (player == null)
					return;			
			CuiHelper.DestroyUi(player, "ZbUih");
		}		
		
		private void ZBOXuiOPENhelp(BasePlayer player)
		{
			CuiHelper.DestroyUi(player, "ZbUih");
			CuiElementContainer container = null;
			container = UI.Container("ZbUih", "0.2627 0.2549 0.2314 0.98", new UI4(-200f, 88f, 180f, 660f), true);

			UI.Button(ref container, "ZbUih", "1 0 0 0.5", "X", 15, new UI4(0.91f, 0.96f, 1f, 1f), $"ZBOXuiOPENhelpclose", TextAnchor.MiddleCenter);

			float startYYy = 1f;
			
			if(_ZBoxesUI.BoxtypeZBUIIRC > 0)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUih",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 833533164, SkinId = 3084640228 },
								new CuiRectTransformComponent { AnchorMin = $"0.05 {startYYy-(1f/8)+0.005f}", AnchorMax = $"0.245 {startYYy}", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});
			UI.Label(ref container, "ZbUih", lang.GetMessage("ZBP_inFO_recycler", this, player.userID.Get().ToString()),  14, new UI4(0.3f, startYYy-(1f/8)+0.005f, 0.9f, startYYy), TextAnchor.MiddleCenter);					
			startYYy -= 1f/8;	
			}			
			if(_ZBoxesUI.BoxtypeZBUIMQB > 0)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUih",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 833533164, SkinId = 3299450471 },
								new CuiRectTransformComponent { AnchorMin = $"0.05 {startYYy-(1f/8)+0.005f}", AnchorMax = $"0.245 {startYYy}", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});
			UI.Label(ref container, "ZbUih", lang.GetMessage("ZBP_inFO_mining", this, player.userID.Get().ToString()),  14, new UI4(0.3f, startYYy-(1f/8)+0.005f, 0.9f, startYYy), TextAnchor.MiddleCenter);					
			startYYy -= 1f/8;					
			}			
			if(_ZBoxesUI.BoxtypeZBUIResB > 0)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUih",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 833533164, SkinId = 3137708597 },
								new CuiRectTransformComponent { AnchorMin = $"0.05 {startYYy-(1f/8)+0.005f}", AnchorMax = $"0.245 {startYYy}", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});
			UI.Label(ref container, "ZbUih", lang.GetMessage("ZBP_inFO_research", this, player.userID.Get().ToString()),  14, new UI4(0.3f, startYYy-(1f/8)+0.005f, 0.9f, startYYy), TextAnchor.MiddleCenter);					
			startYYy -= 1f/8;						
			}			
			if(_ZBoxesUI.BoxtypeZBUIRepB > 0)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUih",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 833533164, SkinId = 3144201633 },
								new CuiRectTransformComponent { AnchorMin = $"0.05 {startYYy-(1f/8)+0.005f}", AnchorMax = $"0.245 {startYYy}", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});
			UI.Label(ref container, "ZbUih", lang.GetMessage("ZBP_inFO_repair", this, player.userID.Get().ToString()),  14, new UI4(0.3f, startYYy-(1f/8)+0.005f, 0.9f, startYYy), TextAnchor.MiddleCenter);					
			startYYy -= 1f/8;						
			}			
			if(_ZBoxesUI.BoxtypeZBUIFZB > 0)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUih",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = -180129657, SkinId = 3171493217 },
								new CuiRectTransformComponent { AnchorMin = $"0.05 {startYYy-(1f/8)+0.005f}", AnchorMax = $"0.245 {startYYy}", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});
			UI.Label(ref container, "ZbUih", lang.GetMessage("ZBP_inFO_furnace", this, player.userID.Get().ToString()),  14, new UI4(0.3f, startYYy-(1f/8)+0.005f, 0.9f, startYYy), TextAnchor.MiddleCenter);					
			startYYy -= 1f/8;					
			}			
			if(_ZBoxesUI.BoxtypeZBUIDIBC > 0)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUih",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = -180129657, SkinId = 3247770012 },
								new CuiRectTransformComponent { AnchorMin = $"0.05 {startYYy-(1f/8)+0.005f}", AnchorMax = $"0.245 {startYYy}", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});
			UI.Label(ref container, "ZbUih", lang.GetMessage("ZBP_inFO_drop", this, player.userID.Get().ToString()),  14, new UI4(0.3f, startYYy-(1f/8)+0.005f, 0.9f, startYYy), TextAnchor.MiddleCenter);					
			startYYy -= 1f/8;					
			}			
			if(_ZBoxesUI.BoxtypeZBUIDIBCFFZ > 0)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUih",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 1413014235, SkinId = 3252660967 },
								new CuiRectTransformComponent { AnchorMin = $"0.05 {startYYy-(1f/8)+0.005f}", AnchorMax = $"0.245 {startYYy}", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});
			UI.Label(ref container, "ZbUih", lang.GetMessage("ZBP_inFO_fridge", this, player.userID.Get().ToString()),  14, new UI4(0.3f, startYYy-(1f/8)+0.005f, 0.9f, startYYy), TextAnchor.MiddleCenter);					
			startYYy -= 1f/8;					
			}		
			UI.Label(ref container, "ZbUih", lang.GetMessage("ZBP_inFO_X", this, player.userID.Get().ToString()),  14, new UI4(0.3f, startYYy-(1f/8)+0.005f, 0.9f, startYYy), TextAnchor.MiddleCenter);					
			UI.Label(ref container, "ZbUih", "<color=red>X</color>",  40, new UI4(0.05f, startYYy-(1f/8)+0.005f, 0.245f, startYYy), TextAnchor.MiddleCenter);					
			
	
			CuiHelper.AddUi(player, container);		
		}
		
		private void ZBOXuiOPEN(BasePlayer player, BaseEntity entity, bool errormessage, int cosTtT, bool SellIng)
		{
			if (player == null){return;}
			var PosSBuI1 = new UI4(370f, 635f, 570f, 680f);
			string CostNaMe = "";
			string CostNaMe2 = "";			
			string CostMaNe = "";			
			bool ScarpIMAgE = false;
			float UI_Posx = 1f;
			float UI_PosxWeight = 0.24f;
			float UI_PosxBetWeen = 0.01f;

			bool ZBUIFB = false;
			if(permission.UserHasPermission(player.userID.ToString(), "ZBoxesUI.FreeBuy"))
			{
			ZBUIFB = true;
			}
			
			if(!ZBUIFB)
			{
			if(_ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3){ScarpIMAgE = true; CostNaMe2 = "Scrap"; CostMaNe = "	  ";}
			else if(_ZBoxesUI.BoxtypeZBUICost == 2)
			{
			CostNaMe = " <color=#66ff66>" + _ZBoxesUI.Eco + "</color>";
			CostNaMe2 = CostNaMe;
			}
			else if(_ZBoxesUI.BoxtypeZBUICost == 3)
			{
			CostNaMe = " <color=#66ff66>" + _ZBoxesUI.SRew + "</color>";
			CostNaMe2 = CostNaMe;			
			}
			}
			if(entity.ShortPrefabName == "woodbox_deployed")
			{
			PosSBuI1 = new UI4(370f, 325f, 570f, 370f);
			}
			
			string price = "";
			
			CuiElementContainer container = null;
			container = UI.Container("ZbUi", "0 0 0 0", PosSBuI1, true);
			if(_ZBoxesUI.BoxtypeZBUIDIBCFFZ + _ZBoxesUI.BoxtypeZBUIDIBC + _ZBoxesUI.BoxtypeZBUIFZB + _ZBoxesUI.BoxtypeZBUIRepB + _ZBoxesUI.BoxtypeZBUIResB + _ZBoxesUI.BoxtypeZBUIMQB + _ZBoxesUI.BoxtypeZBUIIRC > 0)
			{
			UI.Button(ref container, "ZbUi", "0.4 0.4 0.4 0.5", "<color=#ffffff>" + lang.GetMessage("ZBP_inFO", this, player.userID.Get().ToString()) + "</color>", 12, new UI4(0.61f, 1f, 0.97f, 1.5f), $"ZBPinfo", TextAnchor.MiddleCenter);							
			}			
			if(entity.ShortPrefabName == "box.wooden.large" && !SellIng)
			{
				
			if(_ZBoxesUI.BoxtypeZBUIIRC > 0 && RecyclerBox != null)
			{
			price = _ZBoxesUI.BoxtypeZBUIIRC.ToString();
			if(ZBUIFB){price = "";}
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 833533164, SkinId = 3084640228 },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - UI_PosxWeight + " 0", AnchorMax = UI_Posx + " 1", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});		
			if(ScarpIMAgE && !ZBUIFB && _ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3)
			{		
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = _ZBoxesUI.BoxtypeZBUICost, SkinId = _ZBoxesUI.BoxtypeZBUICostSKIN },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - (UI_PosxWeight) + " 0", AnchorMax = UI_Posx - (UI_PosxWeight * 0.6f) + " 0.4", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});				
			}
			UI.Button(ref container, "ZbUi", "0 0 0 0", "\n\n" + CostMaNe + "<color=#66ff66>" + price + "</color>" + CostNaMe, 12, new UI4(UI_Posx-UI_PosxWeight, 0f, UI_Posx, 1f),  $"ZBUiCommIIU {entity.net.ID} {1} {_ZBoxesUI.BoxtypeZBUIIRC.ToString()}");
			UI_Posx -= UI_PosxBetWeen + UI_PosxWeight;
			}

			if(_ZBoxesUI.BoxtypeZBUIMQB > 0 && MiningQuarryBox != null)
			{
			price = _ZBoxesUI.BoxtypeZBUIMQB.ToString();
			if(ZBUIFB){price = "";}				
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 833533164, SkinId = 3299450471 },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - UI_PosxWeight + " 0", AnchorMax = UI_Posx + " 1", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});		
			if(ScarpIMAgE && !ZBUIFB && _ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = _ZBoxesUI.BoxtypeZBUICost, SkinId = _ZBoxesUI.BoxtypeZBUICostSKIN },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - (UI_PosxWeight) + " 0", AnchorMax = UI_Posx - (UI_PosxWeight * 0.6f) + " 0.4", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});	
			}
			UI.Button(ref container, "ZbUi", "0 0 0 0", "\n\n" + CostMaNe + "<color=#66ff66>" + price + "</color>" + CostNaMe, 12, new UI4(UI_Posx-UI_PosxWeight, 0f, UI_Posx, 1f), $"ZBUiCommIIU {entity.net.ID} {2} {_ZBoxesUI.BoxtypeZBUIMQB.ToString()}");
			UI_Posx -= UI_PosxBetWeen + UI_PosxWeight;
			}
			
			if(_ZBoxesUI.BoxtypeZBUIResB > 0 && ResearcHBox != null)
			{	
			price = _ZBoxesUI.BoxtypeZBUIResB.ToString();
			if(ZBUIFB){price = "";}		
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 833533164, SkinId = 3137708597 },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - UI_PosxWeight + " 0", AnchorMax = UI_Posx + " 1", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});		
			if(ScarpIMAgE && !ZBUIFB && _ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = _ZBoxesUI.BoxtypeZBUICost, SkinId = _ZBoxesUI.BoxtypeZBUICostSKIN },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - (UI_PosxWeight) + " 0", AnchorMax = UI_Posx - (UI_PosxWeight * 0.6f) + " 0.4", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});	
			}
			UI.Button(ref container, "ZbUi", "0 0 0 0", "\n\n" + CostMaNe + "<color=#66ff66>" + price + "</color>" + CostNaMe, 12, new UI4(UI_Posx-UI_PosxWeight, 0f, UI_Posx, 1f), $"ZBUiCommIIU {entity.net.ID} {3} {_ZBoxesUI.BoxtypeZBUIResB.ToString()}");
			UI_Posx -= UI_PosxBetWeen + UI_PosxWeight;
			}
			
			if(_ZBoxesUI.BoxtypeZBUIRepB > 0 && RepairBox != null)
			{	
			price = _ZBoxesUI.BoxtypeZBUIRepB.ToString();
			if(ZBUIFB){price = "";}		
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 833533164, SkinId = 3144201633 },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - UI_PosxWeight + " 0", AnchorMax = UI_Posx + " 1", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});			
			if(ScarpIMAgE && !ZBUIFB && _ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = _ZBoxesUI.BoxtypeZBUICost, SkinId = _ZBoxesUI.BoxtypeZBUICostSKIN },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - (UI_PosxWeight) + " 0", AnchorMax = UI_Posx - (UI_PosxWeight * 0.6f) + " 0.4", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});	
			}
			UI.Button(ref container, "ZbUi", "0 0 0 0", "\n\n" + CostMaNe + "<color=#66ff66>" + price + "</color>" + CostNaMe, 12, new UI4(UI_Posx-UI_PosxWeight, 0f, UI_Posx, 1f), $"ZBUiCommIIU {entity.net.ID} {4} {_ZBoxesUI.BoxtypeZBUIRepB.ToString()}");
			}
			
			}
			else if(entity.ShortPrefabName == "woodbox_deployed" && !SellIng)
			{
			if(_ZBoxesUI.BoxtypeZBUIFZB > 0 && FurnaceBox != null)
			{	
			price = _ZBoxesUI.BoxtypeZBUIFZB.ToString();
			if(ZBUIFB){price = "";}		
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = -180129657, SkinId = 3171493217 },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - UI_PosxWeight + " 0", AnchorMax = UI_Posx + " 1", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});	
			if(ScarpIMAgE && !ZBUIFB && _ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = _ZBoxesUI.BoxtypeZBUICost, SkinId = _ZBoxesUI.BoxtypeZBUICostSKIN },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - (UI_PosxWeight) + " 0", AnchorMax = UI_Posx - (UI_PosxWeight * 0.6f) + " 0.4", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});	
			}
			UI.Button(ref container, "ZbUi", "0 0 0 0", "\n\n" + CostMaNe + "<color=#66ff66>" + price + "</color>" + CostNaMe, 12, new UI4(UI_Posx-UI_PosxWeight, 0f, UI_Posx, 1f), $"ZBUiCommIIU {entity.net.ID} {5} {_ZBoxesUI.BoxtypeZBUIFZB.ToString()}");
			UI_Posx -= UI_PosxBetWeen + UI_PosxWeight;
			}
			
			if(_ZBoxesUI.BoxtypeZBUIDIBC > 0 && DroppedItemBoxCollectorZ != null)
			{
			price = _ZBoxesUI.BoxtypeZBUIDIBC.ToString();
			if(ZBUIFB){price = "";}				
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = -180129657, SkinId = 3247770012 },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - UI_PosxWeight + " 0", AnchorMax = UI_Posx + " 1", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});				
			if(ScarpIMAgE && !ZBUIFB && _ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = _ZBoxesUI.BoxtypeZBUICost, SkinId = _ZBoxesUI.BoxtypeZBUICostSKIN },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - (UI_PosxWeight) + " 0", AnchorMax = UI_Posx - (UI_PosxWeight * 0.6f) + " 0.4", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});	
			}
			UI.Button(ref container, "ZbUi", "0 0 0 0", "\n\n" + CostMaNe + "<color=#66ff66>" + price + "</color>" + CostNaMe, 12, new UI4(UI_Posx-UI_PosxWeight, 0f, UI_Posx, 1f), $"ZBUiCommIIU {entity.net.ID} {6} {_ZBoxesUI.BoxtypeZBUIDIBC.ToString()}");
			}
			}
			else if(entity.ShortPrefabName == "fridge.deployed" && !SellIng)
			{
			if(_ZBoxesUI.BoxtypeZBUIDIBCFFZ > 0 && FridgeFarmZ != null)
			{	
			price = _ZBoxesUI.BoxtypeZBUIDIBCFFZ.ToString();
			if(ZBUIFB){price = "";}		
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = 1413014235, SkinId = 3252660967 },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - UI_PosxWeight + " 0", AnchorMax = UI_Posx + " 1", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});	
			if(ScarpIMAgE && !ZBUIFB && _ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = _ZBoxesUI.BoxtypeZBUICost, SkinId = _ZBoxesUI.BoxtypeZBUICostSKIN },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - (UI_PosxWeight) + " 0", AnchorMax = UI_Posx - (UI_PosxWeight * 0.6f) + " 0.4", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});	
			}
			UI.Button(ref container, "ZbUi", "0 0 0 0", "\n\n" + CostMaNe + "<color=#66ff66>" + price + "</color>" + CostNaMe, 12, new UI4(UI_Posx-UI_PosxWeight, 0f, UI_Posx, 1f), $"ZBUiCommIIU {entity.net.ID} {7} {_ZBoxesUI.BoxtypeZBUIDIBCFFZ.ToString()}");
			UI_Posx -= UI_PosxBetWeen + UI_PosxWeight;
			}
			}
			else if(SellIng)
			{
			if(_ZBoxesUI.BoxtypeSELL > 0)
			{	
			price = _ZBoxesUI.BoxtypeSELL.ToString();
			if(ZBUIFB){price = "";}		
			UI.Button(ref container, "ZbUi", "0 0 0 0", "<color=red>X</color>", 30, new UI4(UI_Posx-UI_PosxWeight, 0f, UI_Posx, 1f), "");	
			if(ScarpIMAgE && !ZBUIFB && _ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3)
			{
						container.Add(new CuiElement
						{
							Parent = "ZbUi",
							Components =
							{
								new CuiImageComponent { Color = "1 1 1 1", ItemId = _ZBoxesUI.BoxtypeZBUICost, SkinId = _ZBoxesUI.BoxtypeZBUICostSKIN },
								new CuiRectTransformComponent { AnchorMin = UI_Posx - (UI_PosxWeight) + " 0", AnchorMax = UI_Posx - (UI_PosxWeight * 0.6f) + " 0.4", OffsetMin = "0 1", OffsetMax = "0 1" }
							}
						});	
			}
			UI.Button(ref container, "ZbUi", "0 0 0 0", "\n\n" + CostMaNe + "<color=#66ff66>" + price + "</color>" + CostNaMe, 12, new UI4(UI_Posx-UI_PosxWeight, 0f, UI_Posx, 1f), $"ZBUiCommIIU {entity.net.ID} {8} {_ZBoxesUI.BoxtypeSELL.ToString()}");
			UI_Posx -= UI_PosxBetWeen + UI_PosxWeight;
			}							
			}
			
			
			if(errormessage)
			{
			if(CostNaMe2 == "Scrap"){CostNaMe2 = "";}	
			UI.Button2(ref container, "ZbUi", "1 0 0 0.2", lang.GetMessage("___CantBuy2", this, player.userID.ToString()).Replace("{0}", cosTtT.ToString()).Replace("{1}", CostNaMe2), 10, new UI4(-0.4f, 1f, 0.6f, 1.5f), "");
			}
			
			CuiHelper.DestroyUi(player, "ZbUi");
			CuiHelper.AddUi(player, container);
		}	

		[ConsoleCommand("ZBUiCommIIU")]
		private void ZBUIEXEcute(ConsoleSystem.Arg arg)
		{
			BasePlayer player = arg.Connection.player as BasePlayer;
			if (player == null){ return;}
			
			if(arg.Args[0] == null || Convert.ToInt32(arg.Args[1]) < 1 || Convert.ToInt32(arg.Args[1]) > 8 || Convert.ToInt32(arg.Args[2]) < 1){return;}
			var entityBOX = BaseNetworkable.serverEntities.Find(new NetworkableId(Convert.ToUInt64(Convert.ToUInt64(arg.Args[0]))));
			if (entityBOX == null){ return;}			
			if(entityBOX as BaseEntity){}else{return;}			
			var entityBoxZBUI = entityBOX as BaseEntity;
			string TyppeGettNow = "";

			if(_ZBoxesUI.BoxtypeZBUICost != 2 && _ZBoxesUI.BoxtypeZBUICost != 3){TyppeGettNow = "scrap";}
			else if(_ZBoxesUI.BoxtypeZBUICost == 2){TyppeGettNow = "eco";}
			else if(_ZBoxesUI.BoxtypeZBUICost == 3){TyppeGettNow = "rp";}			

			if(ZBOXCheckBalance(player, TyppeGettNow, Convert.ToInt32(arg.Args[2])))
			{
					if(Convert.ToInt32(arg.Args[1]) == 1){entityBoxZBUI.skinID = 3084640228;}
					if(Convert.ToInt32(arg.Args[1]) == 2){entityBoxZBUI.skinID = 3299450471;}
					if(Convert.ToInt32(arg.Args[1]) == 3){entityBoxZBUI.skinID = 3137708597;}
					if(Convert.ToInt32(arg.Args[1]) == 4){entityBoxZBUI.skinID = 3144201633;}
					if(Convert.ToInt32(arg.Args[1]) == 5){entityBoxZBUI.skinID = 3171493217;}
					if(Convert.ToInt32(arg.Args[1]) == 6){entityBoxZBUI.skinID = 3247770012;}
					if(Convert.ToInt32(arg.Args[1]) == 7){entityBoxZBUI.skinID = 3252660967;}
					if(Convert.ToInt32(arg.Args[1]) == 8){entityBoxZBUI.skinID = 0;}										

				if(Convert.ToInt32(arg.Args[1]) == 8)
				{
				CuiHelper.DestroyUi(player, "ZbUi");
				ZBOXuiOPEN(player, entityBoxZBUI as BaseEntity, false, Convert.ToInt32(arg.Args[2]), false);	
				}
				else
				{
				CuiHelper.DestroyUi(player, "ZbUi");
				ZBOXuiOPEN(player, entityBoxZBUI as BaseEntity, false, Convert.ToInt32(arg.Args[2]), true);	
				}

					}
			else
			{
								if(Convert.ToInt32(arg.Args[1]) == 8)
								{
								CuiHelper.DestroyUi(player, "ZbUi");
								ZBOXuiOPEN(player, entityBoxZBUI as BaseEntity, true, Convert.ToInt32(arg.Args[2]), true);										
								}
								else
								{
								CuiHelper.DestroyUi(player, "ZbUi");
								ZBOXuiOPEN(player, entityBoxZBUI as BaseEntity, true, Convert.ToInt32(arg.Args[2]), false);	
								}
			}

		}	
		
		private bool ZBOXCheckBalance(BasePlayer player, string currencyType, int amount)
		{
			if(permission.UserHasPermission(player.userID.ToString(), "ZBoxesUI.FreeBuy")){return true;}	
			if (currencyType == "rp")
			{
				if (ServerRewards == null)
				{ Puts("ServerRewards is not loaded!"); return false; }

				var playersRP = ServerRewards?.Call<int>("CheckPoints", player.userID);

				if (playersRP < amount) return false;

				ServerRewards?.Call("TakePoints", player.userID, amount);
				return true;
			}
			else if (currencyType == "eco")
			{
				if (Economics == null)
				{ Puts("Economics is not loaded!"); return false; }
			
				double playersEco = Economics.Call<double>("Balance", player.UserIDString);

				if (playersEco < amount)
				{
					return false;
				}
				Economics.CallHook("Withdraw", player.UserIDString, Convert.ToDouble(amount));
				return true;
			}
			else if (currencyType == "scrap")
			{
			if (player.inventory.GetAmount(_ZBoxesUI.BoxtypeZBUICost) >= Convert.ToInt32(amount))
				{
				player.inventory.Take(null, _ZBoxesUI.BoxtypeZBUICost, Convert.ToInt32(amount));
				return true;
				}
			}					
			return false;

		}
		
		
			public static class UI
		{
			public static CuiElementContainer Container(string panelName, string color, UI4 dimensions, bool useCursor = false, string parent = "Overlay")
			{
				CuiElementContainer container = new CuiElementContainer()
				{
					{
						new CuiPanel
						{
							Image = {Color = color},
							RectTransform = 
							{ 
							AnchorMin = "0.5 0", 
							AnchorMax = "0.5 0", 
							OffsetMin = dimensions.GetMin(), 
							OffsetMax = dimensions.GetMax() 
							},
							CursorEnabled = useCursor
						},
						new CuiElement().Parent = parent,
						panelName.ToString()
					}
				};
				return container;
			}			
			
			public static void Button(ref CuiElementContainer container, string panel, string color, string text, int size, UI4 dimensions, string command, TextAnchor align = TextAnchor.MiddleLeft)
			{
				container.Add(new CuiButton
				{
					Button = { Color = color, Command = command, FadeIn = 0f },
					RectTransform = { AnchorMin = dimensions.GetMin(), AnchorMax = dimensions.GetMax() },
					Text = { Text = text, FontSize = size, Align = align }
				},
				panel.ToString());
			}
 
			public static void Button2(ref CuiElementContainer container, string panel, string color, string text, int size, UI4 dimensions, string command, TextAnchor align = TextAnchor.MiddleCenter)
			{
				container.Add(new CuiButton
				{
					Button = { Color = color, Command = command, FadeIn = 0f },
					RectTransform = { AnchorMin = dimensions.GetMin(), AnchorMax = dimensions.GetMax() },
					Text = { Text = text, FontSize = size, Align = align }
				},
				panel.ToString());
			}
			
			public static void Label(ref CuiElementContainer container, string panel, string text, int size, UI4 dimensions, TextAnchor align = TextAnchor.MiddleCenter)
			{
				container.Add(new CuiLabel
				{
					Text = { FontSize = size, Align = align, Text = text },
					RectTransform = { AnchorMin = dimensions.GetMin(), AnchorMax = dimensions.GetMax() }
				},
				panel.ToString());

			}			
			
		}	
		
				public class UI4
		{
			[JsonProperty(PropertyName = "Left (0.0 - 1.0)")]
			public float xMin;

			[JsonProperty(PropertyName = "Bottom (0.0 - 1.0)")]
			public float yMin;

			[JsonProperty(PropertyName = "Right (0.0 - 1.0)")]
			public float xMax;

			[JsonProperty(PropertyName = "Top (0.0 - 1.0)")]
			public float yMax;

			public UI4(float xMin, float yMin, float xMax, float yMax)
			{
				this.xMin = xMin;
				this.yMin = yMin;
				this.xMax = xMax;
				this.yMax = yMax;
			}

			public string GetMin() => $"{xMin} {yMin}";
			public string GetMax() => $"{xMax} {yMax}";
		}
		
			public class PluginConfig
			{
			[JsonProperty("Cost type: (write itemID or 2=Economics or 3=ServerRewards) [itemID list: https://www.corrosionhour.com/rust-item-list/]")] public int BoxtypeZBUICost = -932201673;				
			[JsonProperty("Cost item SKIN (if Cost type not 2 or 3)")] public ulong BoxtypeZBUICostSKIN = 0;				
			[JsonProperty("Economics")] public string Eco = "$";
			[JsonProperty("ServerRewards")] public string SRew = "SR";			
			[JsonProperty("[PLUGIN] Cost for InstantRecyclerBox (0 = disable plugin):")] public int BoxtypeZBUIIRC = 1;
			[JsonProperty("[PLUGIN] Cost for MiningQuarryBox (0 = disable plugin):")] public int BoxtypeZBUIMQB = 1;
			[JsonProperty("[PLUGIN] Cost for ResearchBox (0 = disable plugin):")] public int BoxtypeZBUIResB = 1;
			[JsonProperty("[PLUGIN] Cost for RepairBox (0 = disable plugin):")] public int BoxtypeZBUIRepB = 1;			
			[JsonProperty("[PLUGIN] Cost for FurnaceZBOX (0 = disable plugin):")] public int BoxtypeZBUIFZB = 1;	
			[JsonProperty("[PLUGIN] Cost for DroppedItemBoxCollector (0 = disable plugin):")] public int BoxtypeZBUIDIBC = 1;	
			[JsonProperty("[PLUGIN] Cost for FridgeFarmZ (0 = disable plugin):")] public int BoxtypeZBUIDIBCFFZ = 1;	
			[JsonProperty("[PLUGIN] Selling price (back to normal box) / (0 = disable)")] public int BoxtypeSELL = 1;	
			
			public static PluginConfig DefaultConfig()
				{
					return new PluginConfig()
					{
					 BoxtypeZBUICost = -932201673,
					 BoxtypeZBUICostSKIN = 0,
					 Eco = "$",
					 SRew = "SR",
					 BoxtypeZBUIIRC = 1,
					 BoxtypeZBUIMQB = 1,
					 BoxtypeZBUIResB = 1,
					 BoxtypeZBUIRepB = 1,
					 BoxtypeZBUIFZB = 1,
					 BoxtypeZBUIDIBC = 1,
					 BoxtypeZBUIDIBCFFZ = 1,
					 BoxtypeSELL = 1
					};
				}
				
				

			}
			
		protected override void LoadConfig()
		{
		base.LoadConfig();
		_ZBoxesUI = Config.ReadObject<PluginConfig>();
		SaveConfig();
		}
			
		protected override void LoadDefaultConfig()
		{
			Puts("Creating a default config...");
			_ZBoxesUI = PluginConfig.DefaultConfig();
			SaveConfig();
			Puts("Creation of the default config completed!");
		}			
			
		private void Unload()
		{		
			foreach (BasePlayer player in BasePlayer.activePlayerList)
			{
			CuiHelper.DestroyUi(player, "ZbUi");
			CuiHelper.DestroyUi(player, "ZbUih");
			}
		}

		protected override void LoadDefaultMessages()
		{
			lang.RegisterMessages(new Dictionary<string, string>
			{
				["___CantBuy2"] = "You can't buy it! The price: <color=#66ff66>{0}</color> {1}",
				["ZBP_inFO"] = "Help",
				["ZBP_inFO_mining"] = "Mining quarry functions in a box, mines raw materials.",	
				["ZBP_inFO_recycler"] = "Recycler functions in one box, easy to use with the industrial system.",	
				["ZBP_inFO_repair"] = "Repair bench functions in one box.",	
				["ZBP_inFO_research"] = "Research table features in one box.",	
				["ZBP_inFO_drop"] = "Collects dropped items.",	
				["ZBP_inFO_furnace"] = "It melts raw materials like a furnace",	
				["ZBP_inFO_fridge"] = "The seeds germinate immediately in the refrigerator.",	
				["ZBP_inFO_X"] = "Reset to default (it loses its function and you can choose another).",						
			}, this);
		}			
	
	}
}